<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1747086 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->


<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_ldap.xml.meta">

<name>mod_ldap</name>
<description>Conservation des connexions LDAP et services de mise en
cache du r&eacute;sultat &agrave; destination des autres modules LDAP</description>
<status>Extension</status>
<sourcefile>util_ldap.c</sourcefile>
<identifier>ldap_module</identifier>

<summary>
    <p>Ce module a &eacute;t&eacute; con&ccedil;u dans le but d'am&eacute;liorer les performances
    des sites web s'appuyant sur des connexions en arri&egrave;re-plan vers des
    serveurs LDAP. Il ajoute aux fonctions fournies par les
    biblioth&egrave;ques standards LDAP la conservation des connexions LDAP
    ainsi qu'un cache LDAP partag&eacute; en m&eacute;moire.</p>

    <p>Pour activer ce module, le support LDAP doit &ecirc;tre compil&eacute; dans
    apr-util. Pour ce faire, on ajoute l'option <code>--with-ldap</code>
    au script <program>configure</program> lorsqu'on construit
    Apache.</p>

    <p>Le support SSL/TLS est conditionn&eacute; par le kit de d&eacute;veloppement
    LDAP qui a &eacute;t&eacute; li&eacute; &agrave; <glossary>APR</glossary>. Au moment o&ugrave; ces
    lignes sont &eacute;crites, APR-util supporte <a
    href="http://www.openldap.org/">OpenLDAP SDK</a> (version 2.x ou
    sup&eacute;rieure), <a
    href="http://developer.novell.com/ndk/cldap.htm">Novell LDAP
    SDK</a>, <a href="https://wiki.mozilla.org/LDAP_C_SDK">
    Mozilla LDAP SDK</a>, le SDK LDAP Solaris natif (bas&eacute; sur Mozilla)
    ou le SDK LDAP Microsoft natif. Voir le site web <a
    href="http://apr.apache.org">APR</a> pour plus de d&eacute;tails.</p>

</summary>

<section id="exampleconfig"><title>Exemple de configuration</title>
    <p>Ce qui suit est un exemple de configuration qui utilise
    <module>mod_ldap</module> pour am&eacute;liorer les performances de
    l'authentification HTTP de base fournie par
    <module>mod_authnz_ldap</module>.</p>

    <highlight language="config">
# Active la conservation des connexions LDAP et le cache partag&eacute; en
# m&eacute;moire. Active le gestionnaire de statut du cache LDAP.
# N&eacute;cessite le chargement de mod_ldap et de mod_authnz_ldap.
# Remplacez "votre-domaine.example.com" par le nom de votre
# domaine.

LDAPSharedCacheSize 500000
LDAPCacheEntries 1024
LDAPCacheTTL 600
LDAPOpCacheEntries 1024
LDAPOpCacheTTL 600

&lt;Location "/ldap-status"&gt;
    SetHandler ldap-status
    
    Require host yourdomain.example.com
    
    Satisfy any
    AuthType Basic
    AuthName "LDAP Protected"
    AuthBasicProvider ldap
    AuthLDAPURL "ldap://127.0.0.1/dc=example,dc=com?uid?one"
    Require valid-user
&lt;/Location&gt;
    </highlight>
</section>

<section id="pool"><title>Conservation des connexions LDAP</title>

    <p>Les connexions LDAP sont conserv&eacute;es de requ&ecirc;te en requ&ecirc;te. Ceci
    permet de rester connect&eacute; et identifi&eacute; au serveur LDAP, ce dernier
    &eacute;tant ainsi pr&ecirc;t pour la prochaine requ&ecirc;te, sans avoir &agrave; se
    d&eacute;connecter, reconnecter et r&eacute;identifier. Le gain en performances
    est similaire &agrave; celui des connexions persistantes (keepalives)
    HTTP.</p>

    <p>Sur un serveur tr&egrave;s sollicit&eacute;, il est possible que de nombreuses
    requ&ecirc;tes tentent d'acc&eacute;der simultan&eacute;ment &agrave; la m&ecirc;me connexion au
    serveur LDAP. Lorsqu'une connexion LDAP est utilis&eacute;e, Apache en cr&eacute;e
    une deuxi&egrave;me en parall&egrave;le &agrave; la premi&egrave;re, ce qui permet d'&eacute;viter que
    le syst&egrave;me de conservation des connexions ne devienne un goulot
    d'&eacute;tranglement.</p>

    <p>Il n'est pas n&eacute;cessaire d'activer explicitement la conservation
    des connexions dans la configuration d'Apache. Tout module utilisant
    le module ldap pour acc&eacute;der aux services LDAP partagera le jeu de
    connexions.</p>

    <p>Les connexions LDAP peuvent garder la trace des donn&eacute;es
    d'identification du client ldap utilis&eacute;es pour l'identification
    aupr&egrave;s du serveur LDAP. Ces donn&eacute;es peuvent &ecirc;tre fournies aux
    serveurs LDAP qui ne permettent pas les connexions anonymes au cours
    lors des tentatives de sauts vers des serveurs alternatifs. Pour
    contr&ocirc;ler cette fonctionnalit&eacute;, voir les directives <directive
    module="mod_ldap">LDAPReferrals</directive> et <directive
    module="mod_ldap">LDAPReferralHopLimit</directive>. Cette
    fonctionnalit&eacute; est activ&eacute;e par d&eacute;faut.</p>
</section>

<section id="cache"><title>Cache LDAP</title>

    <p>Pour am&eacute;liorer les performances, <module>mod_ldap</module> met en
    oeuvre une strat&eacute;gie de mise en cache agressive visant &agrave; minimiser
    le nombre de fois que le serveur LDAP doit &ecirc;tre contact&eacute;. La mise en
    cache peut facilement doubler et m&ecirc;me tripler le d&eacute;bit d'Apache
    lorsqu'il sert des pages prot&eacute;g&eacute;es par mod_authnz_ldap. De plus, le
    serveur LDAP verra lui-m&ecirc;me sa charge sensiblement diminu&eacute;e.</p>

    <p><module>mod_ldap</module> supporte deux types de mise en cache
    LDAP : un <em>cache recherche/identification</em> durant la phase
    de recherche/identification et deux <em>caches d'op&eacute;rations</em>
    durant la phase de comparaison. Chaque URL LDAP utilis&eacute;e par le
    serveur a son propre jeu d'instances dans ces trois caches.</p>

    <section id="search-bind"><title>Le cache
    recherche/identification</title>
      <p>Les processus de recherche et d'identification sont les
      op&eacute;rations LDAP les plus consommatrices en temps, en particulier
      si l'annuaire est de grande taille. Le cache de
      recherche/identification met en cache toutes les recherches qui
      ont abouti &agrave; une identification positive. Les r&eacute;sultats n&eacute;gatifs
      (c'est &agrave; dire les recherches sans succ&egrave;s, ou les recherches qui
      n'ont pas abouti &agrave; une identification positive) ne sont pas mis en
      cache. La raison de cette d&eacute;cision r&eacute;side dans le fait que les
      connexions avec des donn&eacute;es d'identification invalides ne
      repr&eacute;sentent qu'un faible pourcentage du nombre total de
      connexions, et ainsi, le fait de ne pas mettre en cache les
      donn&eacute;es d'identification invalides r&eacute;duira d'autant la taille du
      cache.</p>

      <p><module>mod_ldap</module> met en cache le nom d'utilisateur, le
      DN extrait, le mot de passe utilis&eacute; pour l'identification, ainsi
      que l'heure de l'identification. Chaque fois qu'une nouvelle
      connexion est initialis&eacute;e avec le m&ecirc;me nom d'utilisateur,
      <module>mod_ldap</module> compare le mot de passe de la nouvelle
      connexion avec le mot de passe enregistr&eacute; dans le cache. Si les
      mots de passe correspondent, et si l'entr&eacute;e du cache n'est pas
      trop ancienne, <module>mod_ldap</module> court-circuite la phase
      de recherche/identification.</p>

      <p>Le cache de recherche/identification est contr&ocirc;l&eacute; par les
      directives <directive
      module="mod_ldap">LDAPCacheEntries</directive> et <directive
      module="mod_ldap">LDAPCacheTTL</directive>.</p>
    </section>

    <section id="opcaches"><title>Les caches d'op&eacute;rations</title>
      <p>Au cours des op&eacute;rations de comparaison d'attributs et de noms
      distinctifs (DN), <module>mod_ldap</module> utilise deux caches
      d'op&eacute;rations pour mettre en cache les op&eacute;rations de comparaison.
      Le premier cache de comparaison sert &agrave; mettre en cache les
      r&eacute;sultats de comparaisons effectu&eacute;es pour v&eacute;rifier l'appartenance
      &agrave; un groupe LDAP. Le second cache de comparaison sert &agrave; mettre en
      cache les r&eacute;sultats de comparaisons entre DNs.</p>

      <p>Notez que, lorsque l'appartenance &agrave; un groupe est v&eacute;rifi&eacute;e,
      toute comparaison de sous-groupes est mise en cache afin
      d'acc&eacute;l&eacute;rer les comparaisons de sous-groupes ult&eacute;rieures.</p>

      <p>Le comportement de ces deux caches est contr&ocirc;l&eacute; par les
      directives <directive
      module="mod_ldap">LDAPOpCacheEntries</directive> et <directive
      module="mod_ldap">LDAPOpCacheTTL</directive>.</p>
    </section>

    <section id="monitoring"><title>Superviser le cache</title>
      <p><module>mod_ldap</module> poss&egrave;de un gestionnaire de contenu
      qui permet aux administrateurs de superviser les performances du
      cache. Le nom du gestionnaire de contenu est
      <code>ldap-status</code>, et on peut utiliser les directives
      suivantes pour acc&eacute;der aux informations du cache de
      <module>mod_ldap</module> :</p>

      <highlight language="config">
&lt;Location "/server/cache-info"&gt;
    SetHandler ldap-status
&lt;/Location&gt;
      </highlight>

      <p>En se connectant &agrave; l'URL
      <code>http://nom-serveur/infos-cache</code>, l'administrateur peut
      obtenir un rapport sur le statut de chaque cache qu'utilise
      <module>mod_ldap</module>. Notez que si Apache ne supporte pas la
      m&eacute;moire partag&eacute;e, chaque instance de <program>httpd</program>
      poss&egrave;dera son propre cache, et chaque fois que l'URL sera
      recharg&eacute;e, un r&eacute;sultat diff&eacute;rent pourra &ecirc;tre affich&eacute;, en fonction
      de l'instance de <program>httpd</program> qui traitera la
      requ&ecirc;te.</p>
    </section>
</section>

<section id="usingssltls"><title>Utiliser SSL/TLS</title>

    <p>La possibilit&eacute; de cr&eacute;er des connexions SSL et TLS avec un serveur
    LDAP est d&eacute;finie par les directives <directive module="mod_ldap">
    LDAPTrustedGlobalCert</directive>, <directive module="mod_ldap">
    LDAPTrustedClientCert</directive> et <directive module="mod_ldap">
    LDAPTrustedMode</directive>. Ces directives permettent de sp&eacute;cifier
    l'autorit&eacute; de certification (CA), les certificats clients &eacute;ventuels,
    ainsi que le type de chiffrement &agrave; utiliser pour la connexion (none,
    SSL ou TLS/STARTTLS).</p>

    <highlight language="config">
# Etablissement d'une connexion SSL LDAP sur le port 636.
# N&eacute;cessite le chargement de mod_ldap et mod_authnz_ldap.
# Remplacez "votre-domaine.example.com" par le nom de votre
# domaine.

LDAPTrustedGlobalCert CA_DER "/certs/certfile.der"

&lt;Location "/ldap-status"&gt;
    SetHandler ldap-status
    
    Require host yourdomain.example.com
    
    Satisfy any
    AuthType Basic
    AuthName "LDAP Protected"
    AuthBasicProvider ldap
    AuthLDAPURL "ldaps://127.0.0.1/dc=example,dc=com?uid?one"
    Require valid-user
&lt;/Location&gt;
    </highlight>

    <highlight language="config">
# Etablissement d'une connexion TLS LDAP sur le port 389.
# N&eacute;cessite le chargement de mod_ldap et mod_authnz_ldap.
# Remplacez "votre-domaine.example.com" par le nom de votre
# domaine.

LDAPTrustedGlobalCert CA_DER "/certs/certfile.der"

&lt;Location "/ldap-status"&gt;
    SetHandler ldap-status
    
    Require host yourdomain.example.com
    
    Satisfy any
    AuthType Basic
    AuthName "LDAP Protected"
    AuthBasicProvider ldap
    AuthLDAPURL "ldap://127.0.0.1/dc=example,dc=com?uid?one" TLS
    Require valid-user
&lt;/Location&gt;
    </highlight>

</section>

<section id="settingcerts"><title>Certificats SSL/TLS</title>

    <p>Les diff&eacute;rents SDKs LDAP disposent de nombreuses m&eacute;thodes pour
    d&eacute;finir et g&eacute;rer les certificats des clients et des autorit&eacute;s de
    certification (CA).</p>

    <p>Si vous avez l'intention d'utiliser SSL ou TLS, lisez cette
    section ATTENTIVEMENT de fa&ccedil;on &agrave; bien comprendre les diff&eacute;rences de
    configurations entre les diff&eacute;rents SDKs LDAP support&eacute;s.</p>

    <section id="settingcerts-netscape"><title>SDK Netscape/Mozilla/iPlanet</title>
        <p>Les certificat de CA sont enregistr&eacute;s dans un fichier nomm&eacute;
	cert7.db. Le SDK ne dialoguera avec aucun serveur LDAP dont le
	certificat n'a pas &eacute;t&eacute; sign&eacute; par une CA sp&eacute;cifi&eacute;e dans ce
	fichier. Si des certificats clients sont requis, un fichier
	key3.db ainsi qu'un mot de passe optionnels peuvent &ecirc;tre
	sp&eacute;cifi&eacute;s. On peut aussi sp&eacute;cifier le fichier secmod si
	n&eacute;cessaire. Ces fichiers sont du m&ecirc;me format que celui utilis&eacute;
	par les navigateurs web Netscape Communicator ou Mozilla. Le
	moyen le plus simple pour obtenir ces fichiers consiste &agrave; les
	extraire de l'installation de votre navigateur.</p>

        <p>Les certificats clients sont sp&eacute;cifi&eacute;s pour chaque connexion
	en utilisant la directive LDAPTrustedClientCert et en se
	r&eacute;f&eacute;rant au certificat "nickname". On peut &eacute;ventuellement
	sp&eacute;cifier un mot de passe pour d&eacute;verrouiller la cl&eacute; priv&eacute;e du
	certificat.</p>

        <p>Le SDK supporte seulement SSL. Toute tentative d'utilisation
	de STARTTLS engendrera une erreur lors des tentatives de
	contacter le serveur LDAP pendant l'ex&eacute;cution.</p>

        <highlight language="config">
# Sp&eacute;cifie un fichier de certificats de CA Netscape
LDAPTrustedGlobalCert CA_CERT7_DB "/certs/cert7.db"
# Sp&eacute;cifie un fichier key3db optionnel pour le support des
# certificats clients
LDAPTrustedGlobalCert CERT_KEY3_DB "/certs/key3.db"
# Sp&eacute;cifie le fichier secmod si n&eacute;cessaire
LDAPTrustedGlobalCert CA_SECMOD "/certs/secmod"
&lt;Location "/ldap-status"&gt;
    SetHandler ldap-status

    Require host yourdomain.example.com

    Satisfy any
    AuthType Basic
    AuthName "LDAP Protected"
    AuthBasicProvider ldap
    LDAPTrustedClientCert CERT_NICKNAME &lt;nickname&gt; [password]
    AuthLDAPURL "ldaps://127.0.0.1/dc=example,dc=com?uid?one"
    Require valid-user
&lt;/Location&gt;
        </highlight>

    </section>

    <section id="settingcerts-novell"><title>SDK Novell</title>

        <p>Un ou plusieurs certificats de CA doivent &ecirc;tre sp&eacute;cifi&eacute;s pour
	que le SDK Novell fonctionne correctement. Ces certificats
	peuvent &ecirc;tre sp&eacute;cifi&eacute;s sous forme de fichiers au format binaire
	DER ou cod&eacute;s en Base64 (PEM).</p>

        <p>Note: Les certificats clients sont sp&eacute;cifi&eacute;s globalement
	plut&ocirc;t qu'&agrave; chaque connexion, et doivent &ecirc;tre sp&eacute;cifi&eacute;s &agrave; l'aide
	de la directive LDAPTrustedGlobalCert comme ci-dessous. D&eacute;finir
	des certificats clients via la directive LDAPTrustedClientCert
	engendrera une erreur qui sera journalis&eacute;e, au moment de la
	tentative de connexion avec le serveur LDAP.</p>

        <p>Le SDK supporte SSL et STARTTLS, le choix &eacute;tant d&eacute;fini par le
	param&egrave;tre de la directive LDAPTrustedMode. Si une URL de type
	ldaps:// est sp&eacute;cifi&eacute;e, le mode SSL est forc&eacute;, et l'emporte sur
	cette directive.</p>

        <highlight language="config">
# Sp&eacute;cifie deux fichiers contenant des certificats de CA
LDAPTrustedGlobalCert CA_DER "/certs/cacert1.der"
LDAPTrustedGlobalCert CA_BASE64 "/certs/cacert2.pem"
# Sp&eacute;cifie un fichier contenant des certificats clients
# ainsi qu'une cl&eacute;
LDAPTrustedGlobalCert CERT_BASE64 "/certs/cert1.pem"
LDAPTrustedGlobalCert KEY_BASE64 "/certs/key1.pem" [password]
# N'utilisez pas cette directive, sous peine de provoquer
# une erreur
#LDAPTrustedClientCert CERT_BASE64 "/certs/cert1.pem"
        </highlight>

    </section>

    <section id="settingcerts-openldap"><title>SDK OpenLDAP</title>

        <p>Un ou plusieurs certificats de CA doivent &ecirc;tre sp&eacute;cifi&eacute;s pour
	que le SDK OpenLDAP fonctionne correctement. Ces certificats
	peuvent &ecirc;tre sp&eacute;cifi&eacute;s sous forme de fichiers au format binaire
	DER ou cod&eacute;s en Base64 (PEM).</p>

        <p>Les certificats clients sont sp&eacute;cifi&eacute;s pour chaque connexion
	&agrave; l'aide de la directive LDAPTrustedClientCert.</p>

        <p>La documentation du SDK pr&eacute;tend que SSL et STARTTLS sont
	support&eacute;s ; cependant, STARTTLS semble ne pas fonctionner avec
	toutes les versions du SDK. Le mode SSL/TLS peut &ecirc;tre d&eacute;fini en
	utilisant le param&egrave;tre de la directive LDAPTrustedMode. Si une
	URL de type
	ldaps:// est sp&eacute;cifi&eacute;e, le mode SSL est forc&eacute;. La documentation
	OpenLDAP indique que le support SSL (ldaps://) tend &agrave; &ecirc;tre
	remplac&eacute; par TLS, bien que le mode SSL fonctionne toujours.</p>

        <highlight language="config">
# Sp&eacute;cifie deux fichiers contenant des certificats de CA
LDAPTrustedGlobalCert CA_DER "/certs/cacert1.der"
LDAPTrustedGlobalCert CA_BASE64 "/certs/cacert2.pem"
&lt;Location /ldap-status&gt;
    SetHandler ldap-status
    
    Require host yourdomain.example.com
    
    LDAPTrustedClientCert CERT_BASE64 "/certs/cert1.pem"
    LDAPTrustedClientCert KEY_BASE64 "/certs/key1.pem"
    # CA certs respecified due to per-directory client certs
    LDAPTrustedClientCert CA_DER "/certs/cacert1.der"
    LDAPTrustedClientCert CA_BASE64 "/certs/cacert2.pem"
    Satisfy any
    AuthType Basic
    AuthName "LDAP Protected"
    AuthBasicProvider ldap
    AuthLDAPURL "ldaps://127.0.0.1/dc=example,dc=com?uid?one"
    Require valid-user
&lt;/Location&gt;
        </highlight>

    </section>

    <section id="settingcerts-solaris"><title>SDK Solaris</title>

        <p>SSL/TLS pour les biblioth&egrave;ques LDAP propres &agrave; Solaris n'est
	pas encore support&eacute;. Si n&eacute;cessaire, installez et utilisez plut&ocirc;t
	les biblioth&egrave;ques OpenLDAP.</p>

    </section>

    <section id="settingcerts-microsoft"><title>SDK Microsoft</title>

        <p>La configuration des certificats SSL/TLS pour les
	biblioth&egrave;ques LDAP propres &agrave; Microsoft s'effectue &agrave; l'int&eacute;rieur
	du registre syst&egrave;me, et aucune directive de configuration n'est
	requise.</p>

        <p>SSL et TLS sont tous deux support&eacute;s en utilisant des URLs de
	type ldaps://, ou en d&eacute;finissant la directive LDAPTrustedMode &agrave;
	cet effet.</p>

        <p>Note: L'&eacute;tat du support des certificats clients n'est pas
	encore connu pour ce SDK.</p>

    </section>

</section>

<directivesynopsis>
<name>LDAPSharedCacheSize</name>
<description>Taille en octets du cache en m&eacute;moire partag&eacute;e</description>
<syntax>LDAPSharedCacheSize <var>octets</var></syntax>
<default>LDAPSharedCacheSize 500000</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de sp&eacute;cifier le nombre d'octets &agrave; allouer
    pour le cache en m&eacute;moire partag&eacute;e. La valeur par
    d&eacute;faut est 500kb.
    Si elle est d&eacute;finie &agrave; 0, le cache en m&eacute;moire partag&eacute;e ne sera pas
    utilis&eacute; et chaque processus HTTPD va cr&eacute;er son propre cache.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPSharedCacheFile</name>
<description>D&eacute;finit le fichier du cache en m&eacute;moire
partag&eacute;e</description>
<syntax>LDAPSharedCacheFile <var>chemin/fichier</var></syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de sp&eacute;cifier le chemin du
    fichier du cache en m&eacute;moire partag&eacute;e. Si elle n'est pas d&eacute;finie, la
    m&eacute;moire partag&eacute;e anonyme sera utilis&eacute;e si la plate-forme la
    supporte.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPCacheEntries</name>
<description>Nombre maximum d'entr&eacute;es dans le cache LDAP
primaire</description>
<syntax>LDAPCacheEntries <var>nombre</var></syntax>
<default>LDAPCacheEntries 1024</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de sp&eacute;cifier la taille maximale du cache
    LDAP primaire. Ce cache contient les r&eacute;sultats de
    recherche/identification positifs. D&eacute;finissez-la &agrave; 0 pour d&eacute;sactiver
    la mise en cache des r&eacute;sultats de recherche/identification positifs.
    La taille par d&eacute;faut est de 1024 recherches en cache.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPCacheTTL</name>
<description>Dur&eacute;e pendant laquelle les entr&eacute;es du cache restent
valides.</description>
<syntax>LDAPCacheTTL <var>secondes</var></syntax>
<default>LDAPCacheTTL 600</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de sp&eacute;cifier la dur&eacute;e (en secondes)
    pendant laquelle une entr&eacute;e du cache de recherche/identification
    reste valide. La valeur par d&eacute;faut est de 600 secondes (10
    minutes).</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPOpCacheEntries</name>
<description>Nombre d'entr&eacute;es utilis&eacute;es pour mettre en cache les
op&eacute;rations de comparaison LDAP</description>
<syntax>LDAPOpCacheEntries <var>nombre</var></syntax>
<default>LDAPOpCacheEntries 1024</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de sp&eacute;cifier le nombre d'entr&eacute;es que
    <module>mod_ldap</module> va utiliser pour mettre en cache les
    op&eacute;rations de comparaison LDAP. La valeur par d&eacute;faut est de 1024
    entr&eacute;es. Si elle est d&eacute;finie &agrave; 0, la mise en cache des op&eacute;rations de
    comparaison LDAP est d&eacute;sactiv&eacute;e.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPOpCacheTTL</name>
<description>Dur&eacute;e pendant laquelle les entr&eacute;es du cache d'op&eacute;rations
restent valides</description>
<syntax>LDAPOpCacheTTL <var>secondes</var></syntax>
<default>LDAPOpCacheTTL 600</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de sp&eacute;cifier la dur&eacute;e (en secondes)
    pendant laquelle les entr&eacute;es du cache d'op&eacute;rations restent valides.
    La valeur par d&eacute;faut est de 600 secondes.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPReferralHopLimit</name>
<description>Le nombre maximum de redirections vers des serveurs
alternatifs (referrals) avant l'abandon de la requ&ecirc;te
LDAP.</description>
<syntax>LDAPReferralHopLimit <var>nombre</var></syntax>
<default>D&eacute;pend du SDK, en g&eacute;n&eacute;ral entre 5 et 10</default>
<contextlist><context>directory</context><context>.htaccess</context></contextlist>
<override>AuthConfig</override>

<usage>
    <p>Si elle est activ&eacute;e par la directive <directive>LDAPReferrals</directive>,
    cette directive permet de d&eacute;finir le nombre maximum de sauts vers
    des serveurs alternatifs (referrals) avant l'abandon de la requ&ecirc;te
    LDAP.</p>

<note type="warning">
<p>L'ajustement de ce param&egrave;tre n'est pas commun &agrave; tous les SDKs LDAP.</p>
</note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPReferrals</name>
<description>Active la redirection vers des serveurs alternatifs au
cours des requ&ecirc;tes vers le serveur LDAP.</description>
<syntax>LDAPReferrals <var>On|Off|default</var></syntax>
<default>LDAPReferrals On</default>
<contextlist><context>directory</context><context>.htaccess</context></contextlist>
<override>AuthConfig</override>
<compatibility>Le param&egrave;tre <var>default</var> est disponible depuis la
version 2.4.7 du serveur HTTP Apache.</compatibility>

<usage>
    <p>Certains serveurs LDAP partagent leur annuaire en plusieurs
    domaines et utilisent le syst&egrave;me des redirections (referrals) pour
    aiguiller un client lorsque les limites d'un domaine doivent &ecirc;tre
    franchies. Ce processus est similaire &agrave; une redirection HTTP. Les
    biblioth&egrave;ques client LDAP ne respectent pas forc&eacute;ment ces
    redirections par d&eacute;faut. Cette directive permet de configurer
    explicitement les redirections LDAP dans le SDK sous-jacent.</p>

    <p>La directive <directive>LDAPReferrals</directive> accepte les
    valeurs suivantes :</p>

    <dl>
     <dt>"on"</dt>
     <dd> <p>Avec la valeur "on", la prise en compte des redirections
     LDAP par le SDK sous-jacent est activ&eacute;e, la directive
     <directive>LDAPReferralHopLimit</directive> permet de surcharger la
     "hop limit" du SDK, et un "LDAP rebind callback" est enregistr&eacute;.</p></dd>
     <dt>"off"</dt>
     <dd> <p>Avec la valeur "off", la prise en compte des redirections
     LDAP par le SDK sous-jacent est compl&egrave;tement d&eacute;sactiv&eacute;e.</p></dd>
     <dt>"default"</dt>
     <dd> <p>Avec la valeur "default", la prise en compte des redirections
     LDAP par le SDK sous-jacent n'est pas modifi&eacute;e, la directive
     <directive>LDAPReferralHopLimit</directive> ne permet pas de surcharger la
     "hop limit" du SDK, et aucun "LDAP rebind callback" n'est enregistr&eacute;.</p></dd>
    </dl>
    
    <p>La directive <directive>LDAPReferralHopLimit</directive> travaille en
    conjonction avec cette directive pour limiter le nombre de
    redirections &agrave; suivre pour achever le traitement de la requ&ecirc;te LDAP.
    Lorsque le processus de redirection est activ&eacute; par la valeur "On",
    les donn&eacute;es d'authentification du client sont transmises via un
    "rebind callback" &agrave; tout serveur LDAP qui en fait la demande.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPRetryDelay</name>
<description>D&eacute;finit le temps d'attente avant un autre essai de connexion au
serveur LDAP.</description>
<syntax>LDAPRetryDelay <var>secondes</var></syntax>
<default>LDAPRetryDelay 0</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Si la directive <directive>LDAPRetryDelay</directive> est d&eacute;finie
    &agrave; une valeur diff&eacute;rente de 0, le serveur attendra pendant la dur&eacute;e
    sp&eacute;cifi&eacute;e pour envoyer &agrave; nouveau sa requ&ecirc;te LDAP. Une valeur de 0
    implique une absence de d&eacute;lai pour les essais successifs.</p>

    <p>Il est possible d'effectuer une autre tentative de connexion en
    cas d'erreurs LDAP du type d&eacute;lai d&eacute;pass&eacute; ou connexion refus&eacute;e. </p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPRetries</name>
<description>D&eacute;finit le nombre maximum de tentatives de connexions au
serveur LDAP.</description>
<syntax>LDAPRetries <var>nombre d'essais</var></syntax>
<default>LDAPRetries 3</default>
<contextlist><context>server config</context></contextlist>
<usage>
    <p>Suite &agrave; des &eacute;checs de connexion au serveur LDAP, le serveur
    tentera de se connecter autant de fois qu'indiqu&eacute; par la directive
    <directive>LDAPRetries</directive>. Si cette directive est d&eacute;finie &agrave;
    0, le serveur ne tentera pas d'autre connexion apr&egrave;s un &eacute;chec.</p>
    <p>Il est possible d'effectuer une autre tentative de connexion en
    cas d'erreurs LDAP du type d&eacute;lai d&eacute;pass&eacute; ou connexion refus&eacute;e. </p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPTrustedGlobalCert</name>
<description>D&eacute;finit le nom de fichier ou la base de donn&eacute;es contenant
les Autorit&eacute;s de Certification de confiance globales ou les certificats
clients globaux</description>
<syntax>LDAPTrustedGlobalCert <var>type</var>
<var>chemin/nom-fichier</var> <var>[mot de passe]</var></syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de sp&eacute;cifier le chemin et le nom du
    fichier contenant les certificats des CA de confiance et/ou les
    certificats clients du syst&egrave;me global que <module>mod_ldap</module>
    utilisera pour &eacute;tablir une connexion SSL ou TLS avec un serveur
    LDAP. Notez que toute information relative aux certificats sp&eacute;cifi&eacute;e
    en utilisant cette directive s'applique globalement &agrave; l'ensemble de
    l'installation du serveur. Certains SDK LDAP (en particulier Novell)
    n&eacute;cessitent la d&eacute;finition globale de tous les certificats clients en
    utilisant cette directive. La plupart des autres SDK n&eacute;cessitent la
    d&eacute;finition des certificats clients dans une section Directory ou
    Location en utilisant la directive LDAPTrustedClientCert. Si vous ne
    d&eacute;finissez pas ces directives correctement, une erreur sera g&eacute;n&eacute;r&eacute;e
    lors des tentatives de contact avec un serveur LDAP, ou la connexion
    &eacute;chouera silencieusement (Voir plus haut le guide des certificats
    SSL/TLS pour plus de d&eacute;tails). Le param&egrave;tre type sp&eacute;cifie le type de
    certificat en cours de d&eacute;finition, en fonction du SDK LDAP utilis&eacute;.
    Les types support&eacute;s sont :</p>
    <ul>
      <li>CA_DER - certificat de CA cod&eacute; en binaire DER</li>
      <li>CA_BASE64 - certificat de CA cod&eacute; en PEM</li>
      <li>CA_CERT7_DB - fichier de base de donn&eacute;es des certificats de CA
      de Netscape cert7.db</li>
      <li>CA_SECMOD - fichier de base de donn&eacute;es secmod de Netscape</li>
      <li>CERT_DER - certificat client cod&eacute; en binaire DER</li>
      <li>CERT_BASE64 - certificat client cod&eacute; en PEM</li>
      <li>CERT_KEY3_DB - fichier de base de donn&eacute;es des certificats
      clients de Netscape key3.db</li>
      <li>CERT_NICKNAME - certificat client "nickname" (SDK Netscape)</li>
      <li>CERT_PFX - certificat client cod&eacute; en PKCS#12 (SDK Novell)</li>
      <li>KEY_DER - cl&eacute; priv&eacute;e cod&eacute;e en binaire DER</li>
      <li>KEY_BASE64 - cl&eacute; priv&eacute;e cod&eacute;e en PEM</li>
      <li>KEY_PFX - cl&eacute; priv&eacute;e cod&eacute;e en PKCS#12 (SDK Novell)</li>
    </ul>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPTrustedClientCert</name>
<description>D&eacute;finit le nom de fichier contenant un certificat client ou
un alias renvoyant vers un certificat client sp&eacute;cifique &agrave; une connexion.
Tous les SDK LDAP ne supportent pas les certificats clients par
connexion.</description>
<syntax>LDAPTrustedClientCert <var>type</var>
<var>chemin/nom-fichier/alias</var> <var>[mot de passe]</var></syntax>
<contextlist><context>server config</context><context>virtual
host</context><context>directory</context><context>.htaccess</context></contextlist>

<usage>
    <p>Cette directive permet de sp&eacute;cifier le chemin et le nom de
    fichier ou l'alias d'un certificat client par connexion utilis&eacute; lors
    de l'&eacute;tablissement d'une connexion SSL ou TLS avec un serveur LDAP.
    Les sections directory ou location peuvent poss&eacute;der leurs propres
    configurations de certificats clients. Certains SDK LDAP (en
    particulier Novell) ne supportent pas les certificats clients par
    connexion, et renvoient une erreur lors de la connexion au serveur
    LDAP si vous tenter d'utiliser cette directive (Utilisez &agrave; la place
    la directive LDAPTrustedGlobalCert pour les certificats clients sous
    Novell - Voir plus haut le guide des certificats SSL/TLS pour plus
    de d&eacute;tails). Le param&egrave;tre type sp&eacute;cifie le type du certificat en
    cours de d&eacute;finition, en fonction du SDK LDAP utilis&eacute;. Les types
    support&eacute;s sont :</p>
    <ul>
      <li>CA_DER - certificat de CA cod&eacute; en binaire DER</li>
      <li>CA_BASE64 - certificat de CA cod&eacute; en PEM</li>
      <li>CERT_DER - certificat client cod&eacute; en binaire DER</li>
      <li>CERT_BASE64 - certificat client cod&eacute; en PEM</li>
      <li>CERT_NICKNAME - certificat client "nickname" (SDK Netscape)</li>
      <li>KEY_DER - cl&eacute; priv&eacute;e cod&eacute;e en binaire DER</li>
      <li>KEY_BASE64 - cl&eacute; priv&eacute;e cod&eacute;e en PEM</li>
    </ul>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPTrustedMode</name>
<description>Sp&eacute;cifie le mode (SSL ou TLS) &agrave; utiliser lors de la
connexion &agrave; un serveur LDAP.</description>
<syntax>LDAPTrustedMode <var>type</var></syntax>
<contextlist><context>server config</context><context>virtual
host</context></contextlist>

<usage>
    <p>Les modes suivants sont support&eacute;s :</p>
    <ul>
      <li>NONE - aucun chiffrement</li>
      <li>SSL - chiffrement ldaps:// sur le port par d&eacute;faut 636</li>
      <li>TLS - chiffrement STARTTLS sur le port par d&eacute;faut 389</li>
    </ul>

    <p>Les modes ci-dessus ne sont pas support&eacute;s par tous les SDK LDAP.
    Un message d'erreur sera g&eacute;n&eacute;r&eacute; &agrave; l'ex&eacute;cution si un mode n'est pas
    support&eacute;, et la connexion au serveur LDAP &eacute;chouera.
    </p>

    <p>Si une URL de type ldaps:// est sp&eacute;cifi&eacute;e, le mode est forc&eacute; &agrave;
    SSL et la d&eacute;finition de LDAPTrustedMode est ignor&eacute;e.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPConnectionTimeout</name>
<description>Sp&eacute;cifie le d&eacute;lai d'attente en secondes de la socket de
connexion</description>
<syntax>LDAPConnectionTimeout <var>secondes</var></syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive configure l'option LDAP_OPT_NETWORK_TIMEOUT (ou
    LDAP_OPT_CONNECT_TIMEOUT) dans la biblioth&egrave;que client LDAP
    sous-jacente, si elle est disponible. Cette valeur repr&eacute;sente la
    dur&eacute;e pendant laquelle la biblioth&egrave;que client LDAP va attendre que
    le processus de connexion TCP au serveur LDAP soit achev&eacute;.</p>

    <p>Si la connexion n'a pas r&eacute;ussi avant ce d&eacute;lai, une erreur sera
    renvoy&eacute;e, ou la biblioth&egrave;que client LDAP tentera de se connecter &agrave;
    un second serveur LDAP, s'il en a &eacute;t&eacute; d&eacute;fini un (via une liste de
    noms d'h&ocirc;tes s&eacute;par&eacute;s par des espaces dans la directive <directive
    module="mod_authnz_ldap">AuthLDAPURL</directive>).</p>

    <p>La valeur par d&eacute;faut est 10 secondes, si la biblioth&egrave;que client
    LDAP li&eacute;e avec le serveur supporte l'option
    LDAP_OPT_NETWORK_TIMEOUT.</p>

    <note>LDAPConnectionTimeout n'est disponible que si la biblioth&egrave;que client
    LDAP li&eacute;e avec le serveur supporte l'option
    LDAP_OPT_NETWORK_TIMEOUT (ou LDAP_OPT_CONNECT_TIMEOUT), et le
    comportement final est enti&egrave;rement dict&eacute; par la biblioth&egrave;que client
    LDAP.
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPTimeout</name>
<description>Sp&eacute;cifie le d&eacute;lai d'attente pour les op&eacute;rations de
recherche et d'identification LDAP en secondes</description>
<syntax>LDAPTimeout <var>secondes</var></syntax>
<default>LDAPTimeout 60</default>
<contextlist><context>server config</context></contextlist>
<compatibility>Disponible &agrave; partir de la version 2.3.5 du serveur HTTP
Apache</compatibility>

<usage>
    <p>Cette directive permet de sp&eacute;cifier le d&eacute;lai d'attente pour les
    op&eacute;rations de recherche et d'identification, ainsi que l'option
    LDAP_OPT_TIMEOUT dans la biblioth&egrave;que LDAP client sous-jacente,
    lorsqu'elle est disponible.</p>

    <p>Lorsque le d&eacute;lai est atteint, httpd va refaire un essai dans le
    cas o&ugrave; une connexion existante a &eacute;t&eacute; silencieusement ferm&eacute;e par un
    pare-feu. Les performances seront cependant bien meilleures si le
    pare-feu est configur&eacute; pour envoyer des paquets TCP RST au lieu de
    rejeter silencieusement les paquets.</p>

    <note>
    <p>Les d&eacute;lais pour les op&eacute;rations de comparaison LDAP n&eacute;cessitent un
    SDK avec LDAP_OPT_TIMEOUT, comme OpenLDAP &gt;= 2.4.4.</p>
    </note>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPVerifyServerCert</name>
<description>Force la v&eacute;rification du certificat du
serveur</description>
<syntax>LDAPVerifyServerCert <var>On|Off</var></syntax>
<default>LDAPVerifyServerCert On</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de sp&eacute;cifier s'il faut forcer la
    v&eacute;rification d'un certificat de serveur lors de l'&eacute;tablissement
    d'une connexion SSL avec un serveur LDAP.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPConnectionPoolTTL</name>
<description>D&eacute;sactive les connexions d'arri&egrave;re-plan qui sont rest&eacute;es
inactives trop longtemps au sein du jeu de connexions.</description>
<syntax>LDAPConnectionPoolTTL <var>n</var></syntax>
<default>LDAPConnectionPoolTTL -1</default>
<contextlist><context>server config</context><context>virtual host</context></contextlist>
<compatibility>Disponible &agrave; partir de la version 2.3.12 du serveur HTTP
Apache</compatibility>

<usage>
    <p>Cette directive permet de sp&eacute;cifier la dur&eacute;e maximale, en
    secondes, pendant laquelle une connexion LDAP du jeu de connexions
    peut demeurer inactive, mais rester quand-m&ecirc;me disponible pour une
    utilisation &eacute;ventuelle. Le jeu de connexions est nettoy&eacute; au fur et &agrave;
    mesure des besoins, de mani&egrave;re non asynchrone.</p>

    <p>Si cette directive est d&eacute;finie &agrave; 0, les connexions ne sont jamais
    sauvegard&eacute;es dans le jeu de connexions d'arri&egrave;re-plan. Avec la
    valeur par d&eacute;faut -1, ou toute autre valeur n&eacute;gative, les connexions
    peuvent &ecirc;tre r&eacute;utilis&eacute;es sans limite de dur&eacute;e.</p>

    <p>Dans le but d'am&eacute;liorer les performances, le temps de r&eacute;f&eacute;rence
    qu'utilise cette directive correspond au moment o&ugrave; la connexion LDAP
    est enregistr&eacute;e ou remise dans le jeu de connexions, et non au
    moment du dernier &eacute;change r&eacute;ussi avec le serveur LDAP.</p>

    <p>La version 2.4.10 a introduit de nouvelles mesures permettant
    d'&eacute;viter une augmentation excessive du temps de r&eacute;f&eacute;rence due &agrave; des
    correspondances positives dans le cache ou des requ&ecirc;tes lentes. A
    cet effet, le temps de r&eacute;f&eacute;rence n'est pas r&eacute;actualis&eacute; si aucune
    connexion LDAP d'arri&egrave;re-plan n'est requise ; d'autre part, le temps
    de r&eacute;f&eacute;rence se base sur le moment o&ugrave; la requ&ecirc;te HTTP est re&ccedil;ue, et
    non sur le moment o&ugrave; la requ&ecirc;te a &eacute;t&eacute; trait&eacute;e.</p>

    <note><p>Cette dur&eacute;e de vie s'exprime par d&eacute;faut en secondes, mais
    il est possible d'utiliser d'autres unit&eacute;s en ajoutant un suffixe :
    millisecondes (ms), minutes (min), ou heures (h).
    </p></note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPLibraryDebug</name>
<description>Active le d&eacute;bogage dans le SDK LDAP</description>
<syntax>LDAPLibraryDebug <var>7</var></syntax>
<default>disabled</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Active les options de d&eacute;bogage LDAP sp&eacute;cifiques au SDK, qui
    entra&icirc;nent en g&eacute;n&eacute;ral une journalisation d'informations verbeuses du
    SDK LDAP dans le journal principal des erreurs d'Apache. Les
    messages de traces en provenance du SDK LDAP fournissent des
    informations tr&egrave;s d&eacute;taill&eacute;es qui peuvent s'av&eacute;rer utiles lors du
    d&eacute;bogage des probl&egrave;mes de connexion avec des serveurs LDAP
    d'arri&egrave;re-plan.</p>

    <p>Cette option n'est configurable que lorsque le serveur HTTP
    Apache est li&eacute; avec un SDK LDAP qui impl&eacute;mente
    <code>LDAP_OPT_DEBUG</code> ou <code>LDAP_OPT_DEBUG_LEVEL</code>,
    comme OpenLDAP (une valeur de 7 est verbeuse) ou Tivoli Directory
    Server (une valeur de 65535 est verbeuse).</p>

    <note type="warning">
    <p>Les informations journalis&eacute;es peuvent contenir des donn&eacute;es
    d'authentification en clair utilis&eacute;es ou valid&eacute;es lors de
    l'authentification LDAP ; vous devez donc prendre soin de prot&eacute;ger
    et de purger le journal des erreurs lorsque cette directive est
    utilis&eacute;e.</p>
    </note>

</usage>
</directivesynopsis>

</modulesynopsis>
