<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1678567 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_mime.xml.meta">

<name>mod_mime</name>
<description>Associe les extensions des fichiers demand&eacute;s avec l'action
d&eacute;clench&eacute;e par ces fichiers et avec leur contenu (type MIME, langue,
jeu de caract&egrave;re et codage)</description>
<status>Base</status>
<sourcefile>mod_mime.c</sourcefile>
<identifier>mime_module</identifier>

<summary>
    <p>Ce module permet d'assigner des m&eacute;tadonn&eacute;es aux contenus
    s&eacute;lectionn&eacute;s pour une r&eacute;ponse HTTP, en associant des mod&egrave;les d'URI
    ou de noms de fichiers aux valeurs des m&eacute;tadonn&eacute;es. Par exemple, les
    extensions de noms de fichiers d&eacute;finissent souvent le type de m&eacute;dium
    Internet, la langue, le jeu de caract&egrave;res et le codage du contenu.
    Ces informations sont relay&eacute;es par les messages HTTP v&eacute;hiculant ces
    contenus, et utilis&eacute;es au cours de la n&eacute;gociation de contenu lors de
    la s&eacute;lection des diff&eacute;rentes possibilit&eacute;s, de mani&egrave;re &agrave; ce que les
    pr&eacute;f&eacute;rences des utilisateurs soient respect&eacute;es lors du choix d'un
    contenu &agrave; servir parmi plusieurs autres contenus. Voir
    <module>mod_negotiation</module> pour plus d'informations &agrave; propos
    de la <a href="../content-negotiation.html">n&eacute;gociation de
    contenu</a>.</p>

    <p>Les directives <directive
    module="mod_mime">AddCharset</directive>, <directive
    module="mod_mime">AddEncoding</directive>, <directive
    module="mod_mime">AddLanguage</directive> et <directive
    module="mod_mime">AddType</directive> permettent d'associer des
    extensions de fichiers aux m&eacute;tadonn&eacute;es de ces fichiers. Elles
    d&eacute;finissent respectivement le jeu de caract&egrave;res, le codage du
    contenu, la langue du contenu et le <glossary>type de
    m&eacute;dium</glossary> (content-type) des documents. La directive
    <directive module="mod_mime">TypesConfig</directive> permet de
    sp&eacute;cifier un fichier qui contient lui-m&ecirc;me des associations entre
    extensions et types de media.</p>

    <p>De plus, <module>mod_mime</module> peut d&eacute;finir le <a
    href="../handler.html">gestionnaire</a> et les <a
    href="../filter.html">filtres</a> qui sont &agrave; l'origine du contenu et
    le traitent. Les directives <directive
    module="mod_mime">AddHandler</directive>, <directive
    module="mod_mime">AddOutputFilter</directive>, et <directive
    module="mod_mime">AddInputFilter</directive> permettent de contr&ocirc;ler
    les modules ou les scripts qui vont servir le document. La directive
    <directive module="mod_mime">MultiviewsMatch</directive> permet &agrave;
    <module>mod_negotiation</module> de d&eacute;terminer les extensions de
    fichiers &agrave; inclure lors des tests de correspondances multivues.</p>

    <p>Alors que <module>mod_mime</module> associe des m&eacute;tadonn&eacute;es avec
    des extensions de fichiers, le serveur de base <module>core</module>
    fournit des directives permettant d'associer tous les fichiers d'un
    conteneur donn&eacute; (par exemple <directive type="section"
    module="core">Location</directive>, <directive type="section"
    module="core">Directory</directive>, ou <directive type="section"
    module="core">Files</directive>) avec des m&eacute;tadonn&eacute;es particuli&egrave;res.
    Parmi ces directives, on trouve <directive
    module="core">ForceType</directive>, <directive
    module="core">SetHandler</directive>, <directive
    module="core">SetInputFilter</directive>, et <directive
    module="core">SetOutputFilter</directive>. Les directives du serveur
    de base l'emportent sur toute directive d'association d'extensions
    de noms de fichiers d&eacute;finie par <module>mod_mime</module>.</p>

    <p>Notez que la modification des m&eacute;tadonn&eacute;es d'un fichier ne modifie
    pas la valeur de l'en-t&ecirc;te <code>Last-Modified</code>. Ainsi,
    certaines copies de documents pr&eacute;alablement mises en cache peuvent
    encore &ecirc;tre utilis&eacute;es par un client ou un mandataire avec les
    anciens en-t&ecirc;tes. Si vous modifiez les m&eacute;tadonn&eacute;es (langue, type de
    contenu, jeu de caract&egrave;re ou codage), vous devez donc enregistrer
    une modification du fichier concern&eacute; (afin de mettre &agrave; jour sa date
    de derni&egrave;re modification), pour &ecirc;tre s&ucirc;r que tous les visiteurs
    recevront le documents avec les en-t&ecirc;tes corrects. </p>
</summary>
<seealso><directive
module="mod_mime_magic">MimeMagicFile</directive></seealso>
<seealso><directive module="core">AddDefaultCharset</directive></seealso>
<seealso><directive module="core">ForceType</directive></seealso>
<seealso><directive module="core">SetHandler</directive></seealso>
<seealso><directive module="core">SetInputFilter</directive></seealso>
<seealso><directive module="core">SetOutputFilter</directive></seealso>

<section id="multipleext"><title>Fichiers avec extensions
multiples</title>
    <p>Les fichiers peuvent poss&eacute;der plusieurs extensions dont l'ordre
    est <em>normalement</em> sans importance. Par exemple, si
    le fichier <code>welcome.html.fr</code> est associ&eacute; au type de
    contenu <code>text/html</code> et &agrave; la langue fran&ccedil;aise, le fichier
    <code>welcome.fr.html</code> poss&egrave;dera exactement les m&ecirc;me
    m&eacute;tadonn&eacute;es. Si le fichier poss&egrave;de plusieurs extensions associ&eacute;es
    au m&ecirc;me type de m&eacute;tadonn&eacute;e, c'est celle de ces extensions la plus &agrave;
    droite qui sera utilis&eacute;e, except&eacute; pour ce qui concerne les langues
    et les codages de contenu. Par exemple, si <code>.gif</code> est
    associ&eacute; au <glossary>type de m&eacute;dium</glossary>
    <code>image/gif</code>, et <code>.html</code> au type de m&eacute;dium
    <code>text/html</code>, le fichier <code>welcome.gif.html</code>
    sera associ&eacute; au type de m&eacute;dium <code>text/html</code>.</p>

    <p>Les <a href="#charset-lang">Languages</a> et les <a
    href="#contentencoding">codages de contenu</a> sont trait&eacute;s de
    mani&egrave;re cumulative, car il est possible d'assigner plusieurs
    langues ou codages &agrave; une ressource particuli&egrave;re. Par exemple, le
    fichier <code>welcome.html.en.de</code> sera servi avec les en-t&ecirc;tes
    <code>Content-Language: en, de</code> et <code>Content-Type:
    text/html</code>.</p>

    <p>Des pr&eacute;cautions doivent &ecirc;tre prises lorsqu'un fichier avec
    extensions multiples est associ&eacute; &agrave; la fois &agrave; un <glossary>type de
    m&eacute;dium</glossary> et &agrave; un gestionnaire. En g&eacute;n&eacute;ral, cela impliquera
    la gestion de la requ&ecirc;te par le module associ&eacute; au gestionnaire. Par
    exemple, si l'extension <code>.imap</code> est associ&eacute;e au
    gestionnaire <code>imap-file</code> (du module
    <module>mod_imagemap</module>), et si l'extension <code>.html</code>
    est associ&eacute;e au type de m&eacute;dium <code>text/html</code>, le fichier
    <code>world.imap.html</code> sera &agrave; la fois associ&eacute; au gestionnaire
    <code>imap-file</code> et au type de m&eacute;dium <code>text/html</code>.
    Pour son traitement, c'est le gestionnaire <code>imap-file</code>
    qui sera utilis&eacute;, et il sera donc trait&eacute; en tant que fichier
    imagemap.</p>

    <p>Si vous pr&eacute;f&eacute;rez que seule la derni&egrave;re partie d'un nom de fichier
    s&eacute;par&eacute;e du reste du nom par un point soit associ&eacute;e &agrave; une m&eacute;tadonn&eacute;e
    particuli&egrave;re, n'utilisez pas les directives <code>Add*</code>. Par
    exemple, si vous souhaitez que le fichier <code>foo.html.cgi</code>
    soit trait&eacute; en tant que script CGI, mais pas le fichier
    <code>bar.cgi.html</code>, alors, au lieu d'utiliser
    <code>AddHandler cgi-script .cgi</code>, utilisez plut&ocirc;t :</p>

    <example><title>Configuration du gestionnaire en se basant seulement
    sur la derni&egrave;re extension</title>
    <highlight language="config">
&lt;FilesMatch "[^.]+\.cgi$"&gt;
  SetHandler cgi-script
&lt;/FilesMatch&gt;
    </highlight>
    </example>

</section>

<section id="contentencoding"><title>Codage du contenu</title>
    <p>Un fichier d'un <glossary>type de m&eacute;dium</glossary> particulier
    peut &ecirc;tre &eacute;galement cod&eacute; d'une certaine mani&egrave;re pour simplifier sa
    transmission sur Internet. Alors que cela concerne en g&eacute;n&eacute;ral la
    compression, comme <code>gzip</code>, il peut aussi s'agir de
    chiffrement, comme <code>pgp</code> ou d'un codage comme UUencoding,
    qui est con&ccedil;u pour transmettre un fichier binaire sous un format
    ASCII (texte).</p>

    <p>La <a href="http://www.ietf.org/rfc/rfc2616.txt">RFC
    HTTP/1.1</a>, section 14.11 stipule &agrave; ce titre :</p>

    <blockquote cite="http://www.ietf.org/rfc/rfc2616.txt">
      <p>Le champ d'en-t&ecirc;te Content-Encoding de l'entit&eacute; est utilis&eacute; en
      tant que modificateur du type de m&eacute;dium. Lorsqu'il est pr&eacute;sent, sa
      valeur indique quels codages de contenu additionnels ont &eacute;t&eacute;
      appliqu&eacute;s au corps de l'entit&eacute;, et ainsi quels m&eacute;canismes de
      d&eacute;codage doivent &ecirc;tre appliqu&eacute;s afin de retrouver le type de
      m&eacute;dium r&eacute;f&eacute;renc&eacute; par le champ d'en-t&ecirc;te Content-Type. Le codage de
      contenu est principalement utilis&eacute; pour permettre la compression
      d'un document sans perdre l'information concernant le type de
      m&eacute;dium sous-jacent.</p>
    </blockquote>

    <p>En utilisant plusieurs extensions (voir la <a
    href="#multipleext">section ci-dessus &agrave; propos des extensions de
    fichiers multiples</a>), vous pouvez indiquer qu'un fichier est d'un
    <em>type</em>, particulier, et poss&egrave;de aussi un <em>codage</em>
    particulier.</p>

    <p>Consid&eacute;rons par exemple un fichier contenant un document
    Microsoft Word et compress&eacute; par pkzip pour r&eacute;duire sa taille. Si
    l'extension <code>.doc</code> est associ&eacute;e au type de fichier
    Microsoft Word, et si l'extension <code>.zip</code> est associ&eacute;e au
    codage de fichier pkzip, alors le fichier
    <code>Resume.doc.zip</code> sera identifi&eacute; comme document Word
    compress&eacute; par pkzip.</p>

    <p>Apache joint un en-t&ecirc;te <code>Content-encoding</code> &agrave; la
    ressource afin d'informer le navigateur client &agrave; propos de la
    m&eacute;thode de codage.</p>

    <highlight language="config">Content-encoding: pkzip</highlight>
</section>

<section id="charset-lang"><title>Jeux de caract&egrave;res et langues</title>
    <p>En plus du type de fichier et du codage, un autre &eacute;l&eacute;ment
    important d'information est la langue dans laquelle le document est
    &eacute;crit, et avec quel jeu de caract&egrave;res le contenu du fichier doit
    &ecirc;tre affich&eacute;. Par exemple, un document peut &ecirc;tre &eacute;crit en alphabet
    vietnamien ou cyrillique, et doit &ecirc;tre affich&eacute; en cons&eacute;quence. Cette
    information est &eacute;galement transmise via des en-t&ecirc;tes HTTP.</p>

    <p>Les jeu de caract&egrave;res, langue, codage et type MIME sont tous
    utilis&eacute;s au cours du processus de n&eacute;gociation de contenu (voir
    <module>mod_negotiation</module>) afin de d&eacute;terminer quel document
    servir au client, lorsque plusieurs choix sont possibles en fonction
    du jeu de caract&egrave;res, de la langue, du codage ou du type MIME. Toutes
    les associations d'extensions de noms de fichiers cr&eacute;&eacute;es via les
    directives <directive module="mod_mime">AddCharset</directive>,
    <directive module="mod_mime">AddEncoding</directive>, <directive
    module="mod_mime">AddLanguage</directive> et <directive
    module="mod_mime">AddType</directive> (ainsi que les associations
    d'extensions list&eacute;es dans le fichier d&eacute;fini par la directive
    <directive module="mod_mime_magic">MimeMagicFile</directive>),
    participent &agrave; ce processus de s&eacute;lection. Les extensions de noms de
    fichiers qui n'ont &eacute;t&eacute; associ&eacute;s que par des directives <directive
    module="mod_mime">AddHandler</directive>, <directive
    module="mod_mime" >AddInputFilter</directive> ou <directive
    module="mod_mime">AddOutputFilter</directive>, peuvent &ecirc;tre incluses
    ou exclues du processus de s&eacute;lection en utilisant la directive
    <directive module="mod_mime">MultiviewsMatch</directive>.</p>

    <section id="charset"><title>Jeu de caract&egrave;res</title>
      <p>Pour transmettre cette information suppl&eacute;mentaire, Apache peut
      ajouter un en-t&ecirc;te <code>Content-Language</code>, afin de
      sp&eacute;cifier la langue dans laquelle le document est &eacute;crit, et peut
      ajouter des informations additionnelles &agrave; l'en-t&ecirc;te
      <code>Content-Type</code> pour indiquer le jeu de caract&egrave;res
      particulier qui doit &ecirc;tre utilis&eacute; pour restituer correctement le
      document.</p>

      <example>
        Content-Language: en, fr
Content-Type: text/plain; charset=ISO-8859-1
      </example>

      <p>La langue est sp&eacute;cifi&eacute;e via son abr&eacute;viation en deux lettres. Le
      <code>jeu de caract&egrave;res</code> est le nom du jeu de caract&egrave;res
      particulier qui doit &ecirc;tre utilis&eacute;.</p>
    </section>
</section>

<directivesynopsis>
<name>AddCharset</name>
<description>Associe les extensions de noms de fichiers sp&eacute;cifi&eacute;es au
jeu de caract&egrave;res sp&eacute;cifi&eacute;</description>
<syntax>AddCharset <var>jeu-car</var> <var>extension</var>
[<var>extension</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>AddCharset</directive> permet d'associer
    les extensions de noms de fichiers sp&eacute;cifi&eacute;es au jeu de caract&egrave;res
    sp&eacute;cifi&eacute; (le nom enregistr&eacute; sur l'Internet d'un codage de caract&egrave;res
    donn&eacute;). <var>jeu-car</var> est le <a
    href="http://www.iana.org/assignments/character-sets">param&egrave;tre jeu
    de caract&egrave;res du type de m&eacute;dium</a> pour les ressources dont le nom
    de fichier contient <var>extension</var>. Cette association est
    ajout&eacute;e &agrave; toutes les autres d&eacute;j&agrave; en vigueur, et &eacute;crase toute
    association pr&eacute;existante pour la m&ecirc;me <var>extension</var>.</p>

    <example><title>Exemple</title>
      <highlight language="config">
AddLanguage ja .ja
AddCharset EUC-JP .euc
AddCharset ISO-2022-JP .jis
AddCharset SHIFT_JIS .sjis
      </highlight>
    </example>

    <p>Avec cet exemple, le document <code>xxxx.ja.jis</code> sera
    trait&eacute; en tant que document japonais dont le jeu de caract&egrave;re est
    <code>ISO-2022-JP</code> (idem pour le document
    <code>xxxx.jis.ja</code>). La directive
    <directive>AddCharset</directive> sert &agrave; la fois &agrave; informer le
    client sur le codage des caract&egrave;res du document afin que ce dernier
    puisse &ecirc;tre interpr&eacute;t&eacute; et affich&eacute; correctement, et &agrave; la <a
    href="../content-negotiation.html">n&eacute;gociation de contenu</a>, au
    cours de laquelle le serveur d&eacute;cide lequel parmi plusieurs
    documents possibles il renvoie au client en fonction des pr&eacute;f&eacute;rences
    de ce dernier en mati&egrave;re de jeu de caract&egrave;res.</p>

    <p>L'argument <var>extension</var> est insensible &agrave; la casse et peut
    &ecirc;tre sp&eacute;cifi&eacute; avec ou sans le point initial. Les noms de fichiers
    peuvent poss&eacute;der <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera compar&eacute; &agrave; chacune d'entre
    elles.</p>

</usage>
<seealso><module>mod_negotiation</module></seealso>
<seealso><directive module="core">AddDefaultCharset</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AddEncoding</name>
<description>Associe les extensions de noms de fichiers donn&eacute;es au type
de codage sp&eacute;cifi&eacute;</description>
<syntax>AddEncoding <var>codage</var> <var>extension</var>
[<var>extension</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>AddEncoding</directive> permet d'associer
    les extensions de noms de fichiers donn&eacute;es au codage de contenu HTTP
    sp&eacute;cifi&eacute;. <var>codage</var> est le codage de contenu HTTP &agrave; ajouter
    &agrave; la valeur du champ d'en-t&ecirc;te Content-Encoding pour les documents
    poss&eacute;dant l'<var>extension</var> sp&eacute;cifi&eacute;e. Cette association est
    ajout&eacute;e &agrave; toutes les autres d&eacute;j&agrave; en vigueur, et &eacute;crase toute
    association pr&eacute;existante pour la m&ecirc;me <var>extension</var>.</p>

    <example><title>Exemple</title>
      <highlight language="config">
AddEncoding x-gzip .gz
AddEncoding x-compress .Z
      </highlight>
    </example>

    <p>Avec cet exemple, les noms de fichiers poss&eacute;dant l'extension
    <code>.gz</code> seront marqu&eacute;s comme cod&eacute;s &agrave; l'aide du codage
    <code>x-gzip</code>, et les noms de fichiers poss&eacute;dant l'extension
    <code>.Z</code> comme cod&eacute;s avec <code>x-compress</code>.</p>

    <p>Les clients anciens n'acceptent que <code>x-gzip</code> et
    <code>x-compress</code>, bien que les standards stipulent qu'ils
    sont respectivement &eacute;quivalents &agrave; <code>gzip</code> et
    <code>compress</code>. Apache effectue ses comparaisons de codages
    de contenu en ignorant tout pr&eacute;fixe <code>x-</code>. Lorsqu'il
    r&eacute;pond avec un codage, Apache utilise l'une ou l'autre forme (c'est
    &agrave; dire <code>x-foo</code> ou <code>foo</code>) selon les besoins du
    client. Si le client n'a pas besoin d'une forme particuli&egrave;re, Apache
    utilisera la forme employ&eacute;e par la directive
    <code>AddEncoding</code>. Pour r&eacute;sumer, vous devez toujours utiliser
    <code>x-gzip</code> et <code>x-compress</code> pour ces deux
    codages sp&eacute;cifiques. Certains codages plus r&eacute;cents, comme
    <code>deflate</code>, doivent &ecirc;tre sp&eacute;cifi&eacute;s sans le pr&eacute;fixe
    <code>x-</code>.</p>

    <p>L'argument <var>extension</var> est insensible &agrave; la casse et peut
    &ecirc;tre sp&eacute;cifi&eacute; avec ou sans le point initial. Les noms de fichiers
    peuvent poss&eacute;der <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera compar&eacute; &agrave; chacune d'entre
    elles.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AddHandler</name>
<description>Associe les extensions de noms de fichiers donn&eacute;es au
gestionnaire sp&eacute;cifi&eacute;</description>
<syntax>AddHandler <var>nom-gestionnaire</var> <var>extension</var>
[<var>extension</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>Les fichiers dont le nom a pour extension <var>extension</var>
    seront servis par le <var><a
    href="../handler.html">nom-gestionnaire</a></var> sp&eacute;cifi&eacute;. Cette
    association est ajout&eacute;e &agrave; toutes les autres d&eacute;j&agrave; en vigueur, et
    &eacute;crase toute association pr&eacute;existante pour la m&ecirc;me
    <var>extension</var>. Par exemple, pour associer les scripts CGI
    avec l'extension de fichier <code>.cgi</code>, vous pouvez utiliser
    :</p>

    <highlight language="config">
      AddHandler cgi-script .cgi
    </highlight>

    <p>Une fois cette ligne ins&eacute;r&eacute;e dans votre fichier httpd.conf, tout
    fichier poss&eacute;dant l'extension <code>.cgi</code> sera trait&eacute; en tant
    que programme CGI.</p>

    <p>L'argument <var>extension</var> est insensible &agrave; la casse et peut
    &ecirc;tre sp&eacute;cifi&eacute; avec ou sans le point initial. Les noms de fichiers
    peuvent poss&eacute;der <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera compar&eacute; &agrave; chacune d'entre
    elles.</p>
</usage>
<seealso><directive module="core">SetHandler</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AddInputFilter</name>
<description>Associe les extensions de noms de fichiers aux
filtres sp&eacute;cifi&eacute;s qui traiteront les requ&ecirc;tes clients</description>
<syntax>AddInputFilter <var>filtre</var>[;<var>filtre</var>...]
<var>extension</var> [<var>extension</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>AddInputFilter</directive> permet
    d'associer l'extension de nom de fichier <var>extension</var> aux <a
    href="../filter.html">filtres</a> sp&eacute;cifi&eacute;s qui traiteront les
    requ&ecirc;tes clients et les entr&eacute;es POST &agrave; leur r&eacute;ception par le
    serveur. Ceci s'ajoute &agrave; toute d&eacute;finition de filtre pr&eacute;existante, y
    compris la directive <directive
    module="core">SetInputFilter</directive>. Cette
    association est ajout&eacute;e &agrave; toutes les autres d&eacute;j&agrave; en vigueur, et
    &eacute;crase toute association pr&eacute;existante pour la m&ecirc;me
    <var>extension</var>.</p>

    <p>Si plusieurs <var>filtres</var> sont sp&eacute;cifi&eacute;s, ils doivent &ecirc;tre
    s&eacute;par&eacute;s par des points-virgules et inscrits dans l'ordre selon
    lequel ils devront traiter le contenu. L'argument <var>filtre</var>
    est insensible &agrave; la casse.</p>

    <p>L'argument <var>extension</var> est insensible &agrave; la casse et peut
    &ecirc;tre sp&eacute;cifi&eacute; avec ou sans le point initial. Les noms de fichiers
    peuvent poss&eacute;der <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera compar&eacute; &agrave; chacune d'entre
    elles.</p>

</usage>
<seealso><directive module="mod_mime">RemoveInputFilter</directive></seealso>
<seealso><directive module="core">SetInputFilter</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AddLanguage</name>
<description>Associe l'extension de nom de fichier donn&eacute;e &agrave; la langue
sp&eacute;cifi&eacute;</description>
<syntax>AddLanguage <var>symbole-langue</var> <var>extension</var>
[<var>extension</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>AddLanguage</directive> permet d'associer
    l'extension de nom de fichier donn&eacute;e &agrave; la langue sp&eacute;cifi&eacute;e. Les
    fichiers dont l'extension correspond &agrave; la valeur
    de l'argument <var>extension</var> se voient attribuer la valeur de
    l'argument <var>symbole-langue</var> comme en-t&ecirc;te HTTP
    Content-Language en accord avec les identifiants de langues d&eacute;finis
    par la RFC 3066. Cette directive l'emporte sur toute association
    pr&eacute;existante pour la m&ecirc;me <var>extension</var>.</p>

    <example><title>Exemple</title>
      <highlight language="config">
AddEncoding x-compress .Z
AddLanguage en .en
AddLanguage fr .fr
      </highlight>
    </example>

    <p>Avec cet exemple, le document <code>xxxx.en.Z</code> sera trait&eacute;
    en tant que document compress&eacute; de langue anglaise (idem pour le
    document <code>xxxx.Z.en</code>). Bien que la langue soit fournie au
    client, le navigateur n'utilise habituellement pas cette
    information. La directive <directive>AddLanguage</directive> est
    principalement utilis&eacute;e au cours de la <a
    href="../content-negotiation.html">n&eacute;gociation de contenu</a>, o&ugrave; le
    serveur choisit d'envoyer un document parmi plusieurs documents
    possibles en fonction de la pr&eacute;f&eacute;rence du client en mati&egrave;re de
    langue.</p>

    <p>Si une extension fait l'objet de plusieurs associations de
    langues, c'est la derni&egrave;re qui sera utilis&eacute;e. Ainsi, dans le cas
    suivant,</p>

    <highlight language="config">
AddLanguage en .en
AddLanguage en-gb .en
AddLanguage en-us .en
    </highlight>

    <p>les documents poss&eacute;dant l'extension <code>.en</code> seront
    trait&eacute;s en tant que documents de langue <code>en-us</code>.</p>

    <p>L'argument <var>extension</var> est insensible &agrave; la casse et peut
    &ecirc;tre sp&eacute;cifi&eacute; avec ou sans le point initial. Les noms de fichiers
    peuvent poss&eacute;der <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera compar&eacute; &agrave; chacune d'entre
    elles.</p>
</usage>
<seealso><module>mod_negotiation</module></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AddOutputFilter</name>
<description>Associe les extensions de noms de fichiers aux
filtres sp&eacute;cifi&eacute;s qui traiteront les r&eacute;ponses en provenance du
serveur</description>
<syntax>AddOutputFilter <var>filtre</var>[;<var>filtre</var>...]
<var>extension</var> [<var>extension</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>AddOutputFilter</directive> permet
    d'associer l'extension de nom de fichier d&eacute;finie par l'argument
    <var>extension</var> aux <a
    href="../filter.html">filtres</a> qui traiteront les r&eacute;ponses en
    provenance du serveur avant de les envoyer au client. Ces filtres
    s'ajoutent &agrave; tout filtre d&eacute;fini par d'autres directives comme
    <directive module="core">SetOutputFilter</directive> et <directive
    module="mod_filter">AddOutputFilterByType</directive>. Cette association
    est fusionn&eacute;e avec toute autre association en vigueur, et l'emporte
    sur toute association pr&eacute;existante pour la m&ecirc;me
    <var>extension</var>.</p>

    <p>Avec l'exemple suivant, tous les fichiers <code>.shtml</code>
    seront trait&eacute;s en tant qu'inclusions c&ocirc;t&eacute; serveur (SSI), et la
    sortie sera compress&eacute;e &agrave; l'aide du module
    <module>mod_deflate</module>.</p>

    <highlight language="config">
      AddOutputFilter INCLUDES;DEFLATE shtml
    </highlight>

    <p>Si plusieurs <var>filtres</var> sont sp&eacute;cifi&eacute;s, ils doivent &ecirc;tre
    s&eacute;par&eacute;s par des points-virgules et inscrits dans l'ordre selon
    lequel il devront traiter le contenu. L'argument <var>filtre</var>
    est insensible &agrave; la casse.</p>

    <p>L'argument <var>extension</var> est insensible &agrave; la casse et peut
    &ecirc;tre sp&eacute;cifi&eacute; avec ou sans le point initial. Les noms de fichiers
    peuvent poss&eacute;der <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera compar&eacute; &agrave; chacune d'entre
    elles.</p>

    <p>Notez que toute d&eacute;finition de filtres via la directive <directive
    module="mod_mime">AddOutputFilter</directive> remplace toutes les
    d&eacute;finitions pr&eacute;c&eacute;dentes effectu&eacute;es via cette m&ecirc;me directive.</p>

    <highlight language="config">
# Filtre sp&eacute;cifi&eacute; "DEFLATE"
AddOutputFilter DEFLATE shtml
&lt;Location "/foo"&gt;
  # Filtre sp&eacute;cifi&eacute; "INCLUDES", remplace "DEFLATE"
  AddOutputFilter INCLUDES shtml
&lt;/Location&gt;
&lt;Location "/bar"&gt;
  # Filtre sp&eacute;cifi&eacute; "INCLUDES;DEFLATE", remplace "DEFLATE"
  AddOutputFilter INCLUDES;DEFLATE shtml
&lt;/Location&gt;
&lt;Location "/bar/baz"&gt;
  # Filtre sp&eacute;cifi&eacute; "BUFFER", remplace "INCLUDES;DEFLATE"
  AddOutputFilter BUFFER shtml
&lt;/Location&gt;
&lt;Location "/bar/baz/buz"&gt;
  # Pas de filtre sp&eacute;cifi&eacute;, suppression de "BUFFER"
  RemoveOutputFilter shtml
&lt;/Location&gt;
    </highlight>
</usage>
<seealso><directive module="mod_mime">RemoveOutputFilter</directive></seealso>
<seealso><directive module="core">SetOutputFilter</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AddType</name>
<description>Associe les extensions de noms de fichiers au type de
contenu sp&eacute;cifi&eacute;</description>
<syntax>AddType <var>type-m&eacute;dium</var> <var>extension</var>
[<var>extension</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>AddType</directive> permet d'associer les
    extensions de noms de fichiers donn&eacute;es au type de contenu sp&eacute;cifi&eacute;.
    <var>type-m&eacute;dium</var> est le <glossary ref="media-type">Type
    MIME</glossary> &agrave; utiliser pour les fichiers dont le nom poss&egrave;de
    l'extension <var>extension</var>. Cette association s'ajoute &agrave; toute
    autre association en vigueur, et l'emporte sur toute association
    pr&eacute;existante pour la m&ecirc;me <var>extension</var>.</p>

    <note>
      Plut&ocirc;t que d'&eacute;diter directement le fichier <directive
      module="mod_mime">TypesConfig</directive>, il est recommand&eacute;
      d'utiliser la directive <directive>AddType</directive> pour
      ajouter de nouveaux types de m&eacute;dias.
    </note>

    <example><title>Exemple</title>
    <highlight language="config">
      AddType image/gif .gif
      </highlight>
    </example>

    <p>Ou, pour sp&eacute;cifier plusieurs extensions dans une seule directive
    :</p>

    <example><title>Exemple</title>
    <highlight language="config">
      AddType image/jpeg jpeg jpg jpe
      </highlight>
    </example>

    <p>L'argument <var>extension</var> est insensible &agrave; la casse et peut
    &ecirc;tre sp&eacute;cifi&eacute; avec ou sans le point initial. Les noms de fichiers
    peuvent poss&eacute;der <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera compar&eacute; &agrave; chacune d'entre
    elles.</p>

    <p>Il est possible d'obtenir un effet similaire &agrave; celui de la
    directive <directive
    module="mod_negotiation">LanguagePriority</directive> du module
    <module>mod_negotiation</module> en qualifiant un <var>type de
    m&eacute;dia</var> avec <code>qs</code> :</p>

    <example><title>Exemple</title>
      <highlight language="config">
      AddType application/rss+xml;qs=0.8 .xml
      </highlight>
    </example>

    <p>Ceci peut s'av&eacute;rer utile dans certaines situations, par exemple
    lorsqu'un client qui a ajout&eacute; un en-t&ecirc;te <code>Accept: */*</code> &agrave;
    sa requ&ecirc;te n'est pas en mesure de traiter le contenu renvoy&eacute; par le
    serveur.</p>

    <p>&Agrave; la base, cette directive configure le type de contenu g&eacute;n&eacute;r&eacute;
    pour les fichiers statiques servis &agrave; partir du syst&egrave;me de fichiers.
    Dans le cas des ressources autres que les fichiers statiques pour
    lesquelles le g&eacute;n&eacute;rateur de la r&eacute;ponse sp&eacute;cifie en g&eacute;n&eacute;ral un
    Content-Type, cette directive n'a aucun effet.</p>

    <note><title>Note</title>
    <p>Si aucun gestionnaire n'est explicitement d&eacute;fini pour une
    requ&ecirc;te, le type de contenu sp&eacute;cifi&eacute; sera aussi utilis&eacute; comme nom du
    gestionnaire.</p>

    <p>Lorsqu'aucune directive comme <directive
    module="core">SetHandler</directive> ou
    <directive>module="mod_mime">AddHandler</directive> ne s'applique &agrave;
    une requ&ecirc;te, le nom de gestionnaire interne normalement d&eacute;fini
    par une de ces directives est en fait d&eacute;fini par le type de contenu
    sp&eacute;cifi&eacute; par la pr&eacute;sente directive.</p>
    <p>
    Pour des raisons historiques, certains modules tiers comme mod_php
    peuvent adopter ce type de comportement pour prendre en compte la
    requ&ecirc;te concern&eacute;e.
    </p>
    <p>Il est conseill&eacute; d'&eacute;viter les configurations qui reposent sur de
    tels types "synth&eacute;tiques". En outre, les configurations qui
    limitent l'acc&egrave;s aux directives <directive
    module="core">SetHandler</directive> ou <directive
    module="mod_mime">AddHandler</directive> doivent aussi limiter
    l'acc&egrave;s &agrave; la directive AddType.</p>
    </note>

</usage>
<seealso><directive module="core">ForceType</directive></seealso>
<seealso><module>mod_negotiation</module></seealso>
</directivesynopsis>

<directivesynopsis>
<name>MultiviewsMatch</name>
<description>Les types de fichiers qui seront inclus lors d'une
recherche de correspondance de fichier avec les vues multiples
(MultiViews)</description>
<syntax>MultiviewsMatch Any|NegotiatedOnly|Filters|Handlers
[Handlers|Filters]</syntax>
<default>MultiviewsMatch NegotiatedOnly</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>MultiviewsMatch</directive> permet trois
    comportements diff&eacute;rents pour la fonctionnalit&eacute; Multiviews du module
    <a href="mod_negotiation.html">mod_negotiation</a>. Les vues
    multiples permettent d'associer une requ&ecirc;te pour un fichier, par
    exemple <code>index.html</code>, &agrave; toute extension n&eacute;goci&eacute;e
    s'ajoutant &agrave; la requ&ecirc;te de base, par exemple
    <code>index.html.en</code>, <code>index.html.fr</code>, ou
    <code>index.html.gz</code>.</p>

    <p>L'option <code>NegotiatedOnly</code> implique que toute extension
    s'ajoutant au nom de base doit correspondre &agrave; une extension de
    <module>mod_mime</module> reconnue pour la n&eacute;gociation de contenu,
    par exemple Charset, Content-Type, Language, ou Encoding. C'est la
    valeur d'option par d&eacute;faut, et la contrainte la plus stricte
    dont les effets de bord inattendus sont les moins nombreux.</p>

    <p>Pour inclure des extensions associ&eacute;es avec des gestionnaires
    et/ou des filtres, d&eacute;finissez la directive
    <directive>MultiviewsMatch</directive> avec les mots-cl&eacute;s
    <code>Handlers</code>, <code>Filters</code>, ou les deux. Si tous
    les autres facteurs sont &eacute;gaux, c'est le fichier de plus petite
    taille qui sera servi ; par exemple, si le choix doit s'op&eacute;rer entre
    <code>index.html.cgi</code> de 500 octets et
    <code>index.html.pl</code> de 1000 octets, c'est le fichier
    <code>.cgi</code> qui l'emportera dans cet exemple. Les utilisateurs
    de fichiers <code>.asis</code> auront avantage &agrave; utiliser l'option
    Handler, si les fichiers <code>.asis</code> sont associ&eacute;s au
    gestionnaire <code>asis-handler</code>.</p>

    <p>Vous pouvez enfin autoriser l'association de toute extension avec
    l'option <code>Any</code>, m&ecirc;me si <module>mod_mime</module> ne
    reconna&icirc;t pas l'extension. Ceci
    peut conduire &agrave; des r&eacute;sultats impr&eacute;visibles, comme l'envoi de
    fichiers .old ou .bak contrairement aux souhaits du webmaster.</p>

    <p>Par exemple, la configuration suivante va permettre l'inclusion
    des extensions associ&eacute;es aux gestionnaires et aux filtres dans les
    vues multiples, tout en excluant les fichiers de type inconnu :</p>

    <highlight language="config">
      MultiviewsMatch Handlers Filters
    </highlight>

    <p>L'utilisation de la directive
    <directive>MultiviewsMatch</directive> dans une section <directive
    type="section" module="core">Location</directive> ou <directive
    type="section" module="core">LocationMatch</directive> n'est pas
    permise.</p>

</usage>
<seealso><directive module="core">Options</directive></seealso>
<seealso><module>mod_negotiation</module></seealso>
</directivesynopsis>

<directivesynopsis>
<name>DefaultLanguage</name>
<description>D&eacute;finit un symbole de langue par d&eacute;faut &agrave; affecter au champ
d'en-t&ecirc;te Content-Language pour toutes les ressources dans le contexte
courant auxquelles aucun symbole de langue n'a &eacute;t&eacute;
associ&eacute;.</description>
<syntax>DefaultLanguage <var>symbole-langue</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>DefaultLanguage</directive> permet
    d'indiquer &agrave; Apache que toutes les ressources du contexte courant
    (par exemple, toutes les ressources concern&eacute;es par le conteneur
    <directive module="core" type="section">Directory</directive>
    courant) qui ne poss&egrave;dent pas d'extension de langue explicite
    (comme <code>.fr</code> ou <code>.de</code> tel que d&eacute;fini par la
    directive <directive module="mod_mime">AddLanguage</directive>),
    verront leur en-t&ecirc;te HTTP Content-Language affect&eacute; de la langue
    <var>symbole-langue</var>. Ceci permet de marquer des arborescences
    de r&eacute;pertoires enti&egrave;res comme contenant des documents en fran&ccedil;ais,
    par exemple, sans avoir &agrave; renommer chaque fichier. Notez qu'&agrave; la
    diff&eacute;rence de l'utilisation des extensions pour sp&eacute;cifier des
    langues, <directive>DefaultLanguage</directive> ne permet de
    sp&eacute;cifier qu'une seule langue.</p>

    <p>Si aucune directive <directive>DefaultLanguage</directive> n'est
    en vigueur, et si un fichier ne poss&egrave;de pas d'extension configur&eacute;e
    par la directive <directive
    module="mod_mime">AddLanguage</directive>, aucun champ d'en-t&ecirc;te
    Content-Language ne sera g&eacute;n&eacute;r&eacute;.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      DefaultLanguage en
      </highlight>
    </example>
</usage>
<seealso><module>mod_negotiation</module></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ModMimeUsePathInfo</name>
<description>Indique &agrave; <module>mod_mime</module> de traiter les &eacute;l&eacute;ments
de <code>path_info</code> en tant que parties du nom de
fichier</description>
<syntax>ModMimeUsePathInfo On|Off</syntax>
<default>ModMimeUsePathInfo Off</default>
<contextlist><context>directory</context></contextlist>

<usage>
    <p>La directive <directive>ModMimeUsePathInfo</directive> permet de
    combiner le nom de fichier avec la partie <code>path_info</code> de
    l'URL pour appliquer les directives <module>mod_mime</module> &agrave; la
    requ&ecirc;te. La valeur par d&eacute;faut est <code>Off</code> - situation dans
    laquelle l'&eacute;l&eacute;ment <code>path_info</code> est ignor&eacute;.</p>

    <p>L'utilisation de cette directive est conseill&eacute;e si vous utilisez
    un syst&egrave;me de fichiers virtuel.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      ModMimeUsePathInfo On
      </highlight>
    </example>

    <p>Consid&eacute;rons une requ&ecirc;te pour <code>/index.php/foo.shtml</code>,
    <module>mod_mime</module> ne traitera pas la requ&ecirc;te entrante comme
    <code>/index.php/foo.shtml</code> et les directives comme
    <code>AddOutputFilter INCLUDES .shtml</code> ajouteront le filtre
    <code>INCLUDES</code> &agrave; la requ&ecirc;te. Si la directive
    <directive>ModMimeUsePathInfo</directive> n'est pas d&eacute;finie, le
    filtre <code>INCLUDES</code> ne sera pas ajout&eacute;. Le fonctionnement
    sera identique dans le cas des chemins virtuels, tels que ceux
    d&eacute;finis par la directive <directive type="section">Location</directive></p>
</usage>
<seealso><directive module="core">AcceptPathInfo</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>RemoveCharset</name>
<description>Supprime toute association de jeu de caract&egrave;res pour un
ensemble d'extensions de noms de fichiers</description>
<syntax>RemoveCharset <var>extension</var> [<var>extension</var>]
...</syntax>
<contextlist><context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>RemoveCharset</directive> permet de
    supprimer toute association de jeu de caract&egrave;res pour les fichiers
    dont les noms poss&egrave;dent les extensions sp&eacute;cifi&eacute;es. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association h&eacute;rit&eacute;e du r&eacute;pertoire parent ou de la configuration du
    serveur pour un r&eacute;pertoire particulier.</p>

    <p>L'argument <var>extension</var> est insensible &agrave; la casse et peut
    &ecirc;tre sp&eacute;cifi&eacute; avec ou sans le point initial.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      RemoveCharset .html .shtml
      </highlight>
    </example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RemoveEncoding</name>
<description>Supprime toute association de codage de contenu pour un
ensemble d'extensions de noms de fichiers</description>
<syntax>RemoveEncoding <var>extension</var> [<var>extension</var>]
...</syntax>
<contextlist><context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>RemoveEncoding</directive> permet de
    supprimer toute association de codage pour les fichiers dont les
    noms poss&egrave;dent les extensions sp&eacute;cifi&eacute;es. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association h&eacute;rit&eacute;e du r&eacute;pertoire parent ou de la configuration du
    serveur pour un r&eacute;pertoire particulier. Voici un exemple
    d'utilisation de cette directive :</p>

    <example><title>/foo/.htaccess:</title>
      <highlight language="config">
AddEncoding x-gzip .gz
AddType text/plain .asc
&lt;Files "*.gz.asc"&gt;
    RemoveEncoding .gz
&lt;/Files&gt;
      </highlight>
    </example>

    <p>Avec cette configuration, le fichier <code>foo.gz</code> sera
    marqu&eacute; comme cod&eacute; avec gzip, mais <code>foo.gz.asc</code> sera
    marqu&eacute; comme fichier texte non cod&eacute;.</p>

    <note><title>Note</title>
      <p>Les directives <directive>RemoveEncoding</directive> &eacute;tant
      trait&eacute;es <em>apr&egrave;s</em> toute directive <directive
      module="mod_mime">AddEncoding</directive>, il est possible
      qu'elles annulent les effets de ces derni&egrave;res si les deux
      apparaissent dans la configuration du m&ecirc;me r&eacute;pertoire.</p>
    </note>

    <p>L'argument <var>extension</var> est insensible &agrave; la casse et peut
    &ecirc;tre sp&eacute;cifi&eacute; avec ou sans le point initial.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RemoveHandler</name>
<description>Supprime toute association de gestionnaire &agrave; un ensemble
d'extensions de noms de fichiers</description>
<syntax>RemoveHandler <var>extension</var> [<var>extension</var>]
...</syntax>
<contextlist><context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>RemoveHandler</directive> permet de
    supprimer toute association de gestionnaire &agrave; des fichiers dont le
    nom poss&egrave;de l'extension donn&eacute;e. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association h&eacute;rit&eacute;e du r&eacute;pertoire parent ou de la configuration du
    serveur pour un r&eacute;pertoire particulier. Voici un exemple
    d'utilisation de cette directive :</p>

    <example><title>/foo/.htaccess:</title>
    <highlight language="config">
      AddHandler server-parsed .html
      </highlight>
    </example>

    <example><title>/foo/bar/.htaccess:</title>
    <highlight language="config">
      RemoveHandler .html
      </highlight>
    </example>

    <p>Avec cette derni&egrave;re ligne, les fichiers <code>.html</code> du
    r&eacute;pertoire <code>/foo/bar</code> seront trait&eacute;s en tant que fichiers
    normaux, au lieu d'&ecirc;tre trait&eacute;s en tant que candidats &agrave;
    l'interpr&eacute;tation (voir le module <module>mod_include</module>
    module).</p>

    <p>L'argument <var>extension</var> est insensible &agrave; la casse et peut
    &ecirc;tre sp&eacute;cifi&eacute; avec ou sans le point initial.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RemoveInputFilter</name>
<description>Supprime toute association de filtre en entr&eacute;e &agrave; un
ensemble d'extensions de noms de fichiers</description>
<syntax>RemoveInputFilter <var>extension</var> [<var>extension</var>]
...</syntax>
<contextlist><context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>RemoveInputFilter</directive> permet de
    supprimer toute association de <a href="../filter.html">filtre</a>
    en entr&eacute;e &agrave; des fichiers dont le nom poss&egrave;de l'extension donn&eacute;e.
    Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association h&eacute;rit&eacute;e du r&eacute;pertoire parent ou de la configuration du
    serveur pour un r&eacute;pertoire particulier.</p>

    <p>L'argument <var>extension</var> est insensible &agrave; la casse et peut
    &ecirc;tre sp&eacute;cifi&eacute; avec ou sans le point initial.</p>
</usage>
<seealso><directive module="mod_mime">AddInputFilter</directive></seealso>
<seealso><directive module="core">SetInputFilter</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>RemoveLanguage</name>
<description>Supprime toute association de langue &agrave; un ensemble
d'extensions de noms de fichiers</description>
<syntax>RemoveLanguage <var>extension</var> [<var>extension</var>]
...</syntax>
<contextlist><context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>RemoveLanguage</directive> permet de
    supprimer toute association de langue &agrave; des fichiers dont le nom
    poss&egrave;de l'extension donn&eacute;e. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association h&eacute;rit&eacute;e du r&eacute;pertoire parent ou de la configuration du
    serveur pour un r&eacute;pertoire particulier.</p>

    <p>L'argument <var>extension</var> est insensible &agrave; la casse et peut
    &ecirc;tre sp&eacute;cifi&eacute; avec ou sans le point initial.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RemoveOutputFilter</name>
<description>Supprime toute association de filtre en sortie &agrave; un
ensemble d'extensions de noms de fichiers</description>
<syntax>RemoveOutputFilter <var>extension</var> [<var>extension</var>]
...</syntax>
<contextlist><context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>RemoveOutputFilter</directive> permet de
    supprimer toute association de <a href="../filter.html">filtre</a>
    en sortie &agrave; des fichiers dont le nom poss&egrave;de l'extension donn&eacute;e. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association h&eacute;rit&eacute;e du r&eacute;pertoire parent ou de la configuration du
    serveur pour un r&eacute;pertoire particulier.</p>

    <p>L'argument <var>extension</var> est insensible &agrave; la casse et peut
    &ecirc;tre sp&eacute;cifi&eacute; avec ou sans le point initial.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      RemoveOutputFilter shtml
      </highlight>
    </example>
</usage>
<seealso><directive module="mod_mime">AddOutputFilter</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>RemoveType</name>
<description>Supprime toute association de type de contenu &agrave; un ensemble
d'extensions de noms de fichiers</description>
<syntax>RemoveType <var>extension</var> [<var>extension</var>]
...</syntax>
<contextlist><context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>RemoveType</directive> permet de
    supprimer toute association de <glossary ref="media-type">type de
    m&eacute;dium</glossary> &agrave; des fichiers dont le nom poss&egrave;de l'extension
    donn&eacute;e. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association h&eacute;rit&eacute;e du r&eacute;pertoire parent ou de la configuration du
    serveur pour un r&eacute;pertoire particulier. Voici un exemple
    d'utilisation de cette directive :</p>

    <example><title>/foo/.htaccess:</title>
    <highlight language="config">
      RemoveType .cgi
      </highlight>
    </example>

    <p>Cette ligne aura pour effet de supprimer tout traitement
    sp&eacute;cifique des fichiers <code>.cgi</code> dans le r&eacute;pertoire
    <code>/foo/</code> et ses sous-r&eacute;pertoires, et les r&eacute;ponses
    contenant ce type de fichier ne poss&egrave;deront pas de champ d'en-t&ecirc;te
    HTTP Content-Type.</p>

    <note><title>Note</title>
      <p>Les directives <directive>RemoveType</directive> sont trait&eacute;es
      <em>apr&egrave;s</em> toutes les directives <directive
      module="mod_mime">AddType</directive>, et il est possible que les
      effets de ces derni&egrave;res soient annul&eacute;s si les deux types de
      directives sont pr&eacute;sents au sein de la configuration du m&ecirc;me
      r&eacute;pertoire.</p>
    </note>

    <p>L'argument <var>extension</var> est insensible &agrave; la casse et peut
    &ecirc;tre sp&eacute;cifi&eacute; avec ou sans le point initial.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>TypesConfig</name>
<description>Le chemin du fichier <code>mime.types</code></description>
<syntax>TypesConfig <var>chemin-fichier</var></syntax>
<default>TypesConfig conf/mime.types</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>La directive <directive>TypesConfig</directive> permet de d&eacute;finir
    le chemin du fichier de configuration des <glossary
    ref="media-type">types de m&eacute;dia</glossary>. L'argument
    <var>chemin-fichier</var> est un chemin relatif au r&eacute;pertoire d&eacute;fini
    par la directive <directive module="core">ServerRoot</directive>. Ce
    fichier contient la liste des associations par d&eacute;faut des extensions
    de noms de fichiers aux types de contenus. La plupart des
    administrateurs utilisent le fichier <code>mime.types</code> fourni
    par leur syst&egrave;me d'exploitation,
    qui associe les extensions de noms de fichiers courantes &agrave; la liste
    officielle des types de m&eacute;dia enregistr&eacute;s par l'IANA et maintenue &agrave;
    <a href=
    "http://www.iana.org/assignments/media-types/index.html"
    >http://www.iana.org/assignments/media-types/index.html</a>, ainsi
    qu'un grand nombre de types non officiels. Ce fichier permet de
    simplifier le fichier <code>httpd.conf</code> en fournissant la
    majorit&eacute; des d&eacute;finitions de types de m&eacute;dia, et ses d&eacute;finitions
    peuvent &ecirc;tre &eacute;cras&eacute;es par des directives <directive
    module="mod_mime">AddType</directive>, selon les besoins. Il est
    d&eacute;conseill&eacute; de modifier le contenu du fichier
    <code>mime.types</code> car il peut &ecirc;tre remplac&eacute; lors d'une mise &agrave;
    jour du serveur.</p>

    <p>Le fichier contient des lignes dont le format est identique &agrave;
    celui des arguments d'une directive <directive
    module="mod_mime">AddType</directive> :</p>

    <example>
      <var>type-m&eacute;dium</var> [<var>extension</var>] ...
    </example>

    <p>Les extensions sont insensibles &agrave; la casse. Les lignes vides et
    les lignes commen&ccedil;ant par un di&egrave;se (<code>#</code>) sont
    ignor&eacute;es. Les lignes vides servent &agrave; compl&eacute;ter le fichier
    mime.types. Apache httpd peut encore d&eacute;terminer ces types via le
    module <module>mod_mime_magic</module>.</p>

    <note>
      Merci de <strong>ne pas</strong> soumettre de requ&ecirc;tes au Projet
      de Serveur HTTP Apache pour ajouter une entr&eacute;e dans le fichier
      <code>mime.types</code> fourni, sauf si :
      1) le type de m&eacute;dium est d&eacute;j&agrave; enregistr&eacute; &agrave; l'IANA
      2) et si l'extension est largement accept&eacute;e et ne provoque pas de
      conflits d'extensions entre les diff&eacute;rentes plate-formes. Les
      requ&ecirc;tes du type <code>cat&eacute;gorie/x-sous-type</code> seront
      syst&eacute;matiquement rejet&eacute;es, ainsi que toute nouvelle extension de
      deux lettres, car elle ont de fortes chances d'entrer en conflit
      par la suite avec les inombrables langues pr&eacute;existantes et les
      espaces de nommage des jeux de caract&egrave;res.
    </note>
</usage>
<seealso><module>mod_mime_magic</module></seealso>
</directivesynopsis>

</modulesynopsis>
