<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1734259 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="flags.xml.meta">
<parentdocument href="./">Rewrite</parentdocument>

  <title>Les drapeaux de réécriture</title>

<summary>
<p>Ce document décrit les drapeaux disponibles dans la directive
<directive module="mod_rewrite">RewriteRule</directive>, en fournissant
des explications détaillées et des exemples.</p>
</summary>

<seealso><a href="../mod/mod_rewrite.html">Documentation du module</a></seealso>
<seealso><a href="intro.html">Introduction à mod_rewrite</a></seealso>
<seealso><a href="remapping.html">Redirection and remise en
correspondance</a></seealso>
<seealso><a href="access.html">Contrôle d'accès</a></seealso>
<seealso><a href="vhosts.html">Serveurs virtuels</a></seealso>
<seealso><a href="proxy.html">Mise en cache</a></seealso>
<seealso><a href="rewritemap.html">Utilisation de RewriteMap</a></seealso>
<seealso><a href="advanced.html">Techniques avancées</a></seealso>
<seealso><a href="avoid.html">Quand ne pas utiliser mod_rewrite</a></seealso>

<section id="introduction"><title>Introduction</title>
<p>Le comportement d'une directive <directive
module="mod_rewrite">RewriteRule</directive> peut être modifié par un ou
plusieurs drapeaux. Les drapeaux sont situés en fin de règle, entourés
de crochets, et séparés le cas échéant par des virgules.</p>
<highlight language="config">RewriteRule pattern target [Flag1,Flag2,Flag3]</highlight>

<p>Chaque drapeau (à quelques exceptions près)
possède une forme courte, comme <code>CO</code>, ainsi qu'une forme longue,
comme <code>cookie</code>. Bien que
la forme courte soit la plus couramment utilisée, nous vous recommandons
de vous familiariser avec les drapeaux sous leur forme longue, afin de
bien mémoriser ce que chaque drapeau est supposé faire.
Certains drapeaux acceptent un ou plusieurs arguments. Les drapeaux ne
sont pas sensibles à la casse.</p>

<p>Les drapeaux qui modifient les métadonnées associées à la requête
(T=, H=, E=) n'ont aucun effet dans un contexte de répertoire ou de
fichier htaccess, lorsqu'une substitution (autre que '-') est effectuée
au cours de la même passe du processus de réécriture.
</p>

<p>Chaque drapeau disponible est présenté ici, avec un exemple
d'utilisation.</p>
</section>

<section id="flag_b"><title>B (échappement dans les références arrières)</title>
<p>Avec le drapeau [B], la directive <directive
module="mod_rewrite">RewriteRule</directive> échappe les caractères
non-alphanumériques avant d'appliquer la transformation.</p>

<p><code>mod_rewrite</code> doit supprimer les séquences d'échappement
des URLs avant leur
mise en correspondance avec le système de fichiers ; les séquences
d'échappement sont donc supprimées des références arrières au moment où
ces dernières sont appliquées. Avec le drapeau B, les caractères
non-alphanumériques des références arrières seront échappés. Considérons
par exemple cette règle :</p>

<highlight language="config">RewriteRule "^search/(.*)$" "/search.php?term=$1"</highlight>

<p>Soit le terme de recherche 'x &amp; y/z' ; un navigateur va le coder
en 'x%20%26%20y%2Fz', transformant la requête en
'search/x%20%26%20y%2Fz'. Sans le drapeau B, cette règle de réécriture
va réécrire la requête en 'search.php?term=x &amp; y/z', ce qui ne
correspond pas à une URL valide et cette dernière sera encodée en
<code>search.php?term=x%20&amp;y%2Fz=</code>, ce qui ne correspond pas à
ce que l'on souhaitait.</p>

<p>Avec le drapeau B, les paramètres sont réencodés avant d'être passés
à l'URL résultante, ce qui fournit une réécriture correcte en
<code>/search.php?term=x%20%26%20y%2Fz</code>.</p>

<p>Notez que vous devrez peut-être aussi définir la
directive <directive module="core">AllowEncodedSlashes</directive>
à <code>On</code> pour
que cet exemple particulier fonctionne, car httpd ne permet pas les
slashes encodés dans les URLs, et renvoie une erreur 404 s'il en
rencontre un.</p>

<p>Ce processus d'échappement est en particulier nécessaire dans le
contexte d'un mandataire, où l'accès au serveur d'arrière-plan échouera
si on présente à ce dernier une URL non échappée.</p>

</section>

<section id="flag_c"><title>C|chain</title>
<p>Le drapeau [C] ou [chain] indique que la règle <directive
module="mod_rewrite">RewriteRule</directive> est chaînée avec la
suivante. Autrement dit, si la règle s'applique, elle est traitée
normalement et passe le contrôle à la règle suivante. Par contre, si
elle ne s'applique pas, la règle suivante, ainsi que toutes les règles
chaînées qui suivent, seront sautées.</p>

</section>

<section id="flag_co"><title>CO|cookie</title>
<p>Le drapeau [CO], ou [cookie], vous permet de définir un cookie
lorsqu'une règle <directive module="mod_rewrite">RewriteRule</directive>
s'applique. Il possède trois arguments obligatoires et
quatre arguments optionnels.</p>

<p>La syntaxe complète de ce drapeau, avec tous ses attributs, est la
suivante :</p>

<example>
[CO=NAME:VALUE:DOMAIN:lifetime:path:secure:httponly]
</example>

<p>Si un caractère littéral ':' doit être insérer dans un des champs du
cookie, une autre syntaxe est disponible. Pour utiliser cette syntaxe
alternative, le contenu du champ "Name" doit être précédé du caractère
';', et les sépateurs de champs deviendront des ';'.</p>

<example>
[CO=;NAME;VALUE:MOREVALUE;DOMAIN;lifetime;path;secure;httponly]
</example>

<p>Vous devez déclarer un nom, une valeur et un domaine pour que
le cookie puisse être défini.</p>


<dl>
<dt>Domain</dt>
<dd>Le domaine pour lequel vous souhaitez que le cookie soit valide. Ce
peut être un nom de serveur, comme <code>www.example.com</code>, ou un
domaine, comme <code>.example.com</code>. Il doit comporter au moins
deux parties séparées par un point. C'est à dire que vous ne pouvez pas
utiliser les valeurs <code>.com</code> ou <code>.net</code>. En effet,
ce style de cookie est interdit par le modèle de sécurité des cookies.</dd>
</dl>

<p>Vous pouvez aussi définir les valeurs suivantes :</p>

<dl>
<dt>Lifetime</dt>
<dd>La durée de vie du cookie, en minutes.</dd>
<dd>Une valeur de 0 indique une durée de vie correspondant à la session
courante du navigateur. Il s'agit de la valeur par défaut.</dd>

<dt>Path</dt>
<dd>Le chemin, sur le site web concerné, pour lequel le cookie est
valide, du style <code>/clients/</code> or
<code>/fichiers/telechargement/</code>.</dd>
<dd>La valeur par défaut est <code>/</code> - c'est à dire l'ensemble du
site web.</dd>

<dt>Secure</dt>
<dd>Si cet argument a pour valeur <code>secure</code>,
<code>true</code>, ou <code>1</code>, le cookie ne pourra être transmis
que dans le cadre d'une connexion sécurisée (https).</dd>

<dt>httponly</dt>
<dd>Si cet argument a pour valeur <code>HttpOnly</code>,
<code>true</code>, ou <code>1</code>, le cookie aura son drapeau
<code>HttpOnly</code> activé, ce qui signifie qu'il sera inaccessible au
code JavaScript pour les navigateurs qui supportent cette
fonctionnalité.</dd>
</dl>

<p>Voici un exemple :</p>

<highlight language="config">
RewriteEngine On
RewriteRule "^/index\.html" "-" [CO=frontdoor:yes:.example.org:1440:/]
</highlight>

<p>Dans l'exemple ci-dessus, la règle ne réécrit
pas la requête. La cible de réécriture "-"
indique à mod_rewrite de transmettre la requête sans
modification. Par contre, il
définit un cookie nommé 'frontdoor' avec une valeur 'yes'. Le cookie est
valide pour tout hôte situé dans le domaine <code>.example.org</code>. Sa
durée de vie est limitée à 1440 minutes (24 heures), et il sera renvoyé
pour tous les URIs.</p>

</section>

<section id="flag_dpi"><title>DPI|discardpath</title>
<p>Avec le drapeau DPI, la partie PATH_INFO de l'URI
réécrit est supprimée.</p>
<p>Ce drapeau est disponible dans les versions 2.2.12 et supérieures.</p>
<p>Dans un contexte de répertoire, l'URI mis en comparaison par chaque
règle <directive>RewriteRule</directive> est la concaténation des
valeurs courantes de l'URI et de PATH_INFO.</p>

<p>L'URI courant peut être l'URI initial tel qu'il a été fourni par le
client, le résultat d'une passe précédente du processus de réécriture,
ou le résultat de la règle précédente dans le processus courant de
réécriture.</p>

<p>Par contre, la partie PATH_INFO ajoutée à l'URI avant chaque règle ne
reflète que la valeur de PATH_INFO avant la passe courante du processus
de réécriture. En conséquence, si de larges portions de l'URI
correspondent et sont traduites via plusieurs directives
<directive>RewriteRule</directive>, sans prendre en compte
quelles parties de l'URI provenaient du PATH_INFO courant, l'URI final
pourra se voir ajouter plusieurs copies de PATH_INFO.</p>

<p>Utilisez ce drapeau pour toute substitution où la présence du PATH_INFO qui
résultait de la mise en correspondance précédente de cette requête avec
le système de fichier n'est pas nécessaire. Avec ce drapeau, le
PATH_INFO établi avant que cette passe du processus de réécriture ne
débute est oublié. PATH_INFO ne sera pas recalculé tant que la passe
courante du processus de réécriture ne sera pas achevée. Les règles
suivantes de cette passe ne verront que le résultat direct des
substitutions, sans aucun PATH_INFO ajouté.</p>
</section>

<section id="flag_e"><title>E|env</title>
<p>Avec le drapeau [E], ou [env], vous pouvez définir la valeur d'une
variable d'environnement. Notez que certaines variables d'environnement
peuvent être définies après le traitement de la règle, annulant par
la-même ce que vous avez défini. Voir le <a href="../env.html">document
sur les variables d'environnement</a> pour plus de détails sur le
fonctionnement des variables d'environnement.</p>

<p>La syntaxe complète pour ce drapeau est :</p>

<highlight language="config">
[E=!VAR]
</highlight>

<p><code>VAL</code> peut comporter des références arrières
(<code>$N</code> ou <code>%N</code>) qui seront développées.</p>

<p>En utilisant la version courte</p>

<example>
[E=VAR]
</example>

<p>vous pouvez définir la variable d'environnement nommée
<code>VAR</code> avec une valeur vide.</p>

<p>La forme</p>

<example>
[E=!VAR]
</example>

<p>permet d'annuler la définition de la variable <code>VAR</code>.</p>

<p>Les variables d'environnement s'emploient dans différents contextes,
comme les programmes CGI, d'autres directives RewriteRule, ou des
directives CustomLog.</p>

<p>L'exemple suivant définit une variable d'environnement nommée 'image'
avec une valeur de '1' si l'URI de la requête correspond à un fichier
image. Cette variable d'environnement est ensuite utilisée pour exclure
une telle requête du journal des accès.</p>

<example>
RewriteRule "\.(png|gif|jpg)" "-" [E=image:1]<br />
CustomLog "logs/access_log" combined env=!image
</example>

<p>Notez que le même effet peut être obtenu à l'aide de la directive
<directive module="mod_setenvif">SetEnvIf</directive>. Cette technique
est présentée à titre d'exemple et non de recommandation.</p>
</section>

<section id="flag_end"><title>END</title>
<p>L'utilisation du drapeau [END] permet non seulement de terminer le
processus de réécriture en cours (comme [L]), mais aussi d'empêcher tout
processus de réécriture ultérieur dans un contexte de répertoire
(htaccess).</p>

<p>Ceci ne s'applique pas aux nouvelles requêtes résultant d'une
redirection externe.</p>
</section>

<section id="flag_f"><title>F|forbidden</title>
<p>L'utilisation du drapeau [F] permet de faire envoyer par le serveur au
client un code de statut "403 Forbidden". Le même effet peut être obtenu à
l'aide de la directive <directive module="mod_access_compat">Deny</directive>,
mais ce drapeau offre plus de souplesse dans l'attribution d'un statut
Forbidden.</p>

<p>La règle suivante va interdire la téléchargement de fichiers
<code>.exe</code> depuis votre serveur.</p>

<highlight language="config">RewriteRule "\.exe" "-" [F]</highlight>

<p>Cet exemple utilise la syntaxe "-" pour la cible de réécriture, ce
qui signifie que l'URI de la requête n'est pas modifié. Il n'y a aucune
raison de réécrire un URI, si vous avez l'intention d'interdire la
requête.</p>

<p>Lorsqu'on utilise [F], [L] est implicite - c'est à dire que la
réponse est renvoyée immédiatement, et aucune autre règle n'est évaluée.</p>

</section>

<section id="flag_g"><title>G|gone</title>
<p>Le drapeau [G] permet de faire envoyer par le serveur un code de statut
"410 Gone" avec la réponse. Ce code indique qu'une ressource qui était
disponible auparavant ne l'est plus actuellement.</p>

<p>Comme dans le cas du drapeau [F], on utilise en général la syntaxe
"-" pour la cible de réécriture lorsqu'on utilise le drapeau [G] :</p>

<highlight language="config">RewriteRule "oldproduct" "-" [G,NC]</highlight>

<p>Lorsqu'on utilise [G], [L] est implicite - c'est à dire que la
réponse est renvoyée immédiatement, et aucune autre règle n'est évaluée.</p>

</section>

<section id="flag_h"><title>H|handler</title>
<p>Force le traitement de la requête résultante par le gestionnaire
spécifié. Par exemple, on peut utiliser ce drapeau pour forcer
l'interprétation de tous les fichiers sans extension par le gestionnaire
php :</p>

<highlight language="config">RewriteRule "!\." "-" [H=application/x-httpd-php]</highlight>

<p>
L'expression rationnelle ci-dessus - <code>!\.</code> - correspond à
toute requête qui ne contient pas le caractère <code>.</code>.
</p>
<p>On peut aussi utiliser ce drapeau pour forcer l'utilisation d'un
certain gestionnaire en fonction de certaines conditions. Par exemple,
l'extrait suivant utilisé dans un contexte de niveau serveur permet de
faire en sorte que les fichiers <code>.php</code> soient
<em>affichés</em> par <code>mod_php</code> dans le cas où ils font
l'objet d'une requête avec l'extension <code>.phps</code> :</p>

<highlight language="config">
RewriteRule "^(/source/.+\.php)s$" "$1" [H=application/x-httpd-php-source]
</highlight>


<p>L'expression rationnelle ci-dessus -
<code>^(/source/.+\.php)s$</code> - va correspondre à toute requête qui
débutera par <code>/source/</code>, continuera par 1 ou n caractères
puis par <code>.phps</code>. La référence arrière $1 fait référence à la
correspondance capturée entre parenthèses de l'expression
rationnelle.</p>


</section>

<section id="flag_l"><title>L|last</title>
<p>Lorsque le drapeau [L] est présent, <module>mod_rewrite</module>
arrête le traitement du jeu de règles. Cela signifie dans la plupart des
situations que si la règle s'applique, aucune autre règle ne sera
traitée. Ce drapeau correspond à la commande Perl <code>last</code>, ou
à la commande <code>break</code> en C. Utilisez ce drapeau pour indiquer
que la règle courante doit être appliquée immédiatement, sans tenir
compte des règles ultérieures.</p>

<p>Si vous utilisez des règles <directive
module="mod_rewrite">RewriteRule</directive> dans des fichiers
<code>.htaccess</code> ou des sections <directive type="section"
module="core">Directory</directive>, il est important d'avoir quelques
notions sur la manière dont les règles sont traitées. Pour simplifier,
une fois les règles traitées, la requête réécrite est passée à nouveau
au moteur d'interprétation des URLs afin que ce dernier puisse la
traiter. Il est possible qu'au cours du traitement de la requête
réécrite, le fichier <code>.htaccess</code> ou la section <directive
type="section" module="core">Directory</directive> soient à nouveau
rencontrés, entraînant un nouveau traitement du jeu de règles depuis le
début. Cette situation se présente le plus souvent lorsqu'une des règles
provoque une redirection - interne ou externe - ce qui réinitialise le
traitement de la requête.</p>

<p>Si vous utilisez des directives <directive
module="mod_rewrite">RewriteRule</directive> dans un de ces contextes,
il importe par conséquent de prévoir explicitement des étapes permettant
d'éviter un bouclage infini sur les règles,
et de ne pas compter seulement sur
le drapeau [L] pour terminer l'exécution d'une série de règles, comme
décrit ci-dessous.</p>

<p>Un autre drapeau, [END], permet non seulement d'interrompre le cycle
courant du processus de réécriture, mais aussi d'empêcher toute
réécriture ultérieure dans le contexte de répertoire (htaccess). Ceci ne
s'applique pas aux nouvelles requêtes résultant de redirections
externes.</p>

<p>Dans l'exemple donné ici, toute requête est réécrite en
<code>index.php</code>, la requête originale étant ajoutée comme chaîne
de requête en argument à <code>index.php</code> ; cependant, la
directive <directive
module="mod_rewrite">RewriteCond</directive> permet de s'assurer que si
la requête concerne déjà <code>index.php</code>, la directive <directive
module="mod_rewrite">RewriteRule</directive> sera sautée.</p>

<highlight language="config">
RewriteBase "/"
RewriteCond "%{REQUEST_URI}" "!=/index.php"
RewriteRule "^(.*)" "/index.php?req=$1" [L,PT]
</highlight>
</section>

<section id="flag_n"><title>N|next</title>
<p>Le drapeau [N] provoque un redémarrage du traitement des règles
depuis le début, en utilisant le résultat du jeu de règles, sous
réserve qu'il existe un point de démarrage ; à utiliser avec précautions
car il peut provoquer un bouclage infini.
</p>
<p>
Le drapeau [Next] peut servir, par exemple,
à remplacer de manière répétitive
une chaîne de caractère ou une lettre dans une requête. Dans l'exemple
suivant, chaque occurence de A sera remplacée par B dans la requête, et
ceci jusqu'il n'y ait plus de A à remplacer.
</p>

<highlight language="config">RewriteRule "(.*)A(.*)" "$1B$2" [N]</highlight>

<p>Vous pouvez vous représenter ce traitement comme une boucle
<code>while</code> : tant que le modèle de la règle correspond (c'est à
dire, tant que l'URI contient un <code>A</code>),
effectuer la substitution (c'est à dire, remplacer le <code>A</code> par
un <code>B</code>).</p>

<p>A partir de la version 2.4.8, ce module renvoie une erreur après
32000 itérations afin d'éviter les boucles infinies. Ce nombre maximum
d'itération peut être modifié via le drapeau N.</p>
<highlight language="config">
# On veut remplacer 1 caractère à chaque itération de la boucle
RewriteRule "(.+)[&gt;&lt;;]$" "$1" [N=64000]
# ... ou s'arrêter après 10 itérations
RewriteRule "(.+)[&gt;&lt;;]$" "$1" [N=10]
</highlight>

</section>

<section id="flag_nc"><title>NC|nocase</title>
<p>Avec le drapeau [NC], le modèle de la règle <directive
module="mod_rewrite">RewriteRule</directive> est comparé à la requête de
manière insensible à la casse. C'est à dire que cette comparaison
s'effectue sans tenir compte des majuscules/minuscules dans l'URI
comparé.</p>

<p>Dans l'exemple suivant, toute requête pour un fichier image sera
transmise par Apache à votre serveur d'images dédié. La correspondance est
insensible à la casse, si bien que par exemple, <code>.jpg</code> aussi
bien que <code>.JPG</code> seront acceptés.</p>

<highlight language="config">RewriteRule "(.*\.(jpg|gif|png))$" "http://images.example.com$1" [P,NC]</highlight>
</section>

<section id="flag_ne"><title>NE|noescape</title>
<p>Par défaut, les caractères spéciaux, comme <code>&amp;</code> et
<code>?</code>, sont convertis en leur équivalent
hexadécimal. Le drapeau [NE] permet d'éviter cette conversion.
</p>

<highlight language="config">RewriteRule "^/anchor/(.+)" "/bigpage.html#$1" [NE,R]</highlight>

<p>
Dans l'exemple ci-dessus, <code>/anchor/xyz</code> est réécrit en
<code>/bigpage.html#xyz</code>. En l'absence du drapeau [NE], le #
aurait été converti en son équivalent hexadécimal, <code>%23</code>, ce
qui aurait provoqué un code d'erreur "404 Not Found".
</p>

</section>

<section id="flag_ns"><title>NS|nosubreq</title>
<p>Le drapeau [NS] empêche la règle de s'appliquer aux sous-requêtes.
Par exemple, une page incluse au moyen d'une SSI (Server
Side Include) est une sous-requête, et vous ne voudrez probablement pas que
la réécriture s'applique à ces sous-requêtes. Ainsi, lorsque
<module>mod_dir</module> recherche des informations à propos des
fichiers par défaut du répertoire (comme les fichiers
<code>index.html</code>), il s'agit d'une sous-requête interne, et vous
ne désirez en général pas que ces sous-requêtes soient réécrites. Cette
réécriture
n'est pas toujours utile pour les sous-requêtes, et peut même causer des
erreurs si l'ensemble du jeu de règles est appliqué. L'utilisation de
ce drapeau permet d'exclure les règles qui peuvent poser problème.</p>

<p>Comment déterminer si vous devez utiliser cette règle ou non : si
vous préfixez les URLs avec des scripts CGI, afin de forcer leur
traitement par le script CGI, vous vous exposez à des problèmes (ou du
moins à une surcharge significative) avec les sous-requêtes. Dans ces
cas, vous devez utiliser ce drapeau.</p>

<p>
Les images, scripts java, ou fichiers css, chargés en tant que partie
d'une page html, ne sont pas des sous-requêtes - le navigateur les
appelle sous forme de requêtes HTTP à part entière.
</p>
</section>

<section id="flag_p"><title>P|proxy</title>
<p>L'utilisation du drapeau [P] entraîne le traitement de la requête par
le module <module>mod_proxy</module>, et ceci via une requête de
mandataire. Par exemple, si vous voulez que toutes les requêtes d'images
soient traitées par un serveur d'images annexe, vous pouvez utiliser
une règle de ce style :</p>

<highlight language="config">RewriteRule "/(.*)\.(jpg|gif|png)$" "http://images.example.com/$1.$2" [P]</highlight>

<p>L'utilisation du drapeau [P] provoque aussi l'effet du drapeau [L] -
autrement dit, la requête est immédiatement envoyée au mandataire, et
toute règle ultérieure sera ignorée.</p>

<p>
Vous devez vous assurer que la chaîne de substitution soit un URI valide
(commençant typiquement par <code>http://</code><em>nom-serveur</em>)
qui puisse être traitée par le module <module>mod_proxy</module>. Dans
le cas contraire, le module mandataire vous renverra une erreur.
L'utilisation de ce drapeau implémente de manière plus puissante la
directive <directive module="mod_proxy">ProxyPass</directive>, pour
faire correspondre le contenu distant à l'espace de nommage du serveur
local.</p>

<note type="warning">
      <title>Avertissement à propos de la sécurité</title>
      <p>Lors de la construction de l'URL cible de la règle, il convient
      de prendre en compte l'impact en matière de sécurité qu'aura le
      fait de permettre au client d'influencer le jeu d'URLs pour
      lesquelles votre serveur agira en tant que mandataire.
      Assurez-vous que la partie protocole://nom-serveur de l'URL soit
      fixe, ou ne permette pas au client de l'influencer induement.</p>
</note>

<note type="warning">
      <title>Avertissement au sujet des performances</title>
      <p>Utiliser ce drapeau fait intervenir <module>mod_proxy</module> sans la gestion des connexions
      persistantes, ce qui signifie que vous obtiendrez des performances meilleurs si vous utilisez
      <directive module="mod_proxy">ProxyPass</directive> ou <directive module="mod_proxy">ProxyPassMatch</directive>.</p>
      <p>Ceci est du au fait que ce drapeau induit l'utilisation du worker par défaut, qui
      ne gère pas la mise en commun des connexions.</p>
      <p>Partout où cela est possible, préférez l'utilisation de ces directives.</p>
</note>

<p>Note: <module>mod_proxy</module> doit être activé pour pouvoir
utiliser ce drapeau.</p>

</section>

<section id="flag_pt"><title>PT|passthrough</title>

<p>
Par défaut, la cible (ou chaîne de substitution) d'une règle
RewriteRule est sensée être un chemin de fichier. Avec le drapeau [PT],
par contre, elle est traitée comme un URI. Autrement dit, avec le
drapeau [PT], le résultat de la règle  <directive
module="mod_rewrite">RewriteRule</directive> est passé à nouveau au
système de mise en correspondance des URLs avec le système de fichiers,
de façon à ce que les systèmes de mise en correspondance basés sur les
chemins de fichiers, comme la directive <directive
module="mod_alias">Alias</directive>, <directive
module="mod_alias">Redirect</directive>, ou <directive
module="mod_alias">ScriptAlias</directive>, par exemple, puissent avoir une
chance d'accomplir leur tâche.
</p>

<p>
Si par exemple, vous avez un <directive
module="mod_alias">Alias</directive> pour /icons, et une règle  <directive
module="mod_rewrite">RewriteRule</directive> qui renvoie vers /icons,
vous devez utiliser le drapeau [PT] pour être sûr que l'<directive
module="mod_alias">Alias</directive> sera bien évalué.
</p>

<highlight language="config">
Alias "/icons" "/usr/local/apache/icons"
RewriteRule "/pics/(.+)\.jpg$" "/icons/$1.gif" [PT]
</highlight>

<p>
Dans l'exemple précédent, en l'absence du drapeau [PT], l'Alias aurait
été ignoré, ce qui aurait provoqué une erreur 'File not found'.
</p>

<p>Avec le drapeau <code>PT</code>, le drapeau <code>L</code> est
implicite : la réécriture s'arrêtera afin de transmettre la requête à la
phase suivante du traitement.</p>

<p>Notez que le drapeau <code>PT</code> est implicite dans des contextes
de répertoire comme les sections <directive type="section"
module="core">Directory</directive> ou les fichiers
<code>.htaccess</code>. Le seul moyen de contourner ceci consiste à
réécrire vers <code>-</code>.</p>

</section>

<section id="flag_qsa"><title>QSA|qsappend</title>
<p>
Quand l'URI de remplacement contient une chaîne de requête, le
comportement par défaut de la règle <directive
module="mod_rewrite">RewriteRule</directive> est de supprimer la <code>
query string</code> (il s'agit des paramètres éventuellement passés dans l'URL après le
caractère <code>?</code>, usuellement pour les formulaires traités par la
méthode HTTP <code>GET</code>) existante, et de la remplacer par celle nouvellement créée.
Avec le drapeau [QSA], les chaînes de requête peuvent être combinées.
</p>

<p>Considérons la règle suivante :</p>

<highlight language="config">RewriteRule "/pages/(.+)" "/page.php?page=$1" [QSA]</highlight>

<p>Avec le drapeau [QSA], une requête pour
<code>/pages/123?one=two</code> sera réécrite en
<code>/page.php?page=123&amp;one=two</code>. Sans le drapeau [QSA], la
même requête sera réécrite en <code>/page.php?page=123</code> -
autrement dit, la chaîne de requête (<code>query string</code>) existante sera supprimée.
</p>
</section>

<section id="flag_qsd"><title>QSD|qsdiscard</title>
<p>
Lorsque l'URI de la requête contient une chaîne de paramètres, et si
l'URI cible n'en contient pas, le comportement par défaut de la
directive <directive module="mod_rewrite">RewriteRule</directive> consiste à copier cette
chaîne de paramètres dans l'URI cible. Avec le drapeau [QSD], la chaîne
de paramètres est supprimée.
</p>

<p>Ce drapeau est disponible dans les versions 2.4.0 et supérieures.</p>

<p>
Lorsque les drapeaux [QSD] et [QSA] sont utilisés ensemble, c'est le
drapeau [QSD] qui l'emporte.
</p>

<p>
Si l'URI cible possède une chaîne de paramètres, le comportement par
défaut sera respecté - c'est à dire que la chaîne de paramètres
originale sera supprimée et remplacée par la chaîne de paramètres de
l'URI cible.
</p>

</section>

<section id="flag_qsl"><title>QSL|qslast</title>
<p>
Par défaut, le premier (le plus à gauche) point d'interrogation de la
substitution sépare le chemin de la requête de sa chaîne de paramètres. Avec le
drapeau [QSL] au contraire, les deux composants seront séparés en utilisant le
dernier (le plus à droite) point d'interrogation.</p>

<p>
Cela peut s'avérer utile lorsqu'on recherche un fichier dont le nom contient des
points d'interrogation. Si aucune chaîne de paramètre n'est présente dans la
substitution, il est alors possible d'ajouter un point d'interrogation à la fin
et d'utiliser ce drapeau.</p>

<p>Ce drapeau est disponible à partir de la version 2.4.19 du serveur HTTP
Apache.</p>

</section>

<section id="flag_r"><title>R|redirect</title>
<p>
L'utilisation du drapeau [R] provoque l'envoi d'une redirection au
navigateur. Si une URL pleinement qualifiée (FQDN - fully qualified domain name)
 est spécifiée (c'est à dire incluant <code>http://nom-du-serveur/</code>),
 une redirection sera effectuée vers cette adresse. Dans le cas contraire,
 le protocole courant, le nom du serveur et le numéro de port seront
 utilisés pour générer l'URL envoyée avec la redirection.
</p>

<p><em>Tout</em> code de statut de réponse HTTP valide peut être
spécifié, en utilisant la syntaxe [R=305], le code de statut 302 étant
utilisé par défaut si aucun code n'est spécifié. Le code de statut
spécifié n'est pas nécessairement un code de statut
de redirection (3xx). Cependant, si le code de statut est en dehors de la plage des codes de
redirection (300-399), la chaîne de substitution est entièrement
supprimée, et la réécriture s'arrête comme si le drapeau <code>L</code>
était utilisé.</p>

<p>En plus des codes de statut de réponse, vous pouvez spécifier les
codes de redirection en utilisant leurs noms symboliques :
<code>temp</code> (défaut), <code>permanent</code>, ou
<code>seeother</code>.</p>

<p>
Vous utiliserez presque toujours [R] en conjonction avec [L] (c'est à
dire [R,L]), car employé seul, le drapeau [R] préfixe l'URI avec
<code>http://cet-hôte[:ce-port]</code>, mais passe ensuite cette adresse
à la règle suivante, ce qui provoquera le plus souvent des
avertissements 'Invalid URI in request'.
</p>

</section>

<section id="flag_s"><title>S|skip</title>
<p>Le drapeau [S] sert à sauter des règles que vous ne voulez pas voir
exécuter. La syntaxe du drapeau [S] est [S=<em>N</em>], où
<em>N</em> correspond au nombre de règles à sauter (sous
réserve que la règle <directive
module="mod_rewrite">RewriteRule</directive> corresponde).
Ceci peut s'interpréter comme une instruction
<code>goto</code>  dans votre jeu de règles de réécriture. Dans
l'exemple suivant, nous ne voulons exécuter la règle <directive
module="mod_rewrite">RewriteRule</directive> que si l'URI demandé ne
correspond pas à un fichier existant.</p>
<highlight language="config">
# La requête concerne-t-elle un fichier qui n'existe pas ?
RewriteCond "%{REQUEST_FILENAME}" "!-f"
RewriteCond "%{REQUEST_FILENAME}" "!-d"
# Si c'est la cas, on saute les deux règles de réécriture suivantes
RewriteRule ".?" "-" [S=2]

RewriteRule "(.*\.gif)" "images.php?$1"
RewriteRule "(.*\.html)" "docs.php?$1"
</highlight>



<p>Cette technique trouve son utilité dans le fait qu'une directive
<directive module="mod_rewrite">RewriteCond</directive> ne s'applique
qu'à la règle qui la suit immédiatement. Ainsi, si vous voulez
qu'une directive <code>RewriteCond</code> s'applique à plusieurs règles
<code>RewriteRule</code>, une technique possible consiste à inverser ces
conditions et ajouter une <code>RewriteRule</code> avec le drapeau [Skip]. Cette technique permet
d'élaborer des pseudo-constructions if-then-else : la dernière règle du
bloc then contiendra <code>skip=N</code>, où N est le nombre de règles
contenues dans le bloc else :</p>
<highlight language="config">
# Est-ce que le fichier existe ?
RewriteCond "%{REQUEST_FILENAME}" "!-f"
RewriteCond "%{REQUEST_FILENAME}" "!-d"
# Create an if-then-else construct by skipping 3 lines if we meant to go to the &quot;else&quot; stanza.
RewriteRule ".?" "-" [S=3]

# Si le fichier existe, alors :
RewriteRule "(.*\.gif)" "images.php?$1"
    RewriteRule "(.*\.html)" "docs.php?$1"
    # Skip past the &quot;else&quot; stanza.
    RewriteRule ".?" "-" [S=1]
# ELSE...
RewriteRule "(.*)" "404.php?file=$1
# END
</highlight>

<p>Il est probablement plus aisé de définir ce genre de configuration
via les directives <directive type="section">If</directive>, <directive
type="section">ElseIf</directive>, et <directive
type="section">Else</directive>.</p>

</section>

<section id="flag_t"><title>T|type</title>
<p>Définit le type MIME de la réponse résultante renvoyée. L'effet est
identique à celui de la directive <directive
module="mod_mime">AddType</directive>.</p>

<p>Par exemple, vous pouvez utiliser la technique suivante pour servir
du code source Perl en tant que plein texte, s'il est requis d'une
certaine manière :</p>

<highlight language="config">
# Sert les fichier .pl en tant que plein texte
RewriteRule "\.pl$" "-" [T=text/plain]
</highlight>

<p>Ou encore, si vous possédez une caméra qui produit des fichiers
images jpeg sans extension, vous pouvez forcer le renvoi de ces images
avec le type MIME correct en se basant sur le nom du fichier :</p>

<highlight language="config">
# Les fichiers dont le nom contient 'IMG' sont des images jpg.
RewriteRule "IMG" "-" [T=image/jpg]
</highlight>

<p>Notez cependant qu'il s'agit d'un exemple trivial, et que le problème
aurait pu être résolu en utilisant à la place la directive <directive
type="section" module="core">FilesMatch</directive>. Il faut toujours
envisager la possibilité d'une solution alternative à un problème avant
d'avoir recours à la réécriture, qui sera toujours moins efficace qu'une
solution alternative.</p>

<p>
Dans un contexte de niveau répertoire, n'utilisez que <code>-</code>
(tiret) comme substitution, <em>dans toute la séquence de réécriture de
mod_rewrite</em>, sinon le type MIME défini avec ce drapeau
sera perdu suite à un retraitement interne (y compris les séquences de
réécriture suivantes de mod_rewrite). Dans ce contexte, vous pouvez
utiliser le drapeau <code>L</code> pour terminer la séquence
<em>courante</em> de réécriture de mod_rewrite.</p>

</section>

</manualpage>

