<?xml version='1.0' encoding='ISO-8859-1' ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1673563 -->
<!-- French translation by alain B, review by Vincent Deffontaines
	updated by Lucien GENTIS -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="name-based.xml.meta">
<parentdocument href="./">Serveurs virtuels</parentdocument>
<title>Support Apache des serveurs virtuels par nom</title>

<summary>
    <p>Ce document dcrit quand et comment utiliser des serveurs
    virtuels par nom.</p>
</summary>

<seealso><a href="ip-based.html">Support Apache des serveurs virtuels par IP</a></seealso>
<seealso><a href="details.html">Dtails sur le fonctionnement des serveurs virtuels</a></seealso>
<seealso><a href="mass.html">Configuration dynamique des hbergements virtuels de masse</a></seealso>
<seealso><a href="examples.html">Exemples d'utilisations de VirtualHost</a></seealso>

<section id="namevip"><title>Serveurs virtuels par nom vs. par IP</title>

    <p>Les <a href="ip-based.html">serveurs virtuels</a> par IP utilisent l'adresse IP
    de la connexion afin de dterminer quel serveur virtuel doit
    rpondre. Par consquent, vous devez disposer d'adresses IP
    diffrentes pour chaque serveur.</p>

    <p>Avec un hbergement
    virtuel par nom, le serveur s'appuie sur les informations
    transmises par le client dans les en-ttes HTTP de ses requtes.
    La technique prsente ici vous permet de disposer de serveurs
    virtuels diffrents partags sur une mme adresse IP.</p>

    <p>L'hbergement virtuel par nom est habituellement plus simple,
    car il vous suffit de configurer votre serveur DNS pour que
    chaque domaine pointe sur l'adresse IP dont vous disposez, et de
    configurer votre serveur Apache HTTP afin qu'il reconnaisse
    ces domaines. Il rduit aussi la pnurie en adresses IP. Par
    consquent, vous devriez utiliser l'hbergement virtuel par
    nom, sauf dans le cas o vous utiliseriez des quipements qui
    ncessitent un hbergement bas sur IP. Les raisons historiques de
    l'hbergement bas sur IP dans un but de support de certains clients ne
    s'appliquent plus  un serveur web d'usage gnral.</p>

    <p>La slection du serveur virtuel en fonction du nom s'opre en
    dehors de l'algorithme de slection du serveur virtuel en fonction
    de l'adresse IP, ce qui signifie que les recherches du point de vue
    du nom du serveur ne s'effectuent que parmi le jeu de serveurs
    virtuels pour lesquels la correspondance avec la paire adresse
    IP/port est la plus exacte.</p>

</section>

<section id="alg"><title>Comment le serveur slectionne-t-il le serveur
virtuel bas sur le nom appropri</title>

    <p>Il est important de savoir que la premire tape de la rsolution
    de serveur virtuel base sur le nom est une rsolution base sur IP.
    La rsolution de serveur virtuel base sur le nom ne fait que
    choisir le serveur virtuel bas sur le nom le plus appropri, en se
    limitant aux candidats qui conviennent le mieux du point de vue IP.
    La rsolution base sur IP est sans objet si l'on
    utilise un caractre gnrique (*) pour l'adresse IP dans
    toutes les directives VirtualHost.</p>

    <p>A l'arrive d'une requte, le serveur va rechercher l'argument de
    section <directive type="section"
    module="core">VirtualHost</directive> prsentant la meilleure
    (la plus exacte) correspondance avec la paire adresse IP/port
    utilise dans la requte. Si plusieurs serveurs virtuels possdent
    cette mme paire adresse IP/port, Apache va ensuite comparer les
    valeurs des directives <directive module="core"
    >ServerName</directive> et <directive
    >module="core">ServerAlias</directive> avec le nom de serveur
    prsent dans la requte.</p>

    <p>Si vous ne dfinissez pas de directive <directive
    module="core">ServerName</directive> pour un serveur virtuel  base
    de nom, le serveur utilisera par dfaut le nom de domaine
    entirement qualifi (FQDN) dduit du nom d'hte systme. Cette
    configuration sans nom de serveur explicite peut conduire  des
    erreurs de choix du serveur virtuel  utiliser et est dconseille.</p>

    <section id="defaultvhost"><title>Le serveur virtuel  base de nom
    par dfaut pour une paire adresse IP/port</title>
    <p>Si aucune directive ServerName ou ServerAlias ne correspond dans
    la liste de serveurs virtuels prsentant la meilleure correspondance
    du point de vue adresse IP/port, c'est <strong>le premier serveur
    virtuel de cette liste</strong> qui sera utilis.</p></section>


</section>

<section id="using"><title>Utilisation de serveurs virtuels par nom</title>

<related>
    <modulelist>
    <module>core</module>
    </modulelist>

    <directivelist>
	<directive module="core">DocumentRoot</directive>
	<directive module="core">ServerAlias</directive>
	<directive module="core">ServerName</directive>
	<directive module="core" type="section">VirtualHost</directive>
    </directivelist>
</related>


    <p>La premire tape consiste  crer une section
    <directive type="section" module="core">VirtualHost</directive>
    pour chacun des serveurs  dfinir. Dans chaque section
    <directive type="section" module="core">VirtualHost</directive>,
    vous devez dfinir au minimum une directive
    <directive module="core">ServerName</directive> pour dsigner
    le serveur concern et une directive
    <directive module="core">DocumentRoot</directive> pour prciser
    l'emplacement sur le systme de fichiers du contenu de ce serveur.</p>

    <note><title>Le serveur principal disparat</title>
        <p>Toute requte qui ne correspond  aucune section <directive
	type="section" module="core">VirtualHost</directive> existante
	est traite avec la configuration du serveur principal, sans
	tenir compte du nom d'hte ou de la directive ServerName.</p>

        <p>Lorsque vous ajoutez un serveur virtuel bas sur le nom  un
	serveur existant, et si les caractristiques de ce serveur
	virtuel correspondent  des combinaisons IP/port prexistantes,
	les requtes seront alors traites par un serveur virtuel
	explicite. Dans ce cas, il est en gnral judicieux de crer un
	<a href="#defaultvhost">serveur virtuel par dfaut</a>
	comportant une directive <directive
	module="core">ServerName</directive> correspondant au nom du
	serveur principal. De nouveaux domaines sur les mmes interface
	et port, mais ncessitant des configurations distinctes,
	pourront alors tre ajouts en tant que serveurs virtuels
	spcifiques (et non par dfaut).</p>
    </note>

    <note><title>Hritage du nom de serveur</title>
       <p>Il est toujours prfrable de dfinir une directive <directive
       module="core">ServerName</directive> au niveau de chaque serveur
       virtuel  base de nom. Si un serveur virtuel ne dfinit pas
       de directive  <directive module="core">ServerName</directive>, le
       nom de ce serveur virtuel sera hrit du serveur principal. Si
       aucun nom de serveur n'a t explicitement dfini au niveau du
       serveur principal, le serveur tentera de dterminer son nom via
       une rsolution de nom DNS inverse sur la premire adresse
       d'coute. Dans tous les cas, ce nom de serveur hrit influencera
       la slection du serveur virtuel  base de nom, c'est pourquoi il
       est toujours prfrable de dfinir une directive <directive
       module="core">ServerName</directive> pour chaque serveur virtuel
        base de nom.</p>
    </note>

    <p>Par exemple, supposez que vous hbergez le domaine
    <code>www.example.com</code> et que vous souhaitez ajouter le
    serveur virtuel <code>other.example.com</code> qui pointe sur
    la mme adresse IP. Il vous suffit d'ajouter la configuration
    suivante  <code>httpd.conf</code>&nbsp;:</p>

    <highlight language="config">
&lt;VirtualHost *:80&gt;
    # Le premier serveur virtuel de la liste est aussi le
    # serveur par dfaut pour *:80
    ServerName www.example.com
    ServerAlias example.com
    DocumentRoot "/www/domain"
&lt;/VirtualHost&gt;

&lt;VirtualHost *:80&gt;
    ServerName other.example.com
    DocumentRoot "/www/otherdomain"
&lt;/VirtualHost&gt;
    </highlight>

    <p>Autrement, vous pouvez spcifiez une adresse IP explicite
     la place de <code>*</code> dans la directive
    <directive type="section" module="core" >VirtualHost</directive>.
    Par exemple, cette mthode est utile si vous souhaitez faire
    tourner quelques serveurs virtuels par nom sur une mme adresse
    IP, et d'autres, soit par IP, soit bass sur un autre jeu de
    serveurs virtuels par nom sur une autre adresse IP.</p>

    <p>Plusieurs serveurs sont accessibles par plus d'un nom. Il
    suffit de placer la directive
    <directive module="core">ServerAlias</directive> dans une section
    <directive type="section" module="core">VirtualHost</directive>.
    Par exemple, dans la premire section
    <directive type="section" module="core">VirtualHost</directive>
    ci-dessus, la directive <directive module="core">ServerAlias</directive>
    indique aux utilisateurs les autres noms permis pour accder au
    mme site Web&nbsp;:</p>

    <highlight language="config">
        ServerAlias example.com *.example.com
    </highlight>

    <p>ainsi, toutes les requtes portant sur un domaine
    <code>example.com</code> seront servies par le serveur virtuel
    <code>www.example.com</code>. Les caractres joker <code>*</code>
    et <code>?</code> peuvent tre utiliss pour les correspondances.
    Bien entendu, vous ne pouvez pas inventer des noms et les placer
    dans une directive <directive module="core">ServerName</directive>
    ou <code>ServerAlias</code>. Tout d'abord, votre serveur DNS
    doit tre correctement configur pour lier ces noms  une
    adresse IP associe avec votre serveur.</p>

    <p>La recherche du serveur virtuel  base de nom qui correspond au
    plus prs  la requte s'effectue parmi les <directive
    type="section" module="core">virtualhost</directive> selon leur
    ordre d'apparition dans le fichier de configuration. Le premier
    serveur virtuel dont le <directive
    module="core">ServerName</directive> ou le <directive
    module="core">ServerAlias</directive> correspond est utilis, sans
    priorit particulire en cas de prsence de caractres gnriques
    (que ce soit pour le ServerName ou le ServerAlias).</p>

    <p>La liste complte des noms dans la section <directive
    module="core">VirtualHost</directive> sont traits comme une
    directive <directive module="core">ServerAlias</directive> sans
    caractres gnriques.</p>

    <p>Finalement, vous pouvez affiner la configuration des serveurs
    virtuels en plaant d'autres directives  l'intrieur des sections
    <directive type="section" module="core">VirtualHost</directive>.
    La plupart des directives peut tre place dans ces sections en
    y changeant seulement la configuration du serveur virtuel associ.
    Pour dterminer si une directive particulire est permise,
    consultez le <a
    href="../mod/directive-dict.html#Context">contexte</a> de la
    directive. Le jeu de directives configures dans le contexte
    du <em>serveur principal</em> (en dehors de toutes sections
    <directive type="section" module="core">VirtualHost</directive>)
    sera utilis seulement s'il n'y a pas de configuration contraire
    par un serveur virtuel.</p>

</section>

</manualpage>
