<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->
<!-- English Revision: 1784914 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="upgrading.xml.meta">

<title>Mise à jour de la version 2.2 vers la version 2.4</title>

<summary>
  <p>Afin d'assister les utilisateurs lors de leurs opérations de mise à
  jour, nous maintenons un document
  qui comporte des informations critiques à l'attention des personnes qui
  utilisent déjà le serveur HTTP Apache. Ces informations
  ne sont que de brèves notes, et vous
  trouverez plus d'informations dans le document <a
  href="new_features_2_4.html">Nouvelles fonctionnalités</a>, ou dans
  le fichier <code>src/CHANGES</code>. Les développeurs d'applications
  et de modules trouveront un résumé des modifications de l'API dans la
  vue d'ensemble <a href="developer/new_api_2_4.html">Mises à jour de
  l'API</a>.</p>

  <p>Ce document présente les changements de comportement du serveur qui
  peuvent nécessiter une modification de la configuration, et une
  méthode pour utiliser la version 2.4 du serveur en parallèle avec la
  version 2.2. Pour tirer parti des nouvelles fonctionnalités de la
  version 2.4, reportez-vous au document "Nouvelles fonctionnalités".</p>

  <p>Ce document ne décrit que les modifications intervenues entre les versions
  2.2 et 2.4. Si vous effectuez une mise à jour depuis la version 2.0, vous
  devez aussi consulter le
  <a href="http://httpd.apache.org/docs/2.2/upgrading.html">document de mise
  à jour de 2.0 vers 2.2.</a></p>

</summary>
<seealso><a href="new_features_2_4.html">Vue d'ensemble des nouvelles
fonctionnalités du serveur HTTP Apache 2.4</a></seealso>

  <section id="compile-time">
    <title>Modifications des paramètres de compilation</title>
     <p>Le processus de compilation est très similaire à celui de la
     version 2.2. Dans la plupart des cas, vous pourrez utiliser votre
     ancienne ligne de commande <code>configure</code> (telle qu'elle
     est enregistrée dans le fichier <code>build/config.nice</code>
     situé dans le répertoire de compilation du serveur). Voici certains
     changements intervenus dans la configuration par défaut :</p>

    <ul>
      <li>Les modules suivants ont été supprimés : mod_authn_default,
      mod_authz_default et mod_mem_cache. Si vous utilisiez
      mod_mem_cache sous la version 2.2, vous devez maintenant utiliser
      <module>mod_cache_disk</module> dans la version 2.4.</li>

      <li>Toutes les implémentations de répartition de charge ont été
      déplacées vers des sous-modules spécifiques de mod_proxy, comme
      <module>mod_lbmethod_bybusyness</module>. Vous devrez compiler et
      chargés tous les modules correspondants que votre configuration
      utilise.</li>

      <li>Le support de BeOS, TPF, et des anciennes plates-formes telles
      que A/UX, Next, et Tandem a été supprimé, car
      elles ne sont plus considérées comme maintenues.</li>

      <li>configure: les modules dynamiques (DSO) sont compilés par
      défaut</li>

      <li>configure: par défaut, seul un jeu de modules de base est
      chargé. Les autres directives <directive>LoadModule</directive>
      sont mises en commentaires dans le fichier de configuration.</li>

      <li>configure: le jeu de modules "most" est compilé par défaut</li>

      <li>configure: le jeu de modules "reallyall" ajoute les modules de
      développeur au jeu "all".</li>
    </ul>

  </section>

  <section id="run-time">
    <title>Modifications de la configuration à l'exécution</title>
<p>Des changements significatifs dans la configuration de
l'autorisation, ainsi que quelques changements mineurs, peuvent
nécessiter une mise à jour des fichiers de configuration de la version
2.2 avant de les utiliser sous la version 2.4.</p>

    <section id="authz">
      <title>Autorisation</title>

      <p>Tout fichier de configuration qui gère des autorisations devra
      probablement être mis à jour.</p>

    <p>Vous devez vous reporter au document <a
    href="howto/auth.html">Authentification, autorisation et contrôle
    d'accès</a>, et plus particulièrement à la section <a
    href="howto/auth.html#beyond">Pour aller plus loin qu'une simple
    autorisation</a> qui explique les nouveaux mécanismes permettant de
    contrôler l'ordre dans lequel les directives d'autorisation sont
    appliquées.</p>

    <p>Les directives qui contrôlent la manière dont les modules
    d'autorisation réagissent lorsqu'ils ne reconnaissent pas
    l'utilisateur authentifié ont été supprimées : elles comprennent les
    directives AuthzLDAPAuthoritative, AuthzDBDAuthoritative,
    AuthzDBMAuthoritative, AuthzGroupFileAuthoritative,
    AuthzUserAuthoritative et AuthzOwnerAuthoritative. Ces directives
    ont été remplacées par les directives plus explicites <directive
    module="mod_authz_core">RequireAny</directive>, <directive
    module="mod_authz_core">RequireNone</directive>, et <directive
    module="mod_authz_core">RequireAll</directive>.</p>

    <p>Si vous utilisez <module>mod_authz_dbm</module>, vous devez
    mettre à jour votre configuration en remplaçant les directives du
    style <code>Require group ...</code> par des directives du style
    <code>Require dbm-group ...</code>.</p>

    <section id="access">
      <title>Contrôle d'accès</title>

      <p>Dans la version 2.2, le contrôle d'accès basé sur le nom d'hôte
      du client, son adresse IP, ou d'autres caractéristiques de la
      requête était assuré via les directives <directive
      module="mod_access_compat">Order</directive>, <directive
      module="mod_access_compat">Allow</directive>, <directive
      module="mod_access_compat">Deny</directive>, et <directive
      module="mod_access_compat">Satisfy</directive>.</p>

      <p>Dans la version 2.4, ce contrôle d'accès est assuré, comme tout
      contrôle d'autorisation, par le nouveau module
      <module>mod_authz_host</module>. Bien que le module
      <module>mod_access_compat</module> soit fourni à des fins de
      compatibilité avec les anciennes configurations, les anciennes
      directives de contrôle d'accès devront être remplacées par les
      nouveaux mécanismes d'authentification.</p>

      <note><title>Mélanger anciennes et nouvelles directives</title>
      <p>Mélanger d'anciennes directives comme <directive
      module="mod_access_compat">Order</directive>, <directive
      module="mod_access_compat">Allow</directive> ou <directive
      module="mod_access_compat">Deny</directive> avec des nouvelles comme
      <directive module="mod_authz_core">Require</directive> est techniquement
      possible mais déconseillé. En effet, <module>mod_access_compat</module> a
      été conçu pour supporter des configurations ne contenant que des anciennes
      directives afin de faciliter le passage à la version 2.4. Les
      exemples ci-dessous vous permettront de vous faire une meilleure idée des
      problèmes qui peuvent survenir.
      </p>
      </note>

      <p>Voici quelques exemples de contrôle d'accès avec l'ancienne et
      la nouvelle méthode :</p>

      <p>Dans cet exemple, il n'y a pas d'authentification et toutes les requêtes sont rejetées :</p>
      <example>
        <title>version 2.2 :</title>
        <highlight language="config">
Order deny,allow
Deny from all
        </highlight>
      </example>
      <example>
        <title>version 2.4 :</title>
	<highlight language="config">
        Require all denied
	</highlight>
      </example>

      <p>Dans cet exemple, il n'y a pas d'authentification et toutes les requêtes sont acceptées :</p>
      <example>
        <title>version 2.2 :</title>
        <highlight language="config">
Order allow,deny
Allow from all
        </highlight>
      </example>
      <example>
        <title>version 2.4 :</title>
	<highlight language="config">
        Require all granted
	</highlight>
      </example>

      <p>Dans l'exemple suivant, il n'y a pas d'authentification et tous les
      hôtes du domaine example.org ont l'autorisation d'accès, tous les autres
      étant rejetés :</p>

      <example>
        <title>version 2.2 :</title>
        <highlight language="config">
Order Deny,Allow
Deny from all
Allow from example.org
        </highlight>
      </example>
      <example>
        <title>version 2.4 :</title>
	<highlight language="config">
        Require host example.org
	</highlight>
      </example>
    <p>Dans l'exemple suivant, tous les hôtes du domaine example.org
      ont l'autorisation d'accès, tous les autres sont rejetés :</p>

      <example>
        <title>version 2.2 :</title>
        <highlight language="config">
Order Deny,Allow
Deny from all
Allow from example.org
        </highlight>
      </example>
      <example>
        <title>version 2.4 :</title>
	<highlight language="config">
        Require host example.org
	</highlight>
      </example>

      <p>Dans l'exemple suivant, le mélange d'anciennes et de nouvelles
      directives produit des résultats inattendus.</p>
 
      <example>
        <title>Mélange d'anciennes et de nouvelles directives : RESULTAT
	INATTENDU</title>
          <highlight language="config">
DocumentRoot "/var/www/html"

&lt;Directory "/"&gt;
    AllowOverride None
    Order deny,allow
    Deny from all
&lt;/Directory&gt;

&lt;Location "/server-status"&gt;
    SetHandler server-status
    Require local
&lt;/Location&gt;

access.log - GET /server-status 403 127.0.0.1
error.log - AH01797: client denied by server configuration: /var/www/html/server-status
          </highlight>
      </example>
      <p>Pourquoi httpd interdit l'accès à server-status alors que la
      configuration semble l'autoriser ? Parce que dans ce scénario de <a
      href="sections.html#merging">fusion</a> de configuration, les
      directives de <module>mod_access_compat</module> sont prioritaires par
      rapport à celles de <module>mod_authz_host</module>.</p>

      <p>L'exemple suivant quant à lui produit un résultat conforme :</p>

      <example>
        <title>Mélange d'anciennes et de nouvelles directives : RESULTAT
	CONFORME</title>
        <highlight language="config">
DocumentRoot "/var/www/html"

&lt;Directory "/"&gt;
    AllowOverride None
    Require all denied
&lt;/Directory&gt;

&lt;Location "/server-status"&gt;
    SetHandler server-status
    Order deny,allow
    Deny from all
    Allow From 127.0.0.1
&lt;/Location&gt;

access.log - GET /server-status 200 127.0.0.1
        </highlight>
      </example> 
      <p>En conclusion, même si une configuration hybride peut fonctionner,
      essayez de l'éviter lors de la mise à jour : soit conservez les anciennes
      directives, puis migrez-les vers les nouvelles ultérieurement, soit
      effectuez une migration immédiate de toutes les anciennes directives vers
      les nouvelles.  
      </p>      
    </section>

    <p>Dans de nombreuses configurations avec authentification où la directive
     <directive>Satisfy</directive> était définie à sa valeur par défaut
     <em>ALL</em>, les lignes de configuration qui désactivent le contrôle
     d'accès basé sur l'hôte sont maintenant omises :</p>

      <example>
        <title>Version 2.2 :</title>
        <highlight language="config">
Order Deny,Allow
Deny from all
AuthBasicProvider File
AuthUserFile /example.com/conf/users.passwd
AuthName secure
Require valid-user
        </highlight>
      </example>
      <example>
        <title>Version 2.4 :</title>
        <highlight language="config">
# Pas besoin de remplacer les directives Order et deny
AuthBasicProvider File
AuthUserFile /example.com/conf/users.passwd
AuthName secure
Require valid-user
        </highlight>
      </example>

     <p>Dans les configurations où l'authentification et le contrôle d'accès se
     combinaient dans un but précis, les directives de contrôle d'accès doivent
     être migrées. Dans l'exemple suivant, les requêtes qui correspondent aux
     <em>deux</em> critères sont acceptées :</p>
      <example>
        <title>Version 2.2 :</title>
        <highlight language="config">
Order allow,deny
Deny from all
# ALL est la valeur par défaut de Satisfy
Satisfy ALL
Allow from 127.0.0.1
AuthBasicProvider File
AuthUserFile /example.com/conf/users.passwd
AuthName secure
Require valid-user
        </highlight>
      </example>
      <example>
        <title>Version 2.4 :</title>
        <highlight language="config">
AuthBasicProvider File
AuthUserFile /example.com/conf/users.passwd
AuthName secure
&lt;RequireAll&gt;
  Require valid-user
  Require ip 127.0.0.1
&lt;/RequireAll&gt;
        </highlight>
      </example>

     <p>Dans les configurations où l'authentification et le contrôle d'accès se
     combinaient dans un but précis, les directives de contrôle d'accès doivent
     être migrées. Dans l'exemple suivant, les requêtes qui correspondent à
     <em>au moins un</em> critère sont acceptées :</p>
      <example>
        <title>Version 2.2 :</title>
        <highlight language="config">
Order allow,deny
Deny from all
Satisfy any
Allow from 127.0.0.1
AuthBasicProvider File
AuthUserFile /example.com/conf/users.passwd
AuthName secure
Require valid-user
        </highlight>
      </example>
      <example>
        <title>Version 2.4 :</title>
        <highlight language="config">
AuthBasicProvider File
AuthUserFile /example.com/conf/users.passwd
AuthName secure
# Implicite : &lt;RequireAny&gt;
Require valid-user
Require ip 127.0.0.1
        </highlight>
      </example>

    </section>
    
    <section id="config">
      <title>Autres changements dans la configuration</title>

      <p>D'autres ajustements mineurs peuvent s'avérer nécessaires pour
      certaines configurations particulières, comme décrit ci-dessous.</p>

      <ul>
        <li>La directive <directive>MaxRequestsPerChild</directive> a été renommée en
	<directive module="mpm_common">MaxConnectionsPerChild</directive>;
	ce nouveau nom reflète mieux l'usage de cette directive.
	L'ancien nom est encore supporté.</li>

	<li>La directive <directive>MaxClients</directive> a
	été renommée en <directive
	module="mpm_common">MaxRequestWorkers</directive>; ce nouveau
	nom reflète mieux l'usage de cette directive. Pour les
	modules multiprocessus asynchrones, comme <module>event</module>, le nombre
	maximal de clients n'est pas équivalent au nombre de threads du
	worker. L'ancien nom est encore supporté.</li>

        <li>La directive <directive
	module="core">DefaultType</directive> ne produit plus aucun
	effet, si ce n'est d'émettre un avertissement si elle est
	définie à une valeur autre que <code>none</code>. D'autres
	directives de configuration la remplacent dans la version 2.4.
        </li>

	<li>La valeur par défaut de la directive <directive
	module="core">AllowOverride</directive> est maintenant
	<code>None</code>.</li>

	<li>La valeur par défaut de la directive <directive
	module="core">EnableSendfile</directive> est maintenant Off.</li>

	<li>La valeur par défaut de la directive <directive
	module="core">FileETag</directive> est maintenant "MTime Size"
	(sans INode).</li>

        <li><module>mod_dav_fs</module>: le format du fichier <directive
	module="mod_dav_fs">DavLockDB</directive> a changé pour les systèmes
	avec inodes. L'ancien fichier <directive
	module="mod_dav_fs">DavLockDB</directive> doit être supprimé dans le
	cadre de la mise à jour.
        </li>

        <li>La directive <directive module="core">KeepAlive</directive>
	n'accepte que les valeurs <code>On</code> ou <code>Off</code>.
	Avant, toute valeur autre que "Off" ou "0" était traitée comme
	"On".</li>

        <li>Les directives AcceptMutex, LockFile, RewriteLock, SSLMutex,
	SSLStaplingMutex et WatchdogMutexPath ont été remplacées par la
	directive unique <directive module="core">Mutex</directive>.
	Vous devez évaluer l'impact de ces directives obsolètes dans
	votre configuration version 2.2 afin de déterminer si elles
	peuvent être simplement supprimées, ou si elles doivent être
	remplacées par la directive <directive
	module="core">Mutex</directive>.</li>

        <li><module>mod_cache</module>: la directive <directive
	module="mod_cache">CacheIgnoreURLSessionIdentifiers</directive>
	effectue maintenant une correspondance exacte dans la chaîne de
	paramètres au lieu d'une correspondance partielle. Si votre
	configuration mettait en jeu des sous-chaînes comme
	<code>sessionid</code> pour correspondre à
	<code>/une-application/image.gif;jsessionid=123456789</code>,
	vous devez maintenant utiliser la chaîne de correspondance
	complète <code>jsessionid</code>.
        </li>

	<li><module>mod_cache</module>: le second paramètre de la
	directive <directive module="mod_cache">CacheEnable</directive>
	ne concerne les contenus en mandat direct que s'ils débutent par
	le protocole approprié. Dans les versions 2.2 et antérieures, un
	paramètre tel que '/' concernait tous les contenus.</li>

        <li><module>mod_ldap</module>: la directive <directive
	module="mod_ldap">LDAPTrustedClientCert</directive> s'utilise
	maintenant exclusivement au sein d'une configuration de niveau
	répertoire. Si vous utilisez cette directive, passez en revue
	votre configuration pour vous assurer qu'elle est bien présente
	dans tous les contextes de répertoire nécessaires.</li>

	<li><module>mod_filter</module>: la syntaxe de la directive
	<directive module="mod_filter">FilterProvider</directive> utilise
	maintenant une expression booléenne pour déterminer si un filtre
	s'applique.
        </li>

	<li><module>mod_include</module>:
            <ul>
            <li>L'élément <code>#if expr</code> utilise maintenant le
	    nouvel <a href="expr.html">interpréteur d'expressions</a>.
	    L'ancienne syntaxe peut être réactivée via la directive
	    <directive
	    module="mod_include">SSILegacyExprParser</directive>.
            </li>
            <li>Dans la portée du répertoire, une directive de
	    configuration SSI* ne provoque plus la réinitialisation à
	    leur valeur par défaut de toutes les directives SSI* de
	    niveau répertoire.</li>
            </ul>
        </li>

        <li><module>mod_charset_lite</module> : l'option
	<code>DebugLevel</code> a été supprimée en faveur d'une
	configuration de la directive <directive
	module="core">LogLevel</directive> au niveau répertoire.
        </li>

        <li><module>mod_ext_filter</module> : l'option
	<code>DebugLevel</code> a été supprimée en faveur d'une
	configuration de la directive <directive
	module="core">LogLevel</directive> au niveau répertoire.
        </li>

	<li><module>mod_proxy_scgi</module>: certaines applications web
	ne fonctionneront plus correctement avec la nouvelle
	configuration de <code>PATH_INFO</code> qui est différente de
	celle de la version 2.2. La configuration
	précédente peut être
	restaurée en définissant la variable
	<code>proxy-scgi-pathinfo</code>.</li>

	<li><module>mod_ssl</module>: le contrôle de révocation des
	certificats basé sur les CRL doit être maintenant explicitement
	configuré via la directive <directive
        module="mod_ssl">SSLCARevocationCheck</directive>.
        </li>

        <li><module>mod_substitute</module>: la taille maximale d'une
	ligne est maintenant 1Mo.
        </li>

        <li><module>mod_reqtimeout</module>: si ce module est chargé, il
	définit maintenant certains temps d'attente par défaut.</li>

	<li><module>mod_dumpio</module>: la directive
	<directive>DumpIOLogLevel</directive> n'est plus supportée. Les
	données sont toujours enregistrées au niveau <code>trace7</code>
	de <directive module="core">LogLevel</directive></li>

        <li>Jusqu'à la version 2.2, sur les plateformes de style Unix, 
	les commandes de redirection des logs définies via <directive
	module="core">ErrorLog</directive> ou <directive
	module="mod_log_config">CustomLog</directive> étaient invoquées
	en utilisant <code>/bin/sh -c</code>. A
	partir de la version 2.4, les commandes de redirection des logs
	sont exécutées directement. Pour retrouver l'ancien
	comportement, voir la <a href="logs.html#piped">documentation
	sur la redirection des logs</a></li>

    </ul>
    </section>
  </section>

  <section id="misc">
    <title>Changements divers</title>

    <ul>
      <li><module>mod_auto_index</module>: extrait maintenant les titres
      et affiche la description pour les fichiers .xhtml qui étaient
      jusqu'alors ignorés.</li>

      <li><module>mod_ssl</module> : le format par défaut des variables
      <code>*_DN</code> a changé. Il est cependant encore possible
      d'utiliser l'ancien format via la nouvelle option
      <code>LegacyDNStringFormat</code> de la directive <directive
      module="mod_ssl">SSLOptions</directive>. Le protocole SSLv2 n'est
      plus supporté. Les directives <directive
      module="mod_ssl">SSLProxyCheckPeerCN</directive> et
      <directive module="mod_ssl">SSLProxyCheckPeerExpire</directive>
      sont maintenant définies par défaut à On, et les requêtes mandatées
      vers des serveurs HTTPS possèdant des certificats non conformes ou
      périmés échoueront donc avec un code d'erreur 502 (Bad gateway).</li>

      <li><program>htpasswd</program> utilise maintenant par défaut les
      condensés MD5 sur toutes les plates-formes.</li>

      <li>La directive <directive
      module="core">NameVirtualHost</directive> n'a plus aucun effet, si
      ce n'est l'émission d'un avertissement. Toute combinaison
      adresse/port apparaissant dans plusieurs serveurs virtuels est
      traitée implicitement comme un serveur virtuel basé sur le nom.
      </li>

      <li><module>mod_deflate</module> n'effectue plus de compression
      s'il s'aperçoit que la quantité de données ajoutée par la
      compression est supérieure à la quantité de données à compresser.
      </li>

      <li>Les pages d'erreur multilingues de la version 2.2.x ne
      fonctionneront qu'après avoir été corrigées pour
      respecter la nouvelle syntaxe de l'élément <code>#if expr=</code>
      du module <module>mod_include</module>, ou si la directive
      <directive module="mod_include">SSILegacyExprParser</directive> a
      été activée pour le répertoire contenant les pages d'erreur.
      </li>

      <li>La fonctionnalité fournie par <code>mod_authn_alias</code>
      dans les précédentes versions (en fait la directive
      <directive module="mod_authn_core">AuthnProviderAlias</directive>)
      est maintenant fournie par <module>mod_authn_core</module>.  
      </li>

      <li>Les directives RewriteLog et RewriteLogLevel ont été
      supprimées. Leur fonctions sont maintenant assurées par la
      directive <directive
      module="core">LogLevel</directive> qui permet de définir
      un niveau de journalisation approprié pour le module
      <module>mod_rewrite</module>. Voir aussi la section <a
      href="mod/mod_rewrite.html#logging">journalisation de
      mod_rewrite</a>.</li>

    </ul>

    </section>

  <section id="third-party">
    <title>Modules tiers</title>

	<p>Tous les modules tiers doivent être recompilés pour la
	version 2.4 avant d'être chargés.</p>

    <p>De nombreux modules tiers conçus pour la version 2.2
    fonctionneront sans changement avec le serveur HTTP Apache
    version 2.4. Certains nécessiteront cependant des modifications ; se
    reporter à la vue d'ensemble <a
    href="developer/new_api_2_4.html">Mise à jour de l'API</a>.</p>
  </section>
<section id="commonproblems">
    <title>Problèmes de mise à jour courants</title>
    <ul><li>Erreurs au démarrage :
    <ul>
      <li><code>Invalid command 'User', perhaps misspelled or defined by
      a module not included in the server configuration</code> - chargez
      le module <module>mod_unixd</module></li>

      <li><code>Invalid command 'Require', perhaps misspelled or defined
      by a module not included in the server configuration</code>, ou
      <code>Invalid command 'Order', perhaps misspelled or defined by a
      module not included in the server configuration</code> - chargez
      le module <module>mod_access_compat</module>, ou mettez à jour
      vers la version 2.4 les directives d'autorisation.</li>

      <li><code>Ignoring deprecated use of DefaultType in line NN of
      /path/to/httpd.conf</code> - supprimez la directive <directive
      module="core">DefaultType</directive> et remplacez-la par les
      directives de configuration appropriées.</li>

      <li><code>Invalid command 'AddOutputFilterByType', perhaps misspelled 
      or defined by a module not included in the server configuration
      </code> - la directive <directive
      module="mod_filter">AddOutputFilterByType</directive> qui était
      jusqu'alors implémentée par le module core, l'est maintenant par
      le module mod_filter, qui doit donc être chargé.</li>

    </ul></li>
    <li>Erreurs de traitement des requêtes :
    <ul>
      <li><code>configuration error:  couldn't check user: /path</code> -
      chargez le module <module>mod_authn_core</module>.</li>
      <li>Les fichiers <code>.htaccess</code> ne sont pas traités -
      Vérifiez la présence d'une directive <directive
      module="core">AllowOverride</directive> appropriée ; sa valeur par
      défaut est maintenant <code>None</code>.</li>
    </ul>
    </li>
</ul>

  </section>
</manualpage>
