<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1760976 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="vhosts.xml.meta">
  <parentdocument href="./">Rewrite</parentdocument>

<title>Hébergement virtuel de masse avec mod_rewrite</title>

<summary>

<p>Ce document est un complément à la <a
href="../mod/mod_rewrite.html">documentation de référence</a> du module
<module>mod_rewrite</module>. Il décrit comment créer des serveurs
virtuels dynamiquement configurés en utilisant
<module>mod_rewrite</module>.</p>

<note type="warning">L'utilisation de mod_rewrite n'est pas la meilleure
méthode pour configurer des serveurs virtuels. Vous devez dans un
premier temps tenter de résoudre votre problème via ces  <a
href="../vhosts/mass.html">d'autres méthodes</a> avant d'avoir
recours à mod_rewrite. Voir aussi le document <a
href="avoid.html#vhosts">Comment éviter l'utilisation de
mod_rewrite</a>.</note>


</summary>
<seealso><a href="../mod/mod_rewrite.html">Documentation du module</a></seealso>
<seealso><a href="intro.html">Introduction à mod_rewrite</a></seealso>
<seealso><a href="remapping.html">Redirection et remise en
correspondance</a></seealso>
<seealso><a href="access.html">Contrôle d'accès</a></seealso>
<!--<seealso><a href="vhosts.html">Serveurs virtuels</a></seealso>-->
<seealso><a href="proxy.html">Serveurs mandataires</a></seealso>
<seealso><a href="rewritemap.html">Utilisation de RewriteMap</a></seealso>
<seealso><a href="advanced.html">Techniques avancées</a></seealso>
<seealso><a href="avoid.html">Quand ne pas utiliser mod_rewrite</a></seealso>

<section id="per-hostname">

  <title>Serveurs virtuels pour des noms d'hôtes arbitraires</title>

  <dl>
    <dt>Description :</dt>

    <dd>
    <p>Nous voulons créer automatiquement un serveur virtuel pour tout
    nom d'hôte qui peut être résolu dans notre domaine, sans avoir à
    créer de nouvelle section VirtualHost.</p>

    <p>Dans cet exemple, nous supposons que nous utilisons le nom d'hôte
    <code>www.<strong>SITE</strong>.example.com</code> pour chaque
    utilisateur, et que nous servons leur contenu depuis
    <code>/home/<strong>SITE</strong>/www</code>.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>

<highlight language="config">
RewriteEngine on

RewriteMap    lowercase int:tolower

RewriteCond   "${lowercase:%{<strong>HTTP_HOST</strong>}}" "^www\.<strong>([^.]+)</strong>\.example\.com$"
RewriteRule   "^(.*)" "/home/<strong>%1</strong>/www$1"
</highlight></dd>

<dt>Discussion</dt>
    <dd>

    <note type="warning">Vous devez vérifier le bon fonctionnement de la
    résolution DNS - Apache ne gère pas la résolution de nom. Vous
    devrez créer soit des enregistrements CNAME pour chaque nom d'hôte,
    soit un enregistrement DNS avec caractères génériques. La création
    des enregistrements DNS est en dehors du sujet de ce document.</note>

<p>La directive RewriteMap interne <code>tolower</code> permet de
s'assurer que les noms d'hôtes utilisés seront tous en minuscules, de
façon à éviter toute ambiguité dans la structure des répertoires qui
doit être créée.</p>

<p>Les contenus des parenthèses utilisées dans une directive <directive
module="mod_rewrite">RewriteCond</directive> sont enregistrés dans les
références arrières <code>%1</code>, <code>%2</code>, etc..., alors que
les contenus des parenthèses utilisées dans une directive <directive
module="mod_rewrite">RewriteRule</directive> le sont dans les
références arrières <code>$1</code>, <code>$2</code>, etc...</p>

<p>
Comme c'est le cas pour de nombreuses techniques discutées dans ce
document, mod_rewrite n'est vraiment pas la meilleure méthode pour
accomplir cette tâche. Vous devez plutôt vous tourner vers
<module>mod_vhost_alias</module>, car ce dernier sera bien plus à même
de gérer tout ce qui est au delà du domaine des fichiers statiques,
comme les contenus dynamiques et la résolution des alias.
</p>
    </dd>
  </dl>

</section>

<section id="simple.rewrite"><title>Configuration dynamique de serveurs
virtuels via <module>mod_rewrite</module></title>

    <p>Cet extrait du fichier <code>httpd.conf</code> permet d'obtenir
    le même résultat que <a href="#per-hostname">le premier exemple</a>.
    La première moitié est très similaire à la partie correspondante
    ci-dessus, excepté quelques modifications requises à des fins de
    compatibilité ascendante et pour faire en sorte que la partie
    <code>mod_rewrite</code> fonctionne correctement ; la seconde moitié
    configure <code>mod_rewrite</code> pour effectuer le travail
    proprement dit.</p>

    <p>Comme <code>mod_rewrite</code> s'exécute avant tout autre module
    de traduction d'URI (comme <code>mod_alias</code>), il faut lui
    ordonner explicitement d'ignorer toute URL susceptible d'être
    traitée par ces autres modules. Et comme ces règles auraient sinon
    court-circuité toute directive <code>ScriptAlias</code>, nous devons
    faire en sorte que <code>mod_rewrite</code> déclare explicitement
    ces correspondances.</p>

<highlight language="config">
# extrait le nom de serveur de l'en-tête Host:
UseCanonicalName Off

# journaux dissociables
LogFormat "%{Host}i %h %l %u %t \"%r\" %s %b" vcommon
CustomLog "logs/access_log" vcommon

&lt;Directory "/www/hosts"&gt;
    # ExecCGI est nécessaire ici car on ne peut pas forcer l'exécution
    # des CGI à la manière de ScriptAlias
    Options FollowSymLinks ExecCGI
&lt;/Directory&gt;

RewriteEngine On

# un nom de serveur extrait d'un en-tête Host: peut être dans n'importe
# quelle casse
RewriteMap  lowercase  int:tolower

## on s'occupe tout d'abord des documents normaux :<br />
# permet à Alias "/icons/" de fonctionner - répéter pour les autres
RewriteCond  "%{REQUEST_URI}"  "!^/icons/"
# permet aux CGIs de fonctionner
RewriteCond  "%{REQUEST_URI}"  "!^/cgi-bin/"
# le coeur du traitement
RewriteRule  "^/(.*)$"  "/www/hosts/${lowercase:%{SERVER_NAME}}/docs/$1"

## on s'occupe maintenant des CGIs - on doit forcer l'utilisation d'un
# gestionnaire
RewriteCond  "%{REQUEST_URI}"  "^/cgi-bin/"
RewriteRule  "^/(.*)$" "/www/hosts/${lowercase:%{SERVER_NAME}}/cgi-bin/$1"  [H=cgi-script]
</highlight>

</section>

<section id="xtra-conf"><title>Utilisation d'un fichier de configuration
du serveur virtuel séparé</title>

    <p>Cette construction utilise des fonctionnalités plus avancées de
    <module>mod_rewrite</module> pour effectuer la traduction depuis le
    serveur virtuel vers la racine des documents, à partir d'un fichier
    de configuration séparé. Elle est plus souple mais nécessite une
    configuration plus compliquée.</p>

    <p>Le fichier <code>vhost.map</code> devrait ressembler à ceci :</p>

<example>
www.client-1.example.com  /www/clients/1<br />
www.client-2.example.com  /www/clients/2<br />
# ...<br />
www.client-N.example.com  /www/clients/N<br />
</example>

    <p>On doit ajouter à <code>httpd.conf</code> :</p>

<highlight language="config">
RewriteEngine on

RewriteMap   lowercase  int:tolower

# définit le fichier de correspondances
RewriteMap   vhost      "txt:/www/conf/vhost.map"

# on s'occupe des alias comme ci-dessus
RewriteCond  "%{REQUEST_URI}"               "!^/icons/"
RewriteCond  "%{REQUEST_URI}"               "!^/cgi-bin/"
RewriteCond  "${lowercase:%{SERVER_NAME}}"  "^(.+)$"
# on effectue ici la remise en correspondance à base de fichier
RewriteCond  "${vhost:%1}"                  "^(/.*)$"
RewriteRule  "^/(.*)$"                      "%1/docs/$1"

RewriteCond  "%{REQUEST_URI}"               "^/cgi-bin/"
RewriteCond  "${lowercase:%{SERVER_NAME}}"  "^(.+)$"
RewriteCond  "${vhost:%1}"                  "^(/.*)$"
RewriteRule  "^/cgi-bin/(.*)$"              "%1/cgi-bin/$1" [H=cgi-script]
</highlight>

</section>

</manualpage>
