<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1437838 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_heartbeat.xml.meta">

<name>mod_heartbeat</name>
<description>Envoie des messages d'état au mandataire frontal</description>
<status>Experimental</status>
<sourcefile>mod_heartbeat</sourcefile>
<identifier>heartbeat_module</identifier>
<compatibility>Disponible à partir de la version 2.3
du serveur HTTP Apache</compatibility>

<summary>
    <p><module>mod_heartbeat</module> envoie à un moniteur
    <module>mod_heartmonitor</module> des messages multicast l'informant
    du nombre de connexions courantes. En général,
    <module>mod_heartmonitor</module> est chargé sur un serveur
    mandataire où <module>mod_lbmethod_heartbeat</module> est chargé, ce
    qui permet d'utiliser la <em>lbmethod</em> "heartbeat" au sein des
    directives <directive module="mod_proxy">ProxyPass</directive>.</p>

    <p>
    Le module <module>mod_heartbeat</module> est chargé sur le
    serveur d'origine qui sert les requêtes via le
    serveur mandataire.
</p>

    <note type="warning">
        Pour utiliser <module>mod_heartbeat</module>,
	<module>mod_status</module> et <module>mod_watchdog</module>
	doivent être soit des modules statiques, soit des modules
	dynamiques, et dans ce dernier cas, ils doivent être chargés
	avant <module>mod_heartbeat</module>.
    </note>

</summary>

<section id="consuming">
    <title>Utilisation de la sortie de mod_heartbeat</title>
  <p>
      Chaque seconde, ce module génère un paquet multicast UDP contenant
      le nombre de threads/processus occupés et en attente. Le paquet
      possède un format ASCII simple similaire aux paramètres de requête
      GET en HTTP.
  </p>

<example><title>Exemple de paquet</title>
v=1&amp;ready=75&amp;busy=0
</example>

  <p>
    Les utilisateurs disposeront dans le futur de nouvelles variables en
    plus de busy et ready, et toujours séparées par des '&amp;'.
  </p>

</section>

<directivesynopsis>
<name>HeartbeatAddress</name>
<description>Adresse multicast à laquelle envoyer les requêtes
heartbeat</description>
<syntax>HeartbeatAddress <var>addr:port</var></syntax>
<default>disabled</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>La directive <directive>HeartbeatAddress</directive> permet de
    spécifier l'adresse multicast à laquelle <module>mod_heartbeat</module> va
    envoyer ses informations. En général, cette adresse correspond à la
    valeur définie par la directive  <directive
    module="mod_heartmonitor">HeartbeatListen</directive> sur le serveur
    mandataire frontal.</p>
    <highlight language="config">
	HeartbeatAddress 239.0.0.1:27999
    </highlight>
</usage>
</directivesynopsis>

</modulesynopsis>
