<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1673563 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_status.xml.meta">

<name>mod_status</name>
<description>Fournit des informations sur les performances et l'activit&eacute;
du serveur</description>
<status>Base</status>
<sourcefile>mod_status.c</sourcefile>
<identifier>status_module</identifier>


<summary>
    <p>Le module Status permet &agrave; un administrateur de d&eacute;terminer le
    niveau de performances de son serveur. Les statistiques instantan&eacute;es
    du serveur sont pr&eacute;sent&eacute;es dans une page HTML sous une forme
    ais&eacute;ment lisible. Si n&eacute;cessaire, cette page peut &ecirc;tre configur&eacute;e
    pour &ecirc;tre automatiquement actualis&eacute;e (sous r&eacute;serve de
    compatibilit&eacute; du navigateur). Une autre page fournit l'&eacute;tat
    instantan&eacute; du serveur sous la forme d'une simple liste lisible par
    une machine.</p>

    <p>Les d&eacute;tails fournis sont :</p>

    <ul>
      <li>Le nombre de processus servant les requ&ecirc;tes</li>

      <li>Le nombre de processus inactifs</li>

      <li>L'&eacute;tat de chaque processus, le nombre de requ&ecirc;tes qu'il a
      trait&eacute;es et le nombre total d'octets qu'il a servis (*)</li>

      <li>Le nombre total d'acc&egrave;s effectu&eacute;s et d'octets servis (*)</li>

      <li>Le moment o&ugrave; le serveur a &eacute;t&eacute; d&eacute;marr&eacute;/red&eacute;marr&eacute; et le temps
      &eacute;coul&eacute; depuis</li>

      <li>Les valeurs moyennes du nombre de requ&ecirc;tes par seconde, du
      nombre d'octets servis par seconde et du nombre d'octets par
      requ&ecirc;te (*)</li>

      <li>Le pourcentage CPU instantan&eacute; utilis&eacute; par chaque processus et
      par l'ensemble des processus (*)</li>

      <li>Les h&ocirc;tes et requ&ecirc;tes actuellement en cours de traitement
      (*)</li>
    </ul>

    <p>Les lignes se terminant par "(*)" ne sont disponibles que si la
    directive <directive module="core">ExtendedStatus</directive>
    est d&eacute;finie &agrave; <code>On</code>. Depuis la version
    2.3.6, le chargement de mod_status d&eacute;finit automatiquement
    <directive module="core">ExtendedStatus</directive> &agrave; On.</p>
</summary>

<section id="enable">
    <title>Activation du rapport d'&eacute;tat</title>

    <p>Pour n'activer les rapports d'&eacute;tat que pour les navigateurs
    appartenent au domaine example.com, ajoutez ces lignes &agrave; votre
    fichier de configuration <code>httpd.conf</code> :</p>
<highlight language="config">
&lt;Location "/etat-serveur"&gt;
    SetHandler server-status
    Require host example.com
&lt;/Location&gt;
</highlight>

    <p>Il est alors possible d'obtenir les statistiques du serveur en
    utilisant un navigateur web et en acc&eacute;dant &agrave; la page
    <code>http://votre.serveur/etat-serveur</code>.</p>
</section>

<section id="autoupdate">

    <title>Actualisation automatique</title>
    <p>Vous pouvez faire en sorte que cette page d'&eacute;tat s'actualise
    elle-m&ecirc;me automatiquement si votre navigateur supporte "refresh".
    Pour ce faire, acc&eacute;dez &agrave; la page
    <code>http://votre.serveur/etat-serveur?refresh=N</code>, pour que
    cette derni&egrave;re soit actualis&eacute;e toutes les N secondes.</p>

</section>

<section id="machinereadable">

    <title>Fichier d'&eacute;tat lisible par une machine</title>
    <p>La page <code>http://votre.serveur/etat-serveur?auto</code>
    permet d'obtenir une version du fichier d'&eacute;tat lisible par une
    machine. Ceci s'av&egrave;re int&eacute;ressant dans le cadre d'une ex&eacute;cution
    automatique : voir le programme en Perl
    <code>log_server_status</code> situ&eacute; dans le r&eacute;pertoire
    <code>/support</code> de votre distribution du serveur HTTP Apache.</p>

    <note>
      <strong>Veuillez noter que si <module>mod_status</module> a &eacute;t&eacute;
      charg&eacute; dans le serveur, son gestionnaire sera disponible dans
      <em>tous</em> les fichiers de configuration, y compris les
      fichiers de configuration de <em>niveau r&eacute;pertoire</em> (par
      exemple <code>.htaccess</code>), ce qui peut avoir des
      r&eacute;percutions quant &agrave; la s&eacute;curit&eacute; de votre site.</strong>
    </note>

</section>

<section id="troubleshoot">
    <title>Utilisation de server-status pour la recherche de d&eacute;fauts de
    fonctionnement</title>

    <p>La page <code>server-status</code> peut servir de point de d&eacute;part
    &agrave; la recherche de d&eacute;fauts de fonctionnement lorsque votre serveur
    mobilise toutes les ressources disponibles (CPU ou m&eacute;moire), pour
    identifier quels clients ou requ&ecirc;tes sont la cause du probl&egrave;me.</p>

    <p>Tout d'abord, assurez-vous que la directive <directive
    module="core">ExtendedStatus</directive> est bien d&eacute;finie &agrave; on, de
    fa&ccedil;on &agrave; ce que vous puissiez avoir acc&egrave;s &agrave; toutes les informations &agrave;
    propos de la requ&ecirc;te et du client pour chaque processus enfant ou
    thread.</p>

    <p>Consultez ensuite la liste des processus en cours (&agrave; l'aide de
    <code>top</code>, ou d'un utilitaire de listage des processus
    similaire), afin d'identifier les processus coupables. Triez
    l'affichage de <code>top</code> par utilisation CPU ou m&eacute;moire, en
    fonction du probl&egrave;me rencontr&eacute;.</p>

    <p>Rechargez la page <code>server-status</code> et recherchez
    les identifiants des processus trouv&eacute;s pr&eacute;c&eacute;demment ; vous pourrez
    alors d&eacute;terminer quelle requ&ecirc;te est trait&eacute;e par ces processus, pour
    quel client. Les requ&ecirc;tes peuvent appara&icirc;tre de mani&egrave;re fugitive, et
    il se peut que vous deviez effectuer plusieurs essais avant de
    parvenir &agrave; les prendre en flagrant d&eacute;lit, pour ainsi dire.</p>

    <p>Cette proc&eacute;dure <em>devrait</em> vous permettre de cerner quel
    client, ou type de requ&ecirc;te, sont &agrave; l'origine de vos probl&egrave;mes de
    charge. Il est probable que vous identifiiez une application web au
    comportement anormal, ou un client en train d'attaquer votre site.</p>

</section>


</modulesynopsis>

