/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


/**
 * @file win32/win32_config_layout.h
 * @brief This provides layout definitions for non-autoconf-based Windows
 * builds, and is copied to include/ap_config_layout.h during the build.
 */

#ifndef AP_CONFIG_LAYOUT_H
#define AP_CONFIG_LAYOUT_H

/* Check for definition of DEFAULT_REL_RUNTIMEDIR */
#ifndef DEFAULT_REL_RUNTIMEDIR
#define DEFAULT_REL_RUNTIMEDIR "run"
#endif

/* Check for definition of DEFAULT_REL_STATEDIR */
#ifndef DEFAULT_REL_STATEDIR
#define DEFAULT_REL_STATEDIR "var"
#endif

/* JBSC specific */
#define SERVER_CONFIG_FILE "etc/httpd/conf/httpd.conf"

#endif /* AP_CONFIG_LAYOUT_H */

