<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1440768 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_include.xml.meta">

<name>mod_include</name>
<description>Documents html interpr&eacute;t&eacute;s par le serveur (Server Side
Includes ou SSI)</description>
<status>Base</status>
<sourcefile>mod_include.c</sourcefile>
<identifier>include_module</identifier>

<summary>
    <p>Ce module fournit un filtre qui va traiter les fichiers avant
    de les envoyer au client. Le traitement est contr&ocirc;l&eacute; via des
    commentaires SGML sp&eacute;cialement format&eacute;s, aussi nomm&eacute;s
    <dfn>&eacute;l&eacute;ments</dfn>. Ces &eacute;l&eacute;ments permettent l'insertion
    conditionnelle de texte, l'inclusion d'autres fichiers ou
    programmes, ainsi que la d&eacute;finition et l'affichage de variables
    d'environnement.</p>
</summary>
<seealso><directive module="core">Options</directive></seealso>
<seealso><directive module="core">AcceptPathInfo</directive></seealso>
<seealso><a href="../filter.html">Les filtres</a></seealso>
<seealso><a href="../howto/ssi.html">Tutoriel SSI</a></seealso>

<section id="enabling">
    <title>Activation des SSI</title>

    <p>Les SSI sont impl&eacute;ment&eacute;s par le <a
    href="../filter.html">filtre</a> <code>INCLUDES</code>. Si des
    documents contenant des directives SSI poss&egrave;dent une extension
    .shtml, les directives suivantes indiqueront &agrave; Apache de les
    interpr&eacute;ter et d'assigner le type MIME
    <code>text/html</code> au document obtenu :</p>

    <highlight language="config">
AddType text/html .shtml
AddOutputFilter INCLUDES .shtml
    </highlight>

    <p>L'option suivante doit &ecirc;tre d&eacute;finie pour les r&eacute;pertoires qui
    contiennent les fichiers shtml (en g&eacute;n&eacute;ral dans une section
    <directive module="core" type="section">Directory</directive>, mais
    cette option peut &eacute;galement &ecirc;tre d&eacute;finie dans un fichier
    <code>.htaccess</code> si <code><directive
    module="core">AllowOverride</directive> Options</code> a &eacute;t&eacute; d&eacute;fini pour le
    r&eacute;pertoire consid&eacute;r&eacute;) :</p>

    <highlight language="config">
      Options +Includes
    </highlight>

    <p>Pour des raisons de compatibilit&eacute; ascendante, le <a
    href="../handler.html">gestionnaire</a>  <code>server-parsed</code>
    peut aussi activer le filtre INCLUDES. Ainsi, Apache va activer le
    filtre INCLUDES pour tout document de type MIME
    <code>text/x-server-parsed-html</code> ou
    <code>text/x-server-parsed-html3</code> (et le document obtenu aura
    pour type MIME <code>text/html</code>).</p>

    <p>Pour plus d'informations, voyez notre <a
    href="../howto/ssi.html">Tutoriel SSI</a>.</p>
</section> <!-- /enabling -->

<section id="pathinfo">
    <title>PATH_INFO et SSI</title>

    <p>Les fichiers trait&eacute;s dans le cadre des SSI n'acceptent plus par
    d&eacute;faut les requ&ecirc;tes avec <code>PATH_INFO</code> (les informations
    relatives au chemin en fin de requ&ecirc;te). La directive <directive
    module="core">AcceptPathInfo</directive> permet de configurer le
    serveur de fa&ccedil;on &agrave; ce qu'il accepte ce genre de requ&ecirc;te.</p>
</section> <!-- /pathinfo -->

<section id="elements"><title>El&eacute;ments disponibles</title>
    <p>Le document est interpr&eacute;t&eacute; comme un document HTML, avec des
    commandes sp&eacute;ciales incluses sous forme de commentaires SGML. La
    syntaxe d'une commande est la suivante : </p>

    <example>
      &lt;!--#<var>&eacute;l&eacute;ment</var> <var>attribut</var>=<var>valeur</var>
      <var>attribut</var>=<var>valeur</var> ... --&gt;
    </example>

    <p>Les valeurs sont souvent entour&eacute;es de guillemets, mais on peut
    aussi utiliser des apostrophes (<code>'</code>) ou des apostrophes
    inverses (<code>`</code>). De nombreuses commandes n'acceptent
    qu'une seule paire attribut-valeur. Notez que le terminateur de
    commentaire (<code>--&gt;</code>) doit &ecirc;tre pr&eacute;c&eacute;d&eacute; d'un espace afin
    d'&ecirc;tre s&ucirc;r qu'il ne soit pas consid&eacute;r&eacute; comme un &eacute;l&eacute;ment de commande
    SSI. Notez aussi que le d&eacute;limiteur de d&eacute;but <code>&lt;!--#</code>
    est <em>un</em> &eacute;l&eacute;ment de commande et ne doit donc pas contenir
    d'espace.</p>

    <p>La table suivante contient la liste des &eacute;l&eacute;ments autoris&eacute;s :</p>

    <table border="1">
    <tr><th>El&eacute;ment</th><th>Description</th></tr>
    <tr><td><code><a href="#element.config">config</a></code></td>
        <td>configure les formats de sortie</td></tr>
    <tr><td><code><a href="#element.echo">echo</a></code></td>
        <td>affiche le contenu de variables</td></tr>
    <tr><td><code><a href="#element.exec">exec</a></code></td>
        <td>ex&eacute;cute des programmes externes</td></tr>
    <tr><td><code><a href="#element.fsize">fsize</a></code></td>
        <td>affiche la taille d'un fichier</td></tr>
    <tr><td><code><a href="#element.flastmod">flastmod</a></code></td>
        <td>affiche la date de derni&egrave;re modification d'un fichier</td></tr>
    <tr><td><code><a href="#element.include">include</a></code></td>
        <td>inclut un fichier</td></tr>
    <tr><td><code><a href="#element.printenv">printenv</a></code></td>
        <td>affiche toutes les variables disponibles</td></tr>
    <tr><td><code><a href="#element.set">set</a></code></td>
        <td>d&eacute;finit la valeur d'une variable</td></tr>
    </table>

    <p>Les &eacute;l&eacute;ments SSI peuvent &ecirc;tre d&eacute;finis par d'autres modules que
    <module>mod_include</module>. &Agrave; ce titre, l'&eacute;l&eacute;ment <code><a
    href="#element.exec">exec</a></code> est fourni par
    <module>mod_cgi</module>, et ne sera disponible que si ce module est
    charg&eacute;.</p>

    <section id="element.config"><title>L'&eacute;l&eacute;ment config</title>
      <p>Cette commande contr&ocirc;le divers aspects de l'interpr&eacute;tation. Les
      attributs valides sont :</p>

      <dl>
      <dt><code>echomsg</code> (<em>Versions 2.1 et sup&eacute;rieures
      d'Apache</em>)</dt>
      <dd><p>La valeur est un message qui sera envoy&eacute; au client si
      l'&eacute;l&eacute;ment <code><a href="#element.echo">echo</a></code> tente
      d'afficher le contenu d'une variable non d&eacute;finie. Cet attribut
      l'emporte sur toute directive <directive
      module="mod_include">SSIUndefinedEcho</directive>.</p>

      <example>
        &lt;!--#config errmsg="[Valeur non d&eacute;finie]" --&gt;
      </example>
      </dd>

      <dt><code>errmsg</code></dt>
      <dd><p>La valeur est un message qui sera envoy&eacute; au client si une
      erreur survient lors de l'interpr&eacute;tation du document. Cet attribut
      l'emporte sur toute directive <directive
      module="mod_include">SSIErrorMsg</directive>.</p>

      <example>
       &lt;!--#config errmsg="[Zut, quelque chose s'est mal pass&eacute;.]" --&gt;
      </example>
      </dd>

      <dt><code>sizefmt</code></dt>
      <dd><p>La valeur d&eacute;finit l'unit&eacute; employ&eacute;e lors de l'affichage de la
      taille d'un fichier. Les valeurs possibles sont <code>bytes</code>
      pour une taille en octets, ou <code>abbrev</code> pour une taille
      en Ko ou Mo selon son importance ; par exemple, une taille de 1024
      octets sera affich&eacute;e sous la forme "1K".</p>

      <example>
      &lt;!--#config sizefmt="abbrev" --&gt;
      </example>

      </dd>

      <dt><code>timefmt</code></dt>
      <dd><p>La valeur est une cha&icirc;ne que pourra utiliser la fonction de la
      biblioth&egrave;que standard <code>strftime(3)</code> lors de l'affichage
      des dates.</p>

      <example>
      &lt;!--#config timefmt=""%R, %B %d, %Y"" --&gt;
      </example>

      </dd>
      </dl>
    </section> <!-- /config -->

    <section id="element.echo"><title>L'&eacute;l&eacute;ment echo</title>
      <p>Cette commande affiche le contenu d'une des <a
      href="#includevars">variables include</a> d&eacute;finies ci-dessous. Si
      la variable n'est pas d&eacute;finie, le r&eacute;sultat est d&eacute;termin&eacute; par la
      valeur de la directive <directive module="mod_include"
      >SSIUndefinedEcho</directive>. Le format d'affichage des dates est
      d&eacute;fini par l'attribut <code>timefmt</code> de la commande
      config.</p>

      <p>Attributs:</p>

      <dl>
      <dt><code>var</code></dt>
      <dd>La valeur est le nom de la variable &agrave; afficher.</dd>

      <dt><code>decoding</code></dt>
      <dd><p>Sp&eacute;cifie si Apache doit effectuer un d&eacute;codage dans la
      variable avant son traitement ult&eacute;rieur. La valeur par d&eacute;faut est
      <code>none</code>, et dans ce cas, aucun d&eacute;codage n'est effectu&eacute;.
      Si la valeur est <code>url</code>, un d&eacute;codage de type URL sera
      effectu&eacute; (il s'agit du codage de type %-encoding utilis&eacute; dans les
      URLs des liens, etc...). Si la valeur est <code>urlencoded</code>,
      c'est un d&eacute;codage des &eacute;l&eacute;ments de type
      application/x-www-form-urlencode (que l'on trouve dans les cha&icirc;nes
      de param&egrave;tres) qui sera effectu&eacute;. Si la valeur est
      <code>base64</code>, un
      decodage de type base64 sera effectu&eacute;, et si elle est
      <code>entity</code>, c'est un d&eacute;codage des entit&eacute;s HTML qui sera
      effectu&eacute;. Ce d&eacute;codage est effectu&eacute; avant tout codage ult&eacute;rieur de
      la variable. Il est possible d'effectuer plusieurs d&eacute;codages en
      sp&eacute;cifiant plusieurs valeurs s&eacute;par&eacute;es par des virgules. Les
      sp&eacute;cifications de d&eacute;codages restent valables jusqu'au prochain
      attribut de d&eacute;codage, ou la fin de l'&eacute;l&eacute;ment.</p>

      <p>Pour &ecirc;tre pris en compte, l'attribut de <code>d&eacute;codage</code>
      doit <em>pr&eacute;c&eacute;der</em> l'attribut <code>var</code> correspondant.</p>
      </dd>

      <dt><code>encoding</code></dt>
      <dd><p>Sp&eacute;cifie la mani&egrave;re dont Apache va coder les caract&egrave;res
      sp&eacute;ciaux que la variable contient avant leur affichage. S'il est
      d&eacute;fini &agrave; <code>none</code>, aucun codage ne sera effectu&eacute;. S'il
      est d&eacute;fini &agrave; <code>url</code>, un codage de type URL sera effectu&eacute;
      (aussi connu sous le nom de codage avec caract&egrave;res % , il convient
      pour les URLS des liens, etc...). S'il est d&eacute;fini &agrave;
      <code>urlencoded</code>, c'est un codage compatible
      application/x-www-form-urlencoded qui sera effectu&eacute; (&agrave; utiliser
      dans les cha&icirc;nes de param&egrave;tres). S'il est d&eacute;fini &agrave;
      <code>base64</code>, c'est un encodage de type base64 qui sera
      effectu&eacute;. Au d&eacute;but d'un &eacute;l&eacute;ment
      <code>echo</code>, la valeur par d&eacute;faut est d&eacute;finie &agrave;
      <code>entity</code>, ce qui correspond &agrave; un codage de type entit&eacute;
      (codage qui convient pour un &eacute;l&eacute;ment HTML de type bloc, comme le
      paragraphe d'un texte). Cette valeur par d&eacute;faut peut &ecirc;tre modifi&eacute;e
      en ajoutant un attribut <code>encoding</code>, qui fera effet
      jusqu'&agrave; la d&eacute;finition d'un nouvel attribut <code>encoding</code>
      ou la fin de l'&eacute;l&eacute;ment echo.</p>

      <p>Pour produire son effet, l'attribut <code>encoding</code> doit
      pr&eacute;c&eacute;der l'attribut <code>var</code> concern&eacute;.</p>

      <note type="warning">
        Afin de pr&eacute;venir les attaques de type cross-site scripting, il
	est recommand&eacute; de <em>toujours</em> encoder les donn&eacute;es fournies
	par les utilisateurs.
      </note>

      <example><title>Example</title>
        &lt;!--#echo encoding="entity" var="QUERY_STRING" --&gt;
      </example>
      </dd>
      </dl>
    </section> <!-- /echo -->

    <section id="element.exec"><title>L'&eacute;l&eacute;ment exec</title>
      <p>La commande <code>exec</code> ex&eacute;cute la commande shell ou le
      script sp&eacute;cifi&eacute;. Elle n&eacute;cessite le chargement du module
      <module>mod_cgi</module>. Si <directive
      module="core">Options</directive> <code>IncludesNOEXEC</code> est
      d&eacute;finie, cette commande est d&eacute;sactiv&eacute;e. Les attributs disponibles
      sont :</p>

      <dl>
      <dt><code>cgi</code></dt>
      <dd><p>La valeur sp&eacute;cifie un chemin URL vers le script CGI (encod&eacute;
      avec caract&egrave;res %). Si le chemin ne commence pas par un slash (/),
      il est consid&eacute;r&eacute; comme relatif au document courant. Le document
      r&eacute;f&eacute;renc&eacute; par ce chemin est invoqu&eacute; en tant que script CGI, m&ecirc;me
      s'il n'est pas cens&eacute; &ecirc;tre reconnu comme tel par le serveur. Les
      scripts CGI doivent cependant &ecirc;tre activ&eacute;s dans le r&eacute;pertoire qui
      contient les scripts (via la directive <directive
      module="mod_alias">ScriptAlias</directive> ou l'<directive
      module="core">Options</directive> <code>ExecCGI</code>).</p>

      <p>Le <code>PATH_INFO</code> et la cha&icirc;ne d'arguments
      (<code>QUERY_STRING</code>) de la requ&ecirc;te originale du client sont
      fournis au script CGI ; ils <em>ne peuvent pas</em> &ecirc;tre sp&eacute;cifi&eacute;s
      dans le chemin de l'URL. Le script disposera des variables include
      en plus de l'environnement standard <a
      href="mod_cgi.html">CGI</a>.</p>

      <example><title>Exemple</title>
        &lt;!--#exec cgi="/cgi-bin/exemple.cgi" --&gt;
      </example>

      <p>Si, &agrave; la place d'un flux de sortie, le script renvoie un
      en-t&ecirc;te <code>Location:</code>, ce dernier sera traduit en ancrage
      HTML.</p>

      <p>L'&eacute;l&eacute;ment <code><a href="#includevirtual">include
      virtual</a></code> doit &ecirc;tre pr&eacute;f&eacute;r&eacute; &agrave; <code>exec cgi</code>. En
      particulier, si vous devez transmettre des arguments
      suppl&eacute;mentaires &agrave; un programme CGI en utilisant la cha&icirc;ne
      d'arguments de la requ&ecirc;te, c'est impossible avec <code>exec
      cgi</code>, mais vous pouvez y parvenir avec <code>include
      virtual</code> comme suit :</p>

      <example>
        &lt;!--#include virtual="/cgi-bin/exemple.cgi?argument=valeur" --&gt;
      </example>
      </dd>

      <dt><code>cmd</code></dt>
      <dd><p>Le serveur va ex&eacute;cuter la commande fournie en utilisant
      <code>/bin/sh</code>. La commande dispose des <a
      href="#includevars">variables include</a>, en plus du jeu habituel
      de variables CGI.</p>

      <p>Il est toujours pr&eacute;f&eacute;rable d'utiliser <code><a
      href="#includevirtual">#include virtual</a></code> &agrave; la place de
      <code>#exec cgi</code> ou <code>#exec cmd</code>. <code>#include
      virtual</code> utilise le m&eacute;canisme standard des sous-requ&ecirc;tes
      d'Apache pour inclure des fichiers ou des scripts. Il a fait
      l'objet de tests plus approfondis et sa maintenance est mieux
      suivie.</p>

      <p>De plus, sur certaines plate-formes, comme Win32, et sous unix,
      si l'on utilise <a href="../suexec.html">suexec</a>, il est
      impossible de transmettre des arguments &agrave; une commande dans une
      directive <code>exec</code>, &agrave; moins d'ins&eacute;rer des espaces dans la
      commande. Ainsi, alors que ce qui suit fonctionnera sous unix avec
      une configuration sans suexec, l'effet produit ne sera pas celui
      d&eacute;sir&eacute; sous Win32, ou dans le cas de l'utilisation de suexec
      :</p>

      <example>
        &lt;!--#exec cmd="perl /chemin/vers/script_perl arg1 arg2" --&gt;
      </example>
      </dd>
      </dl>
    </section> <!-- /exec -->

    <section id="element.fsize"><title>L'&eacute;l&eacute;ment fsize</title>
      <p>Cette commande permet d'afficher la taille du fichier sp&eacute;cifi&eacute;
      en fonction des sp&eacute;cifications de format de <code>sizefmt</code>.
      Attributs :</p>

      <dl>
      <dt><code>file</code></dt>
      <dd>La valeur est le chemin du fichier, relatif au r&eacute;pertoire
      contenant le document en cours d'interpr&eacute;tation.

      <example>
        Ce fichier a une taille de &lt;!--#fsize file="mod_include.html"
	--&gt; octets.
    </example>

    La valeur de <code>file</code> ne peut pas faire r&eacute;f&eacute;rence &agrave; un
    fichier situ&eacute; &agrave; un niveau sup&eacute;rieur de l'arborescence du r&eacute;pertoire
    courant ou en dehors de la racine des documents ; il ne peut donc
    ni commencer par un slash, ni contenir la s&eacute;quence de caract&egrave;res
    <code>../</code>. Si c'est le cas, le message d'erreur <code>The
    given path was above the root path</code> sera renvoy&eacute;.
      </dd>

      <dt><code>virtual</code></dt>
      <dd>La valeur est un chemin URL (cod&eacute; avec caract&egrave;res %). S'il ne
      commence pas par un slash (/), il est consid&eacute;r&eacute; comme relatif au
      document courant. Notez que cette commande n'affiche <em>pas</em>
      la taille de la sortie d'un programme CGI, mais la taille du
      programme CGI lui-m&ecirc;me.</dd>
      </dl>

      <example>
        Ce fichier a une taille de &lt;!--#fsize
	virtual="/docs/mod/mod_include.html" --&gt; octets.
    </example>

      <p>Notez que dans la plupart des cas, ces deux attributs sont
      identiques. Cependant, l'attribut <code>file</code> ne respecte
      pas les aliases URL-space.</p>
    </section> <!-- /fsize -->

    <section id="element.flastmod"><title>L'&eacute;l&eacute;ment flastmod</title>
      <p>Cette commande permet d'afficher la date de derni&egrave;re
      modification du fichier sp&eacute;cifi&eacute;, en fonction des sp&eacute;cifications
      de format de <code>timefmt</code>. Les attributs sont les m&ecirc;mes
      que ceux de la commande <code><a
      href="#element.fsize">fsize</a></code>.</p>
    </section> <!-- /flastmod -->

    <section id="element.include"><title>L'&eacute;l&eacute;ment include</title>
      <p>Cette commande permet d'ins&eacute;rer le texte d'un autre document ou
      fichier dans le fichier en cours d'interpr&eacute;tation. Tout fichier
      inclus est soumis au contr&ocirc;le d'acc&egrave;s habituel. Si <a
      href="core.html#options">Options</a> <code>IncludesNOEXEC</code>
      est d&eacute;fini pour le r&eacute;pertoire contenant le fichier
      interpr&eacute;t&eacute;, seuls les documents poss&egrave;dant un
      <glossary>type MIME</glossary> de type texte
      (<code>text/plain</code>, <code>text/html</code>, etc...) seront
      inclus. Les scripts CGI, quant &agrave; eux, sont invoqu&eacute;s de mani&egrave;re
      habituelle en utilisant l'URL compl&egrave;te fournie avec la commande, y
      compris toute cha&icirc;ne d'arguments &eacute;ventuelle.</p>

      <p>Un attribut d&eacute;finit le chemin du document &agrave; inclure, et peut
      appara&icirc;tre plusieurs fois dans l'&eacute;l&eacute;ment &agrave; inclure ; en retour, pour
      chaque attribut fourni &agrave; la commande include, une inclusion est
      effectu&eacute;e. Les attributs disponibles sont :</p>

      <dl>
      <dt><code>file</code></dt>
      <dd>La valeur est un chemin relatif au r&eacute;pertoire contenant le
      fichier en cours d'interpr&eacute;tation. Elle ne peut ni contenir
      <code>../</code>, ni &ecirc;tre un chemin absolu. Ainsi, vous ne pouvez
      pas inclure de fichiers situ&eacute;s en dehors de l'arborescence du
      site web ou dans un niveau sup&eacute;rieur &agrave; celui du fichier courant
      dans cette arborescence. Il est toujours pr&eacute;f&eacute;rable d'utiliser
      l'attribut <code>virtual</code>.</dd>

      <dt><code><a id="includevirtual" name="includevirtual"
      >virtual</a></code></dt>
      <dd><p>La valeur est un chemin URL (cod&eacute; avec caract&egrave;res %). L'URL
      ne peut contenir qu'un chemin et une cha&icirc;ne d'arguments
      &eacute;ventuelle, &agrave; l'exclusion de tout protocole ou nom d'h&ocirc;te. S'il ne
      commence pas par un slash (/), il est consid&eacute;r&eacute; comme relatif au
      document courant.</p>

      <p>Une URL est construite &agrave; partir de l'attribut, et la sortie que
      renverrait le serveur si l'URL &eacute;tait acc&eacute;d&eacute;e par le client est
      incluse dans la sortie interpr&eacute;t&eacute;e. Les inclusions de fichiers
      peuvent ainsi &ecirc;tre imbriqu&eacute;es.</p>

      <p>Si l'URL sp&eacute;cifi&eacute;e correspond &agrave; un programme CGI, le programme
      sera ex&eacute;cut&eacute;, et son flux de sortie ins&eacute;r&eacute; &agrave; la place de la
      directive dans le fichier interpr&eacute;t&eacute;. Vous pouvez ins&eacute;rer une
      cha&icirc;ne d'arguments dans une URL correspond &agrave; un programme CGI
      :</p>

      <example>
        &lt;!--#include virtual="/cgi-bin/exemple.cgi?argument=valeur" --&gt;
      </example>

      <p><code>include virtual</code> doit &ecirc;tre pr&eacute;f&eacute;r&eacute; &agrave; <code>exec
      cgi</code> pour inclure le flux de sortie d'un programme CGI dans
      un document HTML.</p>

      <p>Si la directive <directive
      module="mod_request">KeptBodySize</directive> est correctement
      d&eacute;finie et valide pour le fichier inclus, les tentatives de
      requ&ecirc;tes POST vers le document HTML qui inclut des fichiers seront
      transmises aux sous-requ&ecirc;tes en tant que requ&ecirc;tes POST
      elles-m&ecirc;mes. Sans cette directive, toutes les sous-requ&ecirc;tes sont
      trait&eacute;es en tant que requ&ecirc;tes GET.</p>

      </dd>

      <dt><code>onerror</code></dt>
      <dd><p>La valeur est un chemin-URL (cod&eacute;-%) qui est affich&eacute; si une
      tentative pr&eacute;c&eacute;dente d'inclure un fichier ou un attribut virtuel a
      &eacute;chou&eacute;. Pour produire son effet, cet attribut doit &ecirc;tre sp&eacute;cifi&eacute;
      apr&egrave;s le fichier ou les attributs virtuels concern&eacute;s. Si la
      tentative d'inclure le chemin onerror &eacute;choue, ou si onerror n'est
      pas sp&eacute;cifi&eacute;, c'est le message d'erreur par d&eacute;faut qui sera
      inclus.</p>

      <example>
        # Exemple simple<br />
        &lt;!--#include virtual="/not-exist.html" onerror="/error.html" --&gt;
      </example>

      <example>
        # Chemins onerror d&eacute;di&eacute;s<br />
        &lt;!--#include virtual="/path-a.html" onerror="/error-a.html" virtual="/path-b.html" onerror="/error-b.html" --&gt;
      </example>

      </dd>
      </dl>
    </section> <!-- /include -->

    <section id="element.printenv"><title>L'&eacute;l&eacute;ment printenv</title>
      <p>Cette commande affiche la liste en mode texte de toutes les variables et de
      leurs valeurs. Les caract&egrave;res sp&eacute;ciaux sont encod&eacute;s <code>entity</code> avant
      d'&ecirc;tre affich&eacute;s (se reporter &agrave; l'&eacute;l&eacute;ment <code><a
      href="#element.echo">echo</a></code> pour plus de d&eacute;tails). Cette
      commande ne comporte pas d'attributs.</p>

      <example><title>Exemple</title>
        &lt;pre&gt;
          &lt;!--#printenv --&gt;
        &lt;/pre&gt;
      </example>
    </section> <!-- /printenv -->

    <section id="element.set"><title>L'&eacute;l&eacute;ment set</title>
      <p>Cette commande permet de d&eacute;finir la valeur d'une variable. Les
      attributs sont :</p>

      <dl>
      <dt><code>var</code></dt>
      <dd>Le nom de la variable &agrave; d&eacute;finir.</dd>

      <dt><code>value</code></dt>
      <dd>La valeur &agrave; affecter &agrave; la variable.</dd>
      <dt><code>decoding</code></dt>
      <dd><p>Sp&eacute;cifie si Apache doit effectuer un d&eacute;codage dans la
      variable avant son traitement ult&eacute;rieur. La valeur par d&eacute;faut est
      <code>none</code>, et dans ce cas, aucun d&eacute;codage n'est effectu&eacute;.
      Si la valeur est <code>url</code>, <code>urlencoded</code>,
      <code>base64</code> ou
      <code>entity</code>, c'est un d&eacute;codage de type URL,
      application/x-www-form-urlencoded, base64 ou
      entit&eacute; HTML qui sera respectivement effectu&eacute;. Il est possible
      d'effectuer plusieurs d&eacute;codages en
      sp&eacute;cifiant plusieurs valeurs s&eacute;par&eacute;es par des virgules. Les
      sp&eacute;cifications de d&eacute;codages restent valables jusqu'au prochain
      attribut de d&eacute;codage, ou la fin de l'&eacute;l&eacute;ment. Pour &ecirc;tre pris en
      compte, l'attribut de <code>d&eacute;codage</code>
      doit <em>pr&eacute;c&eacute;der</em> l'attribut <code>var</code> correspondant.</p>
      </dd>

      <dt><code>encoding</code></dt>
      <dd><p>Sp&eacute;cifie la mani&egrave;re dont Apache va encoder les caract&egrave;res
      sp&eacute;ciaux que la variable contient avant leur affichage. S'il est
      d&eacute;fini &agrave; <code>none</code>, aucun encodage ne sera effectu&eacute;. Si la
      valeur est <code>url</code>, <code>urlencoding</code>,
      <code>base64</code> ou
      <code>entity</code>, c'est un encodage de type URL,
      application/x-www-form-urlencoded, base64 ou
      entit&eacute; HTML qui sera respectivement effectu&eacute;. Il est possible de
      sp&eacute;cifier plusieurs types d'encodage en les s&eacute;parant par des
      virgules. La sp&eacute;cification du type d'encodage fera effet
      jusqu'&agrave; la d&eacute;finition d'un nouvel attribut encoding
      ou la fin de l'&eacute;l&eacute;ment. Pour produire son effet, l'attribut <code>encoding</code> doit
      pr&eacute;c&eacute;der l'attribut <code>var</code> concern&eacute;. Les encodages sont
      effectu&eacute;s apr&egrave;s les op&eacute;rations de d&eacute;codage.</p>
      </dd>

      </dl>

      <example><title>Exemple</title>
        &lt;!--#set var="category" value="help" --&gt;
      </example>
    </section> <!-- /set -->
</section> <!-- /basic elements -->

<section id="includevars">
    <title>Variables include</title>

    <p>&Agrave; l'instar des variables de l'environnement CGI standard, ces
    variables sont mises &agrave; la disposition de la commande
    <code>echo</code>, des op&eacute;rateurs conditionnels <code>if</code> et
    <code>elif</code>, et de tout programme invoqu&eacute; par le document.</p>

    <dl>
      <dt><code>DATE_GMT</code></dt>
      <dd>La date GMT (Greenwich Mean Time) courante.</dd>

      <dt><code>DATE_LOCAL</code></dt>
      <dd>La date locale courante.</dd>

      <dt><code>DOCUMENT_NAME</code></dt>
      <dd>Le nom de base du fichier demand&eacute; par l'utilisateur (sans son
      chemin).</dd>

      <dt><code>DOCUMENT_URI</code></dt>
      <dd>Le chemin URL (caract&egrave;res % d&eacute;cod&eacute;s) du document demand&eacute; par
      l'utilisateur. Notez que dans le cas d'inclusions de fichiers
      imbriqu&eacute;es, il ne s'agit <em>pas</em> de l'URL du document
      courant. Notez &eacute;galement que si l'URL est modifi&eacute;e en interne (par
      exemple via une directive <directive
      module="mod_alias">alias</directive> ou <directive
      module="mod_dir">directoryindex</directive>), c'est l'URL modifi&eacute;e
      que contiendra la variable.</dd>

      <dt><code>LAST_MODIFIED</code></dt>
      <dd>La date de derni&egrave;re modification du document demand&eacute; par
      l'utilisateur.</dd>

      <dt><code>QUERY_STRING_UNESCAPED</code></dt>
      <dd>Si une cha&icirc;ne d'arguments est pr&eacute;sente, elle sera affect&eacute;e &agrave;
      cette variable, les caract&egrave;res % d&eacute;cod&eacute;s, et &eacute;ventuellement
      <em>&eacute;chapp&eacute;s</em> pour qu'ils ne soient pas interpr&eacute;t&eacute;s par le
      shell (les caract&egrave;res sp&eacute;ciaux comme <code>&amp;</code>,etc...
      sont pr&eacute;c&eacute;d&eacute;s d'anti-slashes).</dd>
    </dl>
</section>

<section id="substitution"><title>Substitution de variable</title>

    <p>Une substitution de variable &agrave; l'int&eacute;rieur d'une cha&icirc;ne entre
    guillemets s'effectue dans la plupart des situations o&ugrave; cette
    derni&egrave;re peut raisonablement constituer un argument d'une directive
    SSI. Sont concern&eacute;es les directives <code>config</code>,
    <code>exec</code>, <code>flastmod</code>, <code>fsize</code>,
    <code>include</code>, <code>echo</code>, et <code>set</code>. Si la
    directive <directive
    module="mod_include">SSILegacyExprParser</directive> est d&eacute;finie &agrave;
    <code>on</code>, la substitution s'effectue aussi dans les arguments
    des op&eacute;rateurs conditionnels. Vous pouvez ins&eacute;rer
    un signe dollar en tant que caract&egrave;re litt&eacute;ral dans une cha&icirc;ne en
    utilisant un anti-slash :</p>

    <example>
      &lt;!--#set var="cur" value="\$test" --&gt;
    </example>

    <p>Si une r&eacute;f&eacute;rence de variable doit &ecirc;tre substitu&eacute;e au beau milieu
    d'une s&eacute;quence de caract&egrave;res qui pourrait &ecirc;tre elle-m&ecirc;me consid&eacute;r&eacute;e
    comme un identifiant valide, l'ambigu&iuml;t&eacute; peut &ecirc;tre lev&eacute;e en
    entourant la r&eacute;f&eacute;rence d'accolades, &agrave; la mani&egrave;re du shell :</p>

    <example>
      &lt;!--#set var="Zed" value="${REMOTE_HOST}_${REQUEST_METHOD}" --&gt;
    </example>

    <p>Dans cet exemple, la variable <code>Zed</code> se verra affecter
    la valeur "<code>X_Y</code>" si <code>REMOTE_HOST</code> et
    <code>REQUEST_METHOD</code> contiennent respectivement
    "<code>X</code>" et "<code>Y</code>".</p>

</section>

<section id="flowctrl">
    <title>El&eacute;ments de contr&ocirc;le d'inclusion conditionnelle</title>

    <p>Les &eacute;l&eacute;ments de base du contr&ocirc;le d'inclusion conditionnelle sont
    :</p>

    <example>
      &lt;!--#if expr="<var>test_condition</var>" --&gt;<br />
      &lt;!--#elif expr="<var>test_condition</var>" --&gt;<br />
      &lt;!--#else --&gt;<br />
      &lt;!--#endif --&gt;
    </example>

    <p>L'&eacute;l&eacute;ment <code>if</code> fonctionne de la m&ecirc;me mani&egrave;re que
    la directive if d'un langage de programmation. La condition est
    &eacute;valu&eacute;e et si le r&eacute;sultat est vrai, le texte qui suit jusqu'au
    prochain &eacute;l&eacute;ment <code>elif</code>, <code>else</code> ou
    <code>endif</code> sera inclus dans le flux de sortie.</p>

    <p>Les &eacute;l&eacute;ments <code>elif</code> ou <code>else</code> permettent
    d'ins&eacute;rer du texte dans le flux de sortie si
    <var>test_condition</var> s'est r&eacute;v&eacute;l&eacute; faux. Ces &eacute;l&eacute;ments sont
    optionnels.</p>

    <p>L'&eacute;l&eacute;ment <code>endif</code> termine le bloc de traitement
    conditionnel <code>if</code> et est obligatoire.</p>

    <p><var>test_condition</var> est une expression bool&eacute;enne qui
    emprunte la syntaxe <a href="../expr.html">ap_expr</a>. La directive
    <directive module="mod_include">SSILegacyExprParser</directive>
    permet de modifier cette syntaxe pour la rendre compatible avec
    Apache HTTPD 2.2.x.</p>

    <p>Le jeu de variables SSI avec l'&eacute;l&eacute;ment <code>var</code> sont
    export&eacute;es vers l'environnement de la requ&ecirc;te et sont accessibles via
    la fonction <code>reqenv</code>. Pour faire simple, le nom de
    fonction <code>v</code> est aussi disponible dans le module
    <module>mod_include</module>.</p>

    <p>Dans l'exemple suivant, "depuis le r&eacute;seau local"  sera affich&eacute; si
    l'adresse IP du client appartient au sous-r&eacute;seau 10.0.0.0/8.</p>

    <example>
      &lt;!--#if expr='-R "10.0.0.0/8"' --&gt;<br />
      <indent>
        depuis le r&eacute;seau local<br />
      </indent>
      &lt;!--#else --&gt;<br />
      <indent>
        depuis ailleurs<br />
      </indent>
      &lt;!--#endif --&gt;
    </example>

    <p>Dans l'exemple suivant, "foo vaut bar" sera affich&eacute; si la variable
    <code>foo</code> contient la valeur "bar".</p>

    <example>
      &lt;!--#if expr='v("foo") = "bar"' --&gt;<br />
      <indent>
        foo vaut bar<br />
      </indent>
      &lt;!--#endif --&gt;
    </example>

    <note><title>Documentation de r&eacute;f&eacute;rence</title>
    <p>Voir aussi <a href="../expr.html">Les expressions dans le serveur
    HTTP Apache</a> pour une r&eacute;f&eacute;rence compl&egrave;te et des exemples. Les
    fonctions <em>restricted</em> ne sont pas disponibles dans
    <module>mod_include</module>.</p>
    </note>
</section>

<section id="legacyexpr">
    <title>Syntaxe des expressions h&eacute;rit&eacute;e</title>

    <p>Cette section d&eacute;crit la syntaxe de l'&eacute;l&eacute;ment <code>#if
    expr</code> dans le cas o&ugrave; la directive <directive
    module="mod_include">SSILegacyExprParser</directive> est d&eacute;finie &agrave;
    <code>on</code>.</p>

    <dl>
      <dt><code><var>cha&icirc;ne</var></code></dt>
      <dd>vrai si <var>cha&icirc;ne</var> n'est pas vide</dd>

      <dt><code><var>-A string</var></code></dt>
      <dd><p>vrai si l'URL que contient la cha&icirc;ne est accessible du
      point de vue de la configuration, faux sinon. Il
      s'av&egrave;re utile lorsqu'un lien vers une URL doit &ecirc;tre cach&eacute; aux
      utilisateurs qui ne sont pas autoris&eacute;s &agrave; voir cette URL. Notez que
      le test porte sur l'autorisation d'acc&egrave;s &agrave; l'URL, et non sur son
      existence.</p>

      <example><title>Exemple</title>
        &lt;!--#if expr="-A /prive" --&gt;<br />
        <indent>
          Cliquez &lt;a href="/prive"&gt;ici&lt;/a&gt; pour acc&eacute;der aux
	  informations priv&eacute;es.<br />
        </indent>
        &lt;!--#endif --&gt;
      </example>
      </dd>

      <dt><code><var>cha&icirc;ne1</var> = <var>cha&icirc;ne2</var><br />
      <var>cha&icirc;ne1</var> == <var>cha&icirc;ne2</var><br />
      <var>cha&icirc;ne1</var> != <var>cha&icirc;ne2</var></code></dt>

      <dd><p>Compare <var>cha&icirc;ne1</var> &agrave; <var>cha&icirc;ne2</var>. Si
      <var>cha&icirc;ne2</var> est de la forme
      <code>/<var>cha&icirc;ne2</var>/</code>, elle est trait&eacute;e comme une
      expression rationnelle. Les expressions rationnelles sont
      impl&eacute;ment&eacute;es par le moteur <a href="http://www.pcre.org">PCRE</a>
      et poss&egrave;dent la m&ecirc;me syntaxe que celles de <a
      href="http://www.perl.com">perl 5</a>. Notez que <code>==</code>
      n'est qu'un alias pour <code>=</code> et se comporte exactement de
      la m&ecirc;me mani&egrave;re que ce dernier.</p>

      <p>Si vous faites une comparaison directe (<code>=</code> ou
      <code>==</code>), vous pouvez extraire des parties de l'expression
      rationnelle. Les parties extraites sont stock&eacute;es dans les
      variables sp&eacute;ciales <code>$1</code> .. <code>$9</code>. L'ensemble
      de la cha&icirc;ne correspondant &agrave; l'expression rationnelle est stock&eacute;
      dans la variable sp&eacute;ciale <code>$0</code>.</p>

      <example><title>Exemple</title>
        &lt;!--#if expr="$QUERY_STRING = /^sid=([a-zA-Z0-9]+)/" --&gt;<br />
        <indent>
          &lt;!--#set var="session" value="$1" --&gt;<br />
        </indent>
        &lt;!--#endif --&gt;
      </example>
      </dd>

      <dt><code><var>cha&icirc;ne1</var> &lt; <var>cha&icirc;ne2</var><br />
       <var>cha&icirc;ne1</var> &lt;= <var>cha&icirc;ne2</var><br />
       <var>cha&icirc;ne1</var> &gt; <var>cha&icirc;ne2</var><br />
       <var>cha&icirc;ne1</var> &gt;= <var>cha&icirc;ne2</var></code></dt>

      <dd>Compare <var>cha&icirc;ne1</var> &agrave; <var>cha&icirc;ne2</var>. Notez que les
      cha&icirc;nes sont compar&eacute;es de mani&egrave;re <em>litt&eacute;rale</em> (en utilisant
      <code>strcmp(3)</code>). Ainsi, la cha&icirc;ne "100" est inf&eacute;rieure &agrave;
      "20".</dd>

      <dt><code>( <var>test_condition</var> )</code></dt>
      <dd>vrai si <var>test_condition</var> est vrai</dd>

      <dt><code>! <var>test_condition</var></code></dt>
      <dd>vrai si <var>test_condition</var> est faux</dd>

      <dt><code><var>test_condition1</var> &amp;&amp;
        <var>test_condition2</var></code></dt>
      <dd>vrai si <var>test_condition1</var> et
      <var>test_condition2</var> sont tous les deux vrais</dd>

      <dt><code><var>test_condition1</var> ||
        <var>test_condition2</var></code></dt>
      <dd>vrai si au moins un des tests <var>test_condition1</var> ou
      <var>test_condition2</var> est vrai</dd>
    </dl>

    <p>"<code>=</code>" et "<code>!=</code>" ont une priorit&eacute; sup&eacute;rieure
    &agrave; "<code>&amp;&amp;</code>" et "<code>||</code>". "<code>!</code>" a
    la priorit&eacute; la plus haute. Ainsi, les deux directives suivantes sont
    &eacute;quivalentes :</p>

    <example>
      &lt;!--#if expr="$a = test1 &amp;&amp; $b = test2" --&gt;<br />
      &lt;!--#if expr="($a = test1) &amp;&amp; ($b = test2)" --&gt;
    </example>

    <p>Les op&eacute;rateurs bool&eacute;ens <code>&amp;&amp;</code> et
    <code>||</code> ont la m&ecirc;me priorit&eacute;. Ainsi, si vous voulez
    augmenter la priorit&eacute; d'un de ces op&eacute;rateurs, vous devez utiliser
    des parenth&egrave;ses.</p>

    <p>Tout ce qui n'est pas reconnu comme variable ou op&eacute;rateur est
    trait&eacute; comme une cha&icirc;ne. Les cha&icirc;nes peuvent aussi &ecirc;tre entour&eacute;es
    d'apostrophes : <code>'cha&icirc;ne'</code>. Les cha&icirc;nes sans apostrophe
    ne peuvent pas contenir d'espaces (espaces ou tabulations) car
    ceux-ci servent &agrave; s&eacute;parer certains &eacute;l&eacute;ments comme les variables. Si
    plusieurs cha&icirc;nes se trouvent dans une ligne, elles sont concat&eacute;n&eacute;es
    en utilisant des espaces. Ainsi,</p>

    <example>
      <p><code><var>cha&icirc;ne1</var>&nbsp;&nbsp;&nbsp;&nbsp;<var
      >cha&icirc;ne2</var></code> devient <code><var>cha&icirc;ne1</var>&nbsp;<var
      >cha&icirc;ne2</var></code><br />
      <br />
      et<br />
      <br />
      <code>'<var>cha&icirc;ne1</var>&nbsp;&nbsp;&nbsp;&nbsp;<var
      >cha&icirc;ne2</var>'</code> devient <code><var
      >cha&icirc;ne1</var>&nbsp;&nbsp;&nbsp;&nbsp;<var>cha&icirc;ne2</var></code>.</p>
    </example>

    <note><title>Optimisation des expressions bool&eacute;ennes</title>
      <p>Si les expressions atteignent une complexit&eacute; suffisante pour
      ralentir les traitements de mani&egrave;re significative, vous pouvez
      essayer de les optimiser en fonction des r&egrave;gles d'&eacute;valuation :</p>
      <ul>
      <li>Les expressions sont &eacute;valu&eacute;es de la gauche vers la droite</li>
      <li>Les op&eacute;rateurs bool&eacute;ens binaires (<code>&amp;&amp;</code> et
      <code>||</code>) font l'objet d'une &eacute;valuation abr&eacute;g&eacute;e chaque fois
      que cela est possible. En d'autres termes, et selon la r&egrave;gle
      ci-dessus, <module>mod_include</module> &eacute;value tout d'abord la
      partie gauche de l'expression. Si le r&eacute;sultat de l'&eacute;valuation de
      cette partie gauche suffit &agrave; d&eacute;terminer le r&eacute;sultat final,
      l'&eacute;valuation s'arr&ecirc;te ici. Dans le cas contraire, la partie droite
      est &eacute;valu&eacute;e, et le r&eacute;sultat final tient compte des r&eacute;sultats des
      &eacute;valuations des parties gauche et droite.</li>
      <li>L'&eacute;valuation abr&eacute;g&eacute;e est d&eacute;sactiv&eacute;e tant qu'il reste des
      expressions r&eacute;guli&egrave;res &agrave; traiter. Ces derni&egrave;res doivent &ecirc;tre
      &eacute;valu&eacute;es afin de d&eacute;finir les variables correspondant aux
      r&eacute;f&eacute;rences arri&egrave;res (<code>$1</code> .. <code>$9</code>).</li>
      </ul>
      <p>Si vous voulez d&eacute;terminer la mani&egrave;re dont une expression est
      trait&eacute;e, vous pouvez recompiler <module>mod_include</module> en
      utilisant l'option de compilation <code>-DDEBUG_INCLUDE</code>.
      Ceci a pour effet d'ins&eacute;rer, pour chaque expression interpr&eacute;t&eacute;e,
      des informations &eacute;tiquet&eacute;es, l'arbre d'interpr&eacute;tation et la
      mani&egrave;re dont elle est &eacute;valu&eacute;e au sein du flux de sortie envoy&eacute; au
      client.</p>
    </note>

    <note><title>Slashes d'&eacute;chappement dans les expressions
    rationnelles</title>
     <p>Tous les caract&egrave;res slashes qui ne sont pas des s&eacute;parateurs dans
     votre expression rationnelle doivent &ecirc;tre &eacute;chapp&eacute;s, et ceci sans
     tenir compte de leur signification du point de vue du moteur
     d'expressions rationnelles.</p>
    </note>

    <note><title>Documentation de r&eacute;f&eacute;rence</title>
    <p>Voir le document <a href="../expr.html">Les expressions dans le
    serveur HTTP Apache</a>, pour une r&eacute;f&eacute;rence compl&egrave;te et des exemples.</p>
    </note>


</section>

<directivesynopsis>
<name>SSIEndTag</name>
<description>Cha&icirc;ne qui termine l'&eacute;l&eacute;ment include</description>
<syntax>SSIEndTag <var>tag</var></syntax>
<default>SSIEndTag &quot;--&gt;&quot;</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Cette directive permet de modifier la cha&icirc;ne que
    <module>mod_include</module> interpr&egrave;te comme la fin d'un &eacute;l&eacute;ment
    include.</p>

    <highlight language="config">
      SSIEndTag "%&gt;"
    </highlight>

</usage>
<seealso><directive module="mod_include">SSIStartTag</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>SSIUndefinedEcho</name>
<description>Cha&icirc;ne &agrave; afficher lorsqu'on tente d'extraire le contenu
d'une variable non d&eacute;finie</description>
<syntax>SSIUndefinedEcho <var>cha&icirc;ne</var></syntax>
<default>SSIUndefinedEcho &quot;(none)&quot;</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>All</override>

<usage>
    <p>Cette directive permet de modifier la cha&icirc;ne affich&eacute;e par
    <module>mod_include</module> lorsqu'on tente d'extraire le contenu
    d'une variable non d&eacute;finie.</p>

    <highlight language="config">
      SSIUndefinedEcho "&lt;!-- nondef --&gt;"
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSIErrorMsg</name>
<description>Message d'erreur affich&eacute; lorsqu'une erreur SSI
survient</description>
<syntax>SSIErrorMsg <var>message</var></syntax>
<default>SSIErrorMsg &quot;[an error occurred while processing this
directive]&quot;</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>All</override>

<usage>
    <p>La directive <directive>SSIErrorMsg</directive> permet de
    modifier le message d'erreur affich&eacute; lorsqu'une erreur SSI survient.
    Pour les serveurs en production, il est recommand&eacute; de modifier le
    message d'erreur par d&eacute;faut en <code>&quot;&lt;!-- Error
    --&gt;&quot;</code>, de fa&ccedil;on &agrave; ce que le message ne soit pas
    pr&eacute;sent&eacute; &agrave; l'utilisateur.</p>

    <p>Cette directive a le m&ecirc;me effet que l'&eacute;l&eacute;ment
    <code>&lt;!--#config errmsg=<var>message</var> --&gt;</code>.</p>

    <highlight language="config">
      SSIErrorMsg "&lt;!-- Error --&gt;"
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSIStartTag</name>
<description>Cha&icirc;ne qui marque le d&eacute;but d'un &eacute;l&eacute;ment
include</description>
<syntax>SSIStartTag <var>tag</var></syntax>
<default>SSIStartTag &quot;&lt;!--#&quot;</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Cette directive permet de modifier la cha&icirc;ne que
    <module>mod_include</module> interpr&egrave;te comme le d&eacute;but d'un &eacute;l&eacute;ment
    include.</p>

    <p>Cette option peut vous &ecirc;tre utile si vous avez deux serveurs qui
    interpr&egrave;tent un fichier avec des commandes diff&eacute;rentes (et
    &eacute;ventuellement &agrave; des moments diff&eacute;rents).</p>

    <highlight language="config">
      SSIStartTag "&lt;%"<br />
      SSIEndTag   "%&gt;"
    </highlight>

    <p>Avec l'exemple ci-dessus, qui d&eacute;finit aussi une directive
    <directive module="mod_include">SSIEndTag</directive>, vous pourrez
    inscrire des directives SSI comme dans l'exemple suivant :</p>

    <example><title>Directives SSI avec marques de d&eacute;but et de fin
    personnalis&eacute;es</title>
      &lt;%printenv %&gt;
    </example>
</usage>
<seealso><directive module="mod_include">SSIEndTag</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>SSITimeFormat</name>
<description>Configuration du format d'affichage des dates</description>
<syntax>SSITimeFormat <var>cha&icirc;ne de formatage</var></syntax>
<default>SSITimeFormat &quot;%A, %d-%b-%Y %H:%M:%S %Z&quot;</default>
<contextlist>
<context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>All</override>

<usage>
<p>Cette directive permet de modifier le format d'affichage des
variables d'environnement <code>DATE</code>. La <var>cha&icirc;ne de
formatage</var> est identique &agrave; celle de la fonction
<code>strftime(3)</code> de la biblioth&egrave;que C standard.</p>

    <p>Cette directive a le m&ecirc;me effet que l'&eacute;l&eacute;ment
    <code>&lt;!--#config timefmt=<var>cha&icirc;ne de formatage</var>
    --&gt;</code>.</p>

    <highlight language="config">
      SSITimeFormat "%R, %B %d, %Y"
    </highlight>

    <p>Avec l'exemple ci-dessus, les dates seront affich&eacute;es dans le
    style "22:26, June 14, 2002".</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSIETag</name>
<description>D&eacute;finit si des en-t&ecirc;tes ETags sont g&eacute;n&eacute;r&eacute;s par le serveur.</description>
<syntax>SSIETag on|off</syntax>
<default>SSIETag off</default>
<contextlist><context>directory</context><context>.htaccess</context></contextlist>
<compatibility>Disponible &agrave; partir de la version 2.2.15 du serveur HTTP
Apache.</compatibility>

<usage>
      <p>Dans le cas g&eacute;n&eacute;ral, un fichier filtr&eacute; par
      <module>mod_include</module> peut contenir des &eacute;l&eacute;ments soit
      g&eacute;n&eacute;r&eacute;s dynamiquement, soit &eacute;ventuellement modifi&eacute;s ind&eacute;pendemment
      du fichier original. En cons&eacute;quence, il est demand&eacute; par d&eacute;faut au
      serveur de ne pas g&eacute;n&eacute;rer d'en-t&ecirc;te <code>ETag</code> &agrave; la r&eacute;ponse
      en ajoutant <code>no-etag</code> aux informations de requ&ecirc;te.</p>

      <p>Ce comportement peut &ecirc;tre modifi&eacute; via la directive
      <directive>SSIETag</directive> qui permet au serveur de g&eacute;n&eacute;rer un
      en-t&ecirc;te <code>ETag</code>. On peut aussi l'utiliser pour la mise
      en cache de la sortie. Notez qu'un serveur d'arri&egrave;re-plan ou un
      g&eacute;n&eacute;rateur de contenu dynamique peut lui-m&ecirc;me g&eacute;n&eacute;rer un en-t&ecirc;te
      <code>ETag</code>, en ignorant l'information <code>no-etag</code>,
      cet en-t&ecirc;te <code>ETag</code> &eacute;tant transmis par
      <module>mod_include</module> sans tenir compte de la d&eacute;finition de
      la pr&eacute;sente directive. La directive <directive>SSIETag</directive>
      peut prendre une des valeurs suivantes :</p>

      <dl>

        <dt><code>off</code></dt>
        <dd><code>no-etag</code> sera ajout&eacute; aux informations de
	requ&ecirc;te, et il sera demand&eacute; au serveur de ne pas g&eacute;n&eacute;rer
	d'en-t&ecirc;te <code>ETag</code>. Lorsqu'un serveur ignore la valeur
	de <code>no-etag</code> et g&eacute;n&egrave;re tout de m&ecirc;me un en-t&ecirc;te
	<code>ETag</code>, ce dernier sera respect&eacute;.</dd>

        <dt><code>on</code></dt>
        <dd>Les en-t&ecirc;tes <code>ETag</code> existants seront respect&eacute;s,
	et ceux g&eacute;n&eacute;r&eacute;s par le serveur seront ajout&eacute;s &agrave; la r&eacute;ponse.</dd>

      </dl>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSILastModified</name>
<description>D&eacute;finit si des en-t&ecirc;tes <code>Last-Modified</code> sont
g&eacute;n&eacute;r&eacute;s par le serveur.</description>
<syntax>SSILastModified on|off</syntax>
<default>SSILastModified off</default>
<contextlist><context>directory</context><context>.htaccess</context></contextlist>
<compatibility>Disponible &agrave; partir de la version 2.2.15 du serveur HTTP
Apache.</compatibility>

<usage>
      <p>Dans le cas g&eacute;n&eacute;ral, un fichier filtr&eacute; par
      <module>mod_include</module> peut contenir des &eacute;l&eacute;ments soit
      g&eacute;n&eacute;r&eacute;s dynamiquement, soit &eacute;ventuellement modifi&eacute;s ind&eacute;pendemment
      du fichier original. En cons&eacute;quence, l'en-t&ecirc;te
      <code>Last-Modified</code> est supprim&eacute; par d&eacute;faut de la r&eacute;ponse.</p>

      <p>La directive <directive>SSILastModified</directive> permet de
      modifier ce comportement en faisant en sorte que l'en-t&ecirc;te
      <code>Last-Modified</code> soit respect&eacute; s'il est d&eacute;j&agrave; pr&eacute;sent, ou
      d&eacute;fini dans le cas contraire. On peut aussi l'utiliser pour la mise
      en cache de la sortie. La directive
      <directive>SSILastModified</directive> peut prendre une des
      valeurs suivantes :</p>

      <dl>

        <dt><code>off</code></dt>
        <dd>L'en-t&ecirc;te <code>Last-Modified</code> sera supprim&eacute; des
	r&eacute;ponses, &agrave; moins que la directive <directive
	module="mod_include">XBitHack</directive> ne soit d&eacute;finie &agrave;
	<code>full</code> comme d&eacute;crit plus loin.</dd>

        <dt><code>on</code></dt>
        <dd>L'en-t&ecirc;te <code>Last-Modified</code> sera respect&eacute; s'il est
	d&eacute;j&agrave; pr&eacute;sent, et ajout&eacute; &agrave; la r&eacute;ponse si cette derni&egrave;re est un
	fichier et si l'en-t&ecirc;te est manquant. La directive <directive
	module="mod_include">SSILastModified</directive> l'emporte sur
	la directive <directive
	module="mod_include">XBitHack</directive>.</dd>

      </dl>

</usage>
</directivesynopsis>
<directivesynopsis>
<name>SSILegacyExprParser</name>
<description>Active le mode de compatibilit&eacute; pour les expressions
conditionnelles.</description>
<syntax>SSILegacyExprParser on|off</syntax>
<default>SSILegacyExprParser off</default>
<contextlist><context>directory</context><context>.htaccess</context></contextlist>
<compatibility>Disponible &agrave; partir de la version 2.3.13.</compatibility>

<usage>
    <p>Depuis la version 2.3.13, <module>mod_include</module> a adopt&eacute;
    la nouvelle syntaxe <a href="../expr.html">ap_expr</a> pour ses
    expressions conditionnelles dans les &eacute;l&eacute;ments de contr&ocirc;le de flux
    <code>#if</code>. Cette directive permet de r&eacute;activer l'<a
    href="#legacyexpr">ancienne syntaxe</a> qui est compatible avec les
    versions 2.2.x et ant&eacute;rieures d'Apache HTTPD.
    </p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>XBitHack</name>
<description>Interpr&egrave;te les directives SSI dans les fichiers dont le bit
d'ex&eacute;cution est positionn&eacute;</description>
<syntax>XBitHack on|off|full</syntax>
<default>XBitHack off</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>Options</override>

<usage>
    <p>La directive <directive>XBitHack</directive> permet de contr&ocirc;ler
    l'interpr&eacute;tation des documents html standards. Elle n'affecte que
    les fichiers dont le <glossary>type MIME</glossary> est
    <code>text/html</code>. <directive>XBitHack</directive> peut prendre
    les valeurs suivantes :</p>

    <dl>
      <dt><code>off</code></dt>
      <dd>Aucun traitement particulier pour les fichiers
      ex&eacute;cutables.</dd>

      <dt><code>on</code></dt>
      <dd>Tout fichier <code>text/html</code> dont le bit d'ex&eacute;cution
      est positionn&eacute; pour le propri&eacute;taire sera trait&eacute; en tant que
      document html interpr&eacute;t&eacute; par le serveur.</dd>

      <dt><code>full</code></dt>
      <dd>Identique &agrave; <code>on</code>, avec test du bit d'ex&eacute;cution pour
      le groupe. Si ce dernier est positionn&eacute;, la date de <code>derni&egrave;re
      modification</code> du fichier renvoy&eacute; est d&eacute;finie &agrave; la date de
      derni&egrave;re modification du fichier. Dans le cas contraire, aucune
      date de derni&egrave;re modification n'est renvoy&eacute;e. Le positionnement de
      ce bit permet aux clients et aux mandataires de g&eacute;rer la mise en
      cache du r&eacute;sultat de la requ&ecirc;te.

      <note><title>Note</title>
      <p>Il est recommand&eacute; de n'utiliser l'option full que dans le cas
      o&ugrave; vous &ecirc;tes certain que le bit d'ex&eacute;cution du groupe est non
      positionn&eacute; pour les scripts SSI qui pourraient effectuer l'<code
      >#include</code> d'un programme CGI ou bien produire des sorties
      diff&eacute;rentes &agrave; chaque acc&egrave;s (ou seraient susceptibles d'&ecirc;tre
      modifi&eacute;es au cours des requ&ecirc;tes ult&eacute;rieures).</p>

      <p>Lorsqu'elle est d&eacute;finie &agrave; <code>on</code>, la directive
      <directive module="mod_include">SSILastModified</directive>
      l'emporte sur la directive <directive
      module="mod_include">XBitHack</directive>.</p>
      </note>

      </dd>
    </dl>

</usage>
</directivesynopsis>

</modulesynopsis>

