<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1425939 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_xml2enc.xml.meta">

<name>mod_xml2enc</name>
<description>Support avanc&eacute; de l'internationalisation et des jeux de
caract&egrave;res pour les modules de filtrage bas&eacute;s sur libxml2</description>
<status>Base</status>
<sourcefile>mod_xml2enc.c</sourcefile>
<identifier>xml2enc_module</identifier>
<compatibility>Disponible depuis la version 2.4 du serveur HTTP Apache.
Disponible en tant que module tiers dans les versions 2.2.x</compatibility>

<summary>
    <p>Ce module fournit un support avanc&eacute; de l'internationalisation
    pour les modules de filtrage supportant les balises (markup-aware)
    comme <module>mod_proxy_html</module>. Il est capable de d&eacute;tecter
    automatiquement l'encodage des donn&eacute;es en entr&eacute;e et de s'assurer
    qu'elle sont trait&eacute;es correctement par l'interpr&eacute;teur <a
    href="http://xmlsoft.org/">libxml2</a>, y compris la conversion en
    Unicode (UTF-8) si n&eacute;cessaire. Il peut aussi convertir les donn&eacute;es
    dans l'encodage de votre choix apr&egrave;s le traitement des balises, et
    s'assurera que le <var>jeu de caract&egrave;res</var> appropri&eacute; sera d&eacute;fini
    dans l'en-t&ecirc;te HTTP <var>Content-Type</var>.</p>
</summary>

<section id="usage"><title>Utilisation</title>
    <p>Il existe deux sc&eacute;narios d'utilisation : le cas des modules
    programm&eacute;s pour travailler avec mod_xml2enc ; et les autres :</p>
    <dl>
    <dt>Modules de filtrages programm&eacute;s pour mod_xml2enc</dt><dd>
    <p>Les modules comme <module>mod_proxy_html</module> versions 3.1 et
    sup&eacute;rieures utilisent la fonction optionnelle
    <code>xml2enc_charset</code> pour d&eacute;terminer la valeur de l'argument
    "jeu de caract&egrave;res" &agrave; transmettre &agrave; l'interpr&eacute;teur libxml2, et
    disposent de la fonction optionnelle <code>xml2enc_filter</code>
    pour effectuer un encodage ult&eacute;rieur &eacute;ventuel. L'utilisation de
    mod_xml2enc avec un module pr&eacute;programm&eacute; &agrave; cet effet ne n&eacute;cessite
    aucune configuration : ce dernier configurera mod_xml2enc pour vous
    (sachant que vous pouvez tout de m&ecirc;me le personnaliser via les
    directives de configuration ci-dessous).</p>
    </dd>
    <dt>Modules de filtrages non programm&eacute;s pour mod_xml2enc</dt><dd>
    <p>Pour utiliser mod_xml2enc avec un module bas&eacute; sur libxml2 qui n'a
    pas &eacute;t&eacute; explicitement programm&eacute; pour mod_xml2enc, vous devrez
    configurer la cha&icirc;ne de filtrage vous-m&ecirc;me. Ainsi, pour utiliser
    mod_xml2enc avec un filtre <strong>foo</strong> fourni par un module
    <strong>mod_foo</strong> et pour
    am&eacute;liorer le support i18n de ce dernier avec HTML et XML, vous
    pouvez utiliser les directives suivantes :</p>
    <pre><code>
    FilterProvider iconv    xml2enc Content-Type $text/html
    FilterProvider iconv    xml2enc Content-Type $xml
    FilterProvider markup   foo Content-Type $text/html
    FilterProvider markup   foo Content-Type $xml
    FilterChain     iconv markup
    </code></pre>
    <p><strong>mod_foo</strong> supportera alors tout jeu de caract&egrave;re support&eacute; soit par
    libxml2, soit par apr_xlate/iconv, soit par les deux.</p>
    </dd></dl>
</section>

<section id="api"><title>API de programmation</title>
    <p>Les programmeurs de modules de filtrage bas&eacute;s sur libxml2 sont
    encourag&eacute;s &agrave; les pr&eacute;programmer pour mod_xml2enc, afin de fournir un
    support i18n solide aux utilisateurs sans avoir &agrave; r&eacute;inventer la
    roue. L'API de programmation est d&eacute;crite dans
    <var>mod_xml2enc.h</var>, et <module>mod_proxy_html</module> est un
    exemple de son utilisation.</p>
</section>

<section id="sniffing"><title>D&eacute;tection et encodage</title>
    <p>A la diff&eacute;rence de <module>mod_charset_lite</module>, mod_xml2enc
    est con&ccedil;u pour travailler avec des donn&eacute;es dont l'encodage ne peut
    pas &ecirc;tre connu, et donc configur&eacute;, &agrave; l'avance. Il utilise donc les
    techniques de 'reniflage' suivantes pour d&eacute;tecter le type d'encodage
    des donn&eacute;es HTTP :</p>
    <ol>
        <li>Si l'en-t&ecirc;te HTTP <var>Content-Type</var> contient un
	param&egrave;tre <var>charset</var>, c'est ce dernier qui sera utilis&eacute;.</li>
        <li>Si les donn&eacute;es commancent par une balise XML concernant
	l'ordre des octets (BOM) ou par une d&eacute;claration d'encodage XML,
	c'est celle-ci qui sera utilis&eacute;e.</li>
        <li>Si un type d'encodage est d&eacute;clar&eacute; dans un &eacute;l&eacute;ment HTML
	<code>&lt;META&gt;</code>, c'est ce dernier qui sera utilis&eacute;.</li>
        <li>Si aucun des &eacute;l&eacute;ments pr&eacute;c&eacute;dents n'est trouv&eacute;, c'est la
	valeur par d&eacute;faut d&eacute;finie par la directive
	<directive>xml2EncDefault</directive> qui sera utilis&eacute;e.</li>
    </ol>
    <p>Les conditions sont test&eacute;es dans cet ordre . D&egrave;s qu'une r&egrave;gle
    s'applique, elle est utilis&eacute;e et la d&eacute;tection est termin&eacute;e.</p>
</section>

<section id="output"><title>Codage en sortie</title>
<p><a href="http://xmlsoft.org/">libxml2</a> utilise toujours UTF-8
(Unicode) en interne, et les modules de filtrage bas&eacute;s sur libxml2
utiliseront cet encodage en sortie par d&eacute;faut. mod_xml2enc peut modifier
l'encodage en sortie via l'API, mais il n'y a actuellement aucun moyen de le
configurer directement.</p>
<p>La modification de l'encodage en sortie ne devrait (du moins en th&eacute;orie)
jamais &ecirc;tre n&eacute;cessaire, et est m&ecirc;me d&eacute;conseill&eacute;e &agrave; cause de la charge de
traitement suppl&eacute;mentaire impos&eacute;e au serveur par une conversion non
n&eacute;cessaire.</p>
</section>

<section id="alias"><title>Codages non support&eacute;s</title>
<p>Si vous travaillez avec des encodages non support&eacute;s par aucune des
m&eacute;thodes de conversion disponibles sur votre plateforme, vous pouvez
tout de m&ecirc;me leur associer un alias vers un code support&eacute; via la
directive <directive>xml2EncAlias</directive>.</p>
</section>

<directivesynopsis>
<name>xml2EncDefault</name>
<description>D&eacute;finit un encodage par d&eacute;faut &agrave; utiliser lorsqu'aucune
information ne peut &ecirc;tre <a href="#sniffing">automatiquement d&eacute;tect&eacute;e</a></description>
<syntax>xml2EncDefault <var>nom</var></syntax>
<contextlist><context>server config</context>
<context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<compatibility>Disponible depuis la version 2.4.0 du serveur HTTP Apache
; disponible depuis un module tiers dans les versions ant&eacute;rieures.</compatibility>

<usage>
    <p>Si vous traitez des donn&eacute;es dont l'encodage est connu, mais ne
    contenant aucune information &agrave; propos de ce dernier, vous pouvez
    d&eacute;finir une valeur par d&eacute;faut afin d'aider mod_xml2enc &agrave; traiter
    correctement les donn&eacute;es. Par exemple, pour d&eacute;finir la valeur par
    d&eacute;faut Latin1 (<var>iso-8859-1</var> specifi&eacute;e dans HTTP/1.0),
    utilisez :</p>
    <highlight language="config">xml2EncDefault iso-8859-1</highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>xml2EncAlias</name>
<description>D&eacute;finit des alias pour les valeurs d'encodage</description>
<syntax>xml2EncAlias <var>jeu-de-caract&egrave;res alias [alias ...]</var></syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive de niveau serveur permet de d&eacute;finir un ou
    plusieurs alias pour un encodage. Elle permet au support d'encodage de
    libxml2 de traiter en interne des encodages non reconnus par libxml2
    en utilisant la table de conversion pour un encodage reconnu. Elle
    permet d'atteindre deux objectifs : supporter des jeux (ou noms) de
    caract&egrave;res non reconnus par libxml2 ou iconv, et &eacute;viter une
    conversion pour un encodage lorsque cela n'est pas n&eacute;cessaire.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>xml2StartParse</name>
<description>Indique &agrave; l'interpr&eacute;teur &agrave; partir de quelle balise il doit
commencer son traitement.</description>
<syntax>xml2StartParse <var>&eacute;l&eacute;ment [&eacute;l&eacute;ment ...]</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>

<usage>
    <p>Cette directive permet de sp&eacute;cifier &agrave; partir de quelle balise,
    parmi les &eacute;l&eacute;ments sp&eacute;cifi&eacute;s, l'interpr&eacute;teur de balise doit
    commencer son traitement. Ccei permet de contourner le probl&egrave;me des
    serveurs d'arri&egrave;re-plan qui ins&egrave;rent des &eacute;l&eacute;ments non conformes en
    d&eacute;but de donn&eacute;es, ce qui a pour effet de perturber l'interpr&eacute;teur (<a
    href="http://bahumbug.wordpress.com/2006/10/12/mod_proxy_html-revisited/"
    >voir un exemple ici</a>).</p>
    <p>Elle ne doit &ecirc;tre utilis&eacute;e ni pour les documents XML, ni pour les
    documents HTML correctement format&eacute;s.</p>
</usage>
</directivesynopsis>

</modulesynopsis>

