/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class CipherStreamTest
extends SimpleTest {
    private static byte[] RK = Hex.decode("0123456789ABCDEF");
    private static byte[] RIN = Hex.decode("4e6f772069732074");
    private static byte[] ROUT = Hex.decode("3afbb5c77938280d");
    private static byte[] SIN = Hex.decode("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
    private static final byte[] SK = Hex.decode("80000000000000000000000000000000");
    private static final byte[] SIV = Hex.decode("0000000000000000");
    private static final byte[] SOUT = Hex.decode("4DFA5E481DA23EA09A31022050859936DA52FCEE218005164F267CB65F5CFD7F2B4F97E0FF16924A52DF269515110A07F9E460BC65EF95DA58F740B7D1DBB0AA");
    private static final byte[] HCIN = new byte[64];
    private static final byte[] HCIV = new byte[32];
    private static final byte[] HCK256A = new byte[32];
    private static final byte[] HC256A = Hex.decode("8589075b0df3f6d82fc0c5425179b6a63465f053f2891f808b24744e18480b72ec2792cdbf4dcfeb7769bf8dfa14aee47b4c50e8eaf3a9c8f506016c81697e32");
    private static final byte[] HCK128A = new byte[16];
    private static final byte[] HC128A = Hex.decode("731500823bfd03a0fb2fd77faa63af0ede122fc6a7dc29b662a685278b75ec689036db1e8189600500ade078491fbf9a1cdc30136c3d6e2490f664b29cd57102");

    private void runTest(String string) throws Exception {
        int n;
        String string2 = "ABCDEFGHIJKLMNOPQRSTUVWXY0123456789";
        KeyGenerator keyGenerator = string.indexOf(47) < 0 ? KeyGenerator.getInstance(string, "BC") : KeyGenerator.getInstance(string.substring(0, string.indexOf(47)), "BC");
        Cipher cipher = Cipher.getInstance(string, "BC");
        Cipher cipher2 = Cipher.getInstance(string, "BC");
        SecretKey secretKey = keyGenerator.generateKey();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        cipher.init(1, secretKey);
        if (cipher.getIV() != null) {
            cipher2.init(2, (Key)secretKey, new IvParameterSpec(cipher.getIV()));
        } else {
            cipher2.init(2, secretKey);
        }
        CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher);
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher2);
        while ((n = cipherInputStream.read()) >= 0) {
            cipherOutputStream.write(n);
        }
        cipherInputStream.close();
        cipherOutputStream.flush();
        cipherOutputStream.close();
        String string3 = new String(byteArrayOutputStream.toByteArray());
        if (!string3.equals(string2)) {
            this.fail("Failed - decrypted data doesn't match.");
        }
    }

    private void testAlgorithm(String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws Exception {
        byte[] byArray5;
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, string);
        Cipher cipher = Cipher.getInstance(string, "BC");
        Cipher cipher2 = Cipher.getInstance(string, "BC");
        if (byArray2 != null) {
            cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(byArray2));
            cipher2.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray2));
        } else {
            cipher.init(1, secretKeySpec);
            cipher2.init(2, secretKeySpec);
        }
        byte[] byArray6 = cipher.doFinal(byArray3);
        if (!this.areEqual(byArray6, byArray4)) {
            this.fail(string + ": cipher text doesn't match");
        }
        if (!this.areEqual(byArray5 = cipher2.doFinal(byArray6), byArray3)) {
            this.fail(string + ": plain text doesn't match");
        }
    }

    private void testException(String string) {
        try {
            Key key;
            Cipher cipher;
            byte[] byArray = new byte[]{-128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113};
            byte[] byArray2 = new byte[]{-128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113};
            byte[] byArray3 = string.equals("HC256") ? byArray2 : byArray;
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, string);
            Cipher cipher2 = Cipher.getInstance(string, "BC");
            cipher2.init(1, secretKeySpec);
            byte[] byArray4 = new byte[]{};
            try {
                cipher2.update(new byte[20], 0, 20, byArray4);
                this.fail("failed exception test - no ShortBufferException thrown");
            }
            catch (ShortBufferException shortBufferException) {
                // empty catch block
            }
            try {
                cipher = Cipher.getInstance(string, "BC");
                key = new PublicKey(){

                    public String getAlgorithm() {
                        return "STUB";
                    }

                    public String getFormat() {
                        return null;
                    }

                    public byte[] getEncoded() {
                        return null;
                    }
                };
                cipher.init(1, key);
                this.fail("failed exception test - no InvalidKeyException thrown for public key");
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
            try {
                cipher = Cipher.getInstance(string, "BC");
                key = new PrivateKey(){

                    public String getAlgorithm() {
                        return "STUB";
                    }

                    public String getFormat() {
                        return null;
                    }

                    public byte[] getEncoded() {
                        return null;
                    }
                };
                cipher.init(2, key);
                this.fail("failed exception test - no InvalidKeyException thrown for private key");
            }
            catch (InvalidKeyException invalidKeyException) {}
        }
        catch (Exception exception) {
            this.fail("unexpected exception.", exception);
        }
    }

    public void performTest() throws Exception {
        this.runTest("RC4");
        this.testException("RC4");
        this.testAlgorithm("RC4", RK, null, RIN, ROUT);
        this.runTest("Salsa20");
        this.testException("Salsa20");
        this.testAlgorithm("Salsa20", SK, SIV, SIN, SOUT);
        this.runTest("HC128");
        this.testException("HC128");
        this.testAlgorithm("HC128", HCK128A, HCIV, HCIN, HC128A);
        this.runTest("HC256");
        this.testException("HC256");
        this.testAlgorithm("HC256", HCK256A, HCIV, HCIN, HC256A);
        this.runTest("VMPC");
        this.testException("VMPC");
        this.runTest("VMPC-KSA3");
        this.testException("VMPC-KSA3");
        this.runTest("DES/ECB/PKCS7Padding");
        this.runTest("DES/CFB8/NoPadding");
    }

    public String getName() {
        return "CipherStreamTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        CipherStreamTest.runTest(new CipherStreamTest());
    }
}

