/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;

public class Main {
    public static boolean firstTime = true;
    public static final String BYTEMAN_PREFIX = "org.jboss.byteman.";
    private static final String PORT_PREFIX = "port:";
    private static final String ADDRESS_PREFIX = "address:";
    private static final String BOOT_PREFIX = "boot:";
    private static final String SYS_PREFIX = "sys:";
    private static final String SCRIPT_PREFIX = "script:";
    private static final String LISTENER_PREFIX = "listener:";
    private static final String REDEFINE_PREFIX = "redefine:";
    private static final String PROP_PREFIX = "prop:";
    private static List<String> bootJarPaths = new ArrayList<String>();
    private static List<String> sysJarPaths = new ArrayList<String>();
    private static List<String> scriptPaths = new ArrayList<String>();
    private static List<String> scripts = new ArrayList<String>();
    private static String hostname = null;
    private static Integer port = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void premain(String args, Instrumentation inst) throws Exception {
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            Method method;
            ClassFileTransformer transformer;
            Constructor<?> constructor;
            Class<?> transformerClazz;
            if (!firstTime) {
                throw new Exception("Main : attempting to load Byteman agent more than once");
            }
            firstTime = false;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            boolean allowRedefine = false;
            if (args != null) {
                String[] argsArray;
                for (String arg : argsArray = args.split(",")) {
                    String value;
                    if (arg.startsWith(BOOT_PREFIX)) {
                        bootJarPaths.add(arg.substring(BOOT_PREFIX.length(), arg.length()));
                        continue;
                    }
                    if (arg.startsWith(SYS_PREFIX)) {
                        sysJarPaths.add(arg.substring(SYS_PREFIX.length(), arg.length()));
                        continue;
                    }
                    if (arg.startsWith(ADDRESS_PREFIX)) {
                        hostname = arg.substring(ADDRESS_PREFIX.length(), arg.length());
                        allowRedefine = true;
                        continue;
                    }
                    if (arg.startsWith(PORT_PREFIX)) {
                        try {
                            port = Integer.valueOf(arg.substring(PORT_PREFIX.length(), arg.length()));
                            if (port <= 0) {
                                System.err.println("Invalid port specified [" + port + "]");
                                port = null;
                                continue;
                            }
                            allowRedefine = true;
                        }
                        catch (Exception e) {
                            System.err.println("Invalid port specified [" + arg + "]. Cause: " + e);
                        }
                        continue;
                    }
                    if (arg.startsWith(SCRIPT_PREFIX)) {
                        scriptPaths.add(arg.substring(SCRIPT_PREFIX.length(), arg.length()));
                        continue;
                    }
                    if (arg.startsWith(LISTENER_PREFIX)) {
                        value = arg.substring(LISTENER_PREFIX.length(), arg.length());
                        allowRedefine = Boolean.parseBoolean(value);
                        if (allowRedefine || hostname == null && port == null) continue;
                        System.err.println("listener disabled with host/port set");
                        continue;
                    }
                    if (arg.startsWith(REDEFINE_PREFIX)) {
                        value = arg.substring(REDEFINE_PREFIX.length(), arg.length());
                        allowRedefine = Boolean.parseBoolean(value);
                        if (allowRedefine || hostname == null && port == null) continue;
                        System.err.println("listener disabled with host/port set");
                        continue;
                    }
                    if (arg.startsWith(PROP_PREFIX)) {
                        String prop = arg.substring(PROP_PREFIX.length(), arg.length());
                        String value2 = "";
                        if (prop.startsWith(BYTEMAN_PREFIX)) {
                            int index = prop.indexOf(61);
                            if (index > 0) {
                                if (index == prop.length() - 1) {
                                    prop = prop.substring(0, index);
                                } else {
                                    value2 = prop.substring(index + 1);
                                    prop = prop.substring(0, index);
                                }
                            }
                            System.out.println("Setting " + prop + "=" + value2);
                            System.setProperty(prop, value2);
                            continue;
                        }
                        System.err.println("Invalid property : " + prop);
                        continue;
                    }
                    System.err.println("org.jboss.byteman.agent.Main:\n  illegal agent argument : " + arg + "\n" + "  valid arguments are boot:<path-to-jar>, sys:<path-to-jar>, script:<path-to-script> or listener:<true-or-false>");
                }
            }
            for (String bootJarPath : bootJarPaths) {
                try {
                    JarFile jarfile = new JarFile(new File(bootJarPath));
                    inst.appendToBootstrapClassLoaderSearch(jarfile);
                }
                catch (IOException ioe) {
                    System.err.println("org.jboss.byteman.agent.Main: unable to open boot jar file : " + bootJarPath);
                    throw ioe;
                }
            }
            for (String sysJarPath : sysJarPaths) {
                try {
                    JarFile jarfile = new JarFile(new File(sysJarPath));
                    inst.appendToSystemClassLoaderSearch(jarfile);
                }
                catch (IOException ioe) {
                    System.err.println("org.jboss.byteman.agent.Main: unable to open system jar file : " + sysJarPath);
                    throw ioe;
                }
            }
            Socket dummy = new Socket();
            for (String scriptPath : scriptPaths) {
                try {
                    FileInputStream fis = new FileInputStream(scriptPath);
                    byte[] bytes = new byte[fis.available()];
                    fis.read(bytes);
                    String ruleScript = new String(bytes);
                    scripts.add(ruleScript);
                }
                catch (IOException ioe) {
                    System.err.println("org.jboss.byteman.agent.Main: unable to read rule script file : " + scriptPath);
                    throw ioe;
                }
            }
            boolean isRedefine = inst.isRedefineClassesSupported();
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            if (allowRedefine && isRedefine) {
                transformerClazz = loader.loadClass("org.jboss.byteman.agent.Retransformer");
                constructor = transformerClazz.getConstructor(Instrumentation.class, List.class, List.class, Boolean.TYPE);
                transformer = (ClassFileTransformer)constructor.newInstance(inst, scriptPaths, scripts, isRedefine);
            } else {
                transformerClazz = loader.loadClass("org.jboss.byteman.agent.Transformer");
                constructor = transformerClazz.getConstructor(Instrumentation.class, List.class, List.class, Boolean.TYPE);
                transformer = (ClassFileTransformer)constructor.newInstance(inst, scriptPaths, scripts, isRedefine);
            }
            inst.addTransformer(transformer, true);
            if (allowRedefine && isRedefine) {
                method = transformerClazz.getMethod("addTransformListener", String.class, Integer.class);
                method.invoke((Object)transformer, hostname, port);
            }
            if (isRedefine) {
                method = transformerClazz.getMethod("installBootScripts", new Class[0]);
                method.invoke((Object)transformer, new Object[0]);
            }
            return;
        }
    }

    public static void agentmain(String args, Instrumentation inst) throws Exception {
        Main.premain(args, inst);
    }
}

