/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.FixedSecureRandom;
import org.bouncycastle.util.test.SimpleTest;

public class ECDSA5Test
extends SimpleTest {
    byte[] k1 = Hex.decode("d5014e4b60ef2ba8b6211b4062ba3224e0427dd3");
    byte[] k2 = Hex.decode("345e8d05c075c3a508df729a1685690e68fcfb8c8117847e89063bca1f85d968fd281540b6e13bd1af989a1fbf17e06462bf511f9d0b140fb48ac1b1baa5bded");
    SecureRandom random = new FixedSecureRandom(new byte[][]{this.k1, this.k2});

    private void decodeTest() {
        EllipticCurve ellipticCurve = new EllipticCurve(new ECFieldFp(new BigInteger("6277101735386680763835789423207666416083908700390324961279")), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16));
        ECPoint eCPoint = ECPointUtil.decodePoint(ellipticCurve, Hex.decode("03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012"));
        if (!eCPoint.getAffineX().equals(new BigInteger("188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012", 16))) {
            this.fail("x uncompressed incorrectly");
        }
        if (!eCPoint.getAffineY().equals(new BigInteger("7192b95ffc8da78631011ed6b24cdd573f977a11e794811", 16))) {
            this.fail("y uncompressed incorrectly");
        }
    }

    private void testECDSA239bitPrime() throws Exception {
        BigInteger[] bigIntegerArray;
        BigInteger bigInteger = new BigInteger("308636143175167811492622547300668018854959378758531778147462058306432176");
        BigInteger bigInteger2 = new BigInteger("323813553209797357708078776831250505931891051755007842781978505179448783");
        byte[] byArray = BigIntegers.asUnsignedByteArray(new BigInteger("700000017569056646655505781757157107570501575775705779575555657156756655"));
        FixedSecureRandom fixedSecureRandom = new FixedSecureRandom(byArray);
        EllipticCurve ellipticCurve = new EllipticCurve(new ECFieldFp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839")), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, ECPointUtil.decodePoint(ellipticCurve, Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"), 1);
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(new BigInteger("876300101507107567501066130761671078357010671067781776716671676178726717"), eCParameterSpec);
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(ECPointUtil.decodePoint(ellipticCurve, Hex.decode("025b6dc53bc61a2548ffb0f671472de6c9521a9d2d2534e65abfcbd5fe0c70")), eCParameterSpec);
        Signature signature = Signature.getInstance("ECDSA", "BC");
        KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(eCPrivateKeySpec);
        PublicKey publicKey = keyFactory.generatePublic(eCPublicKeySpec);
        signature.initSign(privateKey, fixedSecureRandom);
        byte[] byArray2 = new byte[]{97, 98, 99};
        signature.update(byArray2);
        byte[] byArray3 = signature.sign();
        signature.initVerify(publicKey);
        signature.update(byArray2);
        if (!signature.verify(byArray3)) {
            this.fail("239 Bit EC verification failed");
        }
        if (!bigInteger.equals((bigIntegerArray = this.derDecode(byArray3))[0])) {
            this.fail("r component wrong." + System.getProperty("line.separator") + " expecting: " + bigInteger + System.getProperty("line.separator") + " got      : " + bigIntegerArray[0]);
        }
        if (!bigInteger2.equals(bigIntegerArray[1])) {
            this.fail("s component wrong." + System.getProperty("line.separator") + " expecting: " + bigInteger2 + System.getProperty("line.separator") + " got      : " + bigIntegerArray[1]);
        }
    }

    private void testECDSA239bitBinary() throws Exception {
        BigInteger[] bigIntegerArray;
        BigInteger bigInteger = new BigInteger("21596333210419611985018340039034612628818151486841789642455876922391552");
        BigInteger bigInteger2 = new BigInteger("197030374000731686738334997654997227052849804072198819102649413465737174");
        byte[] byArray = BigIntegers.asUnsignedByteArray(new BigInteger("171278725565216523967285789236956265265265235675811949404040041670216363"));
        FixedSecureRandom fixedSecureRandom = new FixedSecureRandom(byArray);
        EllipticCurve ellipticCurve = new EllipticCurve(new ECFieldF2m(239, new int[]{36}), new BigInteger("32010857077C5431123A46B808906756F543423E8D27877578125778AC76", 16), new BigInteger("790408F2EEDAF392B012EDEFB3392F30F4327C0CA3F31FC383C422AA8C16", 16));
        ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, ECPointUtil.decodePoint(ellipticCurve, Hex.decode("0457927098FA932E7C0A96D3FD5B706EF7E5F5C156E16B7E7C86038552E91D61D8EE5077C33FECF6F1A16B268DE469C3C7744EA9A971649FC7A9616305")), new BigInteger("220855883097298041197912187592864814557886993776713230936715041207411783"), 4);
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(new BigInteger("145642755521911534651321230007534120304391871461646461466464667494947990"), eCParameterSpec);
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(ECPointUtil.decodePoint(ellipticCurve, Hex.decode("045894609CCECF9A92533F630DE713A958E96C97CCB8F5ABB5A688A238DEED6DC2D9D0C94EBFB7D526BA6A61764175B99CB6011E2047F9F067293F57F5")), eCParameterSpec);
        Signature signature = Signature.getInstance("ECDSA", "BC");
        KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(eCPrivateKeySpec);
        PublicKey publicKey = keyFactory.generatePublic(eCPublicKeySpec);
        byte[] byArray2 = new byte[]{97, 98, 99};
        signature.initSign(privateKey, fixedSecureRandom);
        signature.update(byArray2);
        byte[] byArray3 = signature.sign();
        signature.initVerify(publicKey);
        signature.update(byArray2);
        if (!signature.verify(byArray3)) {
            this.fail("239 Bit EC verification failed");
        }
        if (!bigInteger.equals((bigIntegerArray = this.derDecode(byArray3))[0])) {
            this.fail("r component wrong." + System.getProperty("line.separator") + " expecting: " + bigInteger + System.getProperty("line.separator") + " got      : " + bigIntegerArray[0]);
        }
        if (!bigInteger2.equals(bigIntegerArray[1])) {
            this.fail("s component wrong." + System.getProperty("line.separator") + " expecting: " + bigInteger2 + System.getProperty("line.separator") + " got      : " + bigIntegerArray[1]);
        }
    }

    private void testGeneration() throws Exception {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        Signature signature = Signature.getInstance("ECDSA", "BC");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        EllipticCurve ellipticCurve = new EllipticCurve(new ECFieldFp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839")), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, ECPointUtil.decodePoint(ellipticCurve, Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"), 1);
        keyPairGenerator.initialize(eCParameterSpec, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        signature.initSign(privateKey);
        signature.update(byArray);
        byte[] byArray2 = signature.sign();
        signature = Signature.getInstance("ECDSA", "BC");
        signature.initVerify(publicKey);
        signature.update(byArray);
        if (!signature.verify(byArray2)) {
            this.fail("ECDSA verification failed");
        }
        this.testKeyFactory((ECPublicKey)publicKey, (ECPrivateKey)privateKey);
    }

    private void testKeyFactory(ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("ECDSA");
        ECPublicKeySpec eCPublicKeySpec = keyFactory.getKeySpec(eCPublicKey, ECPublicKeySpec.class);
        ECPrivateKeySpec eCPrivateKeySpec = keyFactory.getKeySpec(eCPrivateKey, ECPrivateKeySpec.class);
        if (!eCPublicKeySpec.getW().equals(eCPublicKey.getW()) || !eCPublicKeySpec.getParams().getCurve().equals(eCPublicKey.getParams().getCurve())) {
            this.fail("pubSpec not correct");
        }
        if (!eCPrivateKeySpec.getS().equals(eCPrivateKey.getS()) || !eCPrivateKeySpec.getParams().getCurve().equals(eCPrivateKey.getParams().getCurve())) {
            this.fail("privSpec not correct");
        }
        ECPublicKey eCPublicKey2 = (ECPublicKey)keyFactory.translateKey(eCPublicKey);
        ECPrivateKey eCPrivateKey2 = (ECPrivateKey)keyFactory.translateKey(eCPrivateKey);
        if (!eCPublicKey2.getW().equals(eCPublicKey.getW()) || !eCPublicKey2.getParams().getCurve().equals(eCPublicKey.getParams().getCurve())) {
            this.fail("pubKey not correct");
        }
        if (!eCPrivateKey2.getS().equals(eCPrivateKey.getS()) || !eCPrivateKey2.getParams().getCurve().equals(eCPrivateKey.getParams().getCurve())) {
            this.fail("privKey not correct");
        }
    }

    protected BigInteger[] derDecode(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        BigInteger[] bigIntegerArray = new BigInteger[]{((DERInteger)aSN1Sequence.getObjectAt(0)).getValue(), ((DERInteger)aSN1Sequence.getObjectAt(1)).getValue()};
        return bigIntegerArray;
    }

    public String getName() {
        return "ECDSA5";
    }

    public void performTest() throws Exception {
        this.decodeTest();
        this.testECDSA239bitPrime();
        this.testECDSA239bitBinary();
        this.testGeneration();
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        ECDSA5Test.runTest(new ECDSA5Test());
    }
}

