/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.FastFileManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Booleans;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.net.Advertiser;

@Plugin(name="FastFile", category="Core", elementType="appender", printObject=true)
public final class FastFileAppender<T extends Serializable>
extends AbstractOutputStreamAppender<T> {
    private final String fileName;
    private Object advertisement;
    private final Advertiser advertiser;

    private FastFileAppender(String name, Layout<T> layout, Filter filter, FastFileManager manager, String filename, boolean handleException, boolean immediateFlush, Advertiser advertiser) {
        super(name, layout, filter, handleException, immediateFlush, manager);
        if (advertiser != null) {
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.putAll(manager.getContentFormat());
            configuration.put("contentType", layout.getContentType());
            configuration.put("name", name);
            this.advertisement = advertiser.advertise(configuration);
        }
        this.fileName = filename;
        this.advertiser = advertiser;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
    }

    @Override
    public void append(LogEvent event) {
        ((FastFileManager)this.getManager()).setEndOfBatch(event.isEndOfBatch());
        super.append(event);
    }

    public String getFileName() {
        return this.fileName;
    }

    @PluginFactory
    public static <S extends Serializable> FastFileAppender<S> createAppender(@PluginAttr(value="fileName") String fileName, @PluginAttr(value="append") String append, @PluginAttr(value="name") String name, @PluginAttr(value="immediateFlush") String immediateFlush, @PluginAttr(value="suppressExceptions") String suppress, @PluginElement(value="layout") Layout<S> layout, @PluginElement(value="filters") Filter filter, @PluginAttr(value="advertise") String advertise, @PluginAttr(value="advertiseURI") String advertiseURI, @PluginConfiguration Configuration config) {
        FastFileManager manager;
        boolean isAppend = Booleans.parseBoolean(append, true);
        boolean isFlush = Booleans.parseBoolean(immediateFlush, true);
        boolean handleExceptions = Booleans.parseBoolean(suppress, true);
        boolean isAdvertise = Boolean.parseBoolean(advertise);
        if (name == null) {
            LOGGER.error("No name provided for FileAppender");
            return null;
        }
        if (fileName == null) {
            LOGGER.error("No filename provided for FileAppender with name " + name);
            return null;
        }
        if (layout == null) {
            PatternLayout l;
            layout = l = PatternLayout.createLayout(null, null, null, null, null);
        }
        if ((manager = FastFileManager.getFileManager(fileName, isAppend, isFlush, advertiseURI, layout)) == null) {
            return null;
        }
        return new FastFileAppender<String>(name, layout, filter, manager, fileName, handleExceptions, isFlush, isAdvertise ? config.getAdvertiser() : null);
    }
}

