/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseManager;
import org.apache.logging.log4j.core.appender.db.jdbc.ColumnConfig;
import org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;
import org.apache.logging.log4j.core.layout.PatternLayout;

public final class JDBCDatabaseManager
extends AbstractDatabaseManager {
    private static final JDBCDatabaseManagerFactory FACTORY = new JDBCDatabaseManagerFactory();
    private final List<Column> columns;
    private final ConnectionSource connectionSource;
    private final String sqlStatement;
    private Connection connection;
    private PreparedStatement statement;

    private JDBCDatabaseManager(String name, int bufferSize, ConnectionSource connectionSource, String sqlStatement, List<Column> columns) {
        super(name, bufferSize);
        this.connectionSource = connectionSource;
        this.sqlStatement = sqlStatement;
        this.columns = columns;
    }

    @Override
    protected void connectInternal() {
        try {
            this.connection = this.connectionSource.getConnection();
            this.statement = this.connection.prepareStatement(this.sqlStatement);
        }
        catch (SQLException e) {
            LOGGER.error("Failed to connect to relational database using JDBC connection source [{}] in manager [{}].", new Object[]{this.connectionSource, this.getName(), e});
        }
    }

    @Override
    protected void disconnectInternal() {
        try {
            if (this.statement != null && !this.statement.isClosed()) {
                this.statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Error while closing prepared statement in database manager [{}].", new Object[]{this.getName(), e});
        }
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Error while disconnecting from relational database in manager [{}].", new Object[]{this.getName(), e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeInternal(LogEvent event) {
        StringReader reader = null;
        try {
            if (!this.isConnected() || this.connection == null || this.connection.isClosed()) {
                LOGGER.error("Cannot write logging event; manager [{}] not connected to the database.", new Object[]{this.getName()});
                return;
            }
            int i = 1;
            for (Column column : this.columns) {
                if (column.isEventTimestamp) {
                    this.statement.setTimestamp(i++, new Timestamp(event.getMillis()));
                    continue;
                }
                if (column.isClob) {
                    reader = new StringReader(column.layout.toSerializable(event));
                    if (column.isUnicode) {
                        this.statement.setNClob(i++, reader);
                        continue;
                    }
                    this.statement.setClob(i++, reader);
                    continue;
                }
                if (column.isUnicode) {
                    this.statement.setNString(i++, column.layout.toSerializable(event));
                    continue;
                }
                this.statement.setString(i++, column.layout.toSerializable(event));
            }
            if (this.statement.executeUpdate() == 0) {
                LOGGER.warn("No records inserted in database table for log event in manager [{}].", new Object[]{this.getName()});
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed to insert record for log event in manager [{}].", new Object[]{this.getName(), e});
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static JDBCDatabaseManager getJDBCDatabaseManager(String name, int bufferSize, ConnectionSource connectionSource, String tableName, ColumnConfig[] columnConfigs) {
        return AbstractDatabaseManager.getManager(name, new FactoryData(bufferSize, connectionSource, tableName, columnConfigs), FACTORY);
    }

    private static final class Column {
        private final PatternLayout layout;
        private final boolean isEventTimestamp;
        private final boolean isUnicode;
        private final boolean isClob;

        private Column(PatternLayout layout, boolean isEventDate, boolean isUnicode, boolean isClob) {
            this.layout = layout;
            this.isEventTimestamp = isEventDate;
            this.isUnicode = isUnicode;
            this.isClob = isClob;
        }
    }

    private static final class JDBCDatabaseManagerFactory
    implements ManagerFactory<JDBCDatabaseManager, FactoryData> {
        private JDBCDatabaseManagerFactory() {
        }

        @Override
        public JDBCDatabaseManager createManager(String name, FactoryData data) {
            StringBuilder columnPart = new StringBuilder();
            StringBuilder valuePart = new StringBuilder();
            ArrayList<Column> columns = new ArrayList<Column>();
            int i = 0;
            for (ColumnConfig config : data.columnConfigs) {
                if (i++ > 0) {
                    columnPart.append(',');
                    valuePart.append(',');
                }
                columnPart.append(config.getColumnName());
                if (config.getLiteralValue() != null) {
                    valuePart.append(config.getLiteralValue());
                    continue;
                }
                columns.add(new Column(config.getLayout(), config.isEventTimestamp(), config.isUnicode(), config.isClob()));
                valuePart.append('?');
            }
            String sqlStatement = "INSERT INTO " + data.tableName + " (" + columnPart + ") VALUES (" + valuePart + ")";
            return new JDBCDatabaseManager(name, data.getBufferSize(), data.connectionSource, sqlStatement, columns);
        }
    }

    private static final class FactoryData
    extends AbstractDatabaseManager.AbstractFactoryData {
        private final ColumnConfig[] columnConfigs;
        private final ConnectionSource connectionSource;
        private final String tableName;

        protected FactoryData(int bufferSize, ConnectionSource connectionSource, String tableName, ColumnConfig[] columnConfigs) {
            super(bufferSize);
            this.connectionSource = connectionSource;
            this.tableName = tableName;
            this.columnConfigs = columnConfigs;
        }
    }
}

