/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jpa;

import java.lang.reflect.Constructor;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseAppender;
import org.apache.logging.log4j.core.appender.db.jpa.AbstractLogEventWrapperEntity;
import org.apache.logging.log4j.core.appender.db.jpa.JPADatabaseManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Strings;

@Plugin(name="Jpa", category="Core", elementType="appender", printObject=true)
public final class JPAAppender
extends AbstractDatabaseAppender<JPADatabaseManager> {
    private final String description = this.getName() + "{ manager=" + this.getManager() + " }";

    private JPAAppender(String name, Filter filter, boolean handleException, JPADatabaseManager manager) {
        super(name, filter, handleException, manager);
    }

    @Override
    public String toString() {
        return this.description;
    }

    @PluginFactory
    public static JPAAppender createAppender(@PluginAttr(value="name") String name, @PluginAttr(value="suppressExceptions") String suppressExceptions, @PluginElement(value="filter") Filter filter, @PluginAttr(value="bufferSize") String bufferSize, @PluginAttr(value="entityClassName") String entityClassName, @PluginAttr(value="persistenceUnitName") String persistenceUnitName) {
        if (Strings.isEmpty(entityClassName) || Strings.isEmpty(persistenceUnitName)) {
            LOGGER.error("Attributes entityClassName and persistenceUnitName are required for JPA Appender.");
            return null;
        }
        int bufferSizeInt = AbstractAppender.parseInt(bufferSize, 0);
        boolean handleExceptions = !Boolean.parseBoolean(suppressExceptions);
        try {
            Class<?> entityClass = Class.forName(entityClassName);
            if (!AbstractLogEventWrapperEntity.class.isAssignableFrom(entityClass)) {
                LOGGER.error("Entity class [{}] does not extend AbstractLogEventWrapperEntity.", new Object[]{entityClassName});
                return null;
            }
            try {
                entityClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Entity class [{}] does not have a no-arg constructor. The JPA provider will reject it.", new Object[]{entityClassName});
                return null;
            }
            Constructor<?> entityConstructor = entityClass.getConstructor(LogEvent.class);
            String managerName = "jpaManager{ description=" + name + ", bufferSize=" + bufferSizeInt + ", persistenceUnitName=" + persistenceUnitName + ", entityClass=" + entityClass.getName() + "}";
            JPADatabaseManager manager = JPADatabaseManager.getJPADatabaseManager(managerName, bufferSizeInt, entityClass, entityConstructor, persistenceUnitName);
            if (manager == null) {
                return null;
            }
            return new JPAAppender(name, filter, handleExceptions, manager);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Could not load entity class [{}].", new Object[]{entityClassName, e});
            return null;
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Entity class [{}] does not have a constructor with a single argument of type LogEvent.", new Object[]{entityClassName});
            return null;
        }
    }
}

