/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigHelper;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Booleans;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="asyncLogger", category="Core", printObject=true)
public class AsyncLoggerConfig
extends LoggerConfig {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private AsyncLoggerConfigHelper helper;

    public AsyncLoggerConfig() {
    }

    public AsyncLoggerConfig(String name, Level level, boolean additive) {
        super(name, level, additive);
    }

    protected AsyncLoggerConfig(String name, List<AppenderRef> appenders, Filter filter, Level level, boolean additive, Property[] properties, Configuration config, boolean includeLocation) {
        super(name, appenders, filter, level, additive, properties, config, includeLocation);
    }

    @Override
    protected void callAppenders(LogEvent event) {
        event.getSource();
        event.getThreadName();
        this.helper.callAppendersFromAnotherThread(event);
    }

    void asyncCallAppenders(LogEvent event) {
        super.callAppenders(event);
    }

    @Override
    public void startFilter() {
        if (this.helper == null) {
            this.helper = new AsyncLoggerConfigHelper(this);
        }
        super.startFilter();
    }

    @Override
    public void stopFilter() {
        this.helper.shutdown();
        super.stopFilter();
    }

    @PluginFactory
    public static LoggerConfig createLogger(@PluginAttr(value="additivity") String additivity, @PluginAttr(value="level") String levelName, @PluginAttr(value="name") String loggerName, @PluginAttr(value="includeLocation") String includeLocation, @PluginElement(value="appender-ref") AppenderRef[] refs, @PluginElement(value="properties") Property[] properties, @PluginConfiguration Configuration config, @PluginElement(value="filters") Filter filter) {
        Level level;
        if (loggerName == null) {
            LOGGER.error("Loggers cannot be configured without a name");
            return null;
        }
        List<AppenderRef> appenderRefs = Arrays.asList(refs);
        try {
            level = Level.toLevel((String)levelName, (Level)Level.ERROR);
        }
        catch (Exception ex) {
            LOGGER.error("Invalid Log level specified: {}. Defaulting to Error", new Object[]{levelName});
            level = Level.ERROR;
        }
        String name = loggerName.equals("root") ? "" : loggerName;
        boolean additive = Booleans.parseBoolean(additivity, true);
        return new AsyncLoggerConfig(name, appenderRefs, filter, level, additive, properties, config, AsyncLoggerConfig.includeLocation(includeLocation));
    }

    protected static boolean includeLocation(String includeLocationConfigValue) {
        return Boolean.parseBoolean(includeLocationConfigValue);
    }

    @Plugin(name="asyncRoot", category="Core", printObject=true)
    public static class RootLogger
    extends LoggerConfig {
        @PluginFactory
        public static LoggerConfig createLogger(@PluginAttr(value="additivity") String additivity, @PluginAttr(value="level") String levelName, @PluginAttr(value="includeLocation") String includeLocation, @PluginElement(value="appender-ref") AppenderRef[] refs, @PluginElement(value="properties") Property[] properties, @PluginConfiguration Configuration config, @PluginElement(value="filters") Filter filter) {
            Level level;
            List<AppenderRef> appenderRefs = Arrays.asList(refs);
            try {
                level = Level.toLevel((String)levelName, (Level)Level.ERROR);
            }
            catch (Exception ex) {
                LOGGER.error("Invalid Log level specified: {}. Defaulting to Error", new Object[]{levelName});
                level = Level.ERROR;
            }
            boolean additive = Booleans.parseBoolean(additivity, true);
            return new AsyncLoggerConfig("", appenderRefs, filter, level, additive, properties, config, RootLogger.includeLocation(includeLocation));
        }
    }
}

