#!/bin/bash
HEIGHT=20
WIDTH=78
LISTHEIGHT=15

function check_cancel {
    if [ $? -ne 0 ]; then
        exit
    fi
}

# Check Kerberos credentials cache
klist -s
if [ $? -eq 1 ]; then
    kinit
fi

project=$(whiptail --title "JDG Builder" --menu "Project" 20 78 15 git://git.app.eng.bos.redhat.com/infinispan/infinispan.git Infinispan git://git.app.eng.bos.redhat.com/jdg-packaging.git JDG git://git.app.eng.bos.redhat.com/infinispan/protostream.git Protostream git://git.app.eng.bos.redhat.com/jdg/jdg-quickstart.git Quickstarts git://git.app.eng.bos.redhat.com/JGroups.git JGroups git://git.app.eng.bos.redhat.com/jboss-remoting/jboss-marshalling.git JBossMarshalling 3>&1 1>&2 2>&3)
check_cancel
hash=$(whiptail --menu Branch/Tag 20 78 15 `git ls-remote $project | grep -i jdg` 3>&1 1>&2 2>&3)
check_cancel
target=$(whiptail --menu "Target" 20 78 15 jb-edg-6-jdk7-rhel-6 JDK7 jb-edg-6-rhel-6 JDK6 3>&1 1>&2 2>&3)
check_cancel
whiptail --yesno "Release build" 7 40
if [ $? -eq 0 ]; then
    SCRATCH=""
else
    SCRATCH="--scratch"
fi
TEMPFILE=`mktemp`
brew maven-build $SCRATCH --nowait -Pdistribution -Dmaven.test.skip.exec=true $target-candidate $project#$hash > $TEMPFILE
TASK_ID=`grep "Created task" $TEMPFILE |cut -f3 -d' '`
rm -f $TEMPFILE
brew watch-task $TASK_ID
if [ $? -eq 0 ]; then
    brew regen-repo $target-build
fi

