#!/bin/bash

DIR=`dirname $0`
BASEDIR=`readlink -f "$DIR"`

if [ "$#" -ne 1 ]
then
  echo "Usage: $0 [releasename]"
  exit 1
fi
RELEASE=$1

PROJECTS="infinispan infinispan-cachestore-leveldb infinispan-cachestore-rest infinispan-server jdg-quickstart"

for PROJECT in $PROJECTS; do
	echo "Tagging $PROJECT"
	pushd ../$PROJECT > /dev/null
	git tag -m "$RELEASE" -a "$RELEASE"
	popd > /dev/null
done

