package org.infinispan.persistence.migrator.writer;

import java.math.BigDecimal;

import org.h2.Driver;
import org.h2.store.fs.FileUtils;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcBinaryCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedCacheStoreConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups="functional", testName = "persistence.migrator.writer.Jdbc52xWriterTest")
public class Jdbc52xWriterTest {
   
   static final String DATABASE_DIR;
   
   static {
      String buildDirectory = System.getProperty("build.directory");
      DATABASE_DIR = buildDirectory != null ? buildDirectory + "/jdbc-migrator52x" : System.getProperty("java.io.tmpdir") + "/jdbc-migrator52x";
   }
   
   @BeforeClass
   public void setup() {
      FileUtils.deleteRecursive(DATABASE_DIR, true);
      System.out.println("Building to " + DATABASE_DIR);
   }

   public void testJdbcStringWriter() {
      ConfigurationBuilder builder = new ConfigurationBuilder();
      builder.loaders().addLoader(JdbcStringBasedCacheStoreConfigurationBuilder.class)
         .table()
            .idColumnName("id")
            .idColumnType("VARCHAR")
            .dataColumnName("datum")
            .dataColumnType("BINARY")
            .timestampColumnName("version")
            .timestampColumnType("BIGINT")
            .tableNamePrefix("ISPN_JS")
         .simpleConnection()
            .driverClass(Driver.class)
            .connectionUrl(String.format("jdbc:h2:%s/string;DB_CLOSE_DELAY=-1", DATABASE_DIR))
            .username("sa")
            .password("");
      EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager();
      cacheManager.defineConfiguration("source", builder.build());
      Cache<String, String> cache = cacheManager.getCache("source");
      for(char ch = 'A'; ch <= 'Z'; ch++) {
         cache.put(Character.toString(ch), Character.toString(ch));
      }
      cacheManager.stop();
   }
   
   public void testJdbcBinaryWriter() {
      ConfigurationBuilder builder = new ConfigurationBuilder();
      builder.loaders().addLoader(JdbcBinaryCacheStoreConfigurationBuilder.class)
         .table()
            .idColumnName("id")
            .idColumnType("VARCHAR")
            .dataColumnName("datum")
            .dataColumnType("BINARY")
            .timestampColumnName("version")
            .timestampColumnType("BIGINT")
            .tableNamePrefix("ISPN_JB")
         .simpleConnection()
            .driverClass(Driver.class)
            .connectionUrl(String.format("jdbc:h2:%s/binary;DB_CLOSE_DELAY=-1", DATABASE_DIR))
            .username("sa")
            .password("");
      EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager();
      cacheManager.defineConfiguration("source", builder.build());
      Cache<BigDecimal, BigDecimal> cache = cacheManager.getCache("source");
      for(int i = 0; i < 100; i++) {
         cache.put(new BigDecimal(i), new BigDecimal(i));
      }
      cacheManager.stop();
   }
   
   public void testJdbcMixedWriter() {
      ConfigurationBuilder builder = new ConfigurationBuilder();
      builder.loaders().addLoader(JdbcMixedCacheStoreConfigurationBuilder.class)
         .stringTable()
            .idColumnName("id")
            .idColumnType("VARCHAR")
            .dataColumnName("datum")
            .dataColumnType("BINARY")
            .timestampColumnName("version")
            .timestampColumnType("BIGINT")
            .tableNamePrefix("ISPN_JMS")
         .binaryTable()
            .idColumnName("id")
            .idColumnType("VARCHAR")
            .dataColumnName("datum")
            .dataColumnType("BINARY")
            .timestampColumnName("version")
            .timestampColumnType("BIGINT")
            .tableNamePrefix("ISPN_JMB")
         .simpleConnection()
            .driverClass(Driver.class)
            .connectionUrl(String.format("jdbc:h2:%s/mixed;DB_CLOSE_DELAY=-1", DATABASE_DIR))
            .username("sa")
            .password("");
      EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager();
      cacheManager.defineConfiguration("source", builder.build());
      Cache<Object, Object> cache = cacheManager.getCache("source");
      for(char ch = 'A'; ch <= 'Z'; ch++) {
         cache.put(Character.toString(ch), Character.toString(ch));
      }
      for(int i = 1; i < 100; i++) {
         cache.put(new BigDecimal(i), new BigDecimal(i));
      }
      cacheManager.stop();
   }
}
