#!/bin/bash

VERSION=8.4.0
JDG_REMOTE=jdg
REDHAT_REMOTE=redhat
JDG_BRANCH=jdg-7.1.x

# dist-git setup
DIST_GIT_REPO=infinispan-cpp-client
DIST_GIT_BRANCH=jb-dg-7-win
WIN_TARGET=jb-dg-7-win-candidate

function prepare-src() {
    echo "Preparing release for milestone $1"
    rm -fr build
    mkdir build
    pushd build 2> /dev/null
    cmake ..
    cpack --config CPackSourceConfig.cmake
    popd
}

function prepare-dist-git() {
    # Clone repo
    rhpkg clone $DIST_GIT_REPO
    pushd $DIST_GIT_REPO

    # checkout windows branch
    git checkout $DIST_GIT_BRANCH

    # get cpp sources
    cp $2/infinispan-hotrod-cpp-$VERSION.$1-Source.zip .

    # Update sources
    sed -i "s/.*infinispan-hotrod-.*//" sources
    sed -i '/^$/d' sources
    rhpkg --dist rhel-6 upload ../build/infinispan-hotrod-dotnet-$VERSION*$1-Source.zip
    md5sum infinispan-hotrod-cpp-$VERSION.$1-Source.zip >> sources

    # Update .ini file
    PREV_VERSION=`grep "version = " infinispan-cpp-client.ini | sed -e s/"version = "//`
    PREV_RELEASE=`grep "release = " infinispan-cpp-client.ini | sed -e s/"release = "//` 
 
    if [ $PREV_VERSION != $VERSION.$1 ]; then
        sed -i "s/version = $PREV_VERSION/version = $VERSION.$1/" infinispan-cpp-client.ini
        RELEASE=1
    else
        RELEASE=$((PREV_RELEASE+1))
    fi
    sed -i "s/release = $PREV_RELEASE/release = $RELEASE/" infinispan-cpp-client.ini

    # Commit and push
    git commit -a -m "$VERSION.$1" && rhpkg push && git rev-parse HEAD

    popd
    exit
}

function perform-dist-git() {
    if [ ! -f $DIST_GIT_REPO ]; then
        rhpkg clone $DIST_GIT_REPO
    fi
  
    pushd $DIST_GIT_REPO

    git checkout $DIST_GIT_BRANCH

    HASH=`git log --format=%H -n 1`
    brew win-build jb-dg-7-win-candidate git://pkgs.devel.redhat.com/rpms/infinispan-cpp-client\#$HASH jdg-natives-vs2012-20160127 $1

    popd
}

function perform-src() {
    RELEASE=`grep "CPACK_PACKAGE_VERSION " build/CPackSourceConfig.cmake | cut -d\" -f2 | tr \- \.`
    echo "Performing release $RELEASE"
    git add CMakeLists.txt
    git commit -a -m "$RELEASE"
    git tag -a $RELEASE -m $RELEASE
    git checkout $JDG_BRANCH
    git branch -D $TEMP_BRANCH
    echo "Don't forget to push the $RELEASE tag to the $REDHAT_REMOTE remote"
    exit
}

function usage() {
	echo "Usage: $0 --prepare MILESTONE CPP_CLIENT_SOURCES_DIR | --perform [--scratch]"
	exit 1
}

case "$1" in
    "--prepare" )
    	if [ "$#" -lt 2 ]; then
	    usage
	fi
        prepare-src "$2"
        prepare-dist-git "$2" "$3"
        ;;
    "--perform" )
        perform-dist-git
        perform-src "$2" 
        ;;
    *)
        usage
        ;;
esac
