package org.infinispan.server.test.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Users and Roles generated by the testing driver
 *
 * @see {@link org.infinispan.server.test.core.AbstractInfinispanServerDriver}
 *
 * @author Katia Aresti
 * @since 11
 */
public enum TestUser {
   ADMIN("admin", "strongPassword", Arrays.asList("AdminRole", "___schema_manager", "___script_manager")),
   READER("reader", "password", Collections.singletonList("ReaderRole")),
   WRITER("writer", "somePassword", Collections.singletonList("WriterRole")),
   SUPERVISOR("supervisor", "lessStrongPassword", Collections.singletonList("SupervisorRole"));

   private final String user;
   private final String password;
   private final List<String> roles;

   TestUser(String user, String password, List<String> roles) {
      this.user = user;
      this.password = password;
      this.roles = roles;
   }

   public String getUser() {
      return user;
   }

   public String getPassword() {
      return password;
   }

   public List<String> getRoles() {
      return roles;
   }
}
