package org.infinispan.cli.commands.rest;

import java.util.concurrent.CompletionStage;

import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.completers.QueryModeCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.resources.CacheResource;
import org.infinispan.cli.resources.Resource;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestQueryMode;
import org.infinispan.client.rest.RestResponse;
import org.kohsuke.MetaInfServices;

/**
 * @author Tristan Tarrant &lt;tristan@infinispan.org&gt;
 * @since 10.0
 **/
@MetaInfServices(Command.class)
@CommandDefinition(name = "query", description = "Queries a cache", activator = ConnectionActivator.class)
public class Query extends RestCliCommand {

   @Argument(required = true, description = "The Ickle query")
   String query;

   @Option(completer = CacheCompleter.class)
   String cache;

   @Option(name = "max-results", defaultValue = "10")
   Integer maxResults;

   @Option(name = "offset", defaultValue = "0")
   Integer offset;

   @Option(name = "query-mode", completer = QueryModeCompleter.class, defaultValue = "FETCH", description = "Mode for queries FETCH|BROADCAST, defaults to FETCH")
   String queryMode;

   @Option(shortName = 'h', hasValue = false, overrideRequired = true)
   protected boolean help;

   @Override
   public boolean isHelp() {
      return help;
   }

   @Override
   protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
      return client.cache(cache != null ? cache : CacheResource.cacheName(resource)).query(query, maxResults, offset, RestQueryMode.valueOf(queryMode));
   }
}
