package org.infinispan.persistence.jpa.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import org.infinispan.protostream.annotations.ProtoField;

/**
 *
 * @author <a href="mailto:rtsang@redhat.com">Ray Tsang</a>
 *
 */
@Entity
@Table(name="Users")
public class User {

   @Id
   private String username;

   @Column(nullable=false)
   private String firstName;

   @Column(nullable=false)
   private String lastName;

   private String note;

   @ProtoField(1)
   public String getUsername() {
      return username;
   }

   public void setUsername(String username) {
      this.username = username;
   }

   @ProtoField(2)
   public String getFirstName() {
      return firstName;
   }

   public void setFirstName(String firstName) {
      this.firstName = firstName;
   }

   @ProtoField(3)
   public String getLastName() {
      return lastName;
   }

   public void setLastName(String lastName) {
      this.lastName = lastName;
   }

   @ProtoField(4)
   public String getNote() {
      return note;
   }

   public void setNote(String note) {
      this.note = note;
   }

   @Override
   public int hashCode() {
      final int prime = 31;
      int result = 1;
      result = prime * result
            + ((firstName == null) ? 0 : firstName.hashCode());
      result = prime * result
            + ((lastName == null) ? 0 : lastName.hashCode());
      result = prime * result + ((note == null) ? 0 : note.hashCode());
      result = prime * result
            + ((username == null) ? 0 : username.hashCode());
      return result;
   }

   @Override
   public boolean equals(Object obj) {
      if (this == obj)
         return true;
      if (obj == null)
         return false;
      if (getClass() != obj.getClass())
         return false;
      User other = (User) obj;
      if (firstName == null) {
         if (other.firstName != null)
            return false;
      } else if (!firstName.equals(other.firstName))
         return false;
      if (lastName == null) {
         if (other.lastName != null)
            return false;
      } else if (!lastName.equals(other.lastName))
         return false;
      if (note == null) {
         if (other.note != null)
            return false;
      } else if (!note.equals(other.note))
         return false;
      if (username == null) {
         if (other.username != null)
            return false;
      } else if (!username.equals(other.username))
         return false;
      return true;
   }

   @Override
   public String toString() {
      return "User [username=" + username + ", firstName=" + firstName
            + ", lastName=" + lastName + ", note=" + note + "]";
   }
}
