/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.core;

import java.util.List;
import org.odata4j.core.OEntity;
import org.odata4j.core.OLink;
import org.odata4j.core.ORelatedEntitiesLink;
import org.odata4j.core.ORelatedEntitiesLinkInline;
import org.odata4j.core.ORelatedEntityLink;
import org.odata4j.core.ORelatedEntityLinkInline;

public class OLinks {
    private OLinks() {
    }

    public static ORelatedEntitiesLink relatedEntities(String relation, String title, String href) {
        return new ORelatedEntitiesLinkImpl(relation, title, href);
    }

    public static ORelatedEntitiesLinkInline relatedEntitiesInline(String relation, String title, String href, List<OEntity> relatedEntities) {
        return new ORelatedEntitiesLinkInlineImpl(relation, title, href, relatedEntities);
    }

    public static ORelatedEntityLink relatedEntity(String relation, String title, String href) {
        return new ORelatedEntityLinkImpl(relation, title, href);
    }

    public static ORelatedEntityLinkInline relatedEntityInline(String relation, String title, String href, OEntity relatedEntity) {
        return new ORelatedEntityLinkInlineImpl(relation, title, href, relatedEntity);
    }

    private static class ORelatedEntityLinkInlineImpl
    extends OLinkImpl
    implements ORelatedEntityLinkInline {
        private final OEntity relatedEntity;

        public ORelatedEntityLinkInlineImpl(String relation, String title, String href, OEntity relatedEntity) {
            super(ORelatedEntityLinkInline.class, relation, title, href);
            this.relatedEntity = relatedEntity;
        }

        @Override
        public OEntity getRelatedEntity() {
            return this.relatedEntity;
        }

        @Override
        public boolean isInline() {
            return true;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public List<OEntity> getRelatedEntities() {
            return null;
        }
    }

    private static class ORelatedEntityLinkImpl
    extends OLinkImpl
    implements ORelatedEntityLink {
        public ORelatedEntityLinkImpl(String relation, String title, String href) {
            super(ORelatedEntityLink.class, relation, title, href);
        }

        @Override
        public boolean isInline() {
            return false;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public OEntity getRelatedEntity() {
            return null;
        }

        @Override
        public List<OEntity> getRelatedEntities() {
            return null;
        }
    }

    private static class ORelatedEntitiesLinkInlineImpl
    extends OLinkImpl
    implements ORelatedEntitiesLinkInline {
        private final List<OEntity> relatedEntities;

        public ORelatedEntitiesLinkInlineImpl(String relation, String title, String href, List<OEntity> relatedEntities) {
            super(ORelatedEntitiesLinkInline.class, relation, title, href);
            this.relatedEntities = relatedEntities;
        }

        @Override
        public List<OEntity> getRelatedEntities() {
            return this.relatedEntities;
        }

        @Override
        public boolean isInline() {
            return true;
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public OEntity getRelatedEntity() {
            return null;
        }
    }

    private static class ORelatedEntitiesLinkImpl
    extends OLinkImpl
    implements ORelatedEntitiesLink {
        public ORelatedEntitiesLinkImpl(String relation, String title, String href) {
            super(ORelatedEntitiesLink.class, relation, title, href);
        }

        @Override
        public boolean isInline() {
            return false;
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public OEntity getRelatedEntity() {
            return null;
        }

        @Override
        public List<OEntity> getRelatedEntities() {
            return null;
        }
    }

    private static abstract class OLinkImpl
    implements OLink {
        private final Class<?> interfaceType;
        private final String title;
        private final String relation;
        private final String href;

        public OLinkImpl(Class<?> interfaceType, String relation, String title, String href) {
            this.interfaceType = interfaceType;
            this.title = title;
            this.relation = relation;
            this.href = href;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getRelation() {
            return this.relation;
        }

        @Override
        public String getHref() {
            return this.href;
        }

        public String toString() {
            return String.format("%s[rel=%s,title=%s,href=%s]", this.interfaceType.getSimpleName(), this.relation, this.title, this.href);
        }
    }
}

