/**
 * Copyright (C) 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.dashboard.ui.taglib;

import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.VariableInfo;
import java.io.IOException;

/**
 *
 */
public class EnvelopeFooterTag extends TagSupport {
    private static transient org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(EnvelopeFooterTag.class.getName());

    public static final String ENVELOPE_TOKEN = "envelopeFootToken";

    public static class TEI extends TagExtraInfo {
        public VariableInfo[] getVariableInfo(TagData tagData) {
            VariableInfo[] info = new VariableInfo[]{};
            return info;
        }
    }

    public int doStartTag() throws JspException {
        try {
            pageContext.getRequest().setAttribute(ENVELOPE_TOKEN, Boolean.TRUE);
            this.pageContext.include("/templates/footer.jsp");
         } catch (IOException e) {
            log.error("Error: ", e);
        } catch (ServletException e) {
            log.error("Error: ", e);
        }
        return SKIP_BODY;
    }

}
