/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.json;

import java.io.IOException;
import java.io.Writer;
import org.odata4j.core.Throwables;

public class JsonWriter {
    private final Writer writer;

    public JsonWriter(Writer writer) {
        this.writer = writer;
    }

    public void startCallback(String functionName) {
        try {
            this.writer.write(this.encode(functionName) + "(");
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public void endCallback() {
        try {
            this.writer.write(");");
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public void startObject() {
        try {
            this.writer.write("{\n");
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public void endObject() {
        try {
            this.writer.write("\n}");
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public void writeName(String name) {
        try {
            this.writer.write("\"" + this.encode(name) + "\" : ");
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public void startArray() {
        try {
            this.writer.write("[\n");
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public void endArray() {
        try {
            this.writer.write("\n]");
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public void writeSeparator() {
        try {
            this.writer.write(", ");
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public void writeString(String value) {
        try {
            this.writer.write("\"" + this.encode(value) + "\"");
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public void writeNull() {
        try {
            this.writer.write("null");
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public void writeNumber(int value) {
        try {
            this.writer.write(Integer.toString(value));
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public void writeNumber(float value) {
        try {
            String fvalue = Float.toString(value);
            while (fvalue.contains(".") && fvalue.endsWith("0")) {
                fvalue = fvalue.substring(0, fvalue.length() - 1);
            }
            if (fvalue.endsWith(".")) {
                fvalue = fvalue.substring(0, fvalue.length() - 1);
            }
            this.writer.write(fvalue);
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public void writeBoolean(boolean value) {
        try {
            this.writer.write(value ? "true" : "false");
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public void writeRaw(String value) {
        try {
            this.writer.write(value);
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    private String encode(String unencoded) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < unencoded.length(); ++i) {
            char c = unencoded.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

