/*
 * Decompiled with CFR 0.152.
 */
package org.core4j;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class ReadOnlyIterator<T>
implements Iterator<T> {
    private HasNext hasNext = HasNext.UNKNOWN;
    private T current;

    @Override
    public boolean hasNext() {
        if (this.hasNext == HasNext.UNKNOWN) {
            IterationResult<T> result = null;
            try {
                result = this.advance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (result == null) {
                result = IterationResult.done();
            }
            this.hasNext = result.hasNext ? HasNext.YES : HasNext.NO;
            this.current = result.current;
        }
        return this.hasNext.getBoolean();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            this.hasNext = HasNext.UNKNOWN;
            return this.current;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove()");
    }

    protected abstract IterationResult<T> advance() throws Exception;

    static enum HasNext {
        UNKNOWN,
        YES,
        NO;


        public boolean getBoolean() {
            if (this == UNKNOWN) {
                throw new IllegalArgumentException();
            }
            return this == YES;
        }
    }

    public static class IterationResult<T> {
        public final boolean hasNext;
        public final T current;

        private IterationResult(boolean hasNext, T current) {
            this.hasNext = hasNext;
            this.current = current;
        }

        public static <T> IterationResult<T> done() {
            return new IterationResult<Object>(false, null);
        }

        public static <T> IterationResult<T> next(T value) {
            return new IterationResult<T>(true, value);
        }
    }
}

