package com.redhat.installer.action;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;

import org.apache.commons.io.FileUtils;


import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Housekeeper;
import com.redhat.installer.util.ValidatorConstants;

public class BackupListener extends SimpleInstallerListener implements CleanupClient {

	private static AutomatedInstallData idata;
    private static String installPath;
    private static String backupPath;

	/**
	 * Restores backups of all files as needed. TODO: perhaps refactor to use a
	 * list of somekind, defined in a Constants class
	 */
	public void cleanUp() {
        String aborted = idata.getVariable("install.aborted");
        File backupFolder = new File(backupPath);
        File installFolder = new File(installPath);

        if (backupFolder.exists()){
            if (aborted != null && Boolean.parseBoolean(aborted)) {
                try {
                    FileUtils.deleteDirectory(installFolder);
                } catch(IOException e) {
                    e.printStackTrace();
                }
                /**
                 * Restore the backed up eap installation.
                 */
                recursiveDirectoryCopy(backupPath, installPath);
            }

            /**
             * Now remove the backup folder as it's not needed anymore.
             */
            try {
                FileUtils.deleteDirectory(backupFolder);
            } catch(IOException e) {
                e.printStackTrace();
            }
        }
	}

	/**
	 * Replace oldFile with newFile. TODO: refactor to utility class
	 * 
	 * @param oldFile
	 * @param newFile
	 * @throws IOException
	 */
	private void replaceFile(File oldFile, File newFile) throws IOException {
		oldFile.delete();
		if (!newFile.renameTo(oldFile)) {
			// file built-in method failed. manual copy.
			BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(newFile)));
			BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(oldFile)));
			String line;
			while ((line = br.readLine()) != null) {
				bw.write(line);
			}
			br.close();
			bw.close();
		}
	}

    private void restoreFilesList() {
        ArrayList<File> originals = new ArrayList<File>();

        for (String file : ValidatorConstants.filesToBackup) {
            originals.add(new File(installPath + file));
			 /*System.out.println(installPath + file +
			 " added to originals list");*/
        }

        ArrayList<File> backups = new ArrayList<File>();
        for (File original : originals) {
            backups.add(new File(original.getPath() + ValidatorConstants.backupExt));
			 /*System.out.println(original.getPath()+ValidatorConstants.backupExt
			 + " added to backups list");*/
        }

        // backups.add(new File(installPath +
        // ValidatorConstants.layersConfLoc));
        // backups.add(new File(installPath + ValidatorConstants.layersConfLoc +
        // ValidatorConstants.layersConfBackup));
        // System.out.println("layerBackup = " + layerBackup.getPath());
        // File productConf = new File(installPath +
        // ValidatorConstants.productConfLoc);
        // File productBackup = new File(installPath +
        // ValidatorConstants.productConfBackup);
        // System.out.println("productBackup = " + productBackup.getPath());
        String aborted = idata.getVariable("install.aborted");

        if (aborted != null && Boolean.parseBoolean(aborted)) {
            // installation was aborted. restore back ups
            try {
                for (int i = 0; i < originals.size(); i++) {
                    File original = originals.get(i);
                    File backup = backups.get(i);
                    if (original.exists()) { // file exists and was probably
                        // modified by the installer.
                        // rollback on abort
                        if (backup.exists()) {
                            replaceFile(original, backup);
                        } else { // the file was newly created by the installer,
                            // because there is no backup for it.
                            //System.out.println("Deleted " + original.getPath() + " because there was no backup available.");
                            original.delete();
                        }
                    }
                }
            } catch (FileNotFoundException fnfe) {
                // this is ok. this means there was no original to backup, so we
                // don't need to do anything
            } catch (Exception e) {
                // other exceptions are bad.
                e.printStackTrace();
            }
			/*
			 * try{ if (productBackup.exists()){ replaceFile(productConf,
			 * productBackup); } } catch (FileNotFoundException fnfe){ // do
			 * nothing. if the file isn't found by the first call, that means a
			 * backup was not created, // and thus we don't have to rollback
			 * anything } catch (IOException e){ e.printStackTrace(); }
			 */
        }
        // we always delete the backups :)
        for (File backup : backups) {
            backup.delete();
            //System.out.println("Deleted backup file: " + backup.getPath());
        }
		/*
		 * layerBackup.delete(); productBackup.delete();
		 */
    }

    private void backupFilesList() throws IOException {
        // create backups of all the files that may be modified by postinstall,
        // or by
        // the particular product. may require specific modifications for
        // specific products.
        String installPath = idata.getVariable("INSTALL_PATH") + File.separator + idata.getVariable("INSTALL_SUBPATH");
        ArrayList<File> toBackup = new ArrayList<File>();


		for (String file : ValidatorConstants.filesToBackup) {
			toBackup.add(new File(installPath + file));
		}

        // TODO: perhaps factor this out. duplicated a few places
		for (File original : toBackup) {
			if (original.exists()) {
				File backup = new File(original.getPath() + ValidatorConstants.backupExt);
				InputStream in = new FileInputStream(original);
				OutputStream out = new FileOutputStream(backup);
				//System.out.println("Backing up " + original.getPath() + " to: " + backup.getPath());
				byte[] buffer = new byte[1024];
				int l;
				while ((l = in.read(buffer, 0, 1024)) > 0) {
					out.write(buffer, 0, l);
				}

				in.close();
				out.close();
			}
		}
    }

    /**
     * Pre-order traversal of the file system rooted at rootPath while re-creating
     * the file structure but rooted at rootDestPath.
     * @param rootPath
     * @param rootDestPath
     */
    private void recursiveDirectoryCopy(String rootPath, String rootDestPath) {
        Queue<File> files = new LinkedList<File>();
        File root = new File(rootPath);
        files.add(root);

        while (!files.isEmpty()) {
            File current = files.remove();
            copyRetainingPermissions(current, new File(current.getPath().replace(rootPath,rootDestPath)));
            if (current.isDirectory()) {
                for (File child : current.listFiles()) {
                    files.add(child);
                }
            }
        }
    }

    /**
     * Attempts to retain read/write/exec permissions when copying files from source to destination.
     * @param source
     * @param dest
     */
    private void copyRetainingPermissions(File source, File dest) {
        boolean exec = source.canExecute();
        boolean read = source.canRead();
        boolean write = source.canWrite();

        try {
            FileUtils.copyFile(source, dest);
            dest.setExecutable(exec);
            dest.setReadable(read);
            dest.setWritable(write);
        } catch(IOException e){

        }

    }

	@Override
	public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
		// just to save time, since izpack doesn't have a good
		// "execute this before any installation occurs, but only once."
		if (this.idata == null) {
			this.idata = idata;
            installPath = idata.getVariable("INSTALL_PATH") + File.separator + idata.getVariable("INSTALL_SUBPATH");
            backupPath = idata.getVariable("INSTALL_PATH") + File.separator + idata.getVariable("INSTALL_SUBPATH") + ValidatorConstants.backupExt;
		}
        Housekeeper.getInstance().registerForCleanup(this);
        File installPathFile = new File(installPath);

        /**
         * If an existing installation is detected:
         */
        if (installPathFile.exists()) {
            /**
             * Back up the entire jboss-eap-6.* directory, so we can restore it without
             * manging the former installation in the event of some dastardly user quitting early.
             */
            recursiveDirectoryCopy(installPath, backupPath);
        }
    }
	
	
	@Override
	public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {


        // Nothing as of yet


	}
}
