package com.redhat.installer.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;

/**
 * This class resets all of the post-install variables to 'off' if the
 * postinstallServer variable evaluates to "false". It is run when the user hits
 * 'next' in the post-install panel, after the validation occurs.
 * 
 * @author fcanas
 * 
 */
public class PostInstallDefaultReset implements PanelAction {
    String[] postInstallVars = new String[] { "installVault", "installSsl",
            "installLdap", "installInfinispan", "installSecurityDomain",
            "jdbc.driver.install", "datasource.install" };
    
    
    public void executeAction(AutomatedInstallData adata,
            AbstractUIHandler handler) {

        /**
         * We don't run this during automated installations.
         */
        if (adata.getVariable("installerMode").equals("AUTO")) {
            return;
        }
        
        // If the main post-install radion button is set to false:
        if (adata.getVariable("postinstallServer").contains("false")) {

            // Explicitly turn off all post-install options in case they were
            // checked off.
            for (String option : postInstallVars) {
                adata.setVariable(option, "off");
            }
        }

        /**
         * Restore the default value for the jdbc driver if the user is not
         * using their own db settings.
         */
        if (adata.getVariable("jdbc.driver.install").contains("off")) {
            adata.setVariable("jdbc.driver.name", "h2");
            adata.setVariable("db.url", "$db.default.url");
            adata.setVariable("db.user", "$db.default.user");
            adata.setVariable("db.password", "$db.default.password");
        } else {
        	// if we're advancing with a jdbc driver selected, make sure the initial values are blanked.
        	// if the user had already filled the information, it will be destroyed
            adata.getVariables().remove("db.user");
            adata.getVariables().remove("db.password");
        }
    }

    /**
     * Nothing to initialize.
     */
    public void initialize(PanelActionConfiguration configuration) {
        
        
    }

}
