package com.redhat.installer.util;

import java.io.File;

public final class ValidatorConstants {

	// variable names
	public static final String existingLayers = "existing.layers.conf";
	public static final String existingProduct = "existing.product.conf";
	public static final String newLayers = "new.layers.conf";
	public static final String newProduct = "new.product.conf";
	public static final String productReadableName = "platform.readable.name";
	
	// file locations
	public static final String backupExt = ".backup";
	public static final String productConfLoc = File.separator + "bin" + File.separator + "product.conf";
	public static final String layersConfLoc = File.separator + "modules" + File.separator + "layers.conf";
	public static final String standaloneLoc = File.separator + "bin" + File.separator + "standalone.sh";
	public static final String standaloneXmlLoc = File.separator + "standalone" + File.separator + "configuration" + File.separator + "standalone.xml";
	public static final String standaloneFullXmlLoc = File.separator + "standalone" + File.separator + "configuration" + File.separator + "standalone-full.xml";
	public static final String standaloneHaXmlLoc = File.separator + "standalone" + File.separator + "configuration" + File.separator + "standalone-ha.xml";
	public static final String standaloneFullHaXmlLoc = File.separator + "standalone" + File.separator + "configuration" + File.separator + "standalone-full-ha.xml";
	public static final String standaloneOsgiXmlLoc = File.separator + "standalone" + File.separator + "configuration" + File.separator + "standalone-osgi.xml";
	public static final String standaloneUsersLoc = File.separator + "standalone" + File.separator + "configuration" + File.separator + "mgmt-users.properties";
	public static final String domainLoc = File.separator + "bin" + File.separator + "domain.sh";
	public static final String domainXmlLoc = File.separator + "domain" + File.separator + "configuration" + File.separator + "domain.xml";
	public static final String domainUsersLoc = File.separator + "domainFile.separatorconfiguration" + File.separator + "mgmt-users.properties";
	public static final String hostXmlLoc = File.separator + "domain" + File.separator + "configuration" + File.separator + "host.xml";
	public static final String [] filesToBackup = { standaloneXmlLoc, 
													standaloneFullXmlLoc, 
													standaloneHaXmlLoc, 
													standaloneFullHaXmlLoc, 
													standaloneOsgiXmlLoc,
													standaloneUsersLoc,
													domainXmlLoc, 
													hostXmlLoc,
													domainUsersLoc,
													productConfLoc,
													layersConfLoc};
	
	// product.conf possible contents
	public static final String eap = "eap";
	public static final String brms = "brms";
	public static final String bpms = "bpms";
	public static final String soa = "soa";
	public static final String sramp = "sramp"; 
	
	// layers.conf possible combinations.
	public static final String dv = "dv";
	public static final String soaEds = ValidatorConstants.soa+","+ValidatorConstants.dv;
	public static final String soaBrms = ValidatorConstants.soa+","+ValidatorConstants.brms;
	public static final String soaBrmsEds = ValidatorConstants.soa+","+ValidatorConstants.brms+","+ValidatorConstants.dv;
	public static final String soaBpms = ValidatorConstants.soa+","+ValidatorConstants.bpms;
	public static final String brmsEds = ValidatorConstants.brms+","+ValidatorConstants.dv;
	public static final String soaSramp = ValidatorConstants.soa+","+ValidatorConstants.sramp;
	public static final String soaSrampEds = ValidatorConstants.soa+","+ValidatorConstants.sramp+","+ValidatorConstants.dv;
	public static final String soaSrampBrms = ValidatorConstants.soa+","+ValidatorConstants.sramp+","+ValidatorConstants.brms;
	public static final String soaSrampBrmsEds = ValidatorConstants.soa+","+ValidatorConstants.sramp+","+ValidatorConstants.brms+","+ValidatorConstants.dv;
	public static final String soaSrampBpms = ValidatorConstants.soa+","+ValidatorConstants.sramp+","+ValidatorConstants.bpms;
	public static final String srampBrms = ValidatorConstants.sramp+","+ValidatorConstants.brms;
	public static final String srampBrmsEds = ValidatorConstants.sramp+","+ValidatorConstants.brms+","+ValidatorConstants.dv;
	public static final String srampBpms = ValidatorConstants.sramp+","+ValidatorConstants.brms;
	public static final String bpmsEds = ValidatorConstants.bpms+","+ValidatorConstants.dv;
	public static final String srampBpmsEds  = ValidatorConstants.sramp+","+ValidatorConstants.bpms+","+ValidatorConstants.dv;

}
