/*
 * ModeShape (http://www.modeshape.org)
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 * See the AUTHORS.txt file in the distribution for a full listing of
 * individual contributors.
 *
 * ModeShape is free software. Unless otherwise indicated, all code in ModeShape
 * is licensed to you under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * ModeShape is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.modeshape.jboss.metric.ModelMetrics;
import org.modeshape.jboss.metric.ModelMetrics.MetricAttributeDefinition;

/**
 * 
 */
public class ModeShapeRepositoryResource extends SimpleResourceDefinition {
    protected final static ModeShapeRepositoryResource INSTANCE = new ModeShapeRepositoryResource();

    private ModeShapeRepositoryResource() {
        super(ModeShapeExtension.REPOSITORY_PATH, ModeShapeExtension.getResourceDescriptionResolver(ModelKeys.REPOSITORY),
              AddRepository.INSTANCE, RemoveRepository.INSTANCE);
    }

    /**
     * {@inheritDoc}
     * 
     * @see org.jboss.as.controller.SimpleResourceDefinition#registerAttributes(org.jboss.as.controller.registry.ManagementResourceRegistration)
     */
    @Override
    public void registerAttributes( ManagementResourceRegistration resourceRegistration ) {
        super.registerAttributes(resourceRegistration);
        RepositoryWriteAttributeHandler.INSTANCE.registerAttributes(resourceRegistration);
        registerMetrics(resourceRegistration);
    }

    private void registerMetrics( final ManagementResourceRegistration registration ) {
        for (final MetricAttributeDefinition attrDefn : ModelMetrics.ALL_METRICS) {
            registration.registerMetric(attrDefn, attrDefn.metricHandler());
        }
    }

}
