/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid.runtime;

import com.google.gwt.cell.client.ButtonCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ClickableTextCell;
import com.google.gwt.cell.client.DateCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.jboss.as.console.client.teiid.model.Request;
import org.jboss.as.console.client.teiid.model.VDB;
import org.jboss.as.console.client.teiid.runtime.VDBPresenter;
import org.jboss.as.console.client.teiid.runtime.VDBProvider;
import org.jboss.as.console.client.teiid.runtime.VDBView;
import org.jboss.as.console.client.teiid.widgets.QueryPlanPopUpWindow;
import org.jboss.ballroom.client.widgets.common.DefaultButton;
import org.jboss.ballroom.client.widgets.tables.DefaultCellTable;
import org.jboss.ballroom.client.widgets.tables.DefaultPager;

public class VDBRequestsTab
extends VDBProvider {
    private VDBPresenter presenter;
    private ListDataProvider<Request> requestProvider = new ListDataProvider();
    private DefaultCellTable requestsTable;
    private ListDataProvider<Request> sourceRequestProvider = new ListDataProvider();
    private DefaultCellTable sourceRequestsTable;

    public VDBRequestsTab(VDBPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public VerticalPanel getPanel(DefaultCellTable vdbTable) {
        DefaultButton refreshBtn = new DefaultButton("Refresh", new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                VDBRequestsTab.this.refresh();
            }
        });
        refreshBtn.getElement().setAttribute("style", "margin-bottom:10px;");
        ColumnSortEvent.ListHandler sortHandler = new ColumnSortEvent.ListHandler(this.requestProvider.getList());
        this.requestsTable = this.getRequestsTable((ColumnSortEvent.ListHandler<Request>)sortHandler, false);
        this.requestProvider.addDataDisplay((HasData)this.requestsTable);
        VDBView.onTableSectionChange(vdbTable, new VDBView.TableSelectionCallback<VDB>(){

            @Override
            public void onSelectionChange(VDB selection) {
                if (selection != null && VDBRequestsTab.this.isActive(selection)) {
                    VDBRequestsTab.this.setVdbName(selection.getName());
                    VDBRequestsTab.this.setVdbVersion(selection.getVersion());
                    VDBRequestsTab.this.refresh();
                } else {
                    VDBRequestsTab.this.requestProvider.getList().clear();
                    VDBRequestsTab.this.sourceRequestProvider.getList().clear();
                }
            }
        });
        DefaultPager requestsTablePager = new DefaultPager();
        requestsTablePager.setDisplay((HasRows)this.requestsTable);
        ColumnSortEvent.ListHandler sourceSortHandler = new ColumnSortEvent.ListHandler(this.sourceRequestProvider.getList());
        this.sourceRequestsTable = this.getRequestsTable((ColumnSortEvent.ListHandler<Request>)sourceSortHandler, true);
        this.sourceRequestProvider.addDataDisplay((HasData)this.sourceRequestsTable);
        VDBView.onTableSectionChange(this.requestsTable, new VDBView.TableSelectionCallback<Request>(){

            @Override
            public void onSelectionChange(Request selection) {
                if (selection != null) {
                    VDBRequestsTab.this.refreshSources(selection);
                } else {
                    VDBRequestsTab.this.sourceRequestProvider.getList().clear();
                }
            }
        });
        DefaultPager sourceRequestsTablePager = new DefaultPager();
        sourceRequestsTablePager.setDisplay((HasRows)this.sourceRequestsTable);
        VerticalPanel formPanel = new VerticalPanel();
        formPanel.add((Widget)refreshBtn);
        formPanel.add(this.requestsTable.asWidget());
        formPanel.add((Widget)requestsTablePager);
        formPanel.add((Widget)new Label("Source Queries"));
        formPanel.add(this.sourceRequestsTable.asWidget());
        formPanel.add((Widget)sourceRequestsTablePager);
        formPanel.setCellHorizontalAlignment((Widget)refreshBtn, HasHorizontalAlignment.ALIGN_RIGHT);
        return formPanel;
    }

    private DefaultCellTable getRequestsTable(ColumnSortEvent.ListHandler<Request> sortHandler, final boolean sourceTable) {
        ProvidesKey<Request> keyProvider = new ProvidesKey<Request>(){

            public Object getKey(Request item) {
                if (sourceTable) {
                    return item.getNodeId();
                }
                return item.getExecutionId();
            }
        };
        DefaultCellTable table = new DefaultCellTable(20, (ProvidesKey)keyProvider);
        table.addColumnSortHandler(sortHandler);
        TextColumn<Request> executionIdColumn = new TextColumn<Request>(){

            public String getValue(Request record) {
                if (sourceTable) {
                    return String.valueOf(record.getNodeId());
                }
                return String.valueOf(record.getExecutionId());
            }
        };
        executionIdColumn.setSortable(true);
        sortHandler.setComparator((Column)executionIdColumn, (Comparator)new Comparator<Request>(){

            @Override
            public int compare(Request o1, Request o2) {
                return o1.getExecutionId().compareTo(o2.getExecutionId());
            }
        });
        TextColumn<Request> sessionIdColumn = new TextColumn<Request>(){

            public String getValue(Request record) {
                return String.valueOf(record.getSessionId());
            }
        };
        sessionIdColumn.setSortable(true);
        sortHandler.setComparator((Column)sessionIdColumn, (Comparator)new Comparator<Request>(){

            @Override
            public int compare(Request o1, Request o2) {
                return o1.getSessionId().compareTo(o2.getSessionId());
            }
        });
        Column<Request, Date> timeColumn = new Column<Request, Date>((Cell)new DateCell()){

            public Date getValue(Request record) {
                return new Date(record.getStartTime());
            }
        };
        timeColumn.setSortable(true);
        sortHandler.setComparator((Column)timeColumn, (Comparator)new Comparator<Request>(){

            @Override
            public int compare(Request o1, Request o2) {
                return o1.getStartTime().compareTo(o2.getStartTime());
            }
        });
        Column<Request, String> cmdColumn = new Column<Request, String>((Cell)new ClickableTextCell()){

            public String getValue(Request record) {
                return record.getCommand();
            }
        };
        sortHandler.setComparator((Column)cmdColumn, (Comparator)new Comparator<Request>(){

            @Override
            public int compare(Request o1, Request o2) {
                return o1.getCommand().compareTo(o2.getCommand());
            }
        });
        Column<Request, String> planBtn = new Column<Request, String>((Cell)new ButtonCell()){

            public String getValue(Request record) {
                return "Plan";
            }
        };
        planBtn.setFieldUpdater((FieldUpdater)new FieldUpdater<Request, String>(){

            public void update(int index, Request request, String value) {
                VDBRequestsTab.this.showPlanDialog(request);
            }
        });
        Column<Request, String> cancelBtn = new Column<Request, String>((Cell)new ButtonCell()){

            public String getValue(Request record) {
                return "Cancel";
            }
        };
        cancelBtn.setFieldUpdater((FieldUpdater)new FieldUpdater<Request, String>(){

            public void update(int index, Request request, String value) {
                VDBRequestsTab.this.cancelQuery(request);
            }
        });
        table.setSelectionModel((SelectionModel)new SingleSelectionModel((ProvidesKey)keyProvider));
        table.setTitle("Requests");
        if (sourceTable) {
            table.addColumn((Column)executionIdColumn, "Node Id");
        } else {
            table.addColumn((Column)executionIdColumn, "Execution Id");
        }
        table.addColumn((Column)sessionIdColumn, "Session Id");
        table.addColumn((Column)timeColumn, "Start Time");
        table.addColumn((Column)cmdColumn, "Command");
        if (!sourceTable) {
            table.addColumn((Column)planBtn, "Query Plan");
            table.addColumn((Column)cancelBtn, "Cancel Query");
        }
        table.getColumnSortList().push((Column)executionIdColumn);
        return table;
    }

    public void setRequests(List<Request> requests) {
        this.requestProvider.getList().clear();
        if (requests != null && !requests.isEmpty()) {
            this.requestProvider.getList().addAll(requests);
            this.requestsTable.getSelectionModel().setSelected((Object)requests.get(0), true);
        } else {
            this.sourceRequestProvider.getList().clear();
        }
    }

    private void refresh() {
        this.presenter.getRequests(this.getVdbName(), this.getVdbVersion(), false);
    }

    private void cancelQuery(Request request) {
        this.presenter.cancelRequest(request);
    }

    private void showPlanDialog(Request request) {
        this.presenter.getQueryPlan(request);
    }

    public void setQueryPlan(String plan) {
        QueryPlanPopUpWindow showPlanDialogBox = new QueryPlanPopUpWindow("Query Plan", plan);
        showPlanDialogBox.show();
    }

    public void cancelSubmitted(Request request) {
        this.refresh();
    }

    private void refreshSources(Request selection) {
        this.presenter.getSourceRequests(selection);
    }

    public void setSourceRequests(Request selection, List<Request> requests) {
        this.sourceRequestProvider.getList().clear();
        if (requests != null && !requests.isEmpty()) {
            ArrayList<Request> sourceOnly = new ArrayList<Request>();
            for (Request request : requests) {
                if (!request.isSourceRequest().booleanValue() || !request.getExecutionId().equals(selection.getExecutionId())) continue;
                sourceOnly.add(request);
            }
            if (!sourceOnly.isEmpty()) {
                this.sourceRequestProvider.getList().addAll(sourceOnly);
                this.sourceRequestsTable.getSelectionModel().setSelected(sourceOnly.get(0), true);
            }
        }
    }
}

