/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.marshall.AdvancedExternalizer;
import org.infinispan.marshall.jboss.JBossExternalizerAdapter;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.schematic.internal.delta.AddValueIfAbsentOperation;
import org.infinispan.schematic.internal.delta.AddValueOperation;
import org.infinispan.schematic.internal.delta.ClearOperation;
import org.infinispan.schematic.internal.delta.PutIfAbsentOperation;
import org.infinispan.schematic.internal.delta.PutOperation;
import org.infinispan.schematic.internal.delta.RemoveAllValuesOperation;
import org.infinispan.schematic.internal.delta.RemoveAtIndexOperation;
import org.infinispan.schematic.internal.delta.RemoveOperation;
import org.infinispan.schematic.internal.delta.RemoveValueOperation;
import org.infinispan.schematic.internal.delta.RetainAllValuesOperation;
import org.infinispan.schematic.internal.delta.SetValueOperation;
import org.infinispan.schematic.internal.document.ArrayExternalizer;
import org.infinispan.schematic.internal.document.DocumentExternalizer;
import org.infinispan.schematic.internal.document.Paths;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.Externalizer;
import org.jboss.marshalling.MappingClassExternalizerFactory;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.junit.BeforeClass;

public class AbstractExternalizerTest {
    private static MarshallerFactory marshallerFactory;
    private static MarshallingConfiguration configuration;
    private static final Map<Class<?>, Externalizer> externalizersByClass;

    @BeforeClass
    public static void beforeAll() {
        marshallerFactory = Marshalling.getProvidedMarshallerFactory((String)"river");
        configuration = new MarshallingConfiguration();
        configuration.setVersion(3);
        AbstractExternalizerTest.addExternalizer(new DocumentExternalizer());
        AbstractExternalizerTest.addExternalizer(new ArrayExternalizer());
        AbstractExternalizerTest.addExternalizer(new PutOperation.Externalizer());
        AbstractExternalizerTest.addExternalizer(new PutIfAbsentOperation.Externalizer());
        AbstractExternalizerTest.addExternalizer(new RemoveOperation.Externalizer());
        AbstractExternalizerTest.addExternalizer(new AddValueOperation.Externalizer());
        AbstractExternalizerTest.addExternalizer(new AddValueIfAbsentOperation.Externalizer());
        AbstractExternalizerTest.addExternalizer(new ClearOperation.Externalizer());
        AbstractExternalizerTest.addExternalizer(new RemoveValueOperation.Externalizer());
        AbstractExternalizerTest.addExternalizer(new RemoveAllValuesOperation.Externalizer());
        AbstractExternalizerTest.addExternalizer(new RemoveAtIndexOperation.Externalizer());
        AbstractExternalizerTest.addExternalizer(new RetainAllValuesOperation.Externalizer());
        AbstractExternalizerTest.addExternalizer(new SetValueOperation.Externalizer());
        AbstractExternalizerTest.addExternalizer(new Paths.Externalizer());
        MappingClassExternalizerFactory externalizerFactory = new MappingClassExternalizerFactory(externalizersByClass);
        configuration.setClassExternalizerFactory((ClassExternalizerFactory)externalizerFactory);
    }

    protected static void addExternalizer(SchematicExternalizer<?> externalizer) {
        JBossExternalizerAdapter adapter = new JBossExternalizerAdapter(externalizer);
        for (Class clazz : externalizer.getTypeClasses()) {
            externalizersByClass.put(clazz, (Externalizer)adapter);
        }
    }

    protected static void addExternalizer(AdvancedExternalizer<?> externalizer) {
        JBossExternalizerAdapter adapter = new JBossExternalizerAdapter(externalizer);
        for (Class clazz : externalizer.getTypeClasses()) {
            externalizersByClass.put(clazz, (Externalizer)adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] marshall(Object object) throws IOException {
        Marshaller marshaller = marshallerFactory.createMarshaller(configuration);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            marshaller.start(Marshalling.createByteOutput((OutputStream)os));
            marshaller.writeObject(object);
            marshaller.finish();
            os.close();
        }
        finally {
            os.close();
        }
        return os.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object unmarshall(byte[] bytes) throws IOException, ClassNotFoundException {
        Unmarshaller unmarshaller = marshallerFactory.createUnmarshaller(configuration);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            unmarshaller.start(Marshalling.createByteInput((InputStream)is));
            Object result = unmarshaller.readObject();
            unmarshaller.finish();
            is.close();
            Object object = result;
            return object;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                System.err.print("Stream close failed: ");
                e.printStackTrace();
            }
        }
    }

    static {
        externalizersByClass = new HashMap();
    }
}

