/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import org.infinispan.schematic.FixFor;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.internal.document.JsonReader;
import org.infinispan.schematic.internal.document.JsonWriter;
import org.infinispan.schematic.internal.document.PrettyJsonWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonWriterTest {
    protected JsonWriter writer;
    protected JsonReader reader;
    protected boolean print;
    protected EditableDocument doc1;
    protected Document doc2;

    @Before
    public void beforeTest() {
        this.writer = new PrettyJsonWriter();
        this.reader = new JsonReader();
        this.print = false;
    }

    @After
    public void afterTest() {
        this.writer = null;
        this.reader = null;
        this.doc1 = null;
        this.doc2 = null;
    }

    @Test
    public void shouldWriteEmptyDocument() throws Exception {
        this.doc1 = Schematic.newDocument();
        String s = this.writer.write((Object)this.doc1);
        this.doc2 = this.reader.read(s);
        this.assertMatch((Document)this.doc1, this.doc2);
    }

    @Test
    public void shouldWriteDocumentWithOneField() throws Exception {
        this.doc1 = Schematic.newDocument((String)"field1", (Object)"value1");
        String s = this.writer.write((Object)this.doc1);
        this.doc2 = this.reader.read(s);
        this.assertMatch((Document)this.doc1, this.doc2);
    }

    @Test
    public void shouldWriteDocumentWithTwoFields() throws Exception {
        this.doc1 = Schematic.newDocument((String)"field1", (Object)"value1", (String)"field2", (Object)3);
        String s = this.writer.write((Object)this.doc1);
        this.doc2 = this.reader.read(s);
        this.assertMatch((Document)this.doc1, this.doc2);
    }

    @Test
    @FixFor(value={"MODE-2309"})
    public void shouldWriteDocumentWithEscapedCharacters() throws Exception {
        this.doc1 = Schematic.newDocument((String)"field1", (Object)"value1", (String)"field2", (Object)3);
        this.doc1.setString("field3", "This has\nmultiple\nlines");
        this.doc1.setString("field4", "This has\r\nmultiple\r\n lines");
        String s = this.writer.write((Object)this.doc1);
        this.doc2 = this.reader.read(s);
        this.assertMatch((Document)this.doc1, this.doc2);
    }

    @Test
    @FixFor(value={"MODE-2309"})
    public void shouldParseJsonWithNonAsciiCharactersInFields() throws Exception {
        this.doc1 = Schematic.newDocument();
        this.doc1.setString("field1", "basic ascii");
        this.doc1.setString("field2", "basic ascii with some arabic: \u0647\u0630\u0647 \u0647\u064a \u0642\u0635\u0629 \u0645\u0646 \u0645\u0643\u062a\u0628\u0629 \u0639\u0644\u0649 \u0627\u0644\u0634\u0627\u0631\u0639 \u0627\u0644\u0631\u0626\u064a\u0633\u064a");
        this.doc1.setString("field3", "basic ascii with some german: Dies ist die Geschichte von einer Buchhandlung an der Hauptstra\u00dfe");
        this.doc1.setString("field4", "basic ascii with some chinese: \u9019\u662f\u5728\u4e3b\u8981\u8857\u9053\u4e00\u5bb6\u66f8\u5e97\u7684\u6545\u4e8b");
        this.doc1.setString("Hauptstra\u00dfe", "Main street");
        String s = this.writer.write((Object)this.doc1);
        this.doc2 = this.reader.read(s);
        this.assertMatch((Document)this.doc1, this.doc2);
    }

    protected void assertMatch(Document doc1, Document doc2) {
        Assert.assertEquals((long)doc1.size(), (long)doc2.size());
        for (Document.Field field1 : doc1.fields()) {
            if (field1.getValue() instanceof Document) {
                this.assertMatch(field1.getValueAsDocument(), doc2.getDocument(field1.getName()));
                continue;
            }
            Object value2 = doc2.get(field1.getName());
            Assert.assertEquals((Object)field1.getValue(), (Object)value2);
        }
    }
}

