/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.cache.PropertyTypeUtil;
import org.modeshape.jcr.query.IndexRules;
import org.modeshape.jcr.query.model.AllNodes;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.query.validate.ImmutableSchemata;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.basic.LocalNamespaceRegistry;

@Immutable
public class NodeTypeSchemata
implements Schemata {
    protected static final boolean DEFAULT_CAN_CONTAIN_REFERENCES = true;
    protected static final boolean DEFAULT_FULL_TEXT_SEARCHABLE = true;
    private final Schemata schemata;
    private final Map<Integer, String> types;
    private final Map<String, String> prefixesByUris = new HashMap<String, String>();
    private final boolean includeColumnsForInheritedProperties;
    private final boolean includePseudoColumnsInSelectStar;
    private final NodeTypes nodeTypes;
    private final Map<JcrNodeType, Collection<JcrNodeType>> subtypesByName = new HashMap<JcrNodeType, Collection<JcrNodeType>>();
    private final IndexRules indexRules;
    private final List<JcrPropertyDefinition> pseudoProperties = new ArrayList<JcrPropertyDefinition>();

    NodeTypeSchemata(ExecutionContext context, NodeTypes nodeTypes, boolean includeColumnsForInheritedProperties, boolean includePseudoColumnsInSelectStar) {
        this.includeColumnsForInheritedProperties = includeColumnsForInheritedProperties;
        this.includePseudoColumnsInSelectStar = includePseudoColumnsInSelectStar;
        this.nodeTypes = nodeTypes;
        for (NamespaceRegistry.Namespace namespace : context.getNamespaceRegistry().getNamespaces()) {
            this.prefixesByUris.put(namespace.getNamespaceUri(), namespace.getPrefix());
        }
        for (JcrNodeType nodeType : nodeTypes.getAllNodeTypes()) {
            for (JcrNodeType supertype : nodeType.getTypeAndSupertypes()) {
                Collection<JcrNodeType> types = this.subtypesByName.get(supertype);
                if (types == null) {
                    types = new LinkedList<JcrNodeType>();
                    this.subtypesByName.put(supertype, types);
                }
                types.add(nodeType);
            }
        }
        TypeSystem typeSystem = context.getValueFactories().getTypeSystem();
        ImmutableSchemata.Builder builder = ImmutableSchemata.createBuilder(context);
        this.types = new HashMap<Integer, String>();
        this.types.put(2, typeSystem.getBinaryFactory().getTypeName());
        this.types.put(6, typeSystem.getBooleanFactory().getTypeName());
        this.types.put(5, typeSystem.getDateTimeFactory().getTypeName());
        this.types.put(12, typeSystem.getDecimalFactory().getTypeName());
        this.types.put(4, typeSystem.getDoubleFactory().getTypeName());
        this.types.put(3, typeSystem.getLongFactory().getTypeName());
        this.types.put(8, typeSystem.getStringFactory().getTypeName());
        this.types.put(9, typeSystem.getReferenceFactory().getTypeName());
        this.types.put(10, typeSystem.getReferenceFactory().getTypeName());
        this.types.put(100, typeSystem.getReferenceFactory().getTypeName());
        this.types.put(1, typeSystem.getStringFactory().getTypeName());
        this.types.put(7, typeSystem.getStringFactory().getTypeName());
        this.types.put(11, typeSystem.getStringFactory().getTypeName());
        this.pseudoProperties.add(this.pseudoProperty(context, JcrLexicon.PATH, 1));
        this.pseudoProperties.add(this.pseudoProperty(context, JcrLexicon.NAME, 1));
        this.pseudoProperties.add(this.pseudoProperty(context, JcrLexicon.SCORE, 4));
        this.pseudoProperties.add(this.pseudoProperty(context, ModeShapeLexicon.LOCALNAME, 1));
        this.pseudoProperties.add(this.pseudoProperty(context, ModeShapeLexicon.DEPTH, 3));
        IndexRules.Builder indexRulesBuilder = IndexRules.createBuilder(IndexRules.DEFAULT_RULES);
        indexRulesBuilder.defaultTo(Field.Store.NO, Field.Index.ANALYZED, true, true);
        this.addAllNodesTable(builder, indexRulesBuilder, context, this.pseudoProperties);
        for (JcrNodeType nodeType : nodeTypes.getAllNodeTypes()) {
            this.addView(builder, context, nodeType);
        }
        this.schemata = builder.build();
        this.indexRules = indexRulesBuilder.build();
    }

    protected JcrPropertyDefinition pseudoProperty(ExecutionContext context, Name name, int propertyType) {
        int opv = 5;
        boolean autoCreated = true;
        boolean mandatory = true;
        boolean isProtected = true;
        boolean multiple = false;
        boolean fullTextSearchable = false;
        boolean queryOrderable = true;
        JcrValue[] defaultValues = null;
        String[] valueConstraints = new String[]{};
        String[] queryOperators = null;
        return new JcrPropertyDefinition(context, null, null, name, opv, autoCreated, mandatory, isProtected, defaultValues, propertyType, valueConstraints, multiple, fullTextSearchable, queryOrderable, queryOperators);
    }

    public IndexRules getIndexRules() {
        return this.indexRules;
    }

    public NodeTypes getNodeTypes() {
        return this.nodeTypes;
    }

    protected JcrNodeType getNodeType(Name nodeTypeName) {
        return this.nodeTypes.getNodeType(nodeTypeName);
    }

    protected final void addAllNodesTable(ImmutableSchemata.Builder builder, IndexRules.Builder indexRuleBuilder, ExecutionContext context, List<JcrPropertyDefinition> additionalProperties) {
        String previousType;
        String type;
        NamespaceRegistry registry = context.getNamespaceRegistry();
        TypeSystem typeSystem = context.getValueFactories().getTypeSystem();
        String tableName = AllNodes.ALL_NODES_NAME.name();
        boolean first = true;
        HashMap<String, String> typesForNames = new HashMap<String, String>();
        HashSet<String> fullTextSearchableNames = new HashSet<String>();
        for (JcrPropertyDefinition defn : this.nodeTypes.getAllPropertyDefinitions()) {
            boolean fullTextSearchable;
            if (defn.isResidual()) continue;
            Name name = defn.getInternalName();
            String columnName = name.getString(registry);
            if (first) {
                builder.addTable(tableName, columnName);
                first = false;
            }
            boolean canBeReference = false;
            boolean isStrongReference = false;
            PropertyType requiredType = PropertyTypeUtil.modePropertyTypeFor(defn.getRequiredType());
            switch (defn.getRequiredType()) {
                case 9: {
                    canBeReference = true;
                    isStrongReference = true;
                    break;
                }
                case 0: 
                case 10: 
                case 100: {
                    canBeReference = true;
                    requiredType = PropertyType.STRING;
                }
            }
            type = typeSystem.getDefaultType();
            if (defn.getRequiredType() != 0) {
                type = this.types.get(defn.getRequiredType());
            }
            assert (type != null);
            previousType = typesForNames.put(columnName, type);
            if (previousType != null && !previousType.equals(type)) {
                type = typeSystem.getCompatibleType(previousType, type);
            }
            boolean bl = fullTextSearchable = fullTextSearchableNames.contains(columnName) || defn.isFullTextSearchable();
            if (fullTextSearchable) {
                fullTextSearchableNames.add(columnName);
            }
            boolean orderable = defn.isQueryOrderable();
            Set<Operator> operators = this.operatorsFor(defn);
            Object minimum = defn.getMinimumValue();
            Object maximum = defn.getMaximumValue();
            builder.addColumn(tableName, columnName, type, requiredType, fullTextSearchable, orderable, minimum, maximum, operators);
            if (indexRuleBuilder == null) continue;
            this.addIndexRule(indexRuleBuilder, defn, type, typeSystem, canBeReference, isStrongReference);
        }
        if (additionalProperties != null) {
            boolean canBeReference = false;
            boolean isStrongReference = false;
            boolean fullTextSearchable = false;
            for (JcrPropertyDefinition defn : additionalProperties) {
                Name name = defn.getInternalName();
                String columnName = name.getString(registry);
                assert (defn.getRequiredType() != 0);
                type = this.types.get(defn.getRequiredType());
                assert (type != null);
                previousType = typesForNames.put(columnName, type);
                if (previousType != null && !previousType.equals(type)) {
                    type = typeSystem.getCompatibleType(previousType, type);
                }
                boolean orderable = defn.isQueryOrderable();
                Set<Operator> operators = this.operatorsFor(defn);
                Object minimum = defn.getMinimumValue();
                Object maximum = defn.getMaximumValue();
                PropertyType requiredType = PropertyTypeUtil.modePropertyTypeFor(defn.getRequiredType());
                builder.addColumn(tableName, columnName, type, requiredType, fullTextSearchable, orderable, minimum, maximum, operators);
                if (!this.includePseudoColumnsInSelectStar) {
                    builder.excludeFromSelectStar(tableName, columnName);
                }
                if (indexRuleBuilder == null) continue;
                this.addIndexRule(indexRuleBuilder, defn, type, typeSystem, canBeReference, isStrongReference);
            }
        }
    }

    protected Set<Operator> operatorsFor(JcrPropertyDefinition defn) {
        String[] ops = defn.getAvailableQueryOperators();
        if (ops == null || ops.length == 0) {
            return EnumSet.allOf(Operator.class);
        }
        HashSet<Operator> result = new HashSet<Operator>();
        for (String symbol : ops) {
            Operator op = JcrPropertyDefinition.operatorFromSymbol(symbol);
            assert (op != null);
            result.add(op);
        }
        return result;
    }

    protected final void addIndexRule(IndexRules.Builder builder, JcrPropertyDefinition defn, String type, TypeSystem typeSystem, boolean canBeReference, boolean isStrongReference) {
        Field.Index index;
        Field.Store store = Field.Store.YES;
        Field.Index index2 = index = defn.isFullTextSearchable() ? Field.Index.ANALYZED : Field.Index.NO;
        if (typeSystem.getStringFactory().getTypeName().equals(type)) {
            builder.stringField(defn.getInternalName(), store, index, canBeReference, defn.isFullTextSearchable());
        } else if (typeSystem.getDateTimeFactory().getTypeName().equals(type)) {
            Long minimum = typeSystem.getLongFactory().create(defn.getMinimumValue());
            Long maximum = typeSystem.getLongFactory().create(defn.getMaximumValue());
            builder.dateField(defn.getInternalName(), store, index, minimum, maximum);
        } else if (typeSystem.getLongFactory().getTypeName().equals(type)) {
            Long minimum = typeSystem.getLongFactory().create(defn.getMinimumValue());
            Long maximum = typeSystem.getLongFactory().create(defn.getMaximumValue());
            builder.longField(defn.getInternalName(), store, index, minimum, maximum);
        } else if (typeSystem.getDoubleFactory().getTypeName().equals(type)) {
            Double minimum = typeSystem.getDoubleFactory().create(defn.getMinimumValue());
            Double maximum = typeSystem.getDoubleFactory().create(defn.getMaximumValue());
            builder.doubleField(defn.getInternalName(), store, index, minimum, maximum);
        } else if (typeSystem.getBooleanFactory().getTypeName().equals(type)) {
            builder.booleanField(defn.getInternalName(), store, index);
        } else if (typeSystem.getBinaryFactory().getTypeName().equals(type)) {
            store = Field.Store.NO;
            builder.binaryField(defn.getInternalName(), store, index, defn.isFullTextSearchable());
        } else if (typeSystem.getReferenceFactory().getTypeName().equals(type)) {
            store = Field.Store.NO;
            builder.referenceField(defn.getInternalName(), store, index);
        } else if (typeSystem.getPathFactory().getTypeName().equals(type)) {
            builder.pathField(defn.getInternalName(), store, index);
        } else {
            builder.stringField(defn.getInternalName(), store, index, canBeReference, defn.isFullTextSearchable());
        }
    }

    protected final void addView(ImmutableSchemata.Builder builder, ExecutionContext context, JcrNodeType nodeType) {
        NamespaceRegistry registry = context.getNamespaceRegistry();
        if (!nodeType.isQueryable()) {
            return;
        }
        String tableName = nodeType.getName();
        JcrPropertyDefinition[] defns = null;
        defns = this.includeColumnsForInheritedProperties ? nodeType.getPropertyDefinitions() : nodeType.getDeclaredPropertyDefinitions();
        StringBuilder viewDefinition = new StringBuilder("SELECT ");
        boolean hasResidualProperties = false;
        boolean first = true;
        for (JcrPropertyDefinition defn : defns) {
            if (defn.isResidual()) {
                hasResidualProperties = true;
                continue;
            }
            Name name = defn.getInternalName();
            String columnName = name.getString(registry);
            if (first) {
                first = false;
            } else {
                viewDefinition.append(',');
            }
            viewDefinition.append('[').append(columnName).append(']');
            if (!defn.isQueryOrderable()) {
                builder.markOrderable(tableName, columnName, false);
            }
            builder.markOperators(tableName, columnName, this.operatorsFor(defn));
        }
        for (JcrPropertyDefinition defn : this.pseudoProperties) {
            Name name = defn.getInternalName();
            String columnName = name.getString(registry);
            if (first) {
                first = false;
            } else {
                viewDefinition.append(',');
            }
            viewDefinition.append('[').append(columnName).append(']');
            builder.markOperators(tableName, columnName, this.operatorsFor(defn));
        }
        if (first) {
            return;
        }
        viewDefinition.append(" FROM ").append(AllNodes.ALL_NODES_NAME).append(" AS [").append(tableName).append(']');
        if (!JcrNtLexicon.BASE.equals(nodeType.getInternalName())) {
            viewDefinition.append(" WHERE ");
            int mixinTypeCount = 0;
            int primaryTypeCount = 0;
            StringBuilder mixinTypes = new StringBuilder();
            StringBuilder primaryTypes = new StringBuilder();
            Collection<JcrNodeType> typeAndSubtypes = this.subtypesByName.get(nodeType);
            for (JcrNodeType thisOrSupertype : typeAndSubtypes) {
                String name;
                if (thisOrSupertype.isMixin()) {
                    if (mixinTypeCount > 0) {
                        mixinTypes.append(',');
                    }
                    assert (this.prefixesByUris.containsKey(thisOrSupertype.getInternalName().getNamespaceUri()));
                    name = thisOrSupertype.getInternalName().getString(registry);
                    mixinTypes.append('[').append(name).append(']');
                    ++mixinTypeCount;
                    continue;
                }
                if (primaryTypeCount > 0) {
                    primaryTypes.append(',');
                }
                assert (this.prefixesByUris.containsKey(thisOrSupertype.getInternalName().getNamespaceUri()));
                name = thisOrSupertype.getInternalName().getString(registry);
                primaryTypes.append('[').append(name).append(']');
                ++primaryTypeCount;
            }
            if (primaryTypeCount > 0) {
                viewDefinition.append('[').append(JcrLexicon.PRIMARY_TYPE.getString(registry)).append(']');
                if (primaryTypeCount == 1) {
                    viewDefinition.append('=').append((CharSequence)primaryTypes);
                } else {
                    viewDefinition.append(" IN (").append((CharSequence)primaryTypes).append(')');
                }
            }
            if (mixinTypeCount > 0) {
                if (primaryTypeCount > 0) {
                    viewDefinition.append(" OR ");
                }
                viewDefinition.append('[').append(JcrLexicon.MIXIN_TYPES.getString(registry)).append(']');
                if (mixinTypeCount == 1) {
                    viewDefinition.append('=').append((CharSequence)mixinTypes);
                } else {
                    viewDefinition.append(" IN (").append((CharSequence)mixinTypes).append(')');
                }
            }
        }
        builder.addView(tableName, viewDefinition.toString());
        if (hasResidualProperties) {
            builder.markExtraColumns(tableName);
        }
    }

    @Override
    public Schemata.Table getTable(SelectorName name) {
        return this.schemata.getTable(name);
    }

    public Schemata getSchemataForSession(JcrSession session) {
        assert (session != null);
        if (!this.overridesNamespaceMappings(session)) {
            return this;
        }
        return new SessionSchemata(session);
    }

    private boolean overridesNamespaceMappings(JcrSession session) {
        NamespaceRegistry registry = session.context().getNamespaceRegistry();
        if (registry instanceof LocalNamespaceRegistry) {
            Set<NamespaceRegistry.Namespace> localNamespaces = ((LocalNamespaceRegistry)registry).getLocalNamespaces();
            if (localNamespaces.isEmpty()) {
                return false;
            }
            for (NamespaceRegistry.Namespace namespace : localNamespaces) {
                if (!this.prefixesByUris.containsKey(namespace.getNamespaceUri())) continue;
                return true;
            }
            return false;
        }
        for (NamespaceRegistry.Namespace namespace : registry.getNamespaces()) {
            String expectedPrefix = this.prefixesByUris.get(namespace.getNamespaceUri());
            if (expectedPrefix == null || namespace.getPrefix().equals(expectedPrefix)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.schemata.toString();
    }

    @NotThreadSafe
    protected class SessionSchemata
    implements Schemata {
        private final JcrSession session;
        private final ExecutionContext context;
        private final ImmutableSchemata.Builder builder;
        private final NameFactory nameFactory;
        private Schemata schemata;

        protected SessionSchemata(JcrSession session) {
            this.session = session;
            this.context = this.session.context();
            this.nameFactory = this.context.getValueFactories().getNameFactory();
            this.builder = ImmutableSchemata.createBuilder(this.context);
            NodeTypeSchemata.this.addAllNodesTable(this.builder, null, this.context, null);
            this.schemata = this.builder.build();
        }

        @Override
        public Schemata.Table getTable(SelectorName name) {
            Schemata.Table table = this.schemata.getTable(name);
            if (table == null) {
                Name nodeTypeName = (Name)this.nameFactory.create(name.name());
                JcrNodeType nodeType = NodeTypeSchemata.this.getNodeType(nodeTypeName);
                if (nodeType == null) {
                    return null;
                }
                NodeTypeSchemata.this.addView(this.builder, this.context, nodeType);
                this.schemata = this.builder.build();
            }
            return this.schemata.getTable(name);
        }
    }
}

