/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.security.acl;

import java.util.HashMap;
import javax.jcr.Session;
import javax.jcr.security.Privilege;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.security.acl.PrivilegeImpl;

public class Privileges {
    private PrivilegeImpl addChildNodes;
    private PrivilegeImpl lifeCycleManagement;
    private PrivilegeImpl lockManagement;
    private PrivilegeImpl modifyAccessControl;
    private PrivilegeImpl modifyProperties;
    private PrivilegeImpl nodeTypeManagement;
    private PrivilegeImpl read;
    private PrivilegeImpl readAccessControl;
    private PrivilegeImpl removeChildNodes;
    private PrivilegeImpl removeNode;
    private PrivilegeImpl retentionManagement;
    private PrivilegeImpl versionManagement;
    private PrivilegeImpl write;
    private PrivilegeImpl all;
    private final HashMap<String, PrivilegeImpl> privileges = new HashMap();
    private final PrivilegeImpl[] applicablePrivileges;
    private final HashMap<String, PrivilegeImpl> actions = new HashMap();

    public Privileges(JcrSession session) {
        this.addChildNodes = new PrivilegeImpl((Session)session, "{http://www.jcp.org/jcr/1.0}addChildNodes", new Privilege[0]);
        this.lifeCycleManagement = new PrivilegeImpl((Session)session, "{http://www.jcp.org/jcr/1.0}lifecycleManagement", new Privilege[0]);
        this.lockManagement = new PrivilegeImpl((Session)session, "{http://www.jcp.org/jcr/1.0}lockManagement", new Privilege[0]);
        this.modifyAccessControl = new PrivilegeImpl((Session)session, "{http://www.jcp.org/jcr/1.0}modifyAccessControl", new Privilege[0]);
        this.modifyProperties = new PrivilegeImpl((Session)session, "{http://www.jcp.org/jcr/1.0}modifyProperties", new Privilege[0]);
        this.nodeTypeManagement = new PrivilegeImpl((Session)session, "{http://www.jcp.org/jcr/1.0}nodeTypeManagement", new Privilege[0]);
        this.read = new PrivilegeImpl((Session)session, "{http://www.jcp.org/jcr/1.0}read", new Privilege[0]);
        this.readAccessControl = new PrivilegeImpl((Session)session, "{http://www.jcp.org/jcr/1.0}readAccessControl", new Privilege[0]);
        this.removeChildNodes = new PrivilegeImpl((Session)session, "{http://www.jcp.org/jcr/1.0}removeChildNodes", new Privilege[0]);
        this.removeNode = new PrivilegeImpl((Session)session, "{http://www.jcp.org/jcr/1.0}removeNode", new Privilege[0]);
        this.retentionManagement = new PrivilegeImpl((Session)session, "{http://www.jcp.org/jcr/1.0}retentionManagement", new Privilege[0]);
        this.versionManagement = new PrivilegeImpl((Session)session, "{http://www.jcp.org/jcr/1.0}versionManagement", new Privilege[0]);
        this.write = new PrivilegeImpl((Session)session, "{http://www.jcp.org/jcr/1.0}write", new Privilege[]{this.modifyProperties, this.addChildNodes, this.removeNode, this.removeChildNodes});
        this.all = new PrivilegeImpl((Session)session, "{http://www.jcp.org/jcr/1.0}all", new Privilege[]{this.read, this.write, this.readAccessControl, this.modifyAccessControl, this.lockManagement, this.lifeCycleManagement, this.versionManagement, this.nodeTypeManagement, this.retentionManagement});
        this.privileges.clear();
        this.applicablePrivileges = session.isReadOnly() ? new PrivilegeImpl[]{this.read, this.readAccessControl} : new PrivilegeImpl[]{this.all, this.addChildNodes, this.lifeCycleManagement, this.lockManagement, this.modifyAccessControl, this.modifyProperties, this.nodeTypeManagement, this.removeChildNodes, this.removeNode, this.retentionManagement, this.versionManagement, this.write, this.read, this.readAccessControl};
        this.privileges.put(this.addChildNodes.localName(), this.addChildNodes);
        this.privileges.put(this.all.localName(), this.all);
        this.privileges.put(this.lifeCycleManagement.localName(), this.lifeCycleManagement);
        this.privileges.put(this.lockManagement.localName(), this.lockManagement);
        this.privileges.put(this.modifyAccessControl.localName(), this.modifyAccessControl);
        this.privileges.put(this.modifyProperties.localName(), this.modifyProperties);
        this.privileges.put(this.nodeTypeManagement.localName(), this.nodeTypeManagement);
        this.privileges.put(this.removeChildNodes.localName(), this.removeChildNodes);
        this.privileges.put(this.removeNode.localName(), this.removeNode);
        this.privileges.put(this.retentionManagement.localName(), this.retentionManagement);
        this.privileges.put(this.versionManagement.localName(), this.versionManagement);
        this.privileges.put(this.write.localName(), this.write);
        this.privileges.put(this.read.localName(), this.read);
        this.privileges.put(this.readAccessControl.localName(), this.readAccessControl);
        this.actions.clear();
        this.actions.put("add_node", this.addChildNodes);
        this.actions.put("modify_access_control", this.modifyAccessControl);
        this.actions.put("set_property", this.modifyProperties);
        this.actions.put("register_type", this.nodeTypeManagement);
        this.actions.put("read", this.read);
        this.actions.put("read_access_control", this.readAccessControl);
        this.actions.put("remove_child_nodes", this.removeChildNodes);
        this.actions.put("remove", this.removeNode);
    }

    public Privilege[] listOfSupported() {
        return this.applicablePrivileges;
    }

    public PrivilegeImpl forName(String name) {
        if (name.contains("}")) {
            String localName = name.substring(name.indexOf(125) + 1);
            return this.privileges.get(localName);
        }
        if (name.contains(":")) {
            String localName = name.substring(name.indexOf(58) + 1);
            PrivilegeImpl p = this.privileges.get(localName);
            return p.getName().equals(name) ? p : null;
        }
        return null;
    }

    public PrivilegeImpl forAction(String action) {
        return this.actions.get(action);
    }
}

