/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.util.StringUtil;
import org.modeshape.sequencer.ddl.DdlConstants;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.datatype.DataTypeParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlConstants;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParsingException;
import org.modeshape.sequencer.ddl.node.AstNode;
import org.modeshape.sequencer.ddl.node.AstNodeFactory;

abstract class StatementParser
implements DdlConstants {
    static final String[] NOT_NULL = new String[]{"NOT", "NULL"};
    protected Logger logger = Logger.getLogger(this.getClass());
    private final TeiidDdlParser teiidDdlParser;

    protected StatementParser(TeiidDdlParser teiidDdlParser) {
        this.teiidDdlParser = teiidDdlParser;
    }

    protected void addNamespaceAlias(String alias, String identifier) {
        this.teiidDdlParser.addNamespaceAlias(alias, identifier);
    }

    protected final DataTypeParser getDataTypeParser() {
        return this.teiidDdlParser.getDatatypeParser();
    }

    final String getNamespaceUri(String alias) {
        return this.teiidDdlParser.getNamespaceUri(alias);
    }

    protected final AstNodeFactory getNodeFactory() {
        return this.teiidDdlParser.nodeFactory();
    }

    protected AstNode getNode(AstNode rootNode, String nodeName, String ... nodeTypes) {
        assert (rootNode != null);
        assert (nodeName != null && !nodeName.isEmpty());
        assert (nodeTypes != null && nodeTypes.length != 0);
        List<AstNode> kids = rootNode.childrenWithName(nodeName);
        if (kids.isEmpty()) {
            return null;
        }
        for (AstNode kid : kids) {
            for (String nodeType : nodeTypes) {
                if (!kid.getMixins().contains(nodeType) && !nodeType.equals(kid.getPrimaryType())) continue;
                return kid;
            }
        }
        return null;
    }

    protected String getWhitespace(Position current, Position previous, String prevValue) {
        int i;
        int currIndent = current.getIndexInContent();
        int currLine = current.getLine();
        int prevIndent = previous.getIndexInContent();
        int prevLine = previous.getLine();
        int lfCount = currLine - prevLine;
        int whitespaceCount = 0;
        if (currIndent > prevIndent) {
            whitespaceCount = currIndent - prevValue.length() - prevIndent - lfCount;
        } else if (prevIndent > currIndent) {
            whitespaceCount = prevIndent + prevValue.length() - currIndent;
        }
        if (lfCount == 0 && whitespaceCount == 0) {
            return "";
        }
        StringBuilder whitespace = new StringBuilder();
        if (lfCount > 0) {
            for (i = 0; i < lfCount; ++i) {
                whitespace.append('\n');
            }
        }
        if (whitespaceCount > 0) {
            for (i = 0; i < whitespaceCount; ++i) {
                whitespace.append(' ');
            }
        }
        return whitespace.toString();
    }

    abstract boolean matches(DdlTokenStream var1);

    abstract AstNode parse(DdlTokenStream var1, AstNode var2) throws ParsingException;

    protected boolean parseDefaultClause(DdlTokenStream tokens, AstNode columnNode) {
        return this.teiidDdlParser.accessParseDefaultClause(tokens, columnNode);
    }

    String parseIdentifier(DdlTokenStream tokens) {
        boolean quoted = tokens.matches(16) || tokens.matches(8);
        String id = tokens.consume();
        if (quoted) {
            id = id.substring(1, id.length() - 1);
        }
        if (tokens.canConsume(':')) {
            String uri = this.teiidDdlParser.getNamespaceUri(id);
            id = StringUtil.isBlank((String)uri) ? id + ':' + tokens.consume() : '{' + uri + '}' + tokens.consume();
        } else {
            String prefix;
            String uri;
            int index = id.indexOf(58);
            if (index != -1 && !StringUtil.isBlank((String)(uri = this.teiidDdlParser.getNamespaceUri(prefix = id.substring(0, index))))) {
                id = '{' + uri + '}' + id.substring(index + 1);
            }
        }
        if (tokens.canConsume('.')) {
            id = id + '.' + this.parseIdentifier(tokens);
        }
        return id;
    }

    boolean parseOptionsClause(DdlTokenStream tokens, Map<String, String> optionsMap) {
        if (tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.OPTIONS.toDdl()) && tokens.canConsume("(")) {
            String key = this.parseIdentifier(tokens);
            String value = this.parseValue(tokens);
            if (!StringUtil.isBlank((String)value)) {
                optionsMap.put(key, value);
            }
            while (tokens.canConsume(",")) {
                String nextKey = this.parseIdentifier(tokens);
                String nextValue = this.parseValue(tokens);
                if (StringUtil.isBlank((String)nextValue)) continue;
                optionsMap.put(nextKey, nextValue);
            }
            if (tokens.canConsume(")")) {
                return true;
            }
            throw new TeiidDdlParsingException(tokens, "Unparsable options clause");
        }
        return false;
    }

    void createOptionNodes(Map<String, String> options, AstNode parentNode) {
        assert (parentNode != null);
        if (options != null && !options.isEmpty()) {
            for (Map.Entry<String, String> optionEntry : options.entrySet()) {
                AstNode optionNode = this.getNodeFactory().node(optionEntry.getKey(), parentNode, "ddl:statementOption");
                optionNode.setProperty("ddl:value", (Object)optionEntry.getValue());
            }
        }
    }

    boolean parseOptionsClause(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        HashMap<String, String> options = new HashMap<String, String>();
        if (this.parseOptionsClause(tokens, options)) {
            this.createOptionNodes(options, parentNode);
            return true;
        }
        return false;
    }

    protected String parseUntilTerminator(DdlTokenStream tokens) {
        return this.teiidDdlParser.accessParseUntilTerminator(tokens);
    }

    protected String parseUntilTerminatorIgnoreEmbeddedStatements(DdlTokenStream tokens) {
        return this.teiidDdlParser.accessParseUntilTerminatorIgnoreEmbeddedStatements(tokens);
    }

    protected String parseValue(DdlTokenStream tokens) {
        boolean quoted = tokens.matches(16) || tokens.matches(8);
        String id = tokens.consume();
        if (quoted) {
            return id.substring(1, id.length() - 1);
        }
        return id;
    }

    abstract void postProcess(AstNode var1);
}

