/*
 * JBoss; Home of Professional Open Source.
*
* See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.
*
* See the AUTHORS.txt file distributed with this work for a full listing of individual contributors.
*/
package org.komodo.shell;

import org.komodo.utils.i18n.I18n;

/**
 * Localized messages for the {@link org.komodo.shell} package.
 */
@SuppressWarnings( "javadoc" )
public final class ShellI18n extends I18n {

    public static String addChildExamples;
    public static String addChildHelp;
    public static String addChildUsage;

    public static String addDescriptorExamples;
    public static String addDescriptorHelp;
    public static String addDescriptorUsage;

    public static String cdExamples;
    public static String cdHelp;
    public static String cdUsage;

    public static String commitExamples;
    public static String commitHelp;
    public static String commitUsage;

    public static String deleteChildExamples;
    public static String deleteChildHelp;
    public static String deleteChildUsage;

    public static String exitExamples;
    public static String exitHelp;
    public static String exitUsage;

    public static String helpExamples;
    public static String helpHelp;
    public static String helpUsage;

    public static String homeExamples;
    public static String homeHelp;
    public static String homeUsage;

    public static String libraryExamples;
    public static String libraryHelp;
    public static String libraryUsage;

    public static String listExamples;
    public static String listHelp;
    public static String listUsage;

    public static String playExamples;
    public static String playHelp;
    public static String playUsage;

    public static String removeDescriptorExamples;
    public static String removeDescriptorHelp;
    public static String removeDescriptorUsage;

    public static String renameExamples;
    public static String renameHelp;
    public static String renameUsage;

    public static String rollbackExamples;
    public static String rollbackHelp;
    public static String rollbackUsage;

    public static String setAutoCommitExamples;
    public static String setAutoCommitHelp;
    public static String setAutoCommitUsage;

    public static String setGlobalPropertyExamples;
    public static String setGlobalPropertyHelp;
    public static String setGlobalPropertyUsage;

    public static String resetGlobalPropertyExamples;
    public static String resetGlobalPropertyHelp;
    public static String resetGlobalPropertyUsage;

    public static String setPrimaryTypeExamples;
    public static String setPrimaryTypeHelp;
    public static String setPrimaryTypeUsage;

    public static String setPropertyExamples;
    public static String setPropertyHelp;
    public static String setPropertyUsage;

    public static String setRecordExamples;
    public static String setRecordHelp;
    public static String setRecordUsage;

    public static String showChildrenExamples;
    public static String showChildrenHelp;
    public static String showChildrenUsage;

    public static String showDescriptorsExamples;
    public static String showDescriptorsHelp;
    public static String showDescriptorsUsage;

    public static String showGlobalExamples;
    public static String showGlobalHelp;
    public static String showGlobalUsage;

    public static String showPropertiesExamples;
    public static String showPropertiesHelp;
    public static String showPropertiesUsage;

    public static String showPropertyExamples;
    public static String showPropertyHelp;
    public static String showPropertyUsage;

    public static String showStatusExamples;
    public static String showStatusHelp;
    public static String showStatusUsage;

    public static String showSummaryExamples;
    public static String showSummaryHelp;
    public static String showSummaryUsage;

    public static String unsetPropertyExamples;
    public static String unsetPropertyHelp;
    public static String unsetPropertyUsage;

    public static String workspaceExamples;
    public static String workspaceHelp;
    public static String workspaceUsage;

    public static String cannotRenameKomodoRoot;
    public static String cannotRenameObjectDoesNotExist;
    public static String cannotRenameReservedPath;
    public static String cannotRenameTargetContextDoesNotExist;
    public static String cannotRenameWouldCreateDuplicate;
    public static String childAdded;
    public static String childDeleted;
    public static String childDoesNotExistToRename;
    public static String childNameHeader;
    public static String childrenHeader;
    public static String childTypeHeader;
    public static String commandFailure;
    public static String commandIsDisabled;
    public static String commandNotFound;
    public static String commitSuccess;
    public static String componentStarted;
    public static String currentContext;
    public static String currentRepoName;
    public static String currentRepoUrl;
    public static String descriptorAdded;
    public static String descriptorRemoved;
    public static String disabledCommandMethodNotSupported;
    public static String enable_flag_missing;
    public static String engineStarting;
    public static String errorGettingChild;
    public static String errorLoadingProperties;
    public static String exitCanceled;
    public static String fileArgNotAFile;
    public static String fileCannotRead;
    public static String fileExecuted;
    public static String fileNotAccessible;
    public static String fileNotFound;
    public static String fileShellCommandReaderNoConsole;
    public static String globalPropertiesHeader;
    public static String globalPropertySet;
    public static String globalPropertyReset;
    public static String globalResetAllProps;
    public static String goodBye;
    public static String helpAliasesHeading;
    public static String helpCategoryHeader;
    public static String helpCommandListMsg;
    public static String helpDescriptionHeading;
    public static String helpExamplesHeading;
    public static String helpGetHelp1;
    public static String helpGetHelp2;
    public static String helpInvalidCommand;
    public static String helpNoAliases;
    public static String helpUsageHeading;
    public static String invalidArg;
    public static String invalidArgMsgEntryPath;
    public static String invalidArgMsgFileName;
    public static String invalidArgMsgGlobalPropertyName;
    public static String invalidArgMsgResetGlobalPropertyName;
    public static String invalidArgMsgNewName;
    public static String invalidArgMsgObjectName;
    public static String invalidArgMsgPropertiesFileNotExist;
    public static String invalidArgMsgPropertyName;
    public static String invalidArgMsgPropertyNotCorrectFormat;
    public static String invalidArgMsgPropertyValue;
    public static String invalidBooleanGlobalPropertyValue;
    public static String invalidCommandForContext;
    public static String invalidExitArg;
    public static String invalidGlobalProperty;
    public static String invalidGlobalPropertyCannotReset;
    public static String invalidGlobalPropertyName;
    public static String invalidNumericGlobalPropertyValue;
    public static String invalidPropName;
    public static String invalidPropValue;
    public static String invalidStartupArgs;
    public static String invalidStartupFile;
    public static String internalError;
    public static String listHeader;
    public static String localRepositoryStarting;
    public static String localRepositoryTimeoutError;
    public static String locationArgEmpty;
    public static String locationArgNoContextWithThisName;
    public static String missingChildNameForAdd;
    public static String missingChildNameForDelete;
    public static String missingDescriptorNameForAdd;
    public static String missingDescriptorNameForDelete;
    public static String missingRenameFirstArg;
    public static String missingTypeName;
    public static String noChildrenMsg;
    public static String noChildWithName;
    public static String noChildWithNameAndType;
    public static String noDescriptors;
    public static String noPropertiesMsg;
    public static String noPropertyValue;
    public static String notMultiValuedProperty;
    public static String objectRenamed;
    public static String onOffArgEmpty;
    public static String onOffArgInvalid;
    public static String playFailure;
    public static String primaryTypeSet;
    public static String propertiesHeader;
    public static String propertyDefaultValueHeader;
    public static String propertyHeader;
    public static String propertyNameHeader;
    public static String propertySet;
    public static String propertyValueHeader;
    public static String recordingFileCannotWrite;
    public static String recordingFileNotDefined;
    public static String recordingFileNotSet;
    public static String recordingFileOutputError;
    public static String recordingFileProblem;
    public static String renameNewNameNotDifferent;
    public static String rollbackSuccess;
    public static String setRecordingStateMsg;
    public static String shuttingDown;
    public static String tooManyArgs;
    public static String transactionCommitError;
    public static String transactionRollbackError;
    public static String transactionTimeout;
    public static String propertyUnset;
    public static String usage;
    public static String welcomeMessage;
    public static String errorLoadingVersion;
    public static String errorObtainingVersion;

    static {
        final ShellI18n i18n = new ShellI18n();
        i18n.initialize();
    }

    /**
     * Don't allow construction outside of this class.
     */
    private ShellI18n() {
        // nothing to do
    }

}
