/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.federation.spi;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.transaction.TransactionManager;
import org.infinispan.schematic.DocumentFactory;
import org.infinispan.schematic.document.Document;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.federation.ConnectorChangeSetFactory;
import org.modeshape.jcr.federation.FederatedDocumentReader;
import org.modeshape.jcr.federation.FederatedDocumentWriter;
import org.modeshape.jcr.federation.spi.ConnectorChangeSet;
import org.modeshape.jcr.federation.spi.DocumentChanges;
import org.modeshape.jcr.federation.spi.DocumentReader;
import org.modeshape.jcr.federation.spi.DocumentWriter;
import org.modeshape.jcr.federation.spi.ExtraPropertiesStore;
import org.modeshape.jcr.federation.spi.PageKey;
import org.modeshape.jcr.federation.spi.PageWriter;
import org.modeshape.jcr.mimetype.MimeTypeDetector;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.binary.ExternalBinaryValue;

public abstract class Connector {
    private Logger logger;
    private org.modeshape.jcr.api.Logger simpleLogger;
    private String name;
    private String repositoryName;
    private ExecutionContext context;
    private MimeTypeDetector mimeTypeDetector;
    private Integer cacheTtlSeconds;
    private boolean queryable = true;
    private boolean initialized = false;
    private DocumentTranslator translator;
    private ExtraPropertiesStore extraPropertiesStore;
    private TransactionManager transactionManager;
    private ConnectorChangeSetFactory connectorChangedSetFactory;
    private Environment environment;

    public String getSourceName() {
        return this.name;
    }

    public final String getRepositoryName() {
        return this.repositoryName;
    }

    public final Logger getLogger() {
        return this.logger;
    }

    public final org.modeshape.jcr.api.Logger log() {
        return this.simpleLogger;
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    public MimeTypeDetector getMimeTypeDetector() {
        return this.mimeTypeDetector;
    }

    public Integer getCacheTtlSeconds() {
        return this.cacheTtlSeconds;
    }

    public Boolean isQueryable() {
        return this.queryable;
    }

    protected ExtraProperties extraPropertiesFor(String id, boolean update) {
        return new ExtraProperties(id, update);
    }

    protected ExtraPropertiesStore extraPropertiesStore() {
        return this.extraPropertiesStore;
    }

    protected void setExtraPropertiesStore(ExtraPropertiesStore customExtraPropertiesStore) {
        CheckArg.isNotNull((Object)customExtraPropertiesStore, (String)"customExtraPropertiesStore");
        this.extraPropertiesStore = customExtraPropertiesStore;
    }

    protected TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        assert (!this.initialized) : "The Connector.initialize(...) method should not be called by subclasses; ModeShape has already (and automatically) initialized the Connector";
    }

    private void postInitialize() {
        if (!this.initialized) {
            this.initialized = true;
        }
    }

    public void shutdown() {
    }

    public abstract Document getDocumentById(String var1);

    public abstract String getDocumentId(String var1);

    public abstract Collection<String> getDocumentPathsById(String var1);

    public abstract boolean isReadonly();

    public Document getChildReference(String parentKey, String childKey) {
        return null;
    }

    public ExternalBinaryValue getBinaryValue(String id) {
        return null;
    }

    public abstract boolean removeDocument(String var1);

    public abstract boolean hasDocument(String var1);

    public abstract void storeDocument(Document var1);

    public abstract void updateDocument(DocumentChanges var1);

    public abstract String newDocumentId(String var1, Name var2, Name var3);

    protected void checkFieldNotNull(Object fieldValue, String fieldName) throws RepositoryException {
        if (fieldValue == null) {
            throw new RepositoryException(JcrI18n.requiredFieldNotSetInConnector.text(new Object[]{this.getSourceName(), this.getClass(), fieldName}));
        }
    }

    protected DocumentTranslator translator() {
        return this.translator;
    }

    protected DocumentReader readDocument(Document document) {
        return new FederatedDocumentReader(this.translator, document);
    }

    protected DocumentWriter newDocument(String id) {
        return new FederatedDocumentWriter(this.translator).setId(id);
    }

    protected DocumentWriter writeDocument(Document document) {
        return new FederatedDocumentWriter(this.translator, document);
    }

    protected PageWriter newPageDocument(PageKey pageKey) {
        return new FederatedDocumentWriter(this.translator).setId(pageKey.toString());
    }

    protected Document newChildReference(String childId, String childName) {
        return DocumentFactory.newDocument((String)"key", (Object)childId, (String)"name", (Object)childName);
    }

    protected final ValueFactories factories() {
        return this.context.getValueFactories();
    }

    protected final PropertyFactory propertyFactory() {
        return this.context.getPropertyFactory();
    }

    protected final PathFactory pathFactory() {
        return this.factories().getPathFactory();
    }

    protected final Path pathFrom(String path) {
        return (Path)this.factories().getPathFactory().create(path);
    }

    protected final Path pathFrom(Path parentPath, String childPath) {
        Path parent = (Path)this.pathFactory().create(parentPath);
        return this.pathFactory().create(parent, childPath);
    }

    protected final Name nameFrom(String nameString) {
        return (Name)this.factories().getNameFactory().create(nameString);
    }

    protected final Name nameFrom(String namespaceUri, String localName) {
        return this.factories().getNameFactory().create(namespaceUri, localName);
    }

    protected final Name nameFrom(String namespaceUri, String localName, TextDecoder decoder) {
        return this.factories().getNameFactory().create(namespaceUri, localName, decoder);
    }

    protected ConnectorChangeSet newConnectorChangedSet() {
        return this.connectorChangedSetFactory.newChangeSet();
    }

    public final class ExtraProperties {
        private Map<Name, Property> properties = new HashMap<Name, Property>();
        private final boolean update;
        private final String id;

        protected ExtraProperties(String id, boolean update) {
            this.id = id;
            this.update = update;
        }

        public ExtraProperties add(Property property) {
            this.properties.put(property.getName(), property);
            return this;
        }

        public ExtraProperties addAll(Map<Name, Property> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public ExtraProperties remove(Name propertyName) {
            this.properties.put(propertyName, null);
            return this;
        }

        public ExtraProperties remove(String propertyName) {
            this.properties.put(Connector.this.nameFrom(propertyName), null);
            return this;
        }

        public ExtraProperties except(Name ... names) {
            for (Name name : names) {
                this.properties.remove(name);
            }
            return this;
        }

        public ExtraProperties except(String ... names) {
            for (String name : names) {
                this.properties.remove(Connector.this.nameFrom(name));
            }
            return this;
        }

        public ExtraProperties exceptPrimaryType() {
            this.properties.remove(JcrLexicon.PRIMARY_TYPE);
            return this;
        }

        public void save() {
            if (this.update) {
                Connector.this.extraPropertiesStore().updateProperties(this.id, this.properties);
            } else {
                Connector.this.extraPropertiesStore().storeProperties(this.id, this.properties);
            }
            this.properties.clear();
        }
    }
}

