/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.search.SearchException;
import org.hibernate.search.SearchFactory;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.lucene.LuceneException;
import org.modeshape.jcr.query.lucene.LuceneQueryFactory;
import org.modeshape.jcr.query.lucene.LuceneSchema;

@ThreadSafe
public class LuceneProcessingContext {
    private final String repositoryName;
    private final SearchFactory searchFactory;
    private final Map<String, IndexReader> readerByIndexName = new HashMap<String, IndexReader>();
    private final Map<String, IndexSearcher> searcherByIndexName = new HashMap<String, IndexSearcher>();
    private final Lock lock = new ReentrantLock();
    private final QueryContext queryContext;
    private final LuceneQueryFactory queryFactory;

    protected LuceneProcessingContext(QueryContext queryContext, String repositoryName, SearchFactory searchFactory, LuceneSchema schema) {
        assert (queryContext != null);
        assert (searchFactory != null);
        assert (repositoryName != null);
        this.queryContext = queryContext;
        this.searchFactory = searchFactory;
        this.repositoryName = repositoryName;
        this.queryFactory = schema.createLuceneQueryFactory(queryContext, searchFactory);
    }

    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    public LuceneQueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    public Set<String> getWorkspaceNames() {
        return this.queryContext.getWorkspaceNames();
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexReader getReader(String indexName) throws LuceneException {
        IndexReader reader;
        block7: {
            assert (indexName != null);
            reader = this.readerByIndexName.get(indexName);
            if (reader == null) {
                try {
                    this.lock.lock();
                    reader = this.readerByIndexName.get(indexName);
                    if (reader != null) break block7;
                    try {
                        reader = this.searchFactory.getIndexReaderAccessor().open(new String[]{indexName});
                    }
                    catch (SearchException e) {
                        throw new LuceneException(e);
                    }
                    this.readerByIndexName.put(indexName, reader);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        return reader;
    }

    public IndexSearcher getSearcher(String indexName) throws LuceneException {
        IndexSearcher searcher = this.searcherByIndexName.get(indexName);
        if (searcher == null) {
            try {
                this.lock.lock();
                searcher = this.searcherByIndexName.get(indexName);
                if (searcher == null) {
                    searcher = new IndexSearcher(this.getReader(indexName));
                    this.searcherByIndexName.put(indexName, searcher);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return searcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RuntimeException firstError = null;
        try {
            this.lock.lock();
            for (Map.Entry<String, IndexReader> entry : this.readerByIndexName.entrySet()) {
                String indexName = entry.getKey();
                IndexReader reader = entry.getValue();
                assert (reader != null);
                try {
                    this.searchFactory.getIndexReaderAccessor().close(reader);
                }
                catch (RuntimeException e) {
                    if (firstError == null) {
                        firstError = e;
                    }
                    Logger.getLogger(this.getClass()).error((Throwable)firstError, (I18nResource)JcrI18n.errorClosingLuceneReaderForIndex, new Object[]{this.repositoryName, indexName});
                }
            }
            this.readerByIndexName.clear();
            this.searcherByIndexName.clear();
        }
        finally {
            this.lock.unlock();
        }
        if (firstError != null) {
            throw firstError;
        }
    }
}

