/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import java.util.AbstractMap;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.sequencer.ddl.dialect.teiid.CreateProcedureParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlConstants;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlTest;
import org.modeshape.sequencer.ddl.node.AstNode;

public class CreateProcedureParserTest
extends TeiidDdlTest {
    private CreateProcedureParser parser;
    private AstNode rootNode;

    @Before
    public void beforeEach() {
        TeiidDdlParser teiidDdlParser = new TeiidDdlParser();
        this.parser = new CreateProcedureParser(teiidDdlParser);
        this.rootNode = teiidDdlParser.nodeFactory().node("ddlRootNode");
    }

    @Test
    public void shouldParseCreateProcedure() {
        String content = "CREATE PROCEDURE FOO(P1 integer) RETURNS (e1 integer, e2 varchar) AS SELECT * FROM PM1.G1;";
        AstNode procedureNode = this.parser.parse(this.getTokens("CREATE PROCEDURE FOO(P1 integer) RETURNS (e1 integer, e2 varchar) AS SELECT * FROM PM1.G1;"), this.rootNode);
        this.assertMixinType(procedureNode, "teiidddl:createProcedure");
        this.assertProperty(procedureNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)procedureNode.getName(), (Matcher)Is.is((Object)"FOO"));
        Assert.assertThat((Object)procedureNode.getChildCount(), (Matcher)Is.is((Object)2));
        AstNode param1 = (AstNode)procedureNode.childrenWithName("P1").get(0);
        this.assertProperty(param1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
        this.assertProperty(param1, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        AstNode resultSetNode = (AstNode)procedureNode.childrenWithName("resultSet").get(0);
        this.assertMixinType(resultSetNode, "teiidddl:resultColumns");
        this.assertProperty(resultSetNode, "teiidddl:table", false);
        Assert.assertThat((Object)resultSetNode.getChildCount(), (Matcher)Is.is((Object)2));
        AstNode resultCol1 = null;
        AstNode resultCol2 = null;
        if ("e1".equals(resultSetNode.getChild(0).getName())) {
            resultCol1 = resultSetNode.getChild(0);
            resultCol2 = resultSetNode.getChild(1);
        } else {
            resultCol2 = resultSetNode.getChild(0);
            resultCol1 = resultSetNode.getChild(1);
        }
        Assert.assertThat((Object)resultCol1.getName(), (Matcher)Is.is((Object)"e1"));
        this.assertProperty(resultCol1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
        Assert.assertThat((Object)resultCol2.getName(), (Matcher)Is.is((Object)"e2"));
        this.assertProperty(resultCol2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty(procedureNode, "teiidddl:statement", "SELECT * FROM PM1.G1;");
    }

    @Test
    public void shouldParseMixedCaseTypes() {
        String content = "CREATE FUNCTION SourceFunc(flag Boolean) RETURNS varchaR options (UUID 'z')";
        AstNode functionNode = this.parser.parse(this.getTokens("CREATE FUNCTION SourceFunc(flag Boolean) RETURNS varchaR options (UUID 'z')"), this.rootNode);
        this.assertMixinType(functionNode, "teiidddl:createFunction");
        this.assertProperty(functionNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)functionNode.getName(), (Matcher)Is.is((Object)"SourceFunc"));
        Assert.assertThat((Object)functionNode.getChildCount(), (Matcher)Is.is((Object)3));
        AstNode param1 = (AstNode)functionNode.childrenWithName("flag").get(0);
        this.assertProperty(param1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.BOOLEAN.toDdl());
        this.assertProperty(param1, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        AstNode resultSetNode = (AstNode)functionNode.childrenWithName("resultSet").get(0);
        this.assertMixinType(resultSetNode, "teiidddl:resultDataType");
        Assert.assertThat((Object)resultSetNode.getChildCount(), (Matcher)Is.is((Object)0));
        this.assertProperty(resultSetNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty((AstNode)functionNode.childrenWithName("UUID").get(0), "ddl:value", "z");
        this.assertMixinType((AstNode)functionNode.childrenWithName("UUID").get(0), "ddl:statementOption");
    }

    @Test
    public void shouldParsePushdownFunctionNoArgs() {
        String content = "CREATE FOREIGN FUNCTION SourceFunc() RETURNS integer OPTIONS (UUID 'hello world')";
        AstNode functionNode = this.parser.parse(this.getTokens("CREATE FOREIGN FUNCTION SourceFunc() RETURNS integer OPTIONS (UUID 'hello world')"), this.rootNode);
        this.assertMixinType(functionNode, "teiidddl:createFunction");
        this.assertProperty(functionNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)functionNode.getName(), (Matcher)Is.is((Object)"SourceFunc"));
        Assert.assertThat((Object)functionNode.getChildCount(), (Matcher)Is.is((Object)2));
        AstNode resultSetNode = null;
        AstNode optionNode = null;
        if (functionNode.getChild(0).hasMixin("teiidddl:resultDataType")) {
            resultSetNode = functionNode.getChild(0);
            optionNode = functionNode.getChild(1);
        } else if (this.hasMixin(functionNode.getChild(0), "ddl:option")) {
            optionNode = functionNode.getChild(0);
            resultSetNode = functionNode.getChild(1);
        } else {
            Assert.fail((String)"Unexpected function child");
        }
        assert (resultSetNode != null && optionNode != null);
        this.assertProperty(resultSetNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
        Assert.assertThat((Object)optionNode.getName(), (Matcher)Is.is((Object)"UUID"));
        this.assertProperty(optionNode, "ddl:value", "hello world");
    }

    @Test
    public void shouldParseSourceProcedure() {
        String content = "CREATE FOREIGN PROCEDURE myProc(OUT p1 boolean, p2 varchar, INOUT p3 decimal) RETURNS (r1 varchar, r2 decimal) OPTIONS(RANDOM 'any', UUID 'uuid', NAMEINSOURCE 'nis', ANNOTATION 'desc', UPDATECOUNT '2');";
        AstNode procedureNode = this.parser.parse(this.getTokens("CREATE FOREIGN PROCEDURE myProc(OUT p1 boolean, p2 varchar, INOUT p3 decimal) RETURNS (r1 varchar, r2 decimal) OPTIONS(RANDOM 'any', UUID 'uuid', NAMEINSOURCE 'nis', ANNOTATION 'desc', UPDATECOUNT '2');"), this.rootNode);
        this.assertMixinType(procedureNode, "teiidddl:createProcedure");
        this.assertProperty(procedureNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)procedureNode.getName(), (Matcher)Is.is((Object)"myProc"));
        Assert.assertThat((Object)procedureNode.getChildCount(), (Matcher)Is.is((Object)9));
        AstNode param1 = (AstNode)procedureNode.childrenWithName("p1").get(0);
        this.assertProperty(param1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.BOOLEAN.toDdl());
        this.assertProperty(param1, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.OUT.toDdl());
        param1 = (AstNode)procedureNode.childrenWithName("p2").get(0);
        this.assertProperty(param1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty(param1, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        param1 = (AstNode)procedureNode.childrenWithName("p3").get(0);
        this.assertProperty(param1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.DECIMAL.toDdl());
        this.assertProperty(param1, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.INOUT.toDdl());
        AstNode resultSetNode = (AstNode)procedureNode.childrenWithName("resultSet").get(0);
        this.assertMixinType(resultSetNode, "teiidddl:resultColumns");
        this.assertProperty(resultSetNode, "teiidddl:table", false);
        Assert.assertThat((Object)resultSetNode.getChildCount(), (Matcher)Is.is((Object)2));
        AstNode resultCol1 = null;
        AstNode resultCol2 = null;
        if ("r1".equals(resultSetNode.getChild(0).getName())) {
            resultCol1 = resultSetNode.getChild(0);
            resultCol2 = resultSetNode.getChild(1);
        } else {
            resultCol2 = resultSetNode.getChild(0);
            resultCol1 = resultSetNode.getChild(1);
        }
        Assert.assertThat((Object)resultCol1.getName(), (Matcher)Is.is((Object)"r1"));
        this.assertProperty(resultCol1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        Assert.assertThat((Object)resultCol2.getName(), (Matcher)Is.is((Object)"r2"));
        this.assertProperty(resultCol2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.DECIMAL.toDdl());
        this.assertProperty((AstNode)procedureNode.childrenWithName("RANDOM").get(0), "ddl:value", "any");
        this.assertProperty((AstNode)procedureNode.childrenWithName("UUID").get(0), "ddl:value", "uuid");
        this.assertProperty((AstNode)procedureNode.childrenWithName("NAMEINSOURCE").get(0), "ddl:value", "nis");
        this.assertProperty((AstNode)procedureNode.childrenWithName("ANNOTATION").get(0), "ddl:value", "desc");
        this.assertProperty((AstNode)procedureNode.childrenWithName("UPDATECOUNT").get(0), "ddl:value", "2");
    }

    @Test
    public void shouldParseUdAggregate() {
        String content = "CREATE VIRTUAL FUNCTION SourceFunc(flag boolean, msg varchar) RETURNS varchar OPTIONS(CATEGORY 'misc', AGGREGATE 'true', \"allows-distinct\" 'true', UUID 'y')";
        AstNode functionNode = this.parser.parse(this.getTokens("CREATE VIRTUAL FUNCTION SourceFunc(flag boolean, msg varchar) RETURNS varchar OPTIONS(CATEGORY 'misc', AGGREGATE 'true', \"allows-distinct\" 'true', UUID 'y')"), this.rootNode);
        this.assertMixinType(functionNode, "teiidddl:createFunction");
        this.assertProperty(functionNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.VIRTUAL.toDdl());
        Assert.assertThat((Object)functionNode.getName(), (Matcher)Is.is((Object)"SourceFunc"));
        Assert.assertThat((Object)functionNode.getChildCount(), (Matcher)Is.is((Object)7));
        AstNode param1 = (AstNode)functionNode.childrenWithName("flag").get(0);
        this.assertProperty(param1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.BOOLEAN.toDdl());
        this.assertProperty(param1, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        param1 = (AstNode)functionNode.childrenWithName("msg").get(0);
        this.assertProperty(param1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty(param1, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        AstNode resultSetNode = (AstNode)functionNode.childrenWithName("resultSet").get(0);
        this.assertMixinType(resultSetNode, "teiidddl:resultDataType");
        Assert.assertThat((Object)resultSetNode.getChildCount(), (Matcher)Is.is((Object)0));
        this.assertProperty(resultSetNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty((AstNode)functionNode.childrenWithName("CATEGORY").get(0), "ddl:value", "misc");
        this.assertProperty((AstNode)functionNode.childrenWithName("AGGREGATE").get(0), "ddl:value", "true");
        this.assertProperty((AstNode)functionNode.childrenWithName("allows-distinct").get(0), "ddl:value", "true");
        this.assertProperty((AstNode)functionNode.childrenWithName("UUID").get(0), "ddl:value", "y");
    }

    @Test
    public void shouldParseUdf() {
        String functionName = "SourceFunc";
        String flagParam = "flag";
        String msgParam = "msg";
        AbstractMap.SimpleEntry<String, String> option1 = new AbstractMap.SimpleEntry<String, String>("CATEGORY", "misc");
        AbstractMap.SimpleEntry<String, String> option2 = new AbstractMap.SimpleEntry<String, String>("DETERMINISM", "DETERMINISTIC");
        AbstractMap.SimpleEntry<String, String> option3 = new AbstractMap.SimpleEntry<String, String>("NULL-ON-NULL", "true");
        AbstractMap.SimpleEntry<String, String> option4 = new AbstractMap.SimpleEntry<String, String>("JAVA_CLASS", "foo");
        AbstractMap.SimpleEntry<String, String> option5 = new AbstractMap.SimpleEntry<String, String>("JAVA_METHOD", "bar");
        AbstractMap.SimpleEntry<String, String> option6 = new AbstractMap.SimpleEntry<String, String>("RANDOM", "any");
        AbstractMap.SimpleEntry<String, String> option7 = new AbstractMap.SimpleEntry<String, String>("UUID", "x");
        String content = "CREATE VIRTUAL FUNCTION SourceFunc(flag boolean, msg varchar) RETURNS varchar OPTIONS(" + (String)option1.getKey() + " '" + (String)option1.getValue() + "', " + (String)option2.getKey() + " '" + (String)option2.getValue() + "', \"" + (String)option3.getKey() + "\" '" + (String)option3.getValue() + "', " + (String)option4.getKey() + " '" + (String)option4.getValue() + "', " + (String)option5.getKey() + " '" + (String)option5.getValue() + "', " + (String)option6.getKey() + " '" + (String)option6.getValue() + "', " + (String)option7.getKey() + " '" + (String)option7.getValue() + "')";
        AstNode functionNode = this.parser.parse(this.getTokens(content), this.rootNode);
        this.assertMixinType(functionNode, "teiidddl:createFunction");
        this.assertProperty(functionNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.VIRTUAL.toDdl());
        Assert.assertThat((Object)functionNode.getName(), (Matcher)Is.is((Object)"SourceFunc"));
        Assert.assertThat((Object)functionNode.getChildCount(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)functionNode.childrenWithName("flag").size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)functionNode.childrenWithName("flag").get(0), "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.BOOLEAN.toDdl());
        Assert.assertThat((Object)functionNode.childrenWithName("msg").size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)functionNode.childrenWithName("msg").get(0), "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty((AstNode)functionNode.childrenWithName((String)option1.getKey()).get(0), "ddl:value", option1.getValue());
        this.assertProperty((AstNode)functionNode.childrenWithName((String)option2.getKey()).get(0), "ddl:value", option2.getValue());
        this.assertProperty((AstNode)functionNode.childrenWithName((String)option3.getKey()).get(0), "ddl:value", option3.getValue());
        this.assertProperty((AstNode)functionNode.childrenWithName((String)option4.getKey()).get(0), "ddl:value", option4.getValue());
        this.assertProperty((AstNode)functionNode.childrenWithName((String)option5.getKey()).get(0), "ddl:value", option5.getValue());
        this.assertProperty((AstNode)functionNode.childrenWithName((String)option6.getKey()).get(0), "ddl:value", option6.getValue());
        this.assertProperty((AstNode)functionNode.childrenWithName((String)option7.getKey()).get(0), "ddl:value", option7.getValue());
    }

    @Test
    public void shouldParseVarargs() {
        String content = "CREATE FUNCTION SourceFunc(flag boolean) RETURNS varchar options (varargs 'true', UUID 'z')";
        AstNode functionNode = this.parser.parse(this.getTokens("CREATE FUNCTION SourceFunc(flag boolean) RETURNS varchar options (varargs 'true', UUID 'z')"), this.rootNode);
        this.assertMixinType(functionNode, "teiidddl:createFunction");
        this.assertProperty(functionNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)functionNode.getName(), (Matcher)Is.is((Object)"SourceFunc"));
        Assert.assertThat((Object)functionNode.getChildCount(), (Matcher)Is.is((Object)4));
        AstNode param1 = (AstNode)functionNode.childrenWithName("flag").get(0);
        this.assertProperty(param1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.BOOLEAN.toDdl());
        this.assertProperty(param1, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        AstNode resultSetNode = (AstNode)functionNode.childrenWithName("resultSet").get(0);
        this.assertMixinType(resultSetNode, "teiidddl:resultDataType");
        Assert.assertThat((Object)resultSetNode.getChildCount(), (Matcher)Is.is((Object)0));
        this.assertProperty(resultSetNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty((AstNode)functionNode.childrenWithName("varargs").get(0), "ddl:value", "true");
        this.assertProperty((AstNode)functionNode.childrenWithName("UUID").get(0), "ddl:value", "z");
    }

    @Test
    public void shouldParseVirtualProcedure() {
        String content = "CREATE VIRTUAL PROCEDURE myProc(OUT p1 boolean, p2 varchar, INOUT p3 decimal) RETURNS (r1 varchar, r2 decimal) OPTIONS(RANDOM 'any', UUID 'uuid', NAMEINSOURCE 'nis', ANNOTATION 'desc', UPDATECOUNT '2') AS /*+ cache */ BEGIN select * from foo; END";
        AstNode procedureNode = this.parser.parse(this.getTokens("CREATE VIRTUAL PROCEDURE myProc(OUT p1 boolean, p2 varchar, INOUT p3 decimal) RETURNS (r1 varchar, r2 decimal) OPTIONS(RANDOM 'any', UUID 'uuid', NAMEINSOURCE 'nis', ANNOTATION 'desc', UPDATECOUNT '2') AS /*+ cache */ BEGIN select * from foo; END"), this.rootNode);
        this.assertMixinType(procedureNode, "teiidddl:createProcedure");
        this.assertProperty(procedureNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.VIRTUAL.toDdl());
        Assert.assertThat((Object)procedureNode.getName(), (Matcher)Is.is((Object)"myProc"));
        Assert.assertThat((Object)procedureNode.getChildCount(), (Matcher)Is.is((Object)9));
        AstNode param1 = (AstNode)procedureNode.childrenWithName("p1").get(0);
        this.assertProperty(param1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.BOOLEAN.toDdl());
        this.assertProperty(param1, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.OUT.toDdl());
        AstNode param2 = (AstNode)procedureNode.childrenWithName("p2").get(0);
        this.assertProperty(param2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty(param2, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        AstNode param3 = (AstNode)procedureNode.childrenWithName("p3").get(0);
        this.assertProperty(param3, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.DECIMAL.toDdl());
        this.assertProperty(param3, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.INOUT.toDdl());
        AstNode resultSetNode = (AstNode)procedureNode.childrenWithName("resultSet").get(0);
        this.assertMixinType(resultSetNode, "teiidddl:resultColumns");
        this.assertProperty(resultSetNode, "teiidddl:table", false);
        Assert.assertThat((Object)resultSetNode.getChildCount(), (Matcher)Is.is((Object)2));
        AstNode resultCol1 = null;
        AstNode resultCol2 = null;
        if ("r1".equals(resultSetNode.getChild(0).getName())) {
            resultCol1 = resultSetNode.getChild(0);
            resultCol2 = resultSetNode.getChild(1);
        } else {
            resultCol2 = resultSetNode.getChild(0);
            resultCol1 = resultSetNode.getChild(1);
        }
        Assert.assertThat((Object)resultCol1.getName(), (Matcher)Is.is((Object)"r1"));
        this.assertProperty(resultCol1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        Assert.assertThat((Object)resultCol2.getName(), (Matcher)Is.is((Object)"r2"));
        this.assertProperty(resultCol2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.DECIMAL.toDdl());
        this.assertProperty((AstNode)procedureNode.childrenWithName("RANDOM").get(0), "ddl:value", "any");
        this.assertProperty((AstNode)procedureNode.childrenWithName("UUID").get(0), "ddl:value", "uuid");
        this.assertProperty((AstNode)procedureNode.childrenWithName("NAMEINSOURCE").get(0), "ddl:value", "nis");
        this.assertProperty((AstNode)procedureNode.childrenWithName("ANNOTATION").get(0), "ddl:value", "desc");
        this.assertProperty((AstNode)procedureNode.childrenWithName("UPDATECOUNT").get(0), "ddl:value", "2");
        this.assertProperty(procedureNode, "teiidddl:statement", "BEGIN select * from foo; END");
    }

    @Test
    public void shouldParseFlatFileDdl1() {
        String content = "CREATE FOREIGN PROCEDURE getFiles(IN pathAndPattern string OPTIONS (ANNOTATION 'The path and pattern of what files to return.  Currently the only pattern supported is *.<ext>, which returns only the files matching the given extension at the given path.')) RETURNS TABLE (file blob, filePath string) OPTIONS (ANNOTATION 'Returns files that match the given path and pattern as BLOBs')";
        AstNode procedureNode = this.parser.parse(this.getTokens("CREATE FOREIGN PROCEDURE getFiles(IN pathAndPattern string OPTIONS (ANNOTATION 'The path and pattern of what files to return.  Currently the only pattern supported is *.<ext>, which returns only the files matching the given extension at the given path.')) RETURNS TABLE (file blob, filePath string) OPTIONS (ANNOTATION 'Returns files that match the given path and pattern as BLOBs')"), this.rootNode);
        this.assertMixinType(procedureNode, "teiidddl:createProcedure");
        this.assertProperty(procedureNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)procedureNode.getName(), (Matcher)Is.is((Object)"getFiles"));
        Assert.assertThat((Object)procedureNode.getChildCount(), (Matcher)Is.is((Object)3));
        AstNode param1 = (AstNode)procedureNode.childrenWithName("pathAndPattern").get(0);
        this.assertProperty(param1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(param1, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(param1, "teiidddl:result", false);
        Assert.assertThat((Object)param1.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode resultSetNode = (AstNode)procedureNode.childrenWithName("resultSet").get(0);
        this.assertMixinType(resultSetNode, "teiidddl:resultColumns");
        this.assertProperty(resultSetNode, "teiidddl:table", true);
        Assert.assertThat((Object)resultSetNode.getChildCount(), (Matcher)Is.is((Object)2));
        AstNode resultCol1 = null;
        AstNode resultCol2 = null;
        if ("file".equals(resultSetNode.getChild(0).getName())) {
            resultCol1 = resultSetNode.getChild(0);
            resultCol2 = resultSetNode.getChild(1);
        } else {
            resultCol2 = resultSetNode.getChild(0);
            resultCol1 = resultSetNode.getChild(1);
        }
        Assert.assertThat((Object)resultCol1.getName(), (Matcher)Is.is((Object)"file"));
        this.assertProperty(resultCol1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.BLOB.toDdl());
        Assert.assertThat((Object)resultCol2.getName(), (Matcher)Is.is((Object)"filePath"));
        this.assertProperty(resultCol2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty((AstNode)procedureNode.childrenWithName("ANNOTATION").get(0), "ddl:value", "Returns files that match the given path and pattern as BLOBs");
    }

    @Test
    public void shouldParseFlatFileDdl2() {
        String content = "CREATE FOREIGN PROCEDURE getTextFiles(IN pathAndPattern string OPTIONS (ANNOTATION 'The path and pattern of what files to return.  Currently the only pattern supported is *.<ext>, which returns only the files matching the given extension at the given path.')) RETURNS TABLE (file clob, filePath string) OPTIONS (ANNOTATION 'Returns text files that match the given path and pattern as CLOBs')";
        AstNode procedureNode = this.parser.parse(this.getTokens("CREATE FOREIGN PROCEDURE getTextFiles(IN pathAndPattern string OPTIONS (ANNOTATION 'The path and pattern of what files to return.  Currently the only pattern supported is *.<ext>, which returns only the files matching the given extension at the given path.')) RETURNS TABLE (file clob, filePath string) OPTIONS (ANNOTATION 'Returns text files that match the given path and pattern as CLOBs')"), this.rootNode);
        this.assertMixinType(procedureNode, "teiidddl:createProcedure");
        this.assertProperty(procedureNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)procedureNode.getName(), (Matcher)Is.is((Object)"getTextFiles"));
        Assert.assertThat((Object)procedureNode.getChildCount(), (Matcher)Is.is((Object)3));
        AstNode param1 = (AstNode)procedureNode.childrenWithName("pathAndPattern").get(0);
        this.assertProperty(param1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(param1, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(param1, "teiidddl:result", false);
        Assert.assertThat((Object)param1.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode resultSetNode = (AstNode)procedureNode.childrenWithName("resultSet").get(0);
        this.assertMixinType(resultSetNode, "teiidddl:resultColumns");
        this.assertProperty(resultSetNode, "teiidddl:table", true);
        Assert.assertThat((Object)resultSetNode.getChildCount(), (Matcher)Is.is((Object)2));
        AstNode resultCol1 = null;
        AstNode resultCol2 = null;
        if ("file".equals(resultSetNode.getChild(0).getName())) {
            resultCol1 = resultSetNode.getChild(0);
            resultCol2 = resultSetNode.getChild(1);
        } else {
            resultCol2 = resultSetNode.getChild(0);
            resultCol1 = resultSetNode.getChild(1);
        }
        Assert.assertThat((Object)resultCol1.getName(), (Matcher)Is.is((Object)"file"));
        this.assertProperty(resultCol1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.CLOB.toDdl());
        Assert.assertThat((Object)resultCol2.getName(), (Matcher)Is.is((Object)"filePath"));
        this.assertProperty(resultCol2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty((AstNode)procedureNode.childrenWithName("ANNOTATION").get(0), "ddl:value", "Returns text files that match the given path and pattern as CLOBs");
    }

    @Test
    public void shouldParseFlatFileDdl3() {
        String content = "CREATE FOREIGN PROCEDURE saveFile(IN filePath string, IN file object OPTIONS (ANNOTATION 'The contents to save.  Can be one of CLOB, BLOB, or XML'))OPTIONS (ANNOTATION 'Saves the given value to the given path.  Any existing file will be overriden.')";
        AstNode procedureNode = this.parser.parse(this.getTokens("CREATE FOREIGN PROCEDURE saveFile(IN filePath string, IN file object OPTIONS (ANNOTATION 'The contents to save.  Can be one of CLOB, BLOB, or XML'))OPTIONS (ANNOTATION 'Saves the given value to the given path.  Any existing file will be overriden.')"), this.rootNode);
        this.assertMixinType(procedureNode, "teiidddl:createProcedure");
        this.assertProperty(procedureNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)procedureNode.getName(), (Matcher)Is.is((Object)"saveFile"));
        Assert.assertThat((Object)procedureNode.getChildCount(), (Matcher)Is.is((Object)3));
        AstNode param1 = (AstNode)procedureNode.childrenWithName("filePath").get(0);
        this.assertProperty(param1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(param1, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(param1, "teiidddl:result", false);
        Assert.assertThat((Object)param1.getChildCount(), (Matcher)Is.is((Object)0));
        AstNode param2 = (AstNode)procedureNode.childrenWithName("file").get(0);
        this.assertProperty(param2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.OBJECT.toDdl());
        this.assertProperty(param2, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(param2, "teiidddl:result", false);
        Assert.assertThat((Object)param2.getChildCount(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)procedureNode.childrenWithName("ANNOTATION").get(0), "ddl:value", "Saves the given value to the given path.  Any existing file will be overriden.");
    }

    @Test
    public void shouldParseWebService1() {
        String content = "CREATE FOREIGN PROCEDURE invoke(OUT result xml RESULT, IN binding string OPTIONS (ANNOTATION 'The invocation binding (HTTP, SOAP11, SOAP12).  May be set or allowed to default to null to use the default binding.'), IN action string OPTIONS (ANNOTATION 'With a SOAP invocation, action sets the SOAPAction.  With HTTP it sets the HTTP Method (GET, POST - default, etc.).'), IN request xml OPTIONS (ANNOTATION 'The XML document or root element that represents the request.  If the ExecutionFactory is configured in with a DefaultServiceMode of MESSAGE, then the SOAP request must contain the entire SOAP message.'), IN endpoint string OPTIONS (ANNOTATION 'The relative or abolute endpoint to use.  May be set or allowed to default to null to use the default endpoint address.'), IN stream boolean DEFAULT 'false' OPTIONS (ANNOTATION 'If the result should be streamed.'))OPTIONS (ANNOTATION 'Invokes a webservice that returns an XML result')";
        AstNode procedureNode = this.parser.parse(this.getTokens("CREATE FOREIGN PROCEDURE invoke(OUT result xml RESULT, IN binding string OPTIONS (ANNOTATION 'The invocation binding (HTTP, SOAP11, SOAP12).  May be set or allowed to default to null to use the default binding.'), IN action string OPTIONS (ANNOTATION 'With a SOAP invocation, action sets the SOAPAction.  With HTTP it sets the HTTP Method (GET, POST - default, etc.).'), IN request xml OPTIONS (ANNOTATION 'The XML document or root element that represents the request.  If the ExecutionFactory is configured in with a DefaultServiceMode of MESSAGE, then the SOAP request must contain the entire SOAP message.'), IN endpoint string OPTIONS (ANNOTATION 'The relative or abolute endpoint to use.  May be set or allowed to default to null to use the default endpoint address.'), IN stream boolean DEFAULT 'false' OPTIONS (ANNOTATION 'If the result should be streamed.'))OPTIONS (ANNOTATION 'Invokes a webservice that returns an XML result')"), this.rootNode);
        this.assertMixinType(procedureNode, "teiidddl:createProcedure");
        this.assertProperty(procedureNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)procedureNode.getName(), (Matcher)Is.is((Object)"invoke"));
        Assert.assertThat((Object)procedureNode.getChildCount(), (Matcher)Is.is((Object)7));
        AstNode param1 = (AstNode)procedureNode.childrenWithName("result").get(0);
        this.assertProperty(param1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.XML.toDdl());
        this.assertProperty(param1, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.OUT.toDdl());
        this.assertProperty(param1, "teiidddl:result", true);
        Assert.assertThat((Object)param1.getChildCount(), (Matcher)Is.is((Object)0));
        AstNode param2 = (AstNode)procedureNode.childrenWithName("binding").get(0);
        this.assertProperty(param2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(param2, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(param2, "teiidddl:result", false);
        Assert.assertThat((Object)param2.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode param3 = (AstNode)procedureNode.childrenWithName("action").get(0);
        this.assertProperty(param3, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(param3, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(param3, "teiidddl:result", false);
        Assert.assertThat((Object)param3.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode param4 = (AstNode)procedureNode.childrenWithName("request").get(0);
        this.assertProperty(param4, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.XML.toDdl());
        this.assertProperty(param4, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(param4, "teiidddl:result", false);
        Assert.assertThat((Object)param4.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode param5 = (AstNode)procedureNode.childrenWithName("endpoint").get(0);
        this.assertProperty(param5, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(param5, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(param5, "teiidddl:result", false);
        Assert.assertThat((Object)param5.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode param6 = (AstNode)procedureNode.childrenWithName("stream").get(0);
        this.assertProperty(param6, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.BOOLEAN.toDdl());
        this.assertProperty(param6, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(param6, "teiidddl:result", false);
        this.assertProperty(param6, "ddl:defaultValue", "false");
        Assert.assertThat((Object)param6.getChildCount(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)procedureNode.childrenWithName("ANNOTATION").get(0), "ddl:value", "Invokes a webservice that returns an XML result");
    }

    @Test
    public void shouldParseWebService2() {
        String content = "CREATE FOREIGN PROCEDURE invokeHttp(OUT result blob RESULT, IN action string OPTIONS (ANNOTATION 'Sets the HTTP Method (GET, POST - default, etc.).'), IN request object OPTIONS (ANNOTATION 'The String, XML, BLOB, or CLOB value containing a payload (only for POST).'), IN endpoint string OPTIONS (ANNOTATION 'The relative or abolute endpoint to use.  May be set or allowed to default to null to use the default endpoint address.'), IN stream boolean DEFAULT 'false' OPTIONS (ANNOTATION 'If the result should be streamed.'), OUT contentType string) OPTIONS (ANNOTATION 'Invokes a webservice that returns an binary result')";
        AstNode procedureNode = this.parser.parse(this.getTokens("CREATE FOREIGN PROCEDURE invokeHttp(OUT result blob RESULT, IN action string OPTIONS (ANNOTATION 'Sets the HTTP Method (GET, POST - default, etc.).'), IN request object OPTIONS (ANNOTATION 'The String, XML, BLOB, or CLOB value containing a payload (only for POST).'), IN endpoint string OPTIONS (ANNOTATION 'The relative or abolute endpoint to use.  May be set or allowed to default to null to use the default endpoint address.'), IN stream boolean DEFAULT 'false' OPTIONS (ANNOTATION 'If the result should be streamed.'), OUT contentType string) OPTIONS (ANNOTATION 'Invokes a webservice that returns an binary result')"), this.rootNode);
        this.assertMixinType(procedureNode, "teiidddl:createProcedure");
        this.assertProperty(procedureNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)procedureNode.getName(), (Matcher)Is.is((Object)"invokeHttp"));
        Assert.assertThat((Object)procedureNode.getChildCount(), (Matcher)Is.is((Object)7));
        AstNode param1 = (AstNode)procedureNode.childrenWithName("result").get(0);
        this.assertProperty(param1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.BLOB.toDdl());
        this.assertProperty(param1, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.OUT.toDdl());
        this.assertProperty(param1, "teiidddl:result", true);
        Assert.assertThat((Object)param1.getChildCount(), (Matcher)Is.is((Object)0));
        AstNode param2 = (AstNode)procedureNode.childrenWithName("action").get(0);
        this.assertProperty(param2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(param2, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(param2, "teiidddl:result", false);
        Assert.assertThat((Object)param2.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode param3 = (AstNode)procedureNode.childrenWithName("request").get(0);
        this.assertProperty(param3, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.OBJECT.toDdl());
        this.assertProperty(param3, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(param3, "teiidddl:result", false);
        Assert.assertThat((Object)param3.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode param4 = (AstNode)procedureNode.childrenWithName("endpoint").get(0);
        this.assertProperty(param4, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(param4, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(param4, "teiidddl:result", false);
        Assert.assertThat((Object)param4.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode param5 = (AstNode)procedureNode.childrenWithName("stream").get(0);
        this.assertProperty(param5, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.BOOLEAN.toDdl());
        this.assertProperty(param5, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(param5, "teiidddl:result", false);
        this.assertProperty(param5, "ddl:defaultValue", "false");
        Assert.assertThat((Object)param5.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode param6 = (AstNode)procedureNode.childrenWithName("contentType").get(0);
        this.assertProperty(param6, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(param6, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.OUT.toDdl());
        this.assertProperty(param6, "teiidddl:result", false);
        Assert.assertThat((Object)param6.getChildCount(), (Matcher)Is.is((Object)0));
        this.assertProperty((AstNode)procedureNode.childrenWithName("ANNOTATION").get(0), "ddl:value", "Invokes a webservice that returns an binary result");
    }

    @Test
    public void shouldParseImplicitParameterType() {
        String content = "param string";
        this.parser.parseProcedureParameter(this.getTokens("param string"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode paramNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)paramNode.getName(), (Matcher)Is.is((Object)"param"));
        this.assertMixinType(paramNode, "teiidddl:procedureParameter");
        this.assertProperty(paramNode, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(paramNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(paramNode, "ddl:nullable", "NULL");
        this.assertProperty(paramNode, "teiidddl:result", false);
    }

    @Test
    public void shouldParseInParameterType() {
        String content = "IN param string";
        this.parser.parseProcedureParameter(this.getTokens("IN param string"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode paramNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)paramNode.getName(), (Matcher)Is.is((Object)"param"));
        this.assertMixinType(paramNode, "teiidddl:procedureParameter");
        this.assertProperty(paramNode, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(paramNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(paramNode, "ddl:nullable", "NULL");
        this.assertProperty(paramNode, "teiidddl:result", false);
    }

    @Test
    public void shouldParseOutParameterType() {
        String content = "OUT param string";
        this.parser.parseProcedureParameter(this.getTokens("OUT param string"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode paramNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)paramNode.getName(), (Matcher)Is.is((Object)"param"));
        this.assertMixinType(paramNode, "teiidddl:procedureParameter");
        this.assertProperty(paramNode, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.OUT.toDdl());
        this.assertProperty(paramNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(paramNode, "ddl:nullable", "NULL");
        this.assertProperty(paramNode, "teiidddl:result", false);
    }

    @Test
    public void shouldParseInOutParameterType() {
        String content = "INOUT param string";
        this.parser.parseProcedureParameter(this.getTokens("INOUT param string"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode paramNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)paramNode.getName(), (Matcher)Is.is((Object)"param"));
        this.assertMixinType(paramNode, "teiidddl:procedureParameter");
        this.assertProperty(paramNode, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.INOUT.toDdl());
        this.assertProperty(paramNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(paramNode, "ddl:nullable", "NULL");
        this.assertProperty(paramNode, "teiidddl:result", false);
    }

    @Test
    public void shouldParseVariadicParameterType() {
        String content = "VARIADIC param string";
        this.parser.parseProcedureParameter(this.getTokens("VARIADIC param string"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode paramNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)paramNode.getName(), (Matcher)Is.is((Object)"param"));
        this.assertMixinType(paramNode, "teiidddl:procedureParameter");
        this.assertProperty(paramNode, "teiidddl:parameterType", TeiidDdlConstants.TeiidNonReservedWord.VARIADIC.toDdl());
        this.assertProperty(paramNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(paramNode, "ddl:nullable", "NULL");
        this.assertProperty(paramNode, "teiidddl:result", false);
    }

    @Test
    public void shouldParseNotNullParameter() {
        String content = "IN param string NOT NULL";
        this.parser.parseProcedureParameter(this.getTokens("IN param string NOT NULL"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode paramNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)paramNode.getName(), (Matcher)Is.is((Object)"param"));
        this.assertMixinType(paramNode, "teiidddl:procedureParameter");
        this.assertProperty(paramNode, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(paramNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(paramNode, "ddl:nullable", "NOT NULL");
        this.assertProperty(paramNode, "teiidddl:result", false);
    }

    @Test
    public void shouldParseParameterWithResultFlag() {
        String content = "IN param string RESULT";
        this.parser.parseProcedureParameter(this.getTokens("IN param string RESULT"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode paramNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)paramNode.getName(), (Matcher)Is.is((Object)"param"));
        this.assertMixinType(paramNode, "teiidddl:procedureParameter");
        this.assertProperty(paramNode, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(paramNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(paramNode, "teiidddl:result", true);
        this.assertProperty(paramNode, "ddl:nullable", "NULL");
    }

    @Test
    public void shouldParseParameterWithDefaultValue() {
        String content = "IN param string DEFAULT 'default-value'";
        this.parser.parseProcedureParameter(this.getTokens("IN param string DEFAULT 'default-value'"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode paramNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)paramNode.getName(), (Matcher)Is.is((Object)"param"));
        this.assertMixinType(paramNode, "teiidddl:procedureParameter");
        this.assertProperty(paramNode, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(paramNode, "ddl:defaultValue", "default-value");
        this.assertProperty(paramNode, "teiidddl:result", false);
        this.assertProperty(paramNode, "ddl:nullable", "NULL");
    }

    @Test
    public void shouldParseParameterWithOptionClause() {
        String content = "IN param string OPTIONS (a 'a-value', b 'b-value')";
        this.parser.parseProcedureParameter(this.getTokens("IN param string OPTIONS (a 'a-value', b 'b-value')"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode paramNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)paramNode.getName(), (Matcher)Is.is((Object)"param"));
        this.assertMixinType(paramNode, "teiidddl:procedureParameter");
        this.assertProperty(paramNode, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(paramNode, "teiidddl:result", false);
        this.assertProperty(paramNode, "ddl:nullable", "NULL");
        Assert.assertThat((Object)paramNode.getChildCount(), (Matcher)Is.is((Object)2));
        AstNode optionA = null;
        AstNode optionB = null;
        if ("a".equals(paramNode.getChild(0).getName())) {
            optionA = paramNode.getChild(0);
            optionB = paramNode.getChild(1);
        } else {
            optionB = paramNode.getChild(0);
            optionA = paramNode.getChild(1);
        }
        Assert.assertThat((Object)optionA.getName(), (Matcher)Is.is((Object)"a"));
        this.assertMixinType(optionA, "ddl:statementOption");
        this.assertProperty(optionA, "ddl:value", "a-value");
        Assert.assertThat((Object)optionB.getName(), (Matcher)Is.is((Object)"b"));
        this.assertMixinType(optionB, "ddl:statementOption");
        this.assertProperty(optionB, "ddl:value", "b-value");
    }

    @Test
    public void shouldParseParameterWithUnorderedClauses() {
        String content = "IN param string DEFAULT 'default-value' RESULT NOT NULL";
        this.parser.parseProcedureParameter(this.getTokens("IN param string DEFAULT 'default-value' RESULT NOT NULL"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode paramNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)paramNode.getName(), (Matcher)Is.is((Object)"param"));
        this.assertMixinType(paramNode, "teiidddl:procedureParameter");
        this.assertProperty(paramNode, "teiidddl:parameterType", TeiidDdlConstants.TeiidReservedWord.IN.toDdl());
        this.assertProperty(paramNode, "ddl:defaultValue", "default-value");
        this.assertProperty(paramNode, "teiidddl:result", true);
        this.assertProperty(paramNode, "ddl:nullable", "NOT NULL");
    }

    @Test
    public void shouldParseNoParameters() {
        String content = "()";
        this.parser.parseProcedureParameters(this.getTokens("()"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldParseOneParameter() {
        String content = "(INOUT param string)";
        this.parser.parseProcedureParameters(this.getTokens("(INOUT param string)"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        this.assertMixinType(this.rootNode.getChild(0), "teiidddl:procedureParameter");
    }

    @Test
    public void shouldParseMultipleParameters() {
        String content = "(p1 string, in p2 boolean, out p3 integer, inout p4 decimal)";
        this.parser.parseProcedureParameters(this.getTokens("(p1 string, in p2 boolean, out p3 integer, inout p4 decimal)"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)4));
        for (AstNode paramNode : this.rootNode.getChildren()) {
            this.assertMixinType(paramNode, "teiidddl:procedureParameter");
        }
    }

    @Test
    public void shouldParseResultColumn() {
        String content = "r1 string";
        this.parser.parseProcedureResultColumn(this.getTokens("r1 string"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode paramNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)paramNode.getName(), (Matcher)Is.is((Object)"r1"));
        this.assertMixinType(paramNode, "teiidddl:resultColumn");
        this.assertProperty(paramNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(paramNode, "ddl:nullable", "NULL");
    }

    @Test
    public void shouldParseNotNullResultColumn() {
        String content = "r1 string NOT NULL";
        this.parser.parseProcedureResultColumn(this.getTokens("r1 string NOT NULL"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode paramNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)paramNode.getName(), (Matcher)Is.is((Object)"r1"));
        this.assertMixinType(paramNode, "teiidddl:resultColumn");
        this.assertProperty(paramNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(paramNode, "ddl:nullable", "NOT NULL");
    }

    @Test
    public void shouldParseResultColumnWithOptionClause() {
        String content = "r1 string OPTIONS (a 'a-value', b 'b-value')";
        this.parser.parseProcedureResultColumn(this.getTokens("r1 string OPTIONS (a 'a-value', b 'b-value')"), this.rootNode);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode resultColumnNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)resultColumnNode.getName(), (Matcher)Is.is((Object)"r1"));
        this.assertMixinType(resultColumnNode, "teiidddl:resultColumn");
        this.assertProperty(resultColumnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(resultColumnNode, "ddl:nullable", "NULL");
        Assert.assertThat((Object)resultColumnNode.getChildCount(), (Matcher)Is.is((Object)2));
        AstNode optionA = null;
        AstNode optionB = null;
        if ("a".equals(resultColumnNode.getChild(0).getName())) {
            optionA = resultColumnNode.getChild(0);
            optionB = resultColumnNode.getChild(1);
        } else {
            optionB = resultColumnNode.getChild(0);
            optionA = resultColumnNode.getChild(1);
        }
        Assert.assertThat((Object)optionA.getName(), (Matcher)Is.is((Object)"a"));
        this.assertMixinType(optionA, "ddl:statementOption");
        this.assertProperty(optionA, "ddl:value", "a-value");
        Assert.assertThat((Object)optionB.getName(), (Matcher)Is.is((Object)"b"));
        this.assertMixinType(optionB, "ddl:statementOption");
        this.assertProperty(optionB, "ddl:value", "b-value");
    }

    @Test
    public void shouldParseOneResultColumn() {
        String content = "(r1 string)";
        Assert.assertThat((Object)this.parser.parseProcedureResultColumns(this.getTokens("(r1 string)"), this.rootNode), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode resultColumnsNode = this.rootNode.getChild(0);
        this.assertMixinType(resultColumnsNode, "teiidddl:resultColumns");
        this.assertProperty(resultColumnsNode, "teiidddl:table", false);
        Assert.assertThat((Object)resultColumnsNode.getChildCount(), (Matcher)Is.is((Object)1));
        this.assertMixinType(resultColumnsNode.getChild(0), "teiidddl:resultColumn");
    }

    @Test
    public void shouldParseOneResultColumnWithTable() {
        String content = "table (r1 string)";
        Assert.assertThat((Object)this.parser.parseProcedureResultColumns(this.getTokens("table (r1 string)"), this.rootNode), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode resultColumnsNode = this.rootNode.getChild(0);
        this.assertMixinType(resultColumnsNode, "teiidddl:resultColumns");
        this.assertProperty(resultColumnsNode, "teiidddl:table", true);
        Assert.assertThat((Object)resultColumnsNode.getChildCount(), (Matcher)Is.is((Object)1));
        this.assertMixinType(resultColumnsNode.getChild(0), "teiidddl:resultColumn");
    }

    @Test
    public void shouldParseMultipleResultColumns() {
        String content = "(r1 string, r2 boolean, r3 integer, r4 blob, r5 bigdecimal)";
        Assert.assertThat((Object)this.parser.parseProcedureResultColumns(this.getTokens("(r1 string, r2 boolean, r3 integer, r4 blob, r5 bigdecimal)"), this.rootNode), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode resultColumnsNode = this.rootNode.getChild(0);
        this.assertMixinType(resultColumnsNode, "teiidddl:resultColumns");
        this.assertProperty(resultColumnsNode, "teiidddl:table", false);
        Assert.assertThat((Object)resultColumnsNode.getChildCount(), (Matcher)Is.is((Object)5));
        for (AstNode resultColumnNode : resultColumnsNode.getChildren()) {
            this.assertMixinType(resultColumnNode, "teiidddl:resultColumn");
        }
    }

    @Test
    public void shouldParseMultipleResultColumnsWithTable() {
        String content = "TABLE (r1 string, r2 boolean, r3 integer, r4 blob, r5 bigdecimal)";
        Assert.assertThat((Object)this.parser.parseProcedureResultColumns(this.getTokens("TABLE (r1 string, r2 boolean, r3 integer, r4 blob, r5 bigdecimal)"), this.rootNode), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode resultColumnsNode = this.rootNode.getChild(0);
        this.assertMixinType(resultColumnsNode, "teiidddl:resultColumns");
        this.assertProperty(resultColumnsNode, "teiidddl:table", true);
        Assert.assertThat((Object)resultColumnsNode.getChildCount(), (Matcher)Is.is((Object)5));
        for (AstNode resultColumnNode : resultColumnsNode.getChildren()) {
            this.assertMixinType(resultColumnNode, "teiidddl:resultColumn");
        }
    }

    @Test
    public void shouldNotParseDataTypeWithParseResultColumns() {
        String content = "r1 string";
        Assert.assertThat((Object)this.parser.parseProcedureResultColumns(this.getTokens("r1 string"), this.rootNode), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseAsClauseWithOneStatement() {
        String content = "AS SELECT * FROM PM1.G1;";
        Assert.assertThat((Object)this.parser.parseAsClause(this.getTokens("AS SELECT * FROM PM1.G1;"), this.rootNode), (Matcher)Is.is((Object)true));
        this.assertProperty(this.rootNode, "teiidddl:statement", "SELECT * FROM PM1.G1;");
    }

    @Test
    public void shouldParseAsClauseWithOneStatementNoEndingSemiColon() {
        String content = "AS SELECT * FROM PM1.G1";
        Assert.assertThat((Object)this.parser.parseAsClause(this.getTokens("AS SELECT * FROM PM1.G1"), this.rootNode), (Matcher)Is.is((Object)true));
        this.assertProperty(this.rootNode, "teiidddl:statement", "SELECT * FROM PM1.G1");
    }

    @Test
    public void shouldParseAsClauseWithMultipleStatements() {
        String content = "AS BEGIN SELECT * FROM G1;SELECT * FROM PM1.G2; END";
        Assert.assertThat((Object)this.parser.parseAsClause(this.getTokens("AS BEGIN SELECT * FROM G1;SELECT * FROM PM1.G2; END"), this.rootNode), (Matcher)Is.is((Object)true));
        this.assertProperty(this.rootNode, "teiidddl:statement", "BEGIN SELECT * FROM G1;SELECT * FROM PM1.G2; END");
    }

    @Test
    public void shouldParseDataTypeReturnsClause() {
        String content = "returns string";
        Assert.assertThat((Object)this.parser.parseReturnsClause(this.getTokens("returns string"), this.rootNode), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode resultSetNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)resultSetNode.getName(), (Matcher)Is.is((Object)"resultSet"));
        this.assertMixinType(resultSetNode, "teiidddl:resultDataType");
        this.assertProperty(resultSetNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
    }

    @Test
    public void shouldParseDataTypeReturnsClauseWithOptions() {
        String content = "returns OPTIONS(NAMEINSOURCE 'result', ANNOTATION 'desc') string";
        Assert.assertThat((Object)this.parser.parseReturnsClause(this.getTokens("returns OPTIONS(NAMEINSOURCE 'result', ANNOTATION 'desc') string"), this.rootNode), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode resultSetNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)resultSetNode.getName(), (Matcher)Is.is((Object)"resultSet"));
        this.assertMixinType(resultSetNode, "teiidddl:resultDataType");
        this.assertProperty(resultSetNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty((AstNode)resultSetNode.childrenWithName("NAMEINSOURCE").get(0), "ddl:value", "result");
        this.assertMixinType((AstNode)resultSetNode.childrenWithName("NAMEINSOURCE").get(0), "ddl:statementOption");
        this.assertProperty((AstNode)resultSetNode.childrenWithName("ANNOTATION").get(0), "ddl:value", "desc");
        this.assertMixinType((AstNode)resultSetNode.childrenWithName("ANNOTATION").get(0), "ddl:statementOption");
    }

    @Test
    public void shouldParseResultColumnsReturnsClause() {
        String content = "returns (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140))";
        Assert.assertThat((Object)this.parser.parseReturnsClause(this.getTokens("returns (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140))"), this.rootNode), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode resultSetNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)resultSetNode.getName(), (Matcher)Is.is((Object)"resultSet"));
        this.assertMixinType(resultSetNode, "teiidddl:resultColumns");
    }

    @Test
    public void shouldParseResultColumnsReturnsClauseWithOptions() {
        String content = "returns OPTIONS(NAMEINSOURCE 'result', ANNOTATION 'desc') (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140))";
        Assert.assertThat((Object)this.parser.parseReturnsClause(this.getTokens("returns OPTIONS(NAMEINSOURCE 'result', ANNOTATION 'desc') (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140))"), this.rootNode), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode resultSetNode = this.rootNode.getChild(0);
        Assert.assertThat((Object)resultSetNode.getName(), (Matcher)Is.is((Object)"resultSet"));
        this.assertMixinType(resultSetNode, "teiidddl:resultColumns");
        this.assertProperty((AstNode)resultSetNode.childrenWithName("NAMEINSOURCE").get(0), "ddl:value", "result");
        this.assertMixinType((AstNode)resultSetNode.childrenWithName("NAMEINSOURCE").get(0), "ddl:statementOption");
        this.assertProperty((AstNode)resultSetNode.childrenWithName("ANNOTATION").get(0), "ddl:value", "desc");
        this.assertMixinType((AstNode)resultSetNode.childrenWithName("ANNOTATION").get(0), "ddl:statementOption");
    }
}

