/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.util.StringUtil;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.dialect.teiid.StatementParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlConstants;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlTest;
import org.modeshape.sequencer.ddl.node.AstNode;

public class StatementParserTest
extends TeiidDdlTest {
    private TestParser parser;
    private AstNode rootNode;

    @Before
    public void beforeEach() {
        TeiidDdlParser teiidDdlParser = new TeiidDdlParser();
        this.parser = new TestParser(teiidDdlParser);
        this.rootNode = teiidDdlParser.nodeFactory().node("ddlRootNode");
    }

    @Test
    public void shouldParseUnqualifiedIdentifier() {
        String id = "name";
        Assert.assertThat((Object)this.parser.parseIdentifier(this.getTokens("name")), (Matcher)Is.is((Object)"name"));
    }

    @Test
    public void shouldParseDoubleQuotedUnqualifiedIdentifier() {
        String id = "name";
        String quotedId = "\"name\"";
        Assert.assertThat((Object)this.parser.parseIdentifier(this.getTokens("\"name\"")), (Matcher)Is.is((Object)"name"));
    }

    @Test
    public void shouldParseSingleQuotedUnqualifiedIdentifier() {
        String id = "name";
        String quotedId = "'name'";
        Assert.assertThat((Object)this.parser.parseIdentifier(this.getTokens("'name'")), (Matcher)Is.is((Object)"name"));
    }

    @Test
    public void shouldParseQualifiedIdentifier() {
        String id = "first.second";
        Assert.assertThat((Object)this.parser.parseIdentifier(this.getTokens("first.second")), (Matcher)Is.is((Object)"first.second"));
    }

    @Test
    public void shouldParseDoubleQuotedQualifiedIdentifier() {
        String firstSegment = "first";
        String secondSegment = "second";
        String id = "first.second";
        String quotedId = "\"first\".\"second\"";
        Assert.assertThat((Object)this.parser.parseIdentifier(this.getTokens("\"first\".\"second\"")), (Matcher)Is.is((Object)"first.second"));
    }

    @Test
    public void shouldParseSingleQuotedQualifiedIdentifier() {
        String firstSegment = "first";
        String secondSegment = "second";
        String id = "first.second";
        String quotedId = "'first'.'second'";
        Assert.assertThat((Object)this.parser.parseIdentifier(this.getTokens("'first'.'second'")), (Matcher)Is.is((Object)"first.second"));
    }

    @Test
    public void shouldNotAddEmptyValuesOption() {
        this.assertOptionsClause(4, "a", "", "b", "+1.234", "c", "-0.987", "d", "", "e", "`accounts`.`ACCOUNT`", "f", "accounts.ACCOUNT", "g", "");
    }

    @Test
    public void shouldNotAddSingleOptionEmptyValue() {
        this.assertOptionsClause(0, "key", "");
    }

    @Test
    public void shouldNotAddMultipleOptionsAllEmptyValues() {
        this.assertOptionsClause(0, "a", "", "b", "", "c", "", "d", "", "e", "", "f", "", "g", "");
    }

    @Test
    public void shouldParseSingleOption() {
        this.assertOptionsClause("key", "value");
    }

    @Test
    public void shouldParseSingleOptionPositiveDecimal() {
        this.assertOptionsClause("key", "+1.234");
    }

    @Test
    public void shouldParseSingleOptionNegativeDecimal() {
        this.assertOptionsClause("key", "-0.987");
    }

    @Test
    public void shouldParseSingleOptionQuotedUnqualifiedValue() {
        this.assertOptionsClause("key", "`value`");
    }

    @Test
    public void shouldParseSingleOptionQuotedQualifiedValue() {
        this.assertOptionsClause("key", "`accounts`.`ACCOUNT`");
    }

    @Test
    public void shouldParseSingleOptionQualifiedValue() {
        this.assertOptionsClause("key", "accounts.ACCOUNT");
    }

    @Test
    public void shouldParseSingleOptionBoolean() {
        this.assertOptionsClause("key", "TRUE");
    }

    @Test
    public void shouldParseMultipleOptions() {
        this.assertOptionsClause("a", "value", "b", "+1.234", "c", "-0.987", "d", "`value`", "e", "`accounts`.`ACCOUNT`", "f", "accounts.ACCOUNT", "g", "TRUE");
    }

    private void assertOptionsClause(int expectedNumberOfOptions, String ... optionPairs) {
        StringBuilder optionsClause = new StringBuilder(TeiidDdlConstants.TeiidReservedWord.OPTIONS.toDdl() + " ( ");
        for (int i = 0; i < optionPairs.length; ++i) {
            if (i > 1) {
                optionsClause.append(", ");
            }
            optionsClause.append('\'').append(optionPairs[i]).append('\'').append(' ');
            optionsClause.append('\'').append(optionPairs[++i]).append('\'');
        }
        optionsClause.append(" )");
        Assert.assertThat((Object)this.parser.parseOptionsClause(this.getTokens(optionsClause.toString()), this.rootNode), (Matcher)Is.is((Object)true));
        List optionNodes = this.rootNode.getChildren("ddl:statementOption");
        Assert.assertThat((Object)optionNodes.size(), (Matcher)Is.is((Object)expectedNumberOfOptions));
        for (int i = 0; i < optionPairs.length; ++i) {
            String value;
            String key = optionPairs[i];
            if (StringUtil.isBlank((String)(value = optionPairs[++i]))) continue;
            boolean found = false;
            for (AstNode optionNode : optionNodes) {
                if (!key.equals(optionNode.getName()) || !value.equals(optionNode.getProperty("ddl:value"))) continue;
                found = true;
                break;
            }
            if (found) continue;
            Assert.fail((String)("option '" + key + "' with value '" + value + "' was not found"));
        }
    }

    private void assertOptionsClause(String ... optionPairs) {
        this.assertOptionsClause(optionPairs.length / 2, optionPairs);
    }

    class TestParser
    extends StatementParser {
        protected TestParser(TeiidDdlParser teiidDdlParser) {
            super(teiidDdlParser);
        }

        boolean matches(DdlTokenStream tokens) {
            return false;
        }

        AstNode parse(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
            return null;
        }

        protected void postProcess(AstNode rootNode) {
        }
    }
}

