/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.AdvancedCache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.schematic.AbstractSchematicDbTest;
import org.infinispan.schematic.FixFor;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.TestUtil;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableArray;
import org.infinispan.schematic.document.EditableDocument;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="This shouldn't be normally run and is only present to validate MODE-2280")
public class SchematicDbConcurrentTest
extends AbstractSchematicDbTest {
    private AdvancedCache<Object, Object> rawCache;
    private static final AtomicInteger THREAD_IDX = new AtomicInteger(0);

    @Override
    public void beforeTest() {
        try {
            TestUtil.delete(new File("target/concurrent_load"));
            this.cm = new DefaultCacheManager(this.getClass().getClassLoader().getResourceAsStream("infinispan/concurrent-load-infinispan-cache.xml"));
            this.tm = this.cm.getCache().getAdvancedCache().getTransactionManager();
            this.db = Schematic.get((CacheContainer)this.cm, (String)"documents");
            this.rawCache = this.cm.getCache("raw", true).getAdvancedCache();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void afterTest() {
        THREAD_IDX.set(0);
        super.afterTest();
    }

    @Test
    @FixFor(value={"MODE-2280"})
    public void rawCacheShouldHandleOneWriterAndMultipleReadersRepeatedly() throws Exception {
        this.afterTest();
        int repeatCount = 100;
        for (int i = 0; i < repeatCount; ++i) {
            SchematicDbConcurrentTest.print("Run #" + (i + 1));
            this.beforeTest();
            this.rawCacheShouldHandleOneWriterAndMultipleReaders();
            this.afterTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"MODE-2280"})
    public void rawCacheShouldHandleOneWriterAndMultipleReaders() throws Exception {
        int totalNumberOfChildrenDocuments = 500;
        int saveBatchSize = 20;
        int modifierThreadsCount = 500;
        ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Thread_" + THREAD_IDX.incrementAndGet());
            }
        });
        int threadIdx = 1;
        long start = System.nanoTime();
        try {
            this.storeList(Collections.<String>emptyList());
            ArrayList<Future<ReaderResult>> threadResults = new ArrayList<Future<ReaderResult>>();
            LinkedHashSet<String> listElements = new LinkedHashSet<String>();
            for (int i = 0; i != totalNumberOfChildrenDocuments; ++i) {
                listElements.add(UUID.randomUUID().toString());
                if (i < saveBatchSize || i % saveBatchSize != 0) continue;
                SchematicDbConcurrentTest.print("Saving  batch " + i);
                this.storeList(listElements);
                SchematicDbConcurrentTest.print("...saved; at " + System.currentTimeMillis());
                SchematicDbConcurrentTest.print("...firing threads " + threadIdx + " through " + (threadIdx + modifierThreadsCount));
                threadIdx += modifierThreadsCount + 1;
                for (int j = 0; j < modifierThreadsCount; ++j) {
                    threadResults.add(executorService.submit(new ListReader(new LinkedHashSet<String>(listElements))));
                }
                listElements.clear();
            }
            if (!listElements.isEmpty()) {
                SchematicDbConcurrentTest.print("Saving final batch");
                this.storeList(listElements);
                SchematicDbConcurrentTest.print("...saved; at " + System.currentTimeMillis());
                threadResults.add(executorService.submit(new ListReader(new LinkedHashSet<String>(listElements))));
            }
            SchematicDbConcurrentTest.print("Total time to insert records=" + (double)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) / 1000.0 + " seconds with batch size=" + saveBatchSize);
            SchematicDbConcurrentTest.print("Waiting for " + threadResults.size() + " threads to complete");
            for (Future future : threadResults) {
                ReaderResult result = (ReaderResult)future.get(1L, TimeUnit.MINUTES);
                result.validate();
            }
        }
        catch (TimeoutException te) {
            Assert.fail((String)"Task never finished completion");
        }
        finally {
            executorService.shutdown();
            Assert.assertTrue((boolean)executorService.awaitTermination(1L, TimeUnit.MINUTES));
        }
    }

    private void storeList(Iterable<String> ids) throws Exception {
        this.tm.begin();
        List oldList = (List)this.rawCache.get((Object)"list");
        ArrayList<String> newList = new ArrayList<String>();
        if (oldList != null) {
            newList.addAll(oldList);
        }
        for (String childId : ids) {
            newList.add(childId);
            this.rawCache.put((Object)childId, (Object)childId);
        }
        this.rawCache.put((Object)"list", newList);
        this.tm.commit();
        SchematicDbConcurrentTest.print("wrote list reference: " + System.identityHashCode(this.rawCache.get((Object)"list")));
    }

    @Test
    @FixFor(value={"MODE-2280"})
    public void shouldHandleMultipleReadersRepeatedly() throws Exception {
        this.afterTest();
        int repeatCount = 100;
        for (int i = 0; i < repeatCount; ++i) {
            SchematicDbConcurrentTest.print("Run #" + (i + 1));
            this.beforeTest();
            this.shouldHandleOneWriterAndMultipleReaders();
            this.afterTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"MODE-2280"})
    public void shouldHandleOneWriterAndMultipleReaders() throws Exception {
        int totalNumberOfChildrenDocuments = 500;
        int saveBatchSize = 20;
        int modifierThreadsCount = 500;
        ExecutorService executorService = Executors.newFixedThreadPool(modifierThreadsCount);
        long start = System.nanoTime();
        try {
            String parentId = UUID.randomUUID().toString();
            Document parent = this.newDocument(parentId, "parent");
            this.persistDocument(parent);
            ArrayList<Future<ReaderResult>> threadResults = new ArrayList<Future<ReaderResult>>();
            LinkedHashSet<Document> childrenPerBatch = new LinkedHashSet<Document>();
            LinkedHashSet<String> idsPerBatch = new LinkedHashSet<String>();
            for (int i = 0; i != totalNumberOfChildrenDocuments; ++i) {
                String string = UUID.randomUUID().toString();
                childrenPerBatch.add(this.newDocument(string, "child_" + i));
                idsPerBatch.add(string);
                if (i < saveBatchSize || i % saveBatchSize != 0) continue;
                SchematicDbConcurrentTest.print("Saving  batch " + i);
                this.addChildren(parentId, childrenPerBatch);
                SchematicDbConcurrentTest.print("...saved; at " + System.currentTimeMillis());
                for (int j = 0; j < modifierThreadsCount; ++j) {
                    threadResults.add(executorService.submit(new ChildrenReader(new LinkedHashSet(idsPerBatch), parentId)));
                }
                idsPerBatch.clear();
                childrenPerBatch.clear();
            }
            if (!childrenPerBatch.isEmpty()) {
                SchematicDbConcurrentTest.print("Saving final batch");
                this.addChildren(parentId, childrenPerBatch);
                SchematicDbConcurrentTest.print("...saved; at " + System.currentTimeMillis());
                threadResults.add(executorService.submit(new ChildrenReader(new LinkedHashSet(idsPerBatch), parentId)));
            }
            SchematicDbConcurrentTest.print("Total time to insert records=" + (double)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) / 1000.0 + " seconds with batch size=" + saveBatchSize);
            SchematicDbConcurrentTest.print("Waiting for " + threadResults.size() + " threads to complete");
            for (Future future : threadResults) {
                ReaderResult result = (ReaderResult)future.get(1L, TimeUnit.MINUTES);
                result.validate();
            }
        }
        catch (TimeoutException te) {
            Assert.fail((String)"Task never finished completion");
        }
        finally {
            executorService.shutdown();
            Assert.assertTrue((boolean)executorService.awaitTermination(1L, TimeUnit.MINUTES));
        }
    }

    private void addChildren(String parentKey, Iterable<Document> children) throws Exception {
        this.tm.begin();
        EditableDocument parent = this.db.editContent(parentKey, false);
        EditableArray childrenArray = parent.getOrCreateArray("children");
        for (Document child : children) {
            String childName = child.getDocument("content").getString("name");
            String childId = child.getDocument("metadata").getString("id");
            childrenArray.add((Object)Schematic.newDocument((String)"childId", (Object)childId, (String)"childName", (Object)childName));
            this.db.put(child);
        }
        this.tm.commit();
    }

    private static void print(String message) {
        System.out.println(Thread.currentThread().getName() + " " + message);
    }

    private Document newDocument(String id, String name) {
        return Schematic.newDocument((String)"metadata", (Object)Schematic.newDocument((String)"id", (Object)id), (String)"content", (Object)Schematic.newDocument((String)"name", (Object)name, (String)"children", (Object)Schematic.newArray())).unwrap();
    }

    private void persistDocument(Document document) throws Exception {
        this.tm.begin();
        this.db.put(document);
        this.tm.commit();
    }

    private static final class ReaderResult {
        private static final ReaderResult EMPTY = new ReaderResult(null);
        private final String errorMessage;

        private ReaderResult(String errorMessage) {
            this.errorMessage = errorMessage;
            if (errorMessage != null) {
                SchematicDbConcurrentTest.print(errorMessage);
            }
        }

        private void validate() {
            if (this.errorMessage == null) {
                return;
            }
            throw new RuntimeException(this.errorMessage);
        }
    }

    private final class ChildrenReader
    implements Callable<ReaderResult> {
        private final Set<String> childrenIds;
        private final String parentId;

        private ChildrenReader(Set<String> childrenIds, String parentId) {
            this.childrenIds = childrenIds;
            this.parentId = parentId;
        }

        @Override
        public ReaderResult call() throws Exception {
            Document childDocument;
            if (!SchematicDbConcurrentTest.this.db.containsKey(this.parentId)) {
                return new ReaderResult("Parent " + this.parentId + " not found in DB");
            }
            Document parentDocument = SchematicDbConcurrentTest.this.db.get(this.parentId).getContent();
            List children = parentDocument.getArray("children");
            LinkedHashSet<String> storedChildrenIds = new LinkedHashSet<String>();
            for (Object child : children) {
                childDocument = (Document)child;
                storedChildrenIds.add(childDocument.getString("childId"));
            }
            for (String childId : this.childrenIds) {
                if (!SchematicDbConcurrentTest.this.db.containsKey(childId)) {
                    return new ReaderResult("Child " + childId + " not found in DB");
                }
                childDocument = SchematicDbConcurrentTest.this.db.get(childId).getContent();
                String name = childDocument.getString("name");
                if (!name.startsWith("child")) {
                    return new ReaderResult("Invalid child name: " + name);
                }
                if (storedChildrenIds.contains(childId)) continue;
                return new ReaderResult("Child " + childId + " not found in the parent's children array");
            }
            return ReaderResult.EMPTY;
        }
    }

    private final class ListReader
    implements Callable<ReaderResult> {
        private final Set<String> listElements;

        private ListReader(Set<String> listElements) {
            this.listElements = listElements;
        }

        @Override
        public ReaderResult call() throws Exception {
            List storedList = (List)SchematicDbConcurrentTest.this.rawCache.get((Object)"list");
            for (String listElement : this.listElements) {
                if (storedList.contains(listElement)) continue;
                SchematicDbConcurrentTest.print("read list reference: " + System.identityHashCode(storedList));
                return new ReaderResult("Element " + listElement + " not found in the list");
            }
            return ReaderResult.EMPTY;
        }
    }
}

