/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic;

import java.io.File;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.loaders.bdbje.configuration.BdbjeCacheStoreConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.schematic.AbstractSchematicDbTest;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.TestUtil;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.junit.Before;
import org.junit.Test;

public class SchematicDbWithBerkleyTest
extends AbstractSchematicDbTest {
    @Override
    @Before
    public void beforeTest() {
        File dbDir = new File("target/bdb");
        TestUtil.delete(dbDir);
        GlobalConfigurationBuilder globalConfigurationBuilder = new GlobalConfigurationBuilder();
        globalConfigurationBuilder.transport().transport(null).serialization().addAdvancedExternalizer(Schematic.externalizers());
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.invocationBatching().enable().transaction().lockingMode(LockingMode.PESSIMISTIC).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        ((BdbjeCacheStoreConfigurationBuilder)configurationBuilder.loaders().addStore(BdbjeCacheStoreConfigurationBuilder.class)).location(dbDir.getAbsolutePath()).purgeOnStartup(true);
        this.cm = new DefaultCacheManager(globalConfigurationBuilder.build(), configurationBuilder.build(), true);
        this.tm = this.cm.getCache().getAdvancedCache().getTransactionManager();
        this.db = Schematic.get((CacheContainer)this.cm, (String)"documents");
    }

    @Test
    public void shouldGetNonExistantDocument() {
        String key = "can be anything";
        SchematicEntry entry = this.db.get(key);
        assert (entry == null) : "Should not have found a prior entry";
    }

    @Test
    public void shouldStoreDocumentWithUnusedKeyAndWithNullMetadata() {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        String key = "can be anything";
        SchematicEntry prior = this.db.put(key, (Document)doc);
        assert (prior == null) : "Should not have found a prior entry";
        SchematicEntry entry = this.db.get(key);
        assert (entry != null) : "Should have found the entry";
        Document read = entry.getContent();
        assert (read != null);
        assert ("value1".equals(read.getString("k1")));
        assert (2 == read.getInteger("k2"));
        assert (read.containsAll((Document)doc));
        assert (read.equals(doc));
        Document readMetadata = entry.getMetadata();
        assert (readMetadata != null);
        assert (readMetadata.getString("id").equals(key));
    }

    @Test
    public void shouldStoreDocumentWithUnusedKeyAndWithNonNullMetadata() {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        String key = "can be anything";
        SchematicEntry prior = this.db.put(key, (Document)doc);
        assert (prior == null) : "Should not have found a prior entry";
        SchematicEntry entry = this.db.get(key);
        assert (entry != null) : "Should have found the entry";
        Document read = entry.getContent();
        assert (read != null);
        assert ("value1".equals(read.getString("k1")));
        assert (2 == read.getInteger("k2"));
        assert (read.containsAll((Document)doc));
        assert (read.equals(doc));
        Document readMetadata = entry.getMetadata();
        assert (readMetadata != null);
        assert (readMetadata.getString("id").equals(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldStoreDocumentAndFetchAndModifyAndRefetch() throws Exception {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        String key = "can be anything";
        SchematicEntry prior = this.db.put(key, (Document)doc);
        assert (prior == null) : "Should not have found a prior entry";
        SchematicEntry entry = this.db.get(key);
        assert (entry != null) : "Should have found the entry";
        Document read = entry.getContent();
        assert (read != null);
        assert ("value1".equals(read.getString("k1")));
        assert (2 == read.getInteger("k2"));
        assert (read.containsAll((Document)doc));
        assert (read.equals(doc));
        try {
            this.tm.begin();
            this.db.lock(key);
            EditableDocument editable = this.db.editContent(key, true);
            editable.setBoolean("k3", true);
            editable.setNumber("k4", 3.5);
        }
        finally {
            this.tm.commit();
        }
        SchematicEntry entry2 = this.db.get(key);
        Document read2 = entry2.getContent();
        assert (read2 != null);
        assert ("value1".equals(read2.getString("k1")));
        assert (2 == read2.getInteger("k2"));
        assert (read2.getBoolean("k3").booleanValue());
        assert (3.4 < read2.getDouble("k4"));
    }
}

