/*
 * ModeShape (http://www.modeshape.org)
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 * See the AUTHORS.txt file in the distribution for a full listing of 
 * individual contributors.
 *
 * ModeShape is free software. Unless otherwise indicated, all code in ModeShape
 * is licensed to you under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * ModeShape is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.modeshape.jcr.api;

/**
 * Class which allows a customization of the restore process
 * 
 * @author Horia Chiorean (hchiorea@redhat.com)
 */
public abstract class RestoreOptions {
    
    /**
     * The default options used during restore, if no explicit ones are given.
     */
    public static final RestoreOptions DEFAULT = new RestoreOptions(){};

    /**
     * Whether a full reindexing should be performed or not after restoring the content.
     * 
     * @return {@code true} if a full reindexing should be performed; defaults to {@code true}
     */
    public boolean reindexContentOnFinish() {
        return true;
    }

    /**
     * Whether binaries should be restored or not. ModeShape uses references between documents and binary values, so 
     * depending on the context it may not always be desired for binary values to be restored. 
     * 
     * @return {@code true} if binary values should be included; defaults to {@code true}
     */
    public boolean includeBinaries() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("[restore_options: ");
        builder.append("include_binaries=").append(includeBinaries());
        builder.append(", reindex_content_on_finish=").append(reindexContentOnFinish());
        builder.append("]");
        return builder.toString();
    }
}
