/*
 * JBoss, Home of Professional Open Source.
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 */

package org.teiid.query.function.aggregate;

import java.util.Arrays;
import java.util.List;

import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.util.CommandContext;


/**
 */
public class Min extends SingleArgumentAggregateFunction {

    private Object minValue;
    private Class<?> outputType;

    public void reset() {
        minValue = null;
    }
    
    @Override
    public void initialize(Class<?> dataType, Class<?> inputType) {
    	this.outputType = inputType;
    }

    /**
     * @see org.teiid.query.function.aggregate.AggregateFunction#addInputDirect(List, CommandContext, CommandContext)
     */
    public void addInputDirect(Object value, List<?> tuple, CommandContext commandContext)
        throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException {

        if(minValue == null) {
            minValue = value;
        } else {
            Comparable valueComp = (Comparable) value;

            if(Constant.COMPARATOR.compare(valueComp, minValue) < 0) {
                minValue = valueComp;
            }
        }
    }

    /**
     * @see org.teiid.query.function.aggregate.AggregateFunction#getResult(CommandContext)
     */
    public Object getResult(CommandContext commandContext) {
        return this.minValue;
    }

    @Override
    public List<? extends Class<?>> getStateTypes() {
    	return Arrays.asList(outputType);
    }
    
    @Override
    public void getState(List<Object> state) {
    	state.add(minValue);
    }
    
    @Override
    public int setState(List<?> state, int index) {
    	this.minValue = state.get(index);
    	return index++;
    }

}
