/*
 * JBoss, Home of Professional Open Source.
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 */
package org.teiid.translator.object;

import java.util.ResourceBundle;

import org.teiid.core.BundleUtil;


/**
 * ObjectPlugin
 */
public class ObjectPlugin { 
    
    public static final String PLUGIN_ID = "org.teiid.translator.object" ; //$NON-NLS-1$

    /**
     * Provides access to the plugin's log and to it's resources.
     */
    public static final BundleUtil Util = new BundleUtil(PLUGIN_ID, PLUGIN_ID + ".i18n", ResourceBundle.getBundle(PLUGIN_ID + ".i18n")); //$NON-NLS-1$ //$NON-NLS-2$

	public static enum Event implements BundleUtil.Event{
		TEIID21000,
		TEIID21001,
		TEIID21002,
		TEIID21003,
		TEIID21004,
		TEIID21005,
		TEIID21006,
		TEIID21007,
		TEIID21008,
		TEIID21009,
		TEIID21010,
		TEIID21011,
		TEIID21012,
		TEIID21013,
		TEIID21014,
		TEIID21015,
		TEIID21016,
		TEIID21017,
		TEIID21018,
		TEIID21019,
		TEIID21302,
    }
}
