/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { KubeConfig } from '@kubernetes/client-node';
import { OpenShiftHelper } from '../api/openshift';
import { KubeHelper } from './kube';
export declare class CheHelper {
    defaultCheResponseTimeoutMs: number;
    kc: KubeConfig;
    kube: KubeHelper;
    oc: OpenShiftHelper;
    constructor(flags: any);
    /**
     * Finds a pod where workspace is running.
     * Rejects if no workspace is found for the given workspace ID
     * or if workspace ID wasn't specified but more than one workspace is found.
     */
    getWorkspacePod(namespace: string, cheWorkspaceId?: string): Promise<string>;
    getWorkspacePodContainers(namespace: string, cheWorkspaceId?: string): Promise<string[]>;
    cheURL(namespace?: string): Promise<string>;
    cheK8sURL(namespace?: string): Promise<string>;
    cheOpenShiftURL(namespace?: string): Promise<string>;
    cheNamespaceExist(namespace?: string): Promise<boolean>;
    getCheServerStatus(cheURL: string, responseTimeoutMs?: number): Promise<string>;
    startShutdown(cheURL: string, accessToken?: string, responseTimeoutMs?: number): Promise<void>;
    waitUntilReadyToShutdown(cheURL: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    isCheServerReady(cheURL: string, responseTimeoutMs?: number): Promise<boolean>;
    createWorkspaceFromDevfile(namespace: string | undefined, devfilePath: string | undefined, workspaceName: string | undefined, accessToken?: string): Promise<string>;
    parseDevfile(devfilePath?: string): Promise<string>;
    createWorkspaceFromWorkspaceConfig(namespace: string | undefined, workspaceConfigPath?: string, accessToken?: string): Promise<string>;
    isAuthenticationEnabled(cheURL: string, responseTimeoutMs?: number): Promise<boolean>;
    buildDashboardURL(ideURL: string): Promise<string>;
    /**
     * Finds workspace pods and reads logs from it.
     */
    readWorkspacePodLog(namespace: string, workspaceId: string, directory: string): Promise<boolean>;
    /**
     * Reads logs from pods that match a given selector.
     */
    readPodLog(namespace: string, podLabelSelector: string | undefined, directory: string, follow: boolean): Promise<void>;
    /**
     * Reads containers logs inside pod that match a given selector.
     */
    readNamespacedPodLog(namespace: string, podLabelSelector: string | undefined, directory: string): Promise<void>;
    /**
     * Reads all namespace events and store into a file.
     */
    readNamespaceEvents(namespace: string, directory: string, follow: boolean): Promise<void>;
    watchNamespacedPods(namespace: string, podLabelSelector: string | undefined, directory: string): Promise<void>;
    /**
     * Indicates if pod matches given labels.
     */
    private matchLabels;
    /**
     * Returns containers names.
     */
    private getContainers;
    /**
     * Reads pod log from a specific container of the pod.
     */
    private doReadNamespacedPodLog;
    private doCreateLogFile;
    private getCheApiError;
}
